// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \file C++ API <i>mobius.crypt</i> module wrapper
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <Python.h>
#include "cipher_aes.h"
#include "cipher_des.h"
#include "cipher_rc4.h"
#include "cipher_rot13.h"
#include "cipher_zip.h"
#include "hash_adler32.h"
#include "hash_crc32.h"
#include "hash_md5.h"
#include "hash_sha1.h"
#include "hash_sha2_224.h"
#include "hash_sha2_256.h"
#include "hash_sha2_384.h"
#include "hash_sha2_512.h"
#include "hash_sha2_512_224.h"
#include "hash_sha2_512_256.h"
#include "hash_zip.h"
#include "hmac.h"

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief module methods
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyMethodDef module_methods[] =
{
  {
    NULL,
    NULL,
    0,
    NULL
  } // sentinel
};

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief module datatypes
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static constexpr struct
{
  const char *name;
  PyTypeObject *type;
} types[] =

{
  {"cipher_aes", &crypt_cipher_aes_t},
  {"cipher_des", &crypt_cipher_des_t},
  {"cipher_rc4", &crypt_cipher_rc4_t},
  {"cipher_rot13", &crypt_cipher_rot13_t},
  {"cipher_zip", &crypt_cipher_zip_t},
  {"hash_adler32", &crypt_hash_adler32_t},
  {"hash_crc32", &crypt_hash_crc32_t},
  {"hash_md5", &crypt_hash_md5_t},
  {"hash_sha1", &crypt_hash_sha1_t},
  {"hash_sha2_224", &crypt_hash_sha2_224_t},
  {"hash_sha2_256", &crypt_hash_sha2_256_t},
  {"hash_sha2_384", &crypt_hash_sha2_384_t},
  {"hash_sha2_512", &crypt_hash_sha2_512_t},
  {"hash_sha2_512_224", &crypt_hash_sha2_512_224_t},
  {"hash_sha2_512_256", &crypt_hash_sha2_512_256_t},
  {"hash_zip", &crypt_hash_zip_t},
  {"hmac", &crypt_hmac_t},
};

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief create mobius.crypt module
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyObject *
new_crypt_module ()
{
  // initialize module mobius.crypt
  PyObject* module = Py_InitModule3 (
                       "crypt",
                       module_methods,
                       "Mobius Forensic Toolkit mobius.crypt module"
                     );

  // build types
  for (const auto& t : types)
    if (PyType_Ready (t.type) < 0)
      return nullptr;

  // add types
  for (const auto& t : types)
    {
      Py_INCREF (t.type);
      PyModule_AddObject (module, t.name, (PyObject *) t.type);
    }

  // return module
  return module;
}
