// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief  C++ API mobius.imagefile module wrapper
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <Python.h>
#include "imagefile.h"

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief module methods
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyMethodDef module_methods[] =
{
  {
    NULL,
    NULL,
    0,
    NULL
  } // sentinel
};

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief create mobius.imagefile module
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyObject *
new_imagefile_module ()
{
  // initialize module mobius.imagefile
  PyObject* module = Py_InitModule3 (
    "imagefile",
    module_methods,
    "Mobius Forensic Toolkit mobius.imagefile module"
  );

  // build types
  if (PyType_Ready (&imagefile_imagefile_t) < 0)
    return nullptr;

  // add types
  Py_INCREF (&imagefile_imagefile_t);
  PyModule_AddObject (module, "imagefile", (PyObject *) &imagefile_imagefile_t);

  // add typelist module var
  PyObject *typelist = PyList_New (0);

  if (typelist == nullptr)
    return nullptr;
  
  for (auto i : mobius::imagefile::imagefile::typelist)
    {
      PyObject *t = PyTuple_New (4);
      PyTuple_SetItem (t, 0, PyString_FromString (i.type.c_str ()));
      PyTuple_SetItem (t, 1, PyString_FromString (i.description.c_str ()));
      PyTuple_SetItem (t, 2, PyString_FromString (i.extensions.c_str ()));
      PyTuple_SetItem (t, 3, PyBool_FromLong (i.is_writeable));
      PyList_Append (typelist, t);
    }

  PyModule_AddObject (module, "typelist", (PyObject *) typelist);  

  // return module
  return module;
}
