#ifndef MOBIUS_CRYPT_CIPHER_RC2_H
#define MOBIUS_CRYPT_CIPHER_RC2_H

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <mobius/crypt/cipher_block.h>
#include <mobius/bytearray.h>

namespace mobius
{
namespace crypt
{
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief RC2 cipher cryptographic algorithm
//! \author Eduardo Aguiar
//! \see RFC 2268
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class cipher_rc2 : public cipher_block
{
public:
  explicit cipher_rc2 (const mobius::bytearray&, const std::string& = "ecb", const mobius::bytearray& = {0, 0, 0, 0, 0, 0, 0, 0});
  void encrypt_block (mobius::bytearray&) noexcept override;
  void decrypt_block (mobius::bytearray&) noexcept override;

private:
  std::uint16_t k_[64];
};

} // namespace crypt
} // namespace mobius

#endif
