#ifndef MOBIUS_REGISTRY_HIVE_DATA_H
#define MOBIUS_REGISTRY_HIVE_DATA_H

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <mobius/bytearray.h>
#include <mobius/io/reader.h>
#include <cstdint>
#include <memory>

namespace mobius
{
namespace registry
{
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief hive_data class
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class hive_data
{
public:
  // datatypes
  using offset_type = std::uint32_t;

  //! \brief registry data types
  //! \see https://msdn.microsoft.com/en-us/library/windows/desktop/ms724884(v=vs.85).aspx
  enum class data_type
  {
    reg_none,
    reg_sz,
    reg_expand_sz,
    reg_binary,
    reg_dword,
    reg_dword_big_endian,
    reg_link,
    reg_multi_sz,
    reg_resource_list,
    reg_full_resource_descriptor,
    reg_resource_requirements_list,
    reg_qword
  };

  // constructors
  hive_data ();
  hive_data (mobius::io::reader, offset_type, std::uint32_t, std::uint32_t);
  hive_data (hive_data&&) = default;
  hive_data (const hive_data&) = default;

  // operators
  hive_data& operator= (const hive_data&) = default;
  hive_data& operator= (hive_data&&) = default;
  operator bool () const;

  // function prototypes
  offset_type get_offset () const;
  std::uint32_t get_size () const;
  data_type get_type () const;
  mobius::bytearray get_data () const;

private:
  //! \brief implementation class forward declaration
  class impl;

  //! \brief implementation pointer
  std::shared_ptr <impl> impl_;
};

} // namespace registry
} // namespace mobius

#endif
