// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief  C++ API module wrapper
//!\author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <Python.h>
#include "api_reader.h"
#include <mobius/partition/partition_system.h>

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief function mobius.api.get_partition_table
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyObject*
func_get_partition_table (PyObject *self, PyObject *args)
{
  // parse arguments
  int arg_sector_size = 512;
  PyObject *arg_reader;

  if (!PyArg_ParseTuple (args, "O!|i", &api_reader_t, &arg_reader, &arg_sector_size))
    return nullptr;

  mobius::io::reader *reader_p = ((api_reader_o *) arg_reader)->obj;

  // run C++ code
  std::unique_ptr <mobius::partition::partition_system> psystem;

  try
    {
      mobius::io::sector_reader_adaptor reader (*reader_p, arg_sector_size);
      psystem.reset (new mobius::partition::partition_system (reader));
    }
  catch (const std::runtime_error& e)
    {
      Py_DECREF (self);
      PyErr_SetString (PyExc_Exception, e.what ());
      self = NULL;
    }

  // create list
  PyObject *ret = PyList_New (0);
  if (ret == nullptr)
    return nullptr;

  // populate list
  for (auto e : psystem->get_entries ())
    {
      PyObject *t = PyTuple_New (6);
      PyTuple_SetItem (t, 0, PyLong_FromLong (e.starting_sector));
      PyTuple_SetItem (t, 1, PyLong_FromLong (e.ending_sector));
      PyTuple_SetItem (t, 2, PyLong_FromLong (e.sectors));
      PyTuple_SetItem (t, 3, PyString_FromString (e.type.c_str ()));
      PyTuple_SetItem (t, 4, PyString_FromString (e.flags.c_str ()));
      PyTuple_SetItem (t, 5, PyString_FromString (e.description.c_str ()));
      PyList_Append (ret, t);
    }

  return ret;
}
