#!/usr/bin/env python

import mobius.api
import datetime
import sys

def show_resource (r, level=0):
  indent = ' ' * (level * 2)

  if not r.is_valid or not r.exists:
    print '%s? %s' % (indent, r.url)
    return

  # show metadata
  print '%s%s %s' % (indent, '.' if r.is_file else '+', r.url)
  print '%s  size: %d' % (indent, r.size)
  print '%s  user ID: %d' % (indent, r.user_id)
  print '%s  user name: %s' % (indent, r.user_name)
  print '%s  group ID: %d' % (indent, r.group_id)
  print '%s  group name: %s' % (indent, r.group_name)
  print '%s  permissions: %o' % (indent, r.permissions)  
  print '%s  last access time (atime): %s' % (indent, r.last_access_time)
  print '%s  last modification time (mtime): %s' % (indent, r.last_modification_time)
  print '%s  last metadata time (ctime): %s' % (indent, r.last_metadata_time)

  # if resource is a file, show some bytes...
  if r.is_file:
    try:
      reader = r.new_reader ()
      data = reader.read (16)
      print '%s  first 16 bytes: %s' % (indent, ' '.join ('%02x' % ord (c) for c in data))
    except IOError, e:
      print '%s  <Warning: %s>' % (indent, e)
  
  # otherwise resource is a folder, so recurse into it
  else:
    try:
      for child in r.children:
        show_resource (child, level+1)
    except IOError, e:
      print '%s  <Warning: %s>' % (indent, e)

for url in sys.argv[1:]:
  r = mobius.api.file (url)
  
  if r.is_folder:
    r = mobius.api.folder (url)

  show_resource (r)
