# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# Mobius Forensic Toolkit
# Copyright (C) 2008 Eduardo Aguiar
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
# Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
import distutils.core
import distutils.command.build
import distutils.command.install
import sys
import re
import glob

PYTHON_REQUIRED_VERSION = (2, 4, 0)
PYGTK_REQUIRED_VERSION = (2, 10, 0)

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Build class
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class Build (distutils.command.build.build):

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief Initialize build
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def __init__ (self, *args):
    distutils.command.build.build.__init__ (self, *args)

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief Check dependencies and run build
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def run (self):
    self.check_python_version ()
    self.check_pygtk ()
    self.check_pygtk_version ()
    distutils.command.build.build.run (self)

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief Check python version
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def check_python_version (self):
    print 'checking python version...', sys.version.split ()[0]

    if sys.version_info < PYTHON_REQUIRED_VERSION:
      print 'Python %d.%d.%d or newer required. See http://www.python.org' \
          % PYTHON_REQUIRED_VERSION
      sys.exit (2)

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief Check pygtk
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def check_pygtk (self):
    print 'checking for PyGTK...',

    try:
      import gtk
      print 'yes'
    except:
      print 'no'
      print 'PyGTK not found. See http://www.pygtk.org'
      sys.exit (2)

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief Check pygtk version
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def check_pygtk_version (self):
    import gtk
    print 'checking PyGTK version... %d.%d.%d' % gtk.pygtk_version

    if gtk.pygtk_version < PYGTK_REQUIRED_VERSION:
      print 'PyGTK %d.%d.%d or newer required. See http://www.python.org' \
          % PYGTK_REQUIRED_VERSION
      sys.exit (2)

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Install class
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class Install (distutils.command.install.install):

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief Initialize install
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def __init__ (self, *args):
    distutils.command.install.install.__init__ (self, *args)
    self.version = self.distribution.get_version ()

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief Run install
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def run (self):
    distutils.command.install.install.run (self)
    self.install_in ('mobius/config.py')

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief Substitute configure vars (${var})
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def install_in (self, filename):
    path = self.install_lib + filename

    # read file
    fp = open (path, 'r')
    lines = fp.readlines ()
    fp.close ()

    # replace function
    def repl (matchobj):
      name = matchobj.group (1)
      return getattr (self, name, None)

    # replace vars
    fp = open (path, 'w')
    for line in lines:
      fp.write (re.sub (r'\$\{([a-z0-9_]*?)\}', repl, line))
    fp.close ()

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Install
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
distutils.core.setup (name='mobiusft',
       cmdclass={'build' : Build, 'install' : Install},
       description='Mobius Forensic Toolkit',
       version='0.3.4',
       url='http://savannah.nongnu.org/projects/mobiusft',
       author='Eduardo Aguiar',
       author_email='eduardoaguiar@ig.com.br',
       license='GPL',
       packages=['mobius', 'mobius.model', 'mobius.ui', 'mobius.pickle', 'mobius.decoder'],
       scripts=['mobius_bin.py', 'mobius_icq.py'],
       data_files=[('data', ['data/category.xml']), ('data/extensions', glob.glob ('extensions/*.py'))],
      )
