/*
 * @(#)ObjectIdentifierType.java
 *
 * This work is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * As a special exception, the copyright holders of this library 
 * give you permission to link this library with independent modules
 * to produce an executable, regardless of the license terms of 
 * these independent modules, and to copy and distribute the 
 * resulting executable under terms of your choice, provided that 
 * you also meet, for each linked independent module, the terms and 
 * conditions of the license of that module. An independent module 
 * is a module which is not derived from or based on this library. 
 * If you modify this library, you may extend this exception to your 
 * version of the library, but you are not obligated to do so. If 
 * you do not wish to do so, delete this exception statement from 
 * your version. 
 *
 * Copyright (c) 1999 Ericsson Telecom. All rights reserved.
 * Copyright (c) 2003 Per Cederberg. All rights reserved.
 */

package net.percederberg.mib.type;

/**
 * A class for handling object id type information.
 *
 * @version  1.0
 * @author   Per Cederberg, per@percederberg.net
 */
public class ObjectIdentifierType extends Type {

    /**
     * The one and only instance of this type.
     */
    private static ObjectIdentifierType instance = null;

    /**
     * Creates a new object identifier type. Should only be called
     * from the getInstance method.
     *
     * @see #getInstance
     */
    protected ObjectIdentifierType() {
    }

    /**
     * Returns the existing instance of the ObjectIdentifierType or
     * creates a new one if none existed.
     *
     * @return the one and only instance of this type
     */
    public static ObjectIdentifierType getInstance() {
        if (instance == null) {
            instance = new ObjectIdentifierType();
        }
        return instance;
    }

    /**
     * Checks if this type is equals to some other object. It will
     * only be reported equal to other object identifier types.
     *
     * @param  obj     an object
     *
     * @return true if the objects are equal, or
     *         false otherwise
     */
    public boolean equals(Object obj) {
        if (obj instanceof ObjectIdentifierType) {
            return true;
        } else if (obj instanceof NamedType) {
            NamedType t = (NamedType) obj;
            return t.equals(this);
        } else {
            return false;
        }
    }

    /**
     * Returns a string description of this type.
     *
     * @return a string description of the type
     */
    public String toString() {
        return "ObjectIdentifier";
    }

    /**
     * Transfers the type information from this type to a type
     * converter object. The calling conventions declared in the
     * TypeConverter class are followed.
     *
     * @param   converter     a type converter
     */
    public void transferType(TypeConverter converter) {
        throw new UnsupportedOperationException(
            "Object identifiers cannot be mapped to anything");
    }

}
