<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009,2010 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
/*SELECT * FROM information_schema.columns WHERE
table_name='$tablename' AND table_catalog='$schemaname';

*/
error_reporting(E_ALL|E_STRICT);
define('__XF_SETUP_VERSION_STRING','1.2');
define('__XF_SETUP_BRANCH_DEV',false);
define('__XF_SETUP_LAST_TESTED_PHP_VERSION','5.2.99');
define('__XF_SETUP_CONFIG_RAW',';<?php/*
[db]
engine = "%engine"
hostname = "%host"
username = "%user"
password = "%pass"
database = "%name"
prefix = "%prefix"
;*/?>');
function D($a,$b=null,$c=false){ob_start();var_dump($a);$x=ob_get_contents();ob_end_clean();$y='<pre style="border:1px dotted #f00;margin:10px;padding:10px;">'.gettype($b).':'.$b.''.chr(10).''.$x.'</pre>';if($c)return $y;else echo $y;}
function echon($a){echo $a.chr(10);}
function xfs__progressbar($a){
static $init = false;
  if ( defined('__XF_MINIMAL') ){ // paint nice prograss bar to command line interface
    if ( $init ) // rewind cursor to start of line
    fwrite(STDOUT,str_repeat(chr(0x08),62));
  $b = ceil(($a/100)*60);
  $c = sprintf('%03d',ceil(($a/100)*100)).'%';
  $d = '|';
    for ( $i = 1 ; $i <= 60 ; $i++ ){
      if ( $i === 4 || $i === 5 | $i === 6 || $i === 7 )
      $d .= substr($c,$i-4,1);
      else
      $d .= ( $i <= $b ) ? '*' : ' ';
    }
  $d .= '|';
  fwrite(STDOUT,$d); // write to STDOUT and redirect "real" script output to buffers by ob_start() in 'cli_helper.php' ;)
  $init = true;
  }
  else{ // append padding to be a bit larger than 1k as some browsers cache this amount before rerendering the page...
  // thanks to http://de3.php.net/manual/de/function.flush.php
  $c = ( $a > 50 ) ? '00'.dechex((($a-30)/100)*0xff).'ff' : '0000'.dechex((($a+50)/100)*0xff);
  $b  = chr(10);
  $b .= '<script>document.getElementById("xfs_progress_bar_1").style.width="'.ceil($a).'%";</script>'.chr(10);
  $b .= '<script>document.getElementById("xfs_progress_bar_1").style.backgroundColor="#'.sprintf('%06s',$c).'";</script>'.chr(10);
  $b .= '<script>document.getElementById("xfs_progress_bar_2").innerHTML="'.ceil($a).'%";</script>'.chr(10).chr(10);
  echo wordwrap(str_pad($b,1030,' ',STR_PAD_RIGHT),128);
  @ob_flush();
  flush();
  usleep(200*1000); // wait 200ms for our packet to travel through the internet™
  }
return true;
}
function xfs_restore($a,$b=''){
$o = '';
$a = explode(':',$a);
$c = ( isset($_SESSION['xf_setup']['__restore'][$a[1]]) ) ? $_SESSION['xf_setup']['__restore'][$a[1]] : '';
  switch ( $a[0] ){
  case 'text':
    if ( $c === '' && !empty($b) )
    $c = $b;
  $o = htmlspecialchars(substr($c,0,255));
  break;
  case 'select':
    if ( $c === $b )
    $o = 'selected="selected"';
  break;
  case 'radio':
    if ( $c === $b )
    $o = 'checked="checked"';
  break;
  }
return $o;
}
function xfs_config_complete($a){
$b = array('engine','hostname','username','password','database','prefix');
  if ( is_array($a) ){
    foreach ( $b as $v ){
      if ( !isset($a[$v]) )
      return false;
    }
  return true;
  }
  else
  return false;
}
function xfs_detect_hostname($a){
  if ( strpos($_SERVER['HTTP_HOST'],':') ){
  $b = ( substr($a,0,1) === '[' ) ? substr($_SERVER['HTTP_HOST'],0,strrpos($_SERVER['HTTP_HOST'],':'))
  : substr($_SERVER['HTTP_HOST'],0,strpos($_SERVER['HTTP_HOST'],':'));
  }
  else
  $b = $_SERVER['HTTP_HOST'];
return $b;
}

  if ( !defined('__XF_MINIMAL') ){
  session_name('larus_board_setup');
  @ini_set('session.use_trans_sid',0);
  session_start();
  }

  if ( $_SERVER['REQUEST_METHOD'] === 'GET' )
  define('__XF_SETUP_STEP',(isset($_GET['step']))?(int)$_GET['step']:0);
  elseif ( $_SERVER['REQUEST_METHOD'] === 'POST' )
  define('__XF_SETUP_STEP',(isset($_POST['step']))?(int)$_POST['step']:0);

  if ( isset($_SESSION['xf_setup']['lang']) ){
  require_once('lang.'.$_SESSION['xf_setup']['lang'].'.php');
    function xf_i18n($a){
      if ( isset($GLOBALS['XFSLANG'][$a]) )
      return $GLOBALS['XFSLANG'][$a];
      else
      return '{:TRANSLATE('.htmlspecialchars($a).')}';
    }
  }
  else{
    if ( __XF_SETUP_STEP > 1 )
    echo 'Setup session data not found. Please <a href="index.php?step=0">restart setup</a>.';
  }

  if ( function_exists('apache_setenv') )
  @apache_setenv('no-gzip',1);
@ini_set('zlib.output_compression',0);
@ini_set('implicit_flush',1);
@ob_implicit_flush(1);
  if ( !headers_sent() ){
  header('Content-Type: text/html; charset=utf-8');
  header('Cache-Control: no-cache, no-store, must-revalidate, proxy-revalidate');
  header('Pragma: no-cache');
  header('Expires: -1');
  flush();
  }
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<meta name="content-type" content="text/html; charset=utf-8" />
<title>Larus Board <?php echo __XF_SETUP_VERSION_STRING; ?> :: Web-Based Setup</title>
<link rel="stylesheet" href="setup.css" charset="utf-8" />
<script type="text/javascript" charset="utf-8">
/* <![CDATA[ */
function xfs_init(){
document.getElementById('xfs_license').style.display='none';
document.getElementById('xfs_init').style.display='block';
}

function xfs_box(show_sfd,show_tfd){
  if ( show_sfd == 1 )
  document.getElementById('xfs_sfd').style.display='block';
  else
  document.getElementById('xfs_sfd').style.display='none';
  if ( show_tfd == 1 )
  document.getElementById('xfs_tfd').style.display='block';
  else
  document.getElementById('xfs_tfd').style.display='none';
  if ( show_sfd == 1 && show_tfd == 1 )
  document.getElementById('xfs_tfd_admin').style.display='none';
  else
  document.getElementById('xfs_tfd_admin').style.display='block';
}
/* ]]> */
</script>
</head>

<body>
<div class="xf_setup_main">
  <div class="xf_setup_head">LARUS BOARD <?php echo __XF_SETUP_VERSION_STRING; ?></div>
    <ul class="xf_setup_navbar">
    <?php
    $navbar = array(0=>'1,begin',2=>'2,precheck',4=>'3,select',10=>'4,end');
      foreach ( $navbar as $k=>$v ){
        if ( !isset($_SESSION['xf_setup']['lang']) )
        break;
      $v = explode(',',$v);
      $class = ( $k === __XF_SETUP_STEP ) ? 'xf_setup_navbar_select' : 'xf_setup_navbar_link';
        if ( $k <= __XF_SETUP_STEP )
        echon('<li class="'.$class.'">'.$v[0].' <a href="index.php?step='.$k.'">'.xf_i18n($v[1]).'</a></li>');
        else
        echon('<li class="xf_setup_navbar_unavailable">'.$v[0].' '.xf_i18n($v[1]).'</li>');
      }
    unset($k,$v,$navbar,$class);
    ?>
    </ul>
  <br />
<?php
  if ( isset($_SESSION['xf_setup']['lang']) )
  echon('<noscript><div class="xf_setup_error">'.xf_i18n('please_activate_javascript').'</div></noscript>');
  if ( !is_array($_SERVER) || sizeof($_SERVER) === 0 )
  echon('<div class="xf_setup_error">Your "Server Vars" are empty. Please check PHP setting: "variables_order"</div>');

  if ( __XF_SETUP_STEP === 0 ){ //{{{
  echon('<fieldset><legend>Please choose language/Bitte wähle die Sprache aus</legend>');
  echon('<a href="index.php?step=1&lang=en">English</a><br />');
  echon('<a href="index.php?step=1&lang=de">Deutsch</a>');
  echon('</fieldset>');
  } //}}}
  elseif ( __XF_SETUP_STEP === 1 ){ //{{{
  $lang = ( isset($_GET['lang']) ) ? preg_replace('/[^a-z]+/','',$_GET['lang']) : '';
  $lang = ( file_exists('./lang.'.$lang.'.php') ) ? $lang : 'en';
  $_SESSION['xf_setup']['lang'] = $lang;
  echon('<meta http-equiv="refresh" content="0;url=index.php?step=2" />');
  } //}}}
  elseif ( __XF_SETUP_STEP === 2 ){ //{{{
  $rp = realpath(dirname(__FILE__).'/../lb_private');
  $ru = ( ( isset($_SERVER['SSL']) || isset($_SERVER['HTTPS']) ) || (int)$_SERVER['SERVER_PORT'] === 443 ) ? 'https://' : 'http://';
  $ru .= xfs_detect_hostname($_SERVER['HTTP_HOST']);
    if ( substr($ru,0,4) === 'http' && (int)$_SERVER['SERVER_PORT'] !== 80 )
    $ru .= ':'.(int)$_SERVER['SERVER_PORT'];
    if ( substr($ru,0,5) === 'https' && (int)$_SERVER['SERVER_PORT'] !== 443 )
    $ru .= ':'.(int)$_SERVER['SERVER_PORT'];
  $ru .= dirname(dirname($_SERVER['SCRIPT_NAME'])).'/lb_public';
  $rp = preg_replace('=([/]{2,}|\\\)=','/',$rp);
  $tests_success = true;
  $tests = array(
    array('mode'=>'php_version'),
    array('mode'=>'module','name'=>'date','mandatory'=>true),
    array('mode'=>'module','name'=>'filter','mandatory'=>true),
    array('mode'=>'module','name'=>'hash','mandatory'=>true),
    array('mode'=>'module','name'=>'pcre','mandatory'=>true),
    array('mode'=>'module','name'=>'pdo','mandatory'=>true),
    array('mode'=>'module','name'=>'pdo_mysql','mandatory'=>false,'dbd'=>null),
    array('mode'=>'module','name'=>'pdo_pgsql','mandatory'=>false,'dbd'=>null),
    array('mode'=>'module','name'=>'suhosin','mandatory'=>false),
    array('mode'=>'module','name'=>'gd','mandatory'=>false),
    array('mode'=>'module','name'=>'mcrypt','mandatory'=>false),
    array('mode'=>'module','name'=>'gnupg','mandatory'=>false),
    array('mode'=>'module','name'=>'simplexml','mandatory'=>false),
    array('mode'=>'module','name'=>'zlib','mandatory'=>false),
  );
    if ( version_compare(PHP_VERSION,__XF_SETUP_LAST_TESTED_PHP_VERSION,'>') ){
    echon('<fieldset><legend class="notice">'.xf_i18n('notice').'</legend>');
    echon('<span style="font-size: 150%; color: #f70;">'.xf_i18n('php_is_newer_than_tested').'</span>');
    echon('</fieldset>');
    }
    if ( __XF_SETUP_BRANCH_DEV ){
    echon('<fieldset><legend class="notice">'.xf_i18n('notice').'</legend>');
    echon('<span style="font-size: 150%; color: #f70;">'.xf_i18n('development_version').'</span>');
    echon('</fieldset>');
    }
  echon('<fieldset id="xfs_license"><legend>'.xf_i18n('license_information').'</legend>');
  echon('<div style="height: 400px; overflow: auto; text-align: justify; padding-right: 10px;">');
  echon(xf_i18n('license'));
  echon('<button class="xf_setup_button" onclick="xfs_init();">'.xf_i18n('i_agree').'</button>');
  echon('</div>');
  echon('</fieldset>');

  echon('<fieldset id="xfs_init" style="display: none;"><legend>'.xf_i18n('initial_environment_detection').'</legend>');
  echon('<form action="index.php" method="post">');
  echon('<input type="hidden" name="step" value="3" />');
  echon('<dl>');
    foreach ( $tests as $test ){
      switch ( $test['mode'] ){
      case 'php_version':
      $sc = ( version_compare(PHP_VERSION,'5.2.0') ) ? 'success' : 'fail';
      echon('<dt class="xf_preq_test xf_preq_test_'.$sc.'">PHP: '.PHP_VERSION.' '.php_sapi_name().'</dt>');
      echon('<dd>'.xf_i18n('req_explain_php_version').'</dd>');
      break;
      case 'module':
        if ( $test['name'] === 'suhosin' ){
        ob_start();
        phpinfo();
        $pi = ob_get_clean();
        $sc = ( stripos($pi,'suhosin patch') || stripos($pi,'hardened-php') ) ? 'success' : 'missing';
        echon('<dt class="xf_preq_test xf_preq_test_'.$sc.'">'.xf_i18n('php_module').': suhosin patch ['.xf_i18n('php_module_optional').']</dt>');
        echon('<dd>'.xf_i18n('req_explain_php_module_'.$test['name']).'</dd>');
        }
      $add = '';
      $sc = ( extension_loaded($test['name']) ) ? 'success' : 'fail';
      $yn = ( $sc === 'success' ) ? xf_i18n('yes') : xf_i18n('no');
        if ( $test['mandatory'] && $sc === 'fail' )
        $tests_success = false;
        if ( !$test['mandatory'] && $sc === 'fail' )
        $sc = 'missing';
        if ( $sc === 'success' && $test['name'] === 'hash' ){
        $ta = array('md5','sha1','sha256','ripemd256','haval256,5');
        $aa = hash_algos();
        $add .= '<br />Hashes: ';
          foreach ( $ta as $v ){
          $add .= ( in_array($v,$aa,true) )
          ? $v.':'
          : '<s>'.$v.'</s>:';
          }
        $add = substr($add,0,-1);
        unset($ta,$aa);
        }
      $im = ( $test['mandatory'] ) ? xf_i18n('php_module_mandatory') : xf_i18n('php_module_optional');
      echon('<dt class="xf_preq_test xf_preq_test_'.$sc.'">'.xf_i18n('php_module').': '.$test['name'].' ['.$im.']</dt>');
      echon('<dd>'.xf_i18n('req_explain_php_module_'.$test['name']).$add.'</dd>');
      break;
      default: break;
      }
    }
  echon('</dl>');
    if ( $tests_success ){
    echon(xf_i18n('root_path').':<br /><input type="text" name="root_path" size="60" value="'.htmlspecialchars($rp).'" /><br /><br />');
    echon(xf_i18n('root_uri').':<br /><input type="text" name="root_uri" size="60" value="'.htmlspecialchars($ru).'" /><br /><br />');
    echon('<input type="submit" class="xf_setup_button" />');
    }
  echon('</form>');
  echon('</fieldset>');
    if ( isset($_SESSION['xf_setup']['path']) && isset($_SESSION['xf_setup']['uri']) )
    echon('<script type="text/javascript">/* <![CDATA[ */ xfs_init(); /* ]]> */</script>');
  } //}}}
  elseif ( __XF_SETUP_STEP === 3 ){ //{{{
  $rp = ( isset($_POST['root_path']) ) ? $_POST['root_path'] : '';
  $ru = ( isset($_POST['root_uri']) ) ? $_POST['root_uri'] : '';
  $_SESSION['xf_setup']['path'] = $rp;
  $_SESSION['xf_setup']['uri'] = $ru;
  echon('<meta http-equiv="refresh" content="0;url=index.php?step=4" />');
  } //}}}
  elseif ( __XF_SETUP_STEP === 4 ){ //{{{
  $error = ( isset($_GET['err']) ) ? explode(',',substr(preg_replace('/[^a-z0-9_,]+/','',$_GET['err']),0,255)) : array();
  $pdo_mysql = ( extension_loaded('pdo_mysql') ) ? '' : 'disabled="disabled"';
  $pdo_pgsql = ( extension_loaded('pdo_pgsql') ) ? '' : 'disabled="disabled"';
  $cache_dir = $_SESSION['xf_setup']['path'].'/cache';
  $cfg = $_SESSION['xf_setup']['path'].'/config.db.php';
  $cfg_data = array('engine'=>'','hostname'=>'localhost','username'=>'','password'=>'','database'=>'','prefix'=>'lb1_');
    if ( !file_exists($_SESSION['xf_setup']['path'].'/class.root.php') )
    echon('<div class="xf_setup_error">'.xf_i18n('root_class_not_found').'</div>');
  echon('<form action="index.php" method="post">');
  echon('<fieldset><legend>'.xf_i18n('setup_type').'</legend>');
    echon('<div class="xf_repair_options">');
    echon('<strong>'.xf_i18n('repair_options').'</strong><br />');
    echon('<a href="index.php?step=20">'.xf_i18n('reset_a_password').'</a><br />');
    echon('<a href="index.php?step=21">'.xf_i18n('rebuild_passwords').'</a><br />');
    echon('<a href="index.php?step=23">'.xf_i18n('edit_configuration').'</a><br />');
    echon('<a href="index.php?step=24">'.xf_i18n('purge_local_cache').'</a><br />');
    echon('<a href="index.php?step=22">'.xf_i18n('verify_database_integrity').'</a><br />');
    echon('</div>');
    if ( !file_exists($cache_dir) || !is_writeable($cache_dir) )
    echon('<div style="color: #a00;">'.sprintf(xf_i18n('folder_not_writeable'),$cache_dir).'</div>');
    if ( !file_exists($cfg) ){
      if ( is_writeable($_SESSION['xf_setup']['path']) ){
      touch($cfg);
      clearstatcache();
      }
      else
      echon('<div style="color: #a00;">'.sprintf(xf_i18n('folder_not_writeable'),$_SESSION['xf_setup']['path']).'</div>');
    }
    else{
      if ( !is_writeable($cfg) )
      echon('<div style="color: #a00;">'.sprintf(xf_i18n('file_not_writeable'),$cfg).'</div>');
    $cfg_temp = parse_ini_file($cfg);
      if ( xfs_config_complete($cfg_temp) )
      $cfg_data = $cfg_temp;
    unset($cfg_temp);
    }
  echon('<label><input type="radio" name="step" value="5" onclick="xfs_box(0,1);" checked="checked" /> '.xf_i18n('install').'</label><br />');
  echon('<label><input type="radio" name="step" value="8" onclick="xfs_box(0,0);" /> '.xf_i18n('update').'</label><br />');
  echon('<label><input type="radio" name="step" value="5" onclick="xfs_box(1,1);" /> '.xf_i18n('convert').'</label>');
  echon('</fieldset>');

    if ( sizeof($error) > 0 ){
    echon('<style type="text/css">');
      foreach ( $error as $v )
      echon('input[name='.$v.'],select[name='.$v.'] { background-color: #f99; }');
    echon('</style>');
    echon('<div class="xf_setup_error">'.xf_i18n('form_values_error').'</div>');
    }

  $convdir = scandir('.');
  $convertors = array();
    foreach ( $convdir as $v ){
      if ( preg_match('/^convert_(\w+)\.php$/D',$v,$k) ){
      $fn = 'xfs__info_'.$k[1];
      require_once('./'.$v);
        if ( function_exists($fn) ){
        $fn = call_user_func($fn);
          if ( $fn['id'] === $k[1] && $fn['active'] )
          $convertors[] = $fn;
        }
      }
    }
  echon('<fieldset id="xfs_sfd" style="display: none;"><legend>'.xf_i18n('source_database').'</legend>');
  echon(xf_i18n('source_forum_software').':<br />');
  echon('<label><input type="radio" name="sfs" value="-" checked="checked" /> </label><br />');
    foreach ( $convertors as $k=>$v )
    echon('<label title="'.$v['url'].'" onclick="document.getElementById(\'f_guest\').value=\''.$v['guest'].'\';"><input type="radio" name="sfs" value="'.$v['id'].'" '.xfs_restore('radio:sfs',$v['id']).' /> '.$v['name'].' '.$v['supported_versions'].'</label><br />');
  echon('<br />');
  echon(xf_i18n('db_type').': <select name="dbs_type" size="1">');
  echon('<option value="-" /></option>');
  echon('<option value="mysql" '.$pdo_mysql.' '.xfs_restore('select:dbs_type','mysql').' />MySQL</option>');
  echon('<option value="pgsql" '.$pdo_pgsql.' '.xfs_restore('select:dbs_type','pgsql').' />PostgreSQL</option>');
  echon('</select><br /><br />');
  echon(xf_i18n('db_host').':<br /><input type="text" name="dbs_host" size="30" value="'.xfs_restore('text:dbs_host','localhost').'" /><br /><br />');
  echon(xf_i18n('db_username').':<br /><input type="text" name="dbs_username" size="30" value="'.xfs_restore('text:dbs_username').'" /><br /><br />');
  echon(xf_i18n('db_password').':<br /><input type="password" name="dbs_password" size="30" value="'.xfs_restore('text:dbs_password').'" /><br /><br />');
  echon(xf_i18n('db_name').':<br /><input type="text" name="dbs_name" size="30" value="'.xfs_restore('text:dbs_name').'" /><br /><br />');
  echon(xf_i18n('db_prefix').':<br /><input type="text" name="dbs_prefix" size="30" value="'.xfs_restore('text:dbs_prefix').'" /><br /><br />');
  echon(xf_i18n('guest_username').':<br /><input type="text" id="f_guest" name="guest_uid" size="30" value="'.xfs_restore('text:guest_uid').'" />');
  echon('</fieldset>');

  echon('<fieldset id="xfs_tfd" style="display: block;"><legend>'.xf_i18n('target_database').'</legend>');
  echon(xf_i18n('db_type').': <select name="dbt_type" size="1">');
  echon('<option value="-" /></option>');
  echon('<option value="mysql" '.$pdo_mysql.' '.xfs_restore('select:dbt_type','mysql').' />MySQL</option>');
  echon('<option value="pgsql" '.$pdo_pgsql.' '.xfs_restore('select:dbt_type','pgsql').' />PostgreSQL</option>');
  echon('</select><br /><br />');
  echon(xf_i18n('db_host').':<br /><input type="text" name="dbt_host" size="30" value="'.xfs_restore('text:dbt_host',$cfg_data['hostname']).'" /><br /><br />');
  echon(xf_i18n('db_username').':<br /><input type="text" name="dbt_username" size="30" value="'.xfs_restore('text:dbt_username',$cfg_data['username']).'" /><br /><br />');
  echon(xf_i18n('db_password').':<br /><input type="password" name="dbt_password" size="30" value="'.xfs_restore('text:dbt_password',$cfg_data['password']).'" /><br /><br />');
  echon(xf_i18n('db_name').':<br /><input type="text" name="dbt_name" size="30" value="'.xfs_restore('text:dbt_name',$cfg_data['database']).'" /><br /><br />');
  echon(xf_i18n('db_prefix').':<br /><input type="text" name="dbt_prefix" size="30" value="'.xfs_restore('text:dbt_prefix',$cfg_data['prefix']).'" /><br /><br />');
  echon('<div id="xfs_tfd_admin">');
  echon(xf_i18n('admin_name').':<br /><input type="text" name="admin_name" size="30" value="'.xfs_restore('text:admin_name').'" /><br /><br />');
  echon(xf_i18n('admin_password').':<br /><input type="password" name="admin_password" size="30" value="'.xfs_restore('text:admin_password').'" />');
  echon('</div>');
  echon('</fieldset>');

  echon('<input type="submit" class="xf_setup_button" />');
  echon('</form>');
    if ( isset($_SESSION['xf_setup']['__restore']['sfs']) && !empty($_SESSION['xf_setup']['__restore']['sfs']) )
    echon('<script type="text/javascript">/* <![CDATA[ */ xfs_box(1,1); /* ]]> */</script>');
  } //}}}
  elseif ( __XF_SETUP_STEP === 5 ){ //{{{
    /*$_POST['dbs_type']='mysql';
    $_POST['dbs_host']='localhost';
    $_POST['dbs_username']='homenet';
    $_POST['dbs_password']='mysql';
    $_POST['dbs_name']='heaponly';
    $_POST['dbs_prefix']='phpbb_';
    $_POST['dbt_type']='pgsql';
    $_POST['dbt_host']='localhost';
    $_POST['dbt_username']='homenet';
    $_POST['dbt_password']='pgsql';
    $_POST['dbt_name']='test';
    $_POST['dbt_prefix']='lb1_';
    $_POST['guest_uid']='-1';
    $_POST['admin_name']='august';
    $_POST['admin_password']='test123';*/
  $_POST['sfs'] = ( preg_match('/^[a-z0-9_]+$/Du',$_POST['sfs']) ) ? $_POST['sfs'] : false;
  $_POST['dbs_type'] = ( preg_match('/(mysql|pgsql)/',$_POST['dbs_type']) ) ? $_POST['dbs_type'] : false;
  $_POST['dbs_host'] = preg_replace('/[\x00-\x1f]+/','',$_POST['dbs_host']);
  $_POST['dbs_username'] = preg_replace('/[\x00-\x1f]+/','',$_POST['dbs_username']);
  $_POST['dbs_password'] = preg_replace('/[\x00-\x1f]+/','',$_POST['dbs_password']);
  $_POST['dbs_name'] = preg_replace('/[\x00-\x1f]+/','',$_POST['dbs_name']);
  $_POST['dbs_prefix'] = preg_replace('/[\x00-\x1f]+/','',$_POST['dbs_prefix']);
  $_POST['dbt_type'] = ( preg_match('/(mysql|pgsql)/',$_POST['dbt_type']) ) ? $_POST['dbt_type'] : false;
  $_POST['dbt_host'] = preg_replace('/[\x00-\x1f]+/','',$_POST['dbt_host']);
  $_POST['dbt_username'] = preg_replace('/[\x00-\x1f]+/','',$_POST['dbt_username']);
  $_POST['dbt_password'] = preg_replace('/[\x00-\x1f]+/','',$_POST['dbt_password']);
  $_POST['dbt_name'] = preg_replace('/[\x00-\x1f]+/','',$_POST['dbt_name']);
  $_POST['dbt_prefix'] = preg_replace('/[\x00-\x1f]+/','',$_POST['dbt_prefix']);
  $_POST['guest_uid'] = preg_replace('/[\x00-\x1f]+/','',$_POST['guest_uid']);
  $_POST['admin_name'] = preg_replace('/[\x00-\x1f]+/','',$_POST['admin_name']);
  $_POST['admin_password'] = preg_replace('/[\x00-\x1f]+/','',$_POST['admin_password']);
  $invalid = array();
    if ( is_numeric($_POST['admin_name']) || strlen($_POST['admin_name']) < 3 || strlen($_POST['admin_name']) > 32 )
    $_POST['admin_name'] = false;
    if ( strlen($_POST['admin_password']) < 5 )
    $_POST['admin_password'] = false;

    foreach ( $_POST as $k=>$v ){
      if ( $_POST['sfs'] && ( substr($k,0,6) === 'admin_' ) )
      continue;
      if ( !$_POST['sfs'] && ( substr($k,0,4) === 'dbs_' || $k === 'guest_uid' ) )
      continue;
      if ( $k === 'sfs' )
      continue;
      if ( empty($v) || $v === false )
      $invalid[] = $k;
    }

  $_SESSION['xf_setup']['__restore'] = $_POST;
  $a = ( sizeof($invalid) === 0 ) ? '6' : '4&err='.urlencode(implode(',',$invalid));
  echon('<meta http-equiv="refresh" content="0;url=index.php?step='.$a.'" />');
  } //}}}
  elseif ( __XF_SETUP_STEP === 6 ){ //{{{
  $_POST = $_SESSION['xf_setup']['__restore'];
  $success = true;
  $process = array('dbt');
    if ( $_POST['sfs'] )
    $process[] = 'dbs';

  echon('<fieldset style="display: block;"><legend>'.xf_i18n('database_connection_check').'</legend>');
  echon('<dl>');
    foreach ( $process as $v ){
    $a = false;
    $b = array('type'=>$_POST[$v.'_type'],'host'=>$_POST[$v.'_host'],'name'=>$_POST[$v.'_name'],
    'user'=>$_POST[$v.'_username'],'pass'=>$_POST[$v.'_password']);
      try {
      $db = ( $b['type'] === 'mysql' )
      ? new PDO($b['type'].':host='.$b['host'].';dbname='.$b['name'],$b['user'],$b['pass'])
      : new PDO($b['type'].':dbname='.$b['name'].';user='.$b['user'].';password='.$b['pass'],null,null);
      } catch ( Exception $E ){ $a = $E->getMessage(); }
      if ( $a ){
      $sc = 'fail';
      $success = false;
      }
      else{
      $sc = 'success';
      $a = xf_i18n('database_server_version').' '.htmlspecialchars($db->getAttribute(PDO::ATTR_SERVER_VERSION)).chr(10);
      $a .= htmlspecialchars($db->getAttribute(PDO::ATTR_SERVER_INFO)).chr(10);
      $a .= htmlspecialchars($db->getAttribute(PDO::ATTR_CONNECTION_STATUS));
      }
      if ( $b['type'] === 'mysql' && is_object($db) && version_compare('4.1.0',substr($db->getAttribute(PDO::ATTR_SERVER_VERSION),0,strpos($db->getAttribute(PDO::ATTR_SERVER_VERSION),'-')),'>=') )
      $a .= chr(10).'<span style="color: #f00; font-size: 150%;">'.xf_i18n('mysql_is_too_old').'</span>';
    echon('<dt class="xf_preq_test xf_preq_test_'.$sc.'">['.htmlspecialchars($b['type']).'] '.htmlspecialchars($b['user']).'@'.htmlspecialchars($b['host']).' - '.htmlspecialchars($b['name']).'</dt>');
    echon('<dd>'.nl2br($a).'</dd>');
    $db = null;
    }
  echon('</dl>');
  echon('</fieldset>');

  ( $success )
  ? echon('<button class="xf_setup_button" onclick="location.href=\'index.php?step=7\'">'.xf_i18n((!$_POST['sfs'])?'install':'convert').'</button>')
  : echon('<button class="xf_setup_button" onclick="location.href=\'index.php?step=4\'">'.xf_i18n('back').'</button>');
  } //}}}
  elseif ( __XF_SETUP_STEP === 7 ){ //{{{
  $_POST = $_SESSION['xf_setup']['__restore'];

  // write configuration file and load minimum root class
  $cfg = $_SESSION['xf_setup']['path'].'/config.db.php';
    if ( !is_writeable($cfg) )
    die('<div class="xf_setup_error">'.xf_i18n('configuration_file_not_writeable').' ['.htmlspecialchars($cfg).']</div>');
    else{
    $cfg_new = str_replace(
    array('%engine','%host','%user','%pass','%name','%prefix'),
    array($_POST['dbt_type'],$_POST['dbt_host'],$_POST['dbt_username'],$_POST['dbt_password'],$_POST['dbt_name'],$_POST['dbt_prefix']),
    __XF_SETUP_CONFIG_RAW);
    file_put_contents($cfg,$cfg_new,LOCK_EX);
    }

  define('__XF_INCLUDE',1);
  require_once($_SESSION['xf_setup']['path'].'/class.root.php');
  new XF('setup');
  echo '<div id="xfs_progress_bar_1">&nbsp;</div>';
  echo '<div id="xfs_progress_bar_2">0%</div>';
  xfs__progressbar(0);

  // now fill the database with initial data
  XF::sql_query("SELECT 1",'-','setup.php',__LINE__);
  $sequence_list = array('acl'=>'a_id','group'=>'g_id','post_data'=>'pd_id','post_meta'=>'p_id','post_prefix'=>'pp_id',
  'tag_meta'=>'t_id','user'=>'u_id');
  $tbl_exist = XF::get_table_list(); // filter our tables from database
  $b = XF::tbl('*'); sort($b);
  $tbl_exist = array_intersect($b,$tbl_exist); unset($b);

  //echon('<strong>»» SQL QUERIES ARE ONLY SIMULATED - GO TO SETUP.PHP ON LINE '.(__LINE__).' AND SET "SQL_SIMULATE" TO FALSE ««</strong><hr />');
  //XF::$sql_simulate = true;
  //D($tbl_exist);

  // create tables, if not existing
  XF::sql_transaction('begin');
  $sql_structure = explode('/*###*/',file_get_contents('structure_'.$_POST['dbt_type'].'.sql'));
    foreach ( $sql_structure as $v ){
      if ( sizeof($tbl_exist) !== 0 ){
      preg_match('/CREATE TABLE\s+["]*(.+?)["]*\s+/',$v,$k);
        if ( sizeof($k) !== 2 || in_array(str_replace('{$PREFIX}',__XF_SQL_PREFIX,$k[1]),$tbl_exist,true) )
        continue;
      }
    XF::sql_query(str_replace('{$PREFIX}',__XF_SQL_PREFIX,$v),'','setup.php',__LINE__);
    }

    // empty existing tables and refill with fresh data from 'data_init.sql' on repair run
    if ( sizeof($tbl_exist) !== 0 ){
    XF::sql_query("DELETE FROM ".XF::tbl('acl')." WHERE a_use_group = true AND a_key IN (1,2,3,4,5)",'','setup.php',__LINE__);
    XF::sql_query("TRUNCATE ".XF::tbl('config'),'','setup.php',__LINE__);
    XF::sql_query("TRUNCATE ".XF::tbl('config_task'),'','setup.php',__LINE__);
    XF::sql_query("DELETE FROM ".XF::tbl('group')." WHERE g_id IN (1,2,3,4,5)",'','setup.php',__LINE__);
    XF::sql_query("DELETE FROM ".XF::tbl('post_prefix')." WHERE pp_id IN (1,2,3,4,5)",'','setup.php',__LINE__);
    }

  $sql_data = explode('/*###*/',file_get_contents('data_init.sql'));
    foreach ( $sql_data as $v )
    XF::sql_query(str_replace('{$PREFIX}',__XF_SQL_PREFIX,$v),'','setup.php',__LINE__);
  XF::sql_query("UPDATE ".XF::tbl('config')." SET c_value = :data WHERE c_id = 'root_path'",array('data'=>array($_SESSION['xf_setup']['path'],'str')),'setup.php',__LINE__);
  XF::sql_query("UPDATE ".XF::tbl('config')." SET c_value = :data WHERE c_id = 'root_uri'",array('data'=>array($_SESSION['xf_setup']['uri'],'str')),'setup.php',__LINE__);
  XF::sql_query("UPDATE ".XF::tbl('config')." SET c_value = :data WHERE c_id = 'cookie_path'",array('data'=>array('/','str')),'setup.php',__LINE__);
  XF::sql_query("UPDATE ".XF::tbl('config')." SET c_value = :data WHERE c_id = 'cookie_domain'",array('data'=>array($_SERVER['HTTP_HOST'],'str')),'setup.php',__LINE__);
  XF::sql_query("UPDATE ".XF::tbl('config')." SET c_value = :data WHERE c_id = 'mail_from_mail'",array('data'=>array('webmaster@'.xfs_detect_hostname($_SERVER['HTTP_HOST']),'str')),'setup.php',__LINE__);
  XF::sql_query("UPDATE ".XF::tbl('config')." SET c_value = :data WHERE c_id = 'main_language'",array('data'=>array($_SESSION['xf_setup']['lang'],'str')),'setup.php',__LINE__);
  XF::sql_query("UPDATE ".XF::tbl('config')." SET c_value = :data WHERE c_id = 'main_uuid'",array('data'=>array(XF::uuid(),'str')),'setup.php',__LINE__);
  XF::sql_query("UPDATE ".XF::tbl('config')." SET c_value = :data WHERE c_id = 'main_version'",array('data'=>array(XF::DATABASE_VERSION,'int')),'setup.php',__LINE__);

    // do convert before indexing database
    if ( $_POST['sfs'] ){
    XF::sql_transaction('commit');
    XF::sql_transaction('begin');
    echo '<a name="convertor"></a>';
    require_once('convert_'.$_POST['sfs'].'.php');
      if ( function_exists('xfs__convert_'.$_POST['sfs']) )
      call_user_func('xfs__convert_'.$_POST['sfs']);
    }

    // insert common users and indices only on new installation
    if ( sizeof($tbl_exist) === 0 ){
    copy('./smilies.txt',$_SESSION['xf_setup']['path'].'/cache/smilies.txt');
      if ( !$_POST['sfs'] ){
      XF::sql_query("INSERT INTO ".XF::tbl('user')." (u_uuid,u_name,u_active,u_group,u_time_registration) VALUES (:uuid,:name,:active,:group,:regtime)",array(
      'uuid'=>array(XF::uuid(),'str'),
      'name'=>array('{:guest}','str'),
      'active'=>array('0','str'),
      'group'=>array(1,'int'),
      'regtime'=>array(XF::vault_query('uts'),'int')),'setup.php',__LINE__);
      XF::sql_query("INSERT INTO ".XF::tbl('user')." (u_uuid,u_name,u_active,u_password,u_group,u_time_registration) VALUES (:uuid,:name,:active,:password,:group,:regtime)",array(
      'uuid'=>array(XF::uuid(),'str'),
      'name'=>array($_POST['admin_name'],'str'),
      'active'=>array('1','str'),
      'password'=>array(XF::advhash(sha1(sha1($_POST['admin_password']))),'str'),
      'group'=>array(4,'int'),
      'regtime'=>array(XF::vault_query('uts'),'int')),'setup.php',__LINE__);
      }
    $sql_index = explode('/*###*/',file_get_contents('data_index.sql'));
      foreach ( $sql_index as $v )
      XF::sql_query(str_replace('{$PREFIX}',__XF_SQL_PREFIX,$v),'','setup.php',__LINE__);
      if ( __XF_SQL_ENGINE === 'mysql' )
      XF::sql_query("ALTER TABLE ".XF::tbl('post_data')." ADD FULLTEXT (pd_text)",'','setup.php',__LINE__);
    }

    // purge caches on repair run as we reset these data
    if ( sizeof($tbl_exist) !== 0 ){
    XFCache::purge('simple','config');
    XFCache::purge('simple','group');
    XFCache::purge('simple','subject_prefix');
    XFCache::purge('tpl');
    $sacl = XF::sql_query("SELECT a_action FROM ".XF::tbl('acl')." GROUP BY a_action",'',__METHOD__,__LINE__);
      while ( $r = $sacl->fetchObject() )
      XFCache::purge('acl',crc32($r->a_action));
    $sacl->closeCursor();
    }

    // always update auto_increment or sequences
    foreach ( $sequence_list as $k=>$v ){
    $d = XF::sql_query("SELECT MAX($v) AS lastval FROM ".XF::tbl($k),'','setup.php',__LINE__);
    $e = $d->fetchObject();
    $d->closeCursor();
    $e = ( is_object($e) && isset($e->lastval) ) ? (int)$e->lastval+1 : 1;
      if ( __XF_SQL_ENGINE === 'mysql' )
      XF::sql_query("ALTER TABLE ".XF::tbl($k)." AUTO_INCREMENT=$e",'','setup.php',__LINE__);
      elseif ( __XF_SQL_ENGINE === 'pgsql' )
      XF::sql_query("ALTER SEQUENCE ".XF::tbl($k,true)."_".$v."_seq RESTART WITH $e",'','setup.php',__LINE__);
    }

  XF::sql_transaction('commit');
  echon('<button class="xf_setup_button" onclick="location.href=\'index.php?step=10\'">'.xf_i18n('installation_complete').'</button>');
  xfs__progressbar(100);
  } //}}}
  elseif ( __XF_SETUP_STEP === 8 ){ //{{{
  define('__XF_INCLUDE',1);
  require_once($_SESSION['xf_setup']['path'].'/class.root.php');
  new XF('setup');
  XF::reload_safe_cfg();
  $setmm = XF::sanitize_var(XF::ifset('get','setmm',false),'booli');
  $runupd = XF::sanitize_var(XF::ifset('get','run',false),'bool');
    if ( !is_bool($setmm) ){
    XF::sql_query('UPDATE '.XF::tbl('config').' SET c_value = :cv WHERE c_id = :ci',array(
    'ci'=>array('main_enable','str'),
    'cv'=>array($setmm,'int')),'setup.php',__LINE__);
    XF::reload_safe_cfg();
    }
  $canbeupdated = ( (int)XF::DATABASE_VERSION > (int)XF::get_cfg('_') ) ? true : false;
  $mm = ( XF::get_cfg('main_enable') ) ? xf_i18n('no') : xf_i18n('yes');
  echon(xf_i18n('update_explain').'<br /><br />');
  echon(xf_i18n('current_core_version').' '.XF::VERSION.'<br />');
  echon(xf_i18n('current_database_version').' '.XF::get_cfg('_').'<br />');
  echon(xf_i18n('recent_database_version').' '.XF::DATABASE_VERSION.'<br />');
  echon(xf_i18n('forum_is_in_maintenance_mode').': '.$mm);
    if ( XF::get_cfg('main_enable') )
    echon('[ <a href="index.php?step=8&setmm=0">'.xf_i18n('enable_maintenance_mode').'</a> ]');
    else
    echon('[ <a href="index.php?step=8&setmm=1">'.xf_i18n('disable_maintenance_mode').'</a> ]');
  echon('<hr />');
  unset($setmm);
    if ( !$canbeupdated )
    echon('<strong>'.xf_i18n('all_updates_were_applied').'</strong>');
    elseif ( !XF::get_cfg('main_enable') && $canbeupdated ){
      if ( $runupd ){
      echon('<strong>'.xf_i18n('updates_are_prepared').'</strong>');
      echon('<meta http-equiv="refresh" content="2;url=index.php?step=9" />');
      $_SESSION['xf_setup']['allow_update'] = true;
      }
      else{
      echon('<form action="index.php" method="get">');
      echon('<input type="hidden" name="step" value="8" />');
      echon('<input type="hidden" name="run" value="1" />');
      echon('<input type="submit" class="xf_setup_button" value="'.xf_i18n('perform_update').'" />');
      echon('</form>');
      }
    }
  } //}}}
  elseif ( __XF_SETUP_STEP === 9 ){ //{{{
    if ( !isset($_SESSION['xf_setup']['allow_update']) || !$_SESSION['xf_setup']['allow_update'] )
    echon('<meta http-equiv="refresh" content="2;url=index.php?step=8" />');
    else{
    define('__XF_INCLUDE',1);
    require_once($_SESSION['xf_setup']['path'].'/class.root.php');
    new XF('setup');
    XF::reload_safe_cfg();
    require_once('update_base.php');
    xfs_update(XF::get_cfg('_'),XF::DATABASE_VERSION);
    }
  } //}}}
  elseif ( __XF_SETUP_STEP === 10 ){ //{{{
  echon('<meta http-equiv="refresh" content="2;url='.$_SESSION['xf_setup']['uri'].'/lb_main.php" />');
  session_destroy();
  } //}}}
  elseif ( __XF_SETUP_STEP === 20 ){ //{{{
    if ( $_SERVER['REQUEST_METHOD'] === 'GET' ){
    echon('<form action="index.php" method="post">');
    echon('<input type="hidden" name="step" value="20" />');
    echon(xf_i18n('explain_reset_a_password').'<br /><br />');
    echon(xf_i18n('username_or_userid').': <input type="text" name="f_user" size="30" value="" /><br />');
    echon(xf_i18n('password').': <input type="password" name="f_pass_1" size="30" value="" /><br />');
    echon(xf_i18n('please_repeat').': <input type="password" name="f_pass_2" size="30" value="" /><br /><br />');
    echon('<input type="submit" class="xf_setup_button" />');
    echon('</form>');
    }
    elseif ( $_SERVER['REQUEST_METHOD'] === 'POST' ){
    define('__XF_INCLUDE',1);
    require_once($_SESSION['xf_setup']['path'].'/class.root.php');
    new XF('setup');
    $user = XF::sanitize_var(XF::ifset('post','f_user',''),'str');
    $pass_1 = XF::sanitize_var(XF::ifset('post','f_pass_1',''),'str');
    $pass_2 = XF::sanitize_var(XF::ifset('post','f_pass_2',''),'str');
      if ( sha1($pass_1) !== sha1($pass_2) )
      die('<div class="xf_setup_error">'.xf_i18n('passwords_are_not_equal').'</div>');
      if ( is_numeric($user) ){
      $field = 'u_id';
      $type = 'int';
      $user = intval($user);
      }
      else{
      $field = 'u_name';
      $type = 'str';
      }
    $u = XF::sql_query("UPDATE ".XF::tbl('user')." SET u_active = :active, u_login_fail = 0, u_password = :password WHERE $field = :user",array(
    'user'=>array($user,$type),
    'active'=>array('1','str'),
    'password'=>array(XF::advhash(sha1(sha1($pass_2))),'str')),'setup.php',__LINE__);
      ( $u )
      ? echon(xf_i18n('reset_a_password_complete'))
      : echon(xf_i18n('could_not_set_new_password'));
    }
  } //}}}
  elseif ( __XF_SETUP_STEP === 21 ){ //{{{
    if ( $_SERVER['REQUEST_METHOD'] === 'GET' ){
    echon('<form action="index.php" method="post">');
    echon('<input type="hidden" name="step" value="21" />');
    echon(xf_i18n('explain_password_rehashing').'<br /><br />');
    echon('<input type="submit" class="xf_setup_button" />');
    echon('</form>');
    }
    elseif ( $_SERVER['REQUEST_METHOD'] === 'POST' ){
    define('__XF_INCLUDE',1);
    require_once($_SESSION['xf_setup']['path'].'/class.root.php');
    new XF('setup');
    XF::reload_safe_cfg();
    require_once(XF::vault_query('root_path').'/class.mail.php');
      if ( !isset($_SESSION['xf_setup']['rehash_pwd']) ){
      XF::sql_query("UPDATE ".XF::tbl('user')." SET u_password = '' WHERE u_id != 1",'','setup.php',__LINE__);
      $_SESSION['xf_setup']['rehash_pwd'] = 1;
      }
    $al = parse_ini_file(XF::vault_query('root_path').'/config.root.php');
    $al = explode(',',$al['installed_languages']);
    $txt = array();
      foreach ( $al as $v )
      $txt[$v] = XF::file_handler('lang/'.$v.'/reset_password.txt','','read,local');
    $link = XF::link('login','',true);
    $susr = XF::sql_query("SELECT u_id,u_name,u_mail,u_language FROM ".XF::tbl('user')." WHERE u_id != 1 AND u_password = ''",'','setup.php',__LINE__);
      if ( $susr->rowCount() === 0 ){
      echon(xf_i18n('password_rehashing_complete'));
      die();
      }

      while ( $r = $susr->fetchObject() ){
        if ( empty($r->u_mail) )
        continue;
      $password = XF::token(8);
      $language = ( !empty($r->u_language) && isset($txt[$r->u_language]) ) ? $r->u_language : 'en';
      $u = XF::sql_query("UPDATE ".XF::tbl('user')." SET u_password = :password WHERE u_id = :userid",
      array('userid'=>array($r->u_id,'int'),
      'password'=>array(XF::advhash(sha1(sha1($password))),'str')),'setup.php',__LINE__);
        if ( !$u )
        continue;
      $m = XFMail::send(array(
      'nolog'=>true,
      'to'=>$r->u_mail,
      'subject'=>XF::get_cfg('main_title').' - New password',
      'message'=>sprintf($txt[$language],
        XF::get_cfg('main_title'),
        $r->u_name,
        $r->u_name,
        $password,
        $link,
        XF::get_cfg('mail_from_name')
        )
      ));
      }
    $susr->closeCursor();
    echon(xf_i18n('password_rehashing_complete'));
    }
  } //}}}
  elseif ( __XF_SETUP_STEP === 22 ){ //{{{
    if ( $_SERVER['REQUEST_METHOD'] === 'GET' ){
    echon('<form action="index.php" method="post">');
    echon('<input type="hidden" name="step" value="22" />');
    echon(xf_i18n('explain_verify_database_integrity').'<br /><br />');
    echon('<input type="submit" class="xf_setup_button" />');
    echon('</form>');
    }
    elseif ( $_SERVER['REQUEST_METHOD'] === 'POST' ){
    define('__XF_INCLUDE',1);
    require_once($_SESSION['xf_setup']['path'].'/class.root.php');
    new XF('setup');
      if ( !isset($_SESSION['xf_setup']['verify_database']) ){
      $_SESSION['xf_setup']['verify_database'] = array(
      'acl_1'=>false,
      'acl_2'=>false,
      'post_data_1'=>false,
      'post_data_2'=>false,
      'post_meta_1'=>false,
      'post_meta_2'=>false,
      'post_meta_3'=>false,
      'post_meta_4'=>false,
      'post_rating_1'=>false,
      'post_rating_2'=>false,
      'tag_data_1'=>false,
      'tag_data_2'=>false,
      'user_1'=>false,
      'user_blacklist_1'=>false,
      'user_blacklist_2'=>false,
      'user_bookmark_1'=>false,
      'user_bookmark_2'=>false,
      'user_request_1'=>false,
      'user_request_2'=>false
      );
      }
    $groups = array();
    $sgrp = XF::sql_query("SELECT g_id FROM ".XF::tbl('group'),'');
      while ( $r = $sgrp->fetchObject() )
      $groups[] = (int)$r->g_id;
    $sgrp->closeCursor();
   // we inform user only on issues he should check afterwards...

      if ( !$_SESSION['xf_setup']['verify_database']['acl_1'] ){
      echon(sprintf(xf_i18n('database_integrity_check_step'),'acl_1'));
      $sac1 = XF::sql_query("SELECT a_id,a_action FROM ".XF::tbl('acl')."
      LEFT JOIN ".XF::tbl('group')." ON ".XF::tbl('group').".g_id = a_key
      WHERE a_use_group = true AND g_id IS NULL",'','setup.php',__LINE__);
        while ( $r = $sac1->fetchObject() )
        XF::sql_query("DELETE FROM ".XF::tbl('acl')." WHERE a_id = :id",array('id'=>array((int)$r->a_id,'int')),'setup.php',__LINE__);
      $sac1->closeCursor();
      $sac2 = XF::sql_query("SELECT COUNT(a_id) AS rule_count,a_action FROM ".XF::tbl('acl')."
      WHERE a_use_group = true GROUP BY a_action ORDER BY rule_count",'','setup.php',__LINE__);
        while ( $r = $sac2->fetchObject() ){
          if ( (int)$r->rule_count === sizeof($groups) )
          break;
        $missing = array_flip($groups);
        $srep = XF::sql_query("SELECT a_key FROM ".XF::tbl('acl')." WHERE a_action = :action AND a_use_group = true",array('action'=>array($r->a_action,'str')),'setup.php',__LINE__);
          while ( $r2 = $srep->fetchObject() ){
            if ( isset($missing[(int)$r2->a_key]) )
            unset($missing[(int)$r2->a_key]);
          }
        $srep->closeCursor();
          foreach ( $missing as $k=>$v ){
          XF::sql_query("INSERT INTO ".XF::tbl('acl')." (a_action,a_key,a_use_group,a_allow) VALUES (:action,:gid,true,false)",array(
          'action'=>array($r->a_action,'str'),
          'gid'=>array($k,'int')
          ),'setup.php',__LINE__);
          echon(sprintf(xf_i18n('dic_insert_acl'),$r->a_action,$k));
          }
        }
      $sac2->closeCursor();
      $_SESSION['xf_setup']['verify_database']['acl_1'] = true;
      unset($missing,$k,$v,$r,$r2,$sac1,$sac2,$srep);
      }
      else
      echon(sprintf(xf_i18n('database_integrity_skip_step'),'acl_1'));

      // TODO: most routines are basicly the same. probably the code can be generated dynamically during a loop...
      if ( !$_SESSION['xf_setup']['verify_database']['acl_2'] ){
      echon(sprintf(xf_i18n('database_integrity_check_step'),'acl_2'));
      $sac2 = XF::sql_query("SELECT a_id FROM ".XF::tbl('acl')."
      LEFT JOIN ".XF::tbl('user')." ON ".XF::tbl('user').".u_id = a_key
      WHERE a_use_group = false AND u_id IS NULL",'','setup.php',__LINE__);
        while ( $r = $sac2->fetchObject() )
        XF::sql_query("DELETE FROM ".XF::tbl('acl')." WHERE a_id = :id",array('id'=>array((int)$r->a_id,'int')),'setup.php',__LINE__);
      $sac2->closeCursor();
      $_SESSION['xf_setup']['verify_database']['acl_2'] = true;
      unset($r,$sac2);
      }
      else
      echon(sprintf(xf_i18n('database_integrity_skip_step'),'acl_2'));

      if ( !$_SESSION['xf_setup']['verify_database']['post_data_1'] ){
      echon(sprintf(xf_i18n('database_integrity_check_step'),'post_data_1'));
      $spd1 = XF::sql_query("SELECT pd_id FROM ".XF::tbl('post_data')."
      LEFT JOIN ".XF::tbl('post_meta')." ON ".XF::tbl('post_meta').".p_id = pd_p_id
      WHERE pd_p_id IS NULL",'','setup.php',__LINE__);
        while ( $r = $spd1->fetchObject() )
        XF::sql_query("DELETE FROM ".XF::tbl('post_data')." WHERE pd_p_id = :id",array('id'=>array((int)$r->pd_id,'int')),'setup.php',__LINE__);
      $spd1->closeCursor();
      $_SESSION['xf_setup']['verify_database']['post_data_1'] = true;
      unset($r,$spd1);
      }
      else
      echon(sprintf(xf_i18n('database_integrity_skip_step'),'post_data_1'));

      if ( !$_SESSION['xf_setup']['verify_database']['post_data_2'] ){
      echon(sprintf(xf_i18n('database_integrity_check_step'),'post_data_2'));
      $spd2 = XF::sql_query("SELECT pd_id FROM ".XF::tbl('post_data')."
      LEFT JOIN ".XF::tbl('user')." ON ".XF::tbl('user').".u_id = pd_edit_u_id
      WHERE pd_edit_u_id IS NULL",'','setup.php',__LINE__);
        while ( $r = $spd2->fetchObject() ){
        XF::sql_query("UPDATE ".XF::tbl('post_data')." SET pd_edit_u_id = 1 WHERE pd_id = :id",array('id'=>array((int)$r->pd_id,'int')),'setup.php',__LINE__);
        echon(sprintf(xf_i18n('dic_update_post_data'),$r->pd_id));
        }
      $spd2->closeCursor();
      $_SESSION['xf_setup']['verify_database']['post_data_2'] = true;
      unset($r,$spd2);
      }
      else
      echon(sprintf(xf_i18n('database_integrity_skip_step'),'post_data_2'));

      if ( !$_SESSION['xf_setup']['verify_database']['post_meta_1'] ){
      echon(sprintf(xf_i18n('database_integrity_check_step'),'post_meta_1'));
      XF::sql_query("UPDATE ".XF::tbl('post_meta')." SET p_topic_id = p_id WHERE p_is_topic = true AND p_topic_id != p_id",'','setup.php',__LINE__);
      XF::sql_query("UPDATE ".XF::tbl('post_meta')." SET p_pp_id = 0, p_weight = 0, p_closed = false, p_acl = '' WHERE p_is_topic = false",'','setup.php',__LINE__);
      $_SESSION['xf_setup']['verify_database']['post_meta_1'] = true;
      }
      else
      echon(sprintf(xf_i18n('database_integrity_skip_step'),'post_meta_1'));

      if ( !$_SESSION['xf_setup']['verify_database']['post_meta_2'] ){
      echon(sprintf(xf_i18n('database_integrity_check_step'),'post_meta_2'));
      $spm1 = XF::sql_query("SELECT p_id FROM ".XF::tbl('post_meta')."
      LEFT JOIN ".XF::tbl('post_data')." ON ".XF::tbl('post_data').".pd_id = p_pd_id
      WHERE p_pd_id IS NULL",'','setup.php',__LINE__);
        while ( $r = $spm1->fetchObject() )
        XF::sql_query("DELETE FROM ".XF::tbl('post_meta')." WHERE p_id = :id",array('id'=>array((int)$r->p_id,'int')),'setup.php',__LINE__);
      $spm1->closeCursor();
      $_SESSION['xf_setup']['verify_database']['post_meta_2'] = true;
      unset($r,$spm1);
      }
      else
      echon(sprintf(xf_i18n('database_integrity_skip_step'),'post_meta_2'));

      if ( !$_SESSION['xf_setup']['verify_database']['post_meta_3'] ){
      echon(sprintf(xf_i18n('database_integrity_check_step'),'post_meta_3'));
      $spm2 = XF::sql_query("SELECT p_id FROM ".XF::tbl('post_meta')."
      LEFT JOIN ".XF::tbl('user')." ON ".XF::tbl('user').".u_id = p_u_id
      WHERE p_u_id IS NULL",'','setup.php',__LINE__);
        while ( $r = $spm2->fetchObject() ){
        XF::sql_query("UPDATE ".XF::tbl('post_meta')." SET p_u_id = 1 WHERE p_id = :id",array('id'=>array((int)$r->p_id,'int')),'setup.php',__LINE__);
        echon(sprintf(xf_i18n('dic_update_post_meta'),$r->p_id));
        }
      $spm2->closeCursor();
      $_SESSION['xf_setup']['verify_database']['post_meta_3'] = true;
      unset($r,$spm2);
      }
      else
      echon(sprintf(xf_i18n('database_integrity_skip_step'),'post_meta_3'));

      if ( !$_SESSION['xf_setup']['verify_database']['post_meta_4'] ){
      echon(sprintf(xf_i18n('database_integrity_check_step'),'post_meta_4'));
      $spm3 = XF::sql_query("SELECT p_id FROM ".XF::tbl('post_meta')."
      LEFT JOIN ".XF::tbl('post_prefix')." ON ".XF::tbl('post_prefix').".pp_id = p_pp_id
      WHERE p_pp_id IS NULL",'','setup.php',__LINE__);
        while ( $r = $spm3->fetchObject() )
        XF::sql_query("UPDATE ".XF::tbl('post_meta')." SET p_pp_id = 0 WHERE p_id = :id",array('id'=>array((int)$r->p_id,'int')),'setup.php',__LINE__);
      $spm3->closeCursor();
      $_SESSION['xf_setup']['verify_database']['post_meta_4'] = true;
      unset($r,$spm3);
      }
      else
      echon(sprintf(xf_i18n('database_integrity_skip_step'),'post_meta_4'));

      if ( !$_SESSION['xf_setup']['verify_database']['post_rating_1'] ){
      echon(sprintf(xf_i18n('database_integrity_check_step'),'post_rating_1'));
      $spr1 = XF::sql_query("SELECT pr_p_id,p_id FROM ".XF::tbl('post_rating')."
      LEFT JOIN ".XF::tbl('post_meta')." ON ".XF::tbl('post_meta').".p_id = pr_p_id
      WHERE p_id IS NULL",'','setup.php',__LINE__);
        while ( $r = $spr1->fetchObject() )
        XF::sql_query("DELETE FROM ".XF::tbl('post_rating')." WHERE pr_p_id = :id",array('id'=>array((int)$r->pr_p_id,'int')),'setup.php',__LINE__);
      $spr1->closeCursor();
      $_SESSION['xf_setup']['verify_database']['post_rating_1'] = true;
      unset($r,$spr1);
      }
      else
      echon(sprintf(xf_i18n('database_integrity_skip_step'),'post_rating_1'));

      if ( !$_SESSION['xf_setup']['verify_database']['post_rating_2'] ){
      echon(sprintf(xf_i18n('database_integrity_check_step'),'post_rating_2'));
      $spr2 = XF::sql_query("SELECT pr_u_id,u_id FROM ".XF::tbl('post_rating')."
      LEFT JOIN ".XF::tbl('user')." ON ".XF::tbl('user').".u_id = pr_u_id
      WHERE u_id IS NULL",'','setup.php',__LINE__);
        while ( $r = $spr2->fetchObject() )
        XF::sql_query("DELETE FROM ".XF::tbl('post_rating')." WHERE pr_u_id = :id",array('id'=>array((int)$r->pr_u_id,'int')),'setup.php',__LINE__);
      $spr2->closeCursor();
      $_SESSION['xf_setup']['verify_database']['post_rating_2'] = true;
      unset($r,$spr2);
      }
      else
      echon(sprintf(xf_i18n('database_integrity_skip_step'),'post_rating_2'));

      if ( !$_SESSION['xf_setup']['verify_database']['tag_data_1'] ){
      echon(sprintf(xf_i18n('database_integrity_check_step'),'tag_data_1'));
      $std1 = XF::sql_query("SELECT td_t_id,t_id FROM ".XF::tbl('tag_data')."
      LEFT JOIN ".XF::tbl('tag_meta')." ON ".XF::tbl('tag_meta').".t_id = td_t_id
      WHERE t_id IS NULL",'','setup.php',__LINE__);
        while ( $r = $std1->fetchObject() )
        XF::sql_query("DELETE FROM ".XF::tbl('tag_data')." WHERE td_t_id = :id",array('id'=>array((int)$r->td_t_id,'int')),'setup.php',__LINE__);
      $std1->closeCursor();
      $_SESSION['xf_setup']['verify_database']['tag_data_1'] = true;
      unset($r,$std1);
      }
      else
      echon(sprintf(xf_i18n('database_integrity_skip_step'),'tag_data_1'));

      if ( !$_SESSION['xf_setup']['verify_database']['tag_data_2'] ){
      echon(sprintf(xf_i18n('database_integrity_check_step'),'tag_data_2'));
      $std2 = XF::sql_query("SELECT td_p_id,p_id FROM ".XF::tbl('tag_data')."
      LEFT JOIN ".XF::tbl('post_meta')." ON ".XF::tbl('post_meta').".p_id = td_p_id
      WHERE p_id IS NULL",'','setup.php',__LINE__);
        while ( $r = $std2->fetchObject() )
        XF::sql_query("DELETE FROM ".XF::tbl('tag_data')." WHERE td_p_id = :id",array('id'=>array((int)$r->td_p_id,'int')),'setup.php',__LINE__);
      $std2->closeCursor();
      $_SESSION['xf_setup']['verify_database']['tag_data_2'] = true;
      unset($r,$std2);
      }
      else
      echon(sprintf(xf_i18n('database_integrity_skip_step'),'tag_data_2'));

      if ( !$_SESSION['xf_setup']['verify_database']['user_1'] ){
      echon(sprintf(xf_i18n('database_integrity_check_step'),'user_1'));
      $sus1 = XF::sql_query("SELECT u_id,g_id FROM ".XF::tbl('user')."
      LEFT JOIN ".XF::tbl('group')." ON ".XF::tbl('group').".g_id = u_group
      WHERE g_id IS NULL",'','setup.php',__LINE__);
        while ( $r = $sus1->fetchObject() ){
        XF::sql_query("UPDATE ".XF::tbl('user')." SET u_group = 1 WHERE u_id = :id",array('id'=>array((int)$r->u_id,'int')),'setup.php',__LINE__);
        echon(sprintf(xf_i18n('dic_update_user_group'),$r->u_id));
        }
      $sus1->closeCursor();
      $_SESSION['xf_setup']['verify_database']['user_1'] = true;
      unset($r,$sus1);
      }
      else
      echon(sprintf(xf_i18n('database_integrity_skip_step'),'user_1'));

      if ( !$_SESSION['xf_setup']['verify_database']['user_blacklist_1'] ){
      echon(sprintf(xf_i18n('database_integrity_check_step'),'user_blacklist_1'));
      $sub1 = XF::sql_query("SELECT ub_u_id_src,u_id FROM ".XF::tbl('user_blacklist')."
      LEFT JOIN ".XF::tbl('user')." ON ".XF::tbl('user').".u_id = ub_u_id_src
      WHERE u_id IS NULL",'');
        while ( $r = $sub1->fetchObject() )
        XF::sql_query("DELETE FROM ".XF::tbl('user_blacklist')." WHERE ub_u_id_src = :id",array('id'=>array((int)$r->ub_u_id_src,'int')));
      $sub1->closeCursor();
      $_SESSION['xf_setup']['verify_database']['user_blacklist_1'] = true;
      unset($r,$sub1);
      }
      else
      echon(sprintf(xf_i18n('database_integrity_skip_step'),'user_blacklist_1'));

      if ( !$_SESSION['xf_setup']['verify_database']['user_blacklist_2'] ){
      echon(sprintf(xf_i18n('database_integrity_check_step'),'user_blacklist_2'));
      $sub2 = XF::sql_query("SELECT ub_u_id_dst,u_id FROM ".XF::tbl('user_blacklist')."
      LEFT JOIN ".XF::tbl('user')." ON ".XF::tbl('user').".u_id = ub_u_id_dst
      WHERE u_id IS NULL",'','setup.php',__LINE__);
        while ( $r = $sub2->fetchObject() )
        XF::sql_query("DELETE FROM ".XF::tbl('user_blacklist')." WHERE ub_u_id_dst = :id",array('id'=>array((int)$r->ub_u_id_src,'int')),'setup.php',__LINE__);
      $sub2->closeCursor();
      $_SESSION['xf_setup']['verify_database']['user_blacklist_2'] = true;
      unset($r,$sub2);
      }
      else
      echon(sprintf(xf_i18n('database_integrity_skip_step'),'user_blacklist_2'));

      if ( !$_SESSION['xf_setup']['verify_database']['user_bookmark_1'] ){
      echon(sprintf(xf_i18n('database_integrity_check_step'),'user_bookmark_1'));
      $suk1 = XF::sql_query("SELECT uk_u_id,u_id FROM ".XF::tbl('user_bookmark')."
      LEFT JOIN ".XF::tbl('user')." ON ".XF::tbl('user').".u_id = uk_u_id
      WHERE u_id IS NULL",'','setup.php',__LINE__);
        while ( $r = $suk1->fetchObject() )
        XF::sql_query("DELETE FROM ".XF::tbl('user_bookmark')." WHERE uk_u_id = :id",array('id'=>array((int)$r->uk_u_id,'int')),'setup.php',__LINE__);
      $suk1->closeCursor();
      $_SESSION['xf_setup']['verify_database']['user_bookmark_1'] = true;
      unset($r,$suk1);
      }
      else
      echon(sprintf(xf_i18n('database_integrity_skip_step'),'user_bookmark_1'));

      if ( !$_SESSION['xf_setup']['verify_database']['user_bookmark_2'] ){
      echon(sprintf(xf_i18n('database_integrity_check_step'),'user_bookmark_2'));
      $suk2 = XF::sql_query("SELECT uk_p_id,p_id FROM ".XF::tbl('user_bookmark')."
      LEFT JOIN ".XF::tbl('post_meta')." ON ".XF::tbl('post_meta').".p_id = uk_p_id
      WHERE p_id IS NULL",'','setup.php',__LINE__);
        while ( $r = $suk2->fetchObject() )
        XF::sql_query("DELETE FROM ".XF::tbl('user_bookmark')." WHERE uk_p_id = :id",array('id'=>array((int)$r->uk_p_id,'int')),'setup.php',__LINE__);
      $suk2->closeCursor();
      $_SESSION['xf_setup']['verify_database']['user_bookmark_2'] = true;
      unset($r,$suk2);
      }
      else
      echon(sprintf(xf_i18n('database_integrity_skip_step'),'user_bookmark_2'));

      if ( !$_SESSION['xf_setup']['verify_database']['user_request_1'] ){
      echon(sprintf(xf_i18n('database_integrity_check_step'),'user_request_1'));
      $sur1 = XF::sql_query("SELECT ur_u_id,u_id FROM ".XF::tbl('user_request')."
      LEFT JOIN ".XF::tbl('user')." ON ".XF::tbl('user').".u_id = ur_u_id
      WHERE u_id IS NULL",'','setup.php',__LINE__);
        while ( $r = $sur1->fetchObject() )
        XF::sql_query("DELETE FROM ".XF::tbl('user_request')." WHERE ur_u_id = :id",array('id'=>array((int)$r->ur_u_id,'int')),'setup.php',__LINE__);
      $sur1->closeCursor();
      $_SESSION['xf_setup']['verify_database']['user_request_1'] = true;
      unset($r,$sur1);
      }
      else
      echon(sprintf(xf_i18n('database_integrity_skip_step'),'user_request_1'));

      if ( !$_SESSION['xf_setup']['verify_database']['user_request_2'] ){
      echon(sprintf(xf_i18n('database_integrity_check_step'),'user_request_2'));
      $sur2 = XF::sql_query("SELECT ur_data_int,p_id FROM ".XF::tbl('user_request')."
      LEFT JOIN ".XF::tbl('post_meta')." ON ".XF::tbl('post_meta').".p_id = ur_data_int
      WHERE ur_class = 'REPORT_POSTING' AND p_id IS NULL",'','setup.php',__LINE__);
        while ( $r = $sur2->fetchObject() )
        XF::sql_query("DELETE FROM ".XF::tbl('user_request')." WHERE ur_data_int = :id AND ur_class = 'REPORT_POSTING'",array('id'=>array((int)$r->ur_data_int,'int')),'setup.php',__LINE__);
      $sur2->closeCursor();
      $_SESSION['xf_setup']['verify_database']['user_request_2'] = true;
      unset($r,$sur2);
      }
      else
      echon(sprintf(xf_i18n('database_integrity_skip_step'),'user_request_2'));

      if ( array_sum($_SESSION['xf_setup']['verify_database']) === sizeof($_SESSION['xf_setup']['verify_database']) )
      echon(xf_i18n('database_integrity_check_complete'));

    }
  } //}}}
  elseif ( __XF_SETUP_STEP === 23 ){ //{{{
  define('__XF_INCLUDE',1);
  require_once($_SESSION['xf_setup']['path'].'/class.root.php');
  new XF('setup');
    if ( $_SERVER['REQUEST_METHOD'] === 'GET' ){
    echon('<form action="index.php" method="post">');
    echon('<input type="hidden" name="step" value="23" />');
    echon(xf_i18n('explain_edit_configuration').'<br /><br />');
    $scfg = XF::sql_query("SELECT * FROM ".XF::tbl('config')." ORDER BY c_id",'',__METHOD__,__LINE__);
      while ( $r = $scfg->fetchObject() )
      echon(htmlspecialchars($r->c_id).'<br /><input type="text" name="f_'.$r->c_id.'" size="60" value="'.htmlspecialchars($r->c_value).'" /><br /><br />');
    $scfg->closeCursor();
    echon('<input type="submit" class="xf_setup_button" />');
    echon('</form>');
    }
    elseif ( $_SERVER['REQUEST_METHOD'] === 'POST' ){
      foreach ( $_POST as $k=>$v ){
        if ( substr($k,0,2) !== 'f_' )
        continue;
      XF::sql_query("UPDATE ".XF::tbl('config')." SET c_value = :value WHERE c_id = :key",array(
      'key'=>array(substr($k,2),'str'),
      'value'=>array($v,'str')),'setup.php',__LINE__);
      }
    XFCache::purge('simple','config');
    echon(xf_i18n('configuration_edit_complete'));
    }
  } //}}}
  elseif ( __XF_SETUP_STEP === 24 ){ //{{{
    if ( $_SERVER['REQUEST_METHOD'] === 'GET' ){
    echon('<form action="index.php" method="post">');
    echon('<input type="hidden" name="step" value="24" />');
    echon(xf_i18n('explain_purge_local_caches').'<br /><br />');
    echon('<input type="submit" class="xf_setup_button" />');
    echon('</form>');
    }
    elseif ( $_SERVER['REQUEST_METHOD'] === 'POST' ){
    define('__XF_INCLUDE',1);
    require_once($_SESSION['xf_setup']['path'].'/class.root.php');
    new XF('setup');
    XF::reload_safe_cfg();
    $rp = XF::get_cfg('root_path');
    $cache_files = XF::rscandir(XFCache::getdir());
      foreach ( $cache_files as $v ){
        if ( in_array(substr($v,-3),array('tpl','php'),true) && !strpos($v,'smilies.txt') && !strpos($v,'rewrite.txt') ){
          if ( unlink($v) )
          echon('&nbsp;&nbsp;&nbsp;· '.str_replace($rp,'',$v).'<br />');
        }
      }
    echon(xf_i18n('purging_local_caches_complete'));
    }
  } //}}}
  elseif ( __XF_SETUP_STEP === 99 ){ //{{{
  echo '<div id="xfs_progress_bar_1">&nbsp;</div>';
  echo '<div id="xfs_progress_bar_2">0%</div>';
  xfs__progressbar(0);
  echo '<script language="javascript">/* <![CDATA[ */
  var cnt = -1;
    function xfs__endless_progressbar(){
    cnt++;
    clr = ( cnt > 5 ) ? "0,"+Math.ceil(((cnt-3)/10)*255)+",255" : "0,0,"+Math.ceil((cnt/5)*255);
    document.getElementById("xfs_progress_bar_1").style.width=(cnt*10)+"%";
    document.getElementById("xfs_progress_bar_1").style.backgroundColor="rgb("+clr+")";
    document.getElementById("xfs_progress_bar_2").innerHTML=(cnt*10)+"% ["+clr+"]";
      if ( cnt == 10 )
      cnt = -1;
    window.setTimeout("xfs__endless_progressbar()",1000);
    }
  xfs__endless_progressbar();
  /* ]]> */</script>';
  } //}}}

?>
</div>
  <div class="xf_setup_foot">
  Copyright by <a href="http://savannah.nongnu.org/projects/larusboard/" target="_blank">"The Larus Board Team"</a>, 2008,2009,2010.
  All rights reserved; licensed under modified BSD license.<br />
  Current template "default" is licensed under Creative Commons Attribution-Share Alike (by-sa).
  </div>
</body>
</html>