<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009,2010 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_acp_cfg_edit extends XFAction {
const USE_TAN = true;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','acp');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  XFUI::html_redirect(-1,XF::link('acp_overview'));
  return true;
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function ajax($input){
  $this->gpc = $input;
  return true;
  }

  /**
  * edit configuration variables
  * @return boolean
  * @since 1.0.0
  */
  public function execute(){
  XFCache::put('simple','smilies',array(
  array('-@','ext/face-devilish.png'),
  array('-x','ext/face-kiss.png'),
  array(':(','ext/face-sad.png'),
  array(':D','ext/face-grin.png'),
  array(':o','ext/face-surprise.png'),
  array(':)','ext/face-smile.png'),
  array(';)','ext/face-wink.png')
  ));
  $hide = array('_','main_umask','main_uuid','main_version');

    try {
    XF::sql_query("SELECT 1",'',__METHOD__,__LINE__);
    $constraint = XF::get_cfg_data();
    $process = array();
      foreach ( $this->gpc as $k=>$v ){
        if ( preg_match('/^f_([a-z_]+)$/Du',$k,$v) ){
          if ( isset($v[1]) && !isset($constraint[$v[1]]) )
          continue;
        $process[] = XF::$sql->quote($v[1]);
        }
      }
      if ( sizeof($process) === 0 )
      $this->error = '{:no_valid_id}';

      if ( empty($this->error) ){
        if ( !XF::sql_transaction('begin',array('config'=>'w')) )
        throw new XFE('unable to begin database transaction');
      $scfg = XF::sql_query("SELECT * FROM ".XF::tbl('config')." WHERE c_id IN (".implode(',',$process).")",__METHOD__,__LINE__);
      $process = array('info');
        while ( $r = $scfg->fetchObject() ){
          if ( in_array($r->c_id,$hide,true) )
          continue;
        $a = ( isset($constraint[$r->c_id][1]) ) ? $constraint[$r->c_id][1] : '';
          if ( $constraint[$r->c_id][0] === 'bool' ) // well, on form data 'booli' is more useful as we send zero or one per http
          $constraint[$r->c_id][0] = 'booli';
          if ( $constraint[$r->c_id][0] === 'uri' ) // if it contains '{$ROOT_URI}' this fails on checking, therefore use 'str' here
          $constraint[$r->c_id][0] = 'str';
        $b = XF::sanitize_var($this->gpc['f_'.$r->c_id],$constraint[$r->c_id][0],$a);
          if ( $b === false )
          throw new XFE('illegal input in "'.$r->c_id.'" - requires "'.$constraint[$r->c_id][0].'"');
        $c = ( is_numeric($b) ) ? 'int' : 'str';
        $u = XF::sql_query("UPDATE ".XF::tbl('config')." SET c_value = :value WHERE c_id = :id",array(
        'id'=>array($r->c_id,'str'),
        'value'=>array($b,$c)),__METHOD__,__LINE__);
          if ( $u ){
          $process[] = 'key';
          $process[] = $r->c_id;
          $process[] = 'value';
          $process[] = $b;
          }
        }
      $scfg->closeCursor();
      XFCache::purge('simple','config');
      XF::logger($process);
      XF::sql_transaction('commit');

      $forward = array();
      $scfg = XF::sql_query("SELECT * FROM ".XF::tbl('config')." WHERE c_id IN ('http_rewrite_server','param_file','root_uri')",__METHOD__,__LINE__);
        while ( $r = $scfg->fetchObject() )
        $forward[$r->c_id] = $r->c_value;
      $forward['param_file'] = str_replace('{$ROOT_URI}',$forward['root_uri'],$forward['param_file']);
      $scfg->closeCursor();
      XF::file_handler(XFCache::getdir().'/rewrite.txt',self::parse_rewrite_rules($forward['http_rewrite_server'],$forward['param_file']),'write,local,verify');
      $this->success = true;
      }

    } catch ( XFE $E ){ $E->handle(); if ( $E->check_abort() ) return false; }
  return true;
  }

  /**
  * parse rewrite rules according to server software
  * @param string $a select server class, available: apache, lighttpd
  * @param string $b full uri to "public", usually a copy of cfg[param_file]
  * @return string
  * @since 1.1.0
  */
  protected function parse_rewrite_rules($a,$b){
    if ( !in_array($a,array('apache','lighttpd'),true) )
    $a = 'apache';
  $c = parse_url($b);
  $r = array(
  array('([a-z_]+)_.html','?do=$1'),
  array('([a-z_]+)__id.([0-9]+).html','?do=$1&id=$2'),
  array('([a-z_]+)__id.([0-9]+)-quote.([0-9]+).html','?do=$1&id=$2&quote=$3'),
  array('([a-z_]+)__stage.([a-z0-9_]+).html','?do=$1&stage=$2'),
  array('([a-z_]+)__[^-]+-stage.([a-z0-9_]+)-id.([0-9Z]+).html','?do=$1&stage=$2&id=$3'),
  array('overview__mark_all_postings_as-read.1.html','?do=overview&read=1'),
  array('overview__imprint_and_privacy-legal.1.html','?do=overview&legal=1'),
  array('topic__[^-]+-id.([0-9]+).html','?do=topic&id=$1'),
  array('topic__[^-]+-id.([0-9]+)-start.([0-9]+).html','?do=topic&id=$1&start=$2'),
  array('topic__[^-]+-post.([0-9]+).html','?do=topic&post=$1'),
  array('topic__[^-]+-post.([0-9]+)-single.1.html','?do=topic&id=$1&single=1'),
  array('search__stage.result-hash.([0-9-]+).html','?do=search&stage=result&hash=$1'),
  array('search__stage.result-hash.([0-9-]+)-start.([0-9]+).html','?do=search&stage=result&hash=$1&start=$2'),
  array('search__clear.1.html','?do=search&clear=1'),
  array('rss__our_recent_postings-module.last.html','?do=rss&module=last'),
  array('rss__[^-]+-module.topic-id.([0-9]+).html','?do=rss&module=topic&id=$1'),
  array('vcard__[^-]+-user.([0-9]+).html','?do=vcard&user=$1'),
  );
  $o = '# Here are our rewrite rules for Larus Board to provide search-engine friendly uri on public frontend'.chr(10);
  $o .= '# syntax: '.$a.', root: '.$b.chr(10);
  $o .= '# date: '.gmdate('r').chr(10);
  $o .= '#'.chr(10);
    if ( $a === 'apache' )
    $o .= 'RewriteEngine On'.chr(10);
    elseif ( $a === 'lighttpd' )
    $o .= 'url.rewrite-once = ('.chr(10);
    foreach ( $r as $v ){
      if ( $a === 'apache' )
      $o .= 'RewriteRule ^'.$v[0].'$ '.$c['path'].$v[1].chr(10);
      elseif ( $a === 'lighttpd' )
      $o .= '"/'.$v[0].'$"=>"'.$c['path'].$v[1].'",'.chr(10);
    }
    if ( $a === 'lighttpd' )
    $o .= ')';
  return $o;
  }

}

  function xfaf_acp_cfg_edit($input){
  $a = new XFAction_acp_cfg_edit();
  $a->init('ajax',$input);
    if ( !xfaf_process_data($a->get_GPC(),$a->get_mark_GPC()) )
    return false;
  $a->execute();
    if ( $a->get_success() )
    return xfaf_success(XF::link('acp_cfg_list','',false),'{:edit_cfg_successful}');
    else
    return xfaf_failure($a->get_error());
  }

?>