<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009,2010 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_logout extends XFAction {
const USE_TAN = false;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','login');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
    if ( session_id() ){
    XF::cookie(XF::get_cfg('cookie_session'),null);
      if ( $_SESSION['xf_authentication']['auto_login'] ) // hmm, use random values to prevent plain-text attacks to our encryption key?
      XF::cookie(XF::get_cfg('cookie_autologin').'_prevent',XF::token(16,'alnum'));
    session_destroy();
    XF::sql_query("UPDATE ".XF::tbl('user')." SET u_comment = '', u_time_last_read = :now, u_login_token = 0 WHERE u_id = :id",
    array('id'=>array(XF::vault_query('current_user_id'),'int'),
    'now'=>array(XF::vault_query('uts'),'int')),__METHOD__,__LINE__);
    XFCache::purge('user',XF::vault_query('current_user_id'));
    XF::logger('info','..');
    XFUI::html_redirect(1,XF::link('overview'),'{:you_are_now_logged_out}');
    }
    else
    XFUI::html_redirect(0,XF::link('overview'),'{:no_valid_id}');
  return true;
  }

  /**
  * @since 1.0.0
  */
  protected function ajax($input){}

  /**
  * log an user out (done by run())
  * @since 1.0.0
  */
  public function execute(){}

}
?>