<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_post_delete extends XFAction {
const USE_TAN = true;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','post');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  XFUI::html_redirect(-1,XF::link('overview'));
  return true;
  }

  /**
  * fetch vars from asynchronous request
  * @param array $input input stream
  * @return true
  * @since 1.0.0
  */
  protected function ajax($input){
  $id = XF::sanitize_var(XF::ifset($input,'post',0),'int');
  $this->gpc = array('id'=>$id);
  return true;
  }

  /**
  * delete a posting
  * @return boolean
  * @since 1.0.0
  */
  public function execute(){
    try {
    $group = XF::get_group();
    $schk = XF::sql_query("SELECT p_topic_id,p_is_topic,p_u_id FROM ".XF::tbl('post_meta')." WHERE p_id = :id",
    array('id'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
    $postdata = $schk->fetchObject();
    $schk->closeCursor();
      if ( !is_object($postdata) )
      $this->error = '{:no_valid_id}';
      if ( !$group['g_executive'] && !XF::access_control('mcp_overview') ){
        if ( $postdata->p_u_id !== XF::vault_query('current_user_id') && empty($this->error) )
        $this->error = '{:must_not_alter_foreign_entry}';
        if ( (bool)$postdata->p_is_topic && empty($this->error) )
        $this->error = '{:requires_elevated_permissions}';
      }

      if ( empty($this->error) ){
        if ( !XF::sql_transaction('begin',array('post_meta'=>'w','post_data'=>'w','post_rating'=>'w','tag_data'=>'w','user_bookmark'=>'w','user_request'=>'w')) )
        throw new XFE('unable to begin database transaction');
      $cache2 = XFCache::get('simple','post_recent');
      $posts = array($this->gpc['id']);
        if ( is_array($cache2) && in_array((int)$postdata->p_topic_id,$cache2,true) && XF::$tpl->is_cached('overview_recent_posts.tpl') )
        XF::$tpl->clear_cache('overview_recent_posts.tpl');
        if ( XF::$tpl->is_cached('mcp_overview.tpl') )
        XF::$tpl->clear_cache('mcp_overview.tpl');

        if ( (bool)$postdata->p_is_topic ){ // if a topic is processed, obviously include all replies...
        XFCache::purge('rss',XF::RSS_LAST);
        $schk = XF::sql_query("SELECT p_id FROM ".XF::tbl('post_meta')." WHERE p_topic_id = :id AND p_is_topic = false",
        array('id'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
          while ( $r = $schk->fetchObject() )
          $posts[] = intval($r->p_id);
        $schk->closeCursor();
        XFCache::purge('topic',$this->gpc['id']);
        // $cache is not created here!
        }
        else
        $cache = XFCache::topic($postdata->p_topic_id);
      $posts = array_unique($posts);
      XF::sql_query("DELETE FROM ".XF::tbl('post_meta')." WHERE p_id IN (".implode(',',$posts).")",'',__METHOD__,__LINE__);
      XF::sql_query("DELETE FROM ".XF::tbl('post_data')." WHERE pd_p_id IN (".implode(',',$posts).")",'',__METHOD__,__LINE__);
      XF::sql_query("DELETE FROM ".XF::tbl('post_rating')." WHERE pr_p_id IN (".implode(',',$posts).")",'',__METHOD__,__LINE__);
      XF::sql_query("DELETE FROM ".XF::tbl('tag_data')." WHERE td_p_id IN (".implode(',',$posts).")",'',__METHOD__,__LINE__);
      XF::sql_query("DELETE FROM ".XF::tbl('user_bookmark')." WHERE uk_p_id IN (".implode(',',$posts).")",'',__METHOD__,__LINE__);
      XF::sql_query("DELETE FROM ".XF::tbl('user_request')." WHERE ur_class = 'REPORT_POSTING' AND ur_data_int IN (".implode(',',$posts).")",'',__METHOD__,__LINE__);
      XF::logger('info','postid',implode(',',$posts));
      XF::sql_transaction('commit');

      XF::tpl_use_cache_pool(0,'begin');
        foreach ( $posts as $post ){
        XF::tpl_use_cache_pool($post,'change');
          if ( XF::$tpl->is_cached('post.tpl',$post) )
          XF::$tpl->clear_cache('post.tpl',$post);
          if ( isset($cache) && is_array($cache) )
          XFCache::topic_delta($cache,'remove_reply',array('id'=>(int)$post));
        }
      XF::tpl_use_cache_pool(0,'reset');

      XFCache::statistic('post','rebuild');
      XFCache::purge('rss',(int)$postdata->p_topic_id);
      XFCache::purge('rss',XF::RSS_MOD_UNAPPROVE);
        if ( isset($cache) && (bool)$postdata->p_is_topic === false )
        XFCache::put('topic',$this->gpc['id'],$cache);
      $this->success = true;
      }
    } catch ( XFE $E ){ $E->handle(); if ( $E->check_abort() ) return false; }
  return true;
  }

}

  function xfaf_post_delete($input){
  $a = new XFAction_post_delete();
  $a->init('ajax',$input);
    if ( !xfaf_process_data($a->get_GPC(),$a->get_mark_GPC()) )
    return false;
  $b = $a->get_GPC();
  $a->execute();
    if ( $a->get_success() ){
    XFUI::$ajax_response->script('xf_visibility(\'f_post_'.intval($b['id']).'\',\'none\');');
    XFUI::$ajax_response->script('xf_visibility(\'f_post_hide_'.intval($b['id']).'\',\'none\',\'nofade\');');
    return xfaf_success('','{:posting_has_been_deleted}');
    }
    else
    return xfaf_failure($a->get_error());
  }

?>