<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_help extends XFAction {
const USE_TAN = false;
/**
* @var integer amount of color segments in 'color helper'. the more the finer (default is 16)
*/
const COLOR_SELECT_SEGMENT_NUM = 16;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','help');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
    if ( XF::sanitize_var(XF::ifset('get','segment',false),'str','restrict') !== false )
    return $this->popup_helper();
  XFUI::html_head('{:help}');
  XF::$tpl->assign('help_class',XF::get_cfg('help_class'));
  XF::$tpl->assign('help_mail_address',XF::get_cfg('help_mail_address'));
  XF::$tpl->assign('help_text',str_replace('{$XF_URI_IMAGE}',XF::get_cfg('uri_gfx'),XF::file_handler('lang/'.XF::vault_query('current_language').'/help.txt','','read,local')));
  XF::$tpl->display('help.tpl',crc32(XF::vault_query('current_language')));
  XFUI::html_foot();
  return true;
  }

  /**
  * @since 1.0.0
  */
  protected function ajax($input){}

  /**
  * show help page (directly done by run())
  * @since 1.0.0
  */
  public function execute(){}

  /**
  * popup with helping functions
  * @return true
  * @since 1.0.0
  */
  protected function popup_helper(){
  $segment = XF::sanitize_var(XF::ifset('get','segment',''),'str','okifempty,restrict');
  $query = XF::sanitize_var(XF::ifset('get','query','*'),'str');
  $id = XF::sanitize_var(XF::ifset('get','id',''),'str','okifempty');
  $oredir = XF::sanitize_var(XF::ifset('get','or',''),'str','okifempty');
  $this->gpc = array('segment'=>$segment,'query'=>$query,'id'=>$id,'oredir'=>$oredir);
  unset($segment,$query,$id,$oredir);

  $like = ( __XF_SQL_ENGINE === 'pgsql' ) ? 'ILIKE' : 'LIKE';
  echo '<html><head><title>'.XFUI::i18n('help_popup_title').'</title>
  <link rel="stylesheet" href="'.XF::get_cfg('uri_css').'/'.XF::vault_query('current_style').'.css" charset="utf-8" />
  <script type="text/javascript" src="'.XF::get_cfg('uri_js').'/default.js" charset="utf-8"></script></head><body>';
  echo '<div class="xf_content">';

    switch ( $this->gpc['segment'] ){
    case 'user_aa': case 'user_pe': case 'user_ac': case 'user_lv':
    $this->gpc['id'] = intval($this->gpc['id']);
    XF::sql_query("SELECT 1",'-',__METHOD__,__LINE__);
    echo '<form action="'.XF::get_cfg('param_file').'" method="get" />';
    echo '<input type="hidden" name="'.XF::get_cfg('param_action').'" value="help" />';
    echo '<input type="hidden" name="segment" value="'.urlencode($this->gpc['segment']).'" />';
    echo '<input type="hidden" name="id" value="'.urlencode($this->gpc['id']).'" />';
    echo XFUI::i18n('help_popup_search_user').':<br />';
    echo '<input type="text" class="xf_input_field" name="query" value="'.htmlspecialchars($this->gpc['query']).'" />';
    echo '<button type="submit" class="xf_input_submit">'.XFUI::i18n('submit').'</button>';
      if ( !empty($this->gpc['query']) ){
      $susr = XF::sql_query("SELECT u_id,u_name,g_color FROM ".XF::tbl('user')."
      LEFT JOIN ".XF::tbl('group')." ON ".XF::tbl('group').".g_id = ".XF::tbl('user').".u_group
      WHERE u_id != '".XF::get_cfg('main_guest_uid')."' AND u_name $like ".XF::$sql->quote(str_replace('*','%',$this->gpc['query']))."
      ORDER BY u_group ASC, u_name ASC LIMIT 50 OFFSET 0",'',__METHOD__,__LINE__);
        if ( $susr->rowCount() > 0 ){
          if ( $this->gpc['segment'] === 'user_aa' ) // acp_acl
          echo '<hr /><select id="xf__selector" size="10" class="xf_input_select" onclick="
          window.opener.document.getElementById(\'f_ace_user_name_'.$this->gpc['id'].'\').innerHTML=this.form.xf__selector.options[this.form.xf__selector.options.selectedIndex].innerHTML;
          window.opener.document.getElementById(\'f_ace_key_'.$this->gpc['id'].'\').value=this.form.xf__selector.options[this.form.xf__selector.options.selectedIndex].value;
          window.opener.document.getElementById(\'f_ace_link_'.$this->gpc['id'].'\').style.display=\'none\';
          ">';
          elseif ( $this->gpc['segment'] === 'user_pe' ) // post_edit
          echo '<hr /><select id="xf__selector" size="10" class="xf_input_select" onclick="
          window.opener.document.getElementById(\'f_post_user_name\').innerHTML=this.form.xf__selector.options[this.form.xf__selector.options.selectedIndex].innerHTML;
          window.opener.document.getElementById(\'f_user\').value=this.form.xf__selector.options[this.form.xf__selector.options.selectedIndex].value;
          ">';
          elseif ( $this->gpc['segment'] === 'user_lv' ) // log_view
          echo '<hr /><select id="xf__selector" size="10" class="xf_input_select" onclick="
          window.opener.document.getElementById(\'f_log_user_name\').innerHTML=this.form.xf__selector.options[this.form.xf__selector.options.selectedIndex].innerHTML;
          window.opener.document.getElementById(\'f_user\').value=this.form.xf__selector.options[this.form.xf__selector.options.selectedIndex].value;
          ">';
          elseif ( $this->gpc['segment'] === 'user_ac' ) // 'select user'
          echo '<hr /><select id="xf__selector" size="10" class="xf_input_select" onclick="
          window.opener.document.getElementById(\'f_u\').value=window.opener.document.getElementById(\'f_u\').value+this.form.xf__selector.options[this.form.xf__selector.options.selectedIndex].value+\',\';
          ">';
          while ( $r = $susr->fetchObject() )
          echo '<option value="'.intval($r->u_id).'" style="color: #'.htmlspecialchars($r->g_color).';">'.htmlspecialchars($r->u_name).'</option>';
        echo '</select>';
        }
      $susr->closeCursor();
      }
    echo '</form>';
    break;

    case 'color':
    echo '<script type="text/javascript">/* <![CDATA[ */';
    echo 'function xf_color(){
    c = document.getElementById(\'f_ch_r\').value+document.getElementById(\'f_ch_g\').value+document.getElementById(\'f_ch_b\').value;
    document.getElementById(\'f_color\').style.backgroundColor=c;
    }
    function xf_merge(){
    return document.getElementById(\'f_ch_r\').value+document.getElementById(\'f_ch_g\').value+document.getElementById(\'f_ch_b\').value;
    }';
    echo '/* ]]> */</script>';
    $ch = array('r','g','b');
      function str_double($a){return $a.$a;}
      if ( strlen($this->gpc['id']) === 6 )
      $a = array('r'=>substr($this->gpc['id'],0,2),'g'=>substr($this->gpc['id'],2,2),'b'=>substr($this->gpc['id'],4));
      elseif ( strlen($this->gpc['id']) === 3 )
      $a = array('r'=>str_double(substr($this->gpc['id'],0,1)),'g'=>str_double(substr($this->gpc['id'],1,1)),'b'=>str_double(substr($this->gpc['id'],2)));
      else
      $a = array('r'=>'00','g'=>'00','b'=>'00');

      foreach ( $ch as $v ){
      echo '<strong>'.strtoupper($v).'</strong>&nbsp;&nbsp;';
        for ( $i = 0 ; $i <= self::COLOR_SELECT_SEGMENT_NUM ; $i++ ){
        $pt = ceil(0xff/self::COLOR_SELECT_SEGMENT_NUM);
        $k = $i*$pt;
          if ( $i !== 0 )
          $k--;
          switch ( $v ){
          case 'r': $b = sprintf('%02x',$k).'0000'; break;
          case 'g': $b = '00'.sprintf('%02x',$k).'00'; break;
          case 'b': $b = '0000'.sprintf('%02x',$k); break;
          }
        echo '<span title="'.sprintf('%02x, %d',$k,$k).'" style="background-color: #'.$b.';cursor: pointer;" onclick="document.getElementById(\'f_ch_'.$v.'\').value=\''.sprintf('%02x',$k).'\';window.setTimeout(\'xf_color()\',200);">&nbsp;&nbsp;&nbsp;</span>';
        }
      echo '<br /><br />';
      }

    echo '<input type="text" id="f_ch_r" style="border:0;" size="4" readonly="readonly" value="'.$a['r'].'" />&nbsp;';
    echo '<input type="text" id="f_ch_g" style="border:0;" size="4" readonly="readonly" value="'.$a['g'].'" />&nbsp;';
    echo '<input type="text" id="f_ch_b" style="border:0;" size="4" readonly="readonly" value="'.$a['b'].'" />&nbsp;&nbsp;';
    echo '<span id="f_color" style="border: 1px solid #000;background-color: #'.$a['r'].$a['g'].$a['b'].';">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>';
    echo '<button type="submit" class="xf_input_submit" onclick="window.opener.document.getElementById(\'f_color\').value=xf_merge();window.close();">'.XFUI::i18n('submit').'</button>';
    break;

    case 'time':
    require_once(XF::vault_query('root_path').'/class.parser.php');
    $or = ( strlen($this->gpc['oredir']) === 0 ) ? 'interval' : $this->gpc['oredir'];
    echo '<script type="text/javascript">/* <![CDATA[ */';
    echo 'function xf_time(){
    a = 0;
    a += Math.abs(document.getElementById(\'f_tday\').value*86400);
    a += Math.abs(document.getElementById(\'f_thr\').value*3600);
    a += Math.abs(document.getElementById(\'f_tmin\').value*60);
    a += Math.abs(document.getElementById(\'f_tsec\').value);
      if ( a > 0 )
      window.opener.document.getElementById(\'f_'.$or.'\').value=a;
    }';
    echo '/* ]]> */</script>';
    $a = array('d'=>0,'h'=>0,'m'=>0,'s'=>0);
      if ( $this->gpc['id'] !== 0 ){
      $b = XFParser::calculate_age(XF::vault_query('uts')-XF::sanitize_var($this->gpc['id'],'utime'),false);
        if ( $b['year'] > 0 )
        $b['day'] += floor($b['year']*365);
        if ( $b['month'] > 0 )
        $b['day'] += floor($b['month']*31);
      $a['d'] = $b['day'];
      $a['h'] = $b['hr'];
      $a['m'] = $b['min'];
      $a['s'] = $b['sec'];
      }
    echo '<form id="xf__time">';
    echo '<input type="text" id="f_tsec" size="5" class="xf_input_field" value="'.$a['s'].'" /> '.XFUI::i18n('seconds').'<br />';
    echo '<input type="text" id="f_tmin" size="5" class="xf_input_field" value="'.$a['m'].'" /> '.XFUI::i18n('minutes').'<br />';
    echo '<input type="text" id="f_thr" size="5" class="xf_input_field" value="'.$a['h'].'" /> '.XFUI::i18n('hours').'<br />';
    echo '<input type="text" id="f_tday" size="5" class="xf_input_field" value="'.$a['d'].'" /> '.XFUI::i18n('days');
    echo '</form>';
    echo '<button type="submit" class="xf_input_submit" onclick="xf_time();window.close();">'.XFUI::i18n('submit').'</button>';
    break;

    case 'acl':
    echo '<script type="text/javascript">/* <![CDATA[ */';
    echo 'function xf_acl(){
    pa = \'\';
      for ( i = 0 ; i < document.getElementById(\'xf__acl\').elements.length ; i++ ){
        if ( document.getElementById(\'xf__acl\').elements[i].type === "checkbox" && document.getElementById(\'xf__acl\').elements[i].checked ){
        pa = pa+document.getElementById(\'xf__acl\').elements[i].value+\',\';
        }
      }
    pa = pa+document.getElementById(\'f_u\').value;
    pa = pa.substring(0,(pa.length-1));
    return pa;
    }';
    echo '/* ]]> */</script>';
    $user = array();
    $group = XF::get_group('*');
    $preset = array(
    array('{$MODERATOR}',XFUI::i18n('ap_mod')),
    array('{$EXECUTIVE}',XFUI::i18n('ap_exec')),
    array('{$OWNER}',XFUI::i18n('ap_owner'))
    );
    $use = explode(',',$this->gpc['id']);
    $use = array_unique($use);
      foreach ( $use as $v ){
        if ( is_numeric($v) )
        $user[] = $v;
      }
    echo '<form id="xf__acl">';
    echo '<div class="xf_right">';
      foreach ( $group as $v ){
      echo '<label><input type="checkbox" id="f_g[]" class="xf_input_check" value="@'.intval($v['g_id']).'"';
        if ( in_array('@'.$v['g_id'],$use,true) )
        echo 'checked="checked"';
      echo ' /><span style="color: #'.htmlspecialchars($v['g_color']).'">'.htmlspecialchars($v['g_name']).'</span></label><br />';
      }
    echo '</div>';
    echo '<div class="xf_left">';
      foreach ( $preset as $v ){
      echo '<label><input type="checkbox" id="f_p[]" class="xf_input_check" value="'.$v[0].'"';
        if ( in_array($v[0],$use,true) )
        echo 'checked="checked"';
      echo ' />'.$v[1].'</label><br />';
      }
    echo '&nbsp;&nbsp;&nbsp;&nbsp;'.XFUI::i18n('user').' <input type="text" id="f_u" size="16" value="'.implode(',',$user).'" /><br />';
    echo '&nbsp;&nbsp;&nbsp;&nbsp;<a href="#" onclick="window.open(\''.XF::link('help',array('segment'=>'user_ac')).'\',\'xfus\',\'width=400,height=300,dependent=yes\');">'.XFUI::i18n('select_user').'</a>';
    echo '</div><br clear="all" />';
    echo '</form>';
    echo '<button type="submit" class="xf_input_submit" onclick="window.opener.document.getElementById(\'f_acl\').value=xf_acl();window.close();">'.XFUI::i18n('submit').'</button>';
    break;

    case 'mcp_rss':
    echo '<script type="text/javascript" src="'.XF::get_cfg('uri_js').'/ext/sha1.js"></script>';
    echo '<script type="text/javascript">/* <![CDATA[ */';
    echo 'function xf_make_link(){
    uri = \''.XF::link('rss',array('module'=>'mod_unapprove','user'=>XF::vault_query('current_user_id'),'password'=>'__HASH'),false).'\';
    uri = uri.replace(/__HASH/,hex_sha1(hex_sha1(document.getElementById(\'f_p\').value)));
    document.getElementById(\'f_p\').value=\'\';
    document.getElementById(\'f_l\').innerHTML=uri;
    }';
    echo '/* ]]> */</script>';
    echo '<div id="f_l" class="xf_text_small xf_nowrap"></div>';
    echo XFUI::i18n('help_popup_mcp_rss').'<br /><br />';
    echo XFUI::i18n('password').' <input type="password" id="f_p" class="xf_input_field" size="30" value="" /> ';
    echo '<button type="submit" class="xf_input_submit" onclick="xf_make_link();">'.XFUI::i18n('submit').'</button>';
    break;

    case 'bbcode_url': case 'bbcode_img': case 'bbcode_embed': case 'bbcode_mail':
    echo '<form action="'.XF::get_cfg('param_file').'" method="get" />';
    echo '<input type="hidden" name="'.XF::get_cfg('param_action').'" value="help" />';
    echo '<input type="hidden" name="segment" value="'.urlencode($this->gpc['segment']).'" />';
    $str = ( $this->gpc['segment'] === 'bbcode_mail' ) ? 'help_popup_insert_mail' : 'help_popup_insert_uri';
    $san = ( $this->gpc['segment'] === 'bbcode_mail' ) ? 'mail' : 'uri';
    $valid = false;
      if ( XF::sanitize_var($this->gpc['id'],$san,'okifempty') ){
      $uri = parse_url($this->gpc['id']);
        if ( $this->gpc['segment'] === 'bbcode_mail' && isset($uri['path']) && strpos($uri['path'],'@') )
        $uri['host'] = substr($uri['path'],strpos($uri['path'],'@')+1);
        if ( isset($uri['host']) && checkdnsrr($uri['host'],'ANY') )
        $valid = true;
      }
    echo XFUI::i18n($str).':<br />';
    echo '<input type="text" class="xf_input_field" name="id" size="50" value="'.htmlspecialchars($this->gpc['id']).'" /><br />';
    echo '<button type="submit" class="xf_input_submit">'.XFUI::i18n('submit').'</button>';
      if ( $valid )
      echo '<button type="submit" class="xf_input_submit xf_ib_insert" onclick="xf_bbcode_insert(\'['.substr($this->gpc['segment'],strpos($this->gpc['segment'],'_')+1).'='.$this->gpc['id'].']\',true);window.close();">'.XFUI::i18n('insert').'</button>';
    echo '</form>';
    break;

    case 'bbcode_link':
    echo '<form action="'.XF::get_cfg('param_file').'" method="get" />';
    echo '<input type="hidden" name="'.XF::get_cfg('param_action').'" value="help" />';
    echo '<input type="hidden" name="segment" value="'.urlencode($this->gpc['segment']).'" />';
    echo XFUI::i18n('help_popup_insert_link').':<br />';
      if ( !empty($this->gpc['query']) ){
      XF::sql_query("SELECT 1",'-',__METHOD__,__LINE__);
      $spst = XF::sql_query("SELECT p_id,p_subject FROM ".XF::tbl('post_meta')."
      WHERE p_subject $like ".XF::$sql->quote(str_replace('*','%',$this->gpc['query']))."
      ORDER BY p_id DESC LIMIT 50 OFFSET 0",'',__METHOD__,__LINE__);
        if ( $spst->rowCount() > 0 ){
        echo '<select id="xf__selector" size="5" class="xf_input_select" onclick="document.getElementById(\'f_i\').value=this.form.xf__selector.options[this.form.xf__selector.options.selectedIndex].value;">';
          while ( $r = $spst->fetchObject() )
          echo '<option value="'.intval($r->p_id).'">#'.$r->p_id.': '.htmlspecialchars($r->p_subject).'</option>';
        echo '</select><br />';
        }
      $spst->closeCursor();
      }
    echo '<input type="text" class="xf_input_field" id="f_i" name="query" size="10" value="'.htmlspecialchars($this->gpc['query']).'" /><br />';
    echo '<button type="submit" class="xf_input_submit">'.XFUI::i18n('submit').'</button>';
    echo '<button type="submit" class="xf_input_submit xf_ib_insert" onclick="if(document.getElementById(\'f_i\').value!==\'*\'){xf_bbcode_insert(\'[link=\'+document.getElementById(\'f_i\').value+\']\',true);window.close();}">'.XFUI::i18n('insert').'</button>';
    echo '</form>';
    break;

    case 'bbcode_anchor':
    echo XFUI::i18n('help_popup_insert_anchor').':<br />';
    echo '<input type="text" class="xf_input_field" id="f_i" size="30" /><br />';
    echo '<button type="submit" class="xf_input_submit xf_ib_insert" onclick="if(document.getElementById(\'f_i\').value.length>3){xf_bbcode_insert(\'[anchor=\'+document.getElementById(\'f_i\').value+\']\',true);window.close();}">'.XFUI::i18n('insert').'</button>';
    break;

    case 'bbcode_format':
    echo '<script type="text/javascript">/* <![CDATA[ */';
    echo 'function xf_message_format(){
    fstr = \'\';
      for ( i = 0 ; i < document.getElementById(\'xf__format\').elements.length ; i++ ){
        if ( document.getElementById(\'xf__format\').elements[i].type === "checkbox" && document.getElementById(\'xf__format\').elements[i].checked ){
        fstr = fstr+document.getElementById(\'xf__format\').elements[i].value+\',\';
        }
      }
      if ( document.getElementById(\'f_b\').value.length === 6 )
      fstr = fstr+\'bgcolor:#\'+document.getElementById(\'f_b\').value+\',\';
      if ( document.getElementById(\'f_c\').value.length === 6 )
      fstr = fstr+\'color:#\'+document.getElementById(\'f_c\').value+\',\';
      if ( document.getElementById(\'f_s\').value.length > 3 )
      fstr = fstr+\'size:\'+document.getElementById(\'f_s\').value+\',\';
    fstr = fstr.substring(0,(fstr.length-1));
    xf_bbcode_replace(\'[format=\'+fstr+\']\',\'[/format]\',true);
    }';
    echo '/* ]]> */</script>';
    echo XFUI::i18n('help_popup_insert_format').':<br />';
    echo '<form id="xf__format">';
    echo '<label><input type="checkbox" id="f_p[]" class="xf_input_check" value="inline" /> '.XFUI::i18n('help_format_inline').'</label><br />';
    echo '<label><input type="checkbox" id="f_p[]" class="xf_input_check" value="b" /> '.XFUI::i18n('help_format_bold').'</label><br />';
    echo '<label><input type="checkbox" id="f_p[]" class="xf_input_check" value="i" /> '.XFUI::i18n('help_format_italic').'</label><br />';
    echo '<label><input type="checkbox" id="f_p[]" class="xf_input_check" value="u" /> '.XFUI::i18n('help_format_underline').'</label><br />';
    echo '<input type="text" class="xf_input_field" id="f_b" size="6" /> '.XFUI::i18n('help_format_bgcolor').' <a href="#" onclick="window.open(\''.XF::link('help',array('segment'=>'color','or'=>'f_b')).'\',\'xfcl\',\'width=400,height=300,dependent=yes\');">'.XFUI::i18n('select_color').'</a><br />';
    echo '<input type="text" class="xf_input_field" id="f_c" size="6" /> '.XFUI::i18n('help_format_color').' <a href="#" onclick="window.open(\''.XF::link('help',array('segment'=>'color','or'=>'f_c')).'\',\'xfcl\',\'width=400,height=300,dependent=yes\');">'.XFUI::i18n('select_color').'</a><br />';
    echo '<input type="text" class="xf_input_field" id="f_s" size="6" /> <label title="12px, 150%, 2em, ...">'.XFUI::i18n('help_format_size').'</label>';
    echo '</form>';
    echo '<button type="submit" class="xf_input_submit xf_ib_insert" onclick="xf_message_format();window.close();">'.XFUI::i18n('insert').'</button>';
    break;
    }

  echo '</div></body></html>';
  return true;
  }

}
?>