<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_mcp_overview extends XFAction {
const USE_TAN = false;
/**
* @var integer limit message length for preview popups (default is 500)
*/
const POSTING_PREVIEW_LENGTH = 500;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','mcp');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  XF::tan('post_approve');
  XF::tan('post_delete');
  XFUI::ajax_init();
  XFUI::html_head('{:mcp_overview}');

    if ( !XF::$tpl->is_cached('mcp_overview.tpl') ){
    $cache = array();
    $groups = XF::get_group('*');
    $pp = XFUI::get_post_prefix_list();
    $susr = XF::sql_query("SELECT u_id,u_name,u_group,u_warning_level FROM ".XF::tbl('user')."
    WHERE u_warning_level != 'none' ORDER BY u_warning_level DESC, u_name",'',__METHOD__,__LINE__);
    $warned_user = array();
      while ( $r = $susr->fetchObject() ){
      $r->u_id = intval($r->u_id);
      $r->u_name = XFUI::lang_str($r->u_name);
      $warned_user[$r->u_id] = (array)$r;
      $warned_user[$r->u_id]['g_name'] = $groups[$r->u_group]['g_name'];
      $warned_user[$r->u_id]['g_color'] = $groups[$r->u_group]['g_color'];
      $warned_user[$r->u_id]['str_wlvl'] = 'warning_level_'.$r->u_warning_level;
      }
    $susr->closeCursor();

    $suap = XF::sql_query("SELECT p_id,p_topic_id,p_time,p_pp_id,p_subject,p_acl,pd_text,u_name,u_group FROM ".XF::tbl('post_meta')."
    LEFT JOIN ".XF::tbl('post_data')." ON ".XF::tbl('post_data').".pd_p_id = ".XF::tbl('post_meta').".p_id
    LEFT JOIN ".XF::tbl('user')." ON ".XF::tbl('user').".u_id = ".XF::tbl('post_meta').".p_u_id
    WHERE p_approved = false ORDER BY p_id",'',__METHOD__,__LINE__);
    $unapproved_post = array();
      while ( $r = $suap->fetchObject() ){
      $a = array('attr'=>array('prefix'=>$r->p_pp_id,'acl'=>$r->p_acl));
        if ( isset($cache[(int)$r->p_topic_id]) )
        continue;
        if ( !XFUI::topic_access($a,$pp) ){
        $cache[(int)$r->p_topic_id] = false;
        continue;
        }
      $r->p_id = intval($r->p_id);
      $r->p_subject = ( isset($pp[$r->p_pp_id]) ) ? '['.$pp[$r->p_pp_id]['pp_name'].'] '.$r->p_subject : $r->p_subject;
      $r->pd_text = ( strlen($r->pd_text) > self::POSTING_PREVIEW_LENGTH ) ? substr($r->pd_text,0,self::POSTING_PREVIEW_LENGTH).'...' : $r->pd_text;
      $r->u_name = XFUI::lang_str($r->u_name);
      $unapproved_post[$r->p_id] = (array)$r;
      $unapproved_post[$r->p_id]['g_name'] = $groups[$r->u_group]['g_name'];
      $unapproved_post[$r->p_id]['g_color'] = $groups[$r->u_group]['g_color'];
      }
    $suap->closeCursor();

    XF::$tpl->cache_lifetime = 600;
    XF::$tpl->assign('warned_user',$warned_user);
    XF::$tpl->assign('unapproved_posts',$unapproved_post);
    }

  XF::$tpl->display('mcp_overview.tpl');
  XFUI::html_foot();
  return true;
  }

  /**
  * @since 1.0.0
  */
  protected function ajax($input){}

  /**
  * overview for moderators (directly done by run())
  * @since 1.0.0
  */
  public function execute(){}

}
?>
