/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;

public class ComandoStampa
extends Comando {
    private final String nomeComando = "stampa";
    private String info;

    public ComandoStampa(String what) {
        this.info = what;
    }

    public String getNomeComando() {
        return this.nomeComando;
    }

    public boolean esegui(Giocatore giocatore, Tabellone planisfero) throws IOException {
        if (this.info == null) {
            new ComandoNonValido().esegui(giocatore, planisfero);
        } else if (this.info.equals("tabellone")) {
            this.stampaTabellone(giocatore, planisfero);
        } else if (planisfero.getGiocatore(this.info) != null) {
            this.stampaGiocatore(giocatore, planisfero);
        } else if (ElencoTerritoriContinenti.territorioValido(this.info)) {
            this.stampaTerritorio(giocatore, planisfero);
        } else {
            new ComandoNonValido().esegui(giocatore, planisfero);
        }
        return false;
    }

    private void stampaTabellone(Giocatore g, Tabellone t) {
        g.schermo.stampaln(t.toString());
    }

    private void stampaTerritorio(Giocatore g, Tabellone t) {
        Giocatore temp = t.getGiocatoreAt(this.info);
        Territorio territorio = temp.getTerritorio(this.info);
        g.schermo.stampa(territorio.toString());
        g.schermo.stampa(" e' occupato dal giocatore " + temp.getColore());
        g.schermo.stampaln(" con " + territorio.getArmate() + " armate");
        g.schermo.stampa("Confina con");
        Set confinanti = territorio.getTerritoriConfinanti();
        Iterator it = confinanti.iterator();
        while (it.hasNext()) {
            Territorio confinante = (Territorio)it.next();
            g.schermo.stampa(" " + confinante.getNome());
        }
        g.schermo.stampaln();
    }

    private void stampaGiocatore(Giocatore g, Tabellone t) {
        Giocatore temp = t.getGiocatore(this.info);
        g.schermo.stampaln(temp);
        g.schermo.stampa(temp.getColore());
        if (temp.numeroCarte() == 0) {
            g.schermo.stampa(" non possiede carte, ");
        } else if (temp.numeroCarte() == 1) {
            g.schermo.stampa(" possiede 1 carta, ");
        } else {
            g.schermo.stampa(String.valueOf(temp.numeroCarte()) + " carte, ");
        }
        g.schermo.stampa("occupa " + temp.getTerritori().size() + " territori e ");
        if (!temp.getPuoPescare()) {
            g.schermo.stampaln("al momento non puo' pescare la carta.");
        } else {
            g.schermo.stampaln("puo' pescare la carta.");
        }
    }
}

