/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack.chooser;

import ch.fhnw.jbackpack.chooser.Increment;
import ch.fhnw.jbackpack.chooser.RdiffFile;
import ch.fhnw.jbackpack.chooser.RdiffTimestamp;
import ch.fhnw.util.FileTools;
import ch.fhnw.util.ProcessExecutor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RdiffFileDatabase {
    private static final Logger LOGGER = Logger.getLogger(RdiffFileDatabase.class.getName());
    private static final String MIRROR_TIMESTAMP_TABLE = "mirror_timestamp";
    private static final String INCREMENT_TIMESTAMPS_TABLE = "increment_timestamps";
    private static final String MIRROR_DIRECTORIES_TABLE = "mirror_directories";
    private static final String MIRROR_FILES_TABLE = "mirror_files";
    private static final String INCREMENT_DIRECTORIES_TABLE = "increment_directories";
    private static final String INCREMENT_FILES_TABLE = "increment_files";
    private static final String ID_COLUMN = "id";
    private static final String PARENT_ID_COLUMN = "parent_id";
    private static final String TIMESTAMP_COLUMN = "timestamp";
    private static final String NAME_COLUMN = "name";
    private static final String TYPE_COLUMN = "type";
    private static final String SIZE_COLUMN = "size";
    private static final String MODTIME_COLUMN = "mod_time";
    private static final String QUOTED_SEPARATOR = Pattern.quote(File.separator);
    private static final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance();
    private final File backupDirectory;
    private final List<String> rdiffBackupListOutput;
    private final List<DirCacheEntry> mirrorDirectoryIdCache;
    private final List<DirCacheEntry> incrementDirectoryIdCache;
    private Connection connection;
    private PreparedStatement getIncrementsStatement;
    private PreparedStatement getMirrorDirIDStatement;
    private PreparedStatement getMirrorFilesStatement;
    private PreparedStatement getIncrementDirIDStatement;
    private PreparedStatement getIncrementFilesStatement;
    private SyncState syncState = SyncState.CHECKING;
    private int maxIncrementCounter;
    private int incrementCounter;
    private long directoryCounter;
    private long fileCounter;
    private Date currentTimestamp;
    private String currentPath;
    private String currentName;
    private boolean connectionSucceeded;
    private boolean anotherInstanceRunning;
    private List<RdiffTimestamp> fileSystemTimestamps;

    public static RdiffFileDatabase getInstance(File backupDirectory, String databasePath, List<String> rdiffBackupListOutput) {
        return new RdiffFileDatabase(backupDirectory, databasePath, rdiffBackupListOutput);
    }

    public static RdiffFileDatabase getInstance(File backupDirectory) {
        ProcessExecutor processExecutor = new ProcessExecutor();
        processExecutor.executeProcess(true, true, "rdiff-backup", "--parsable-output", "-l", backupDirectory.getPath());
        List<String> output = processExecutor.getStdOutList();
        String databasePath = backupDirectory.getPath() + File.separatorChar + "rdiff-backup-data" + File.separatorChar + "jbackpack";
        return new RdiffFileDatabase(backupDirectory, databasePath, output);
    }

    private RdiffFileDatabase(File backupDirectory, String databasePath, List<String> rdiffBackupListOutput) {
        this.backupDirectory = backupDirectory;
        this.rdiffBackupListOutput = rdiffBackupListOutput;
        this.mirrorDirectoryIdCache = new ArrayList<DirCacheEntry>();
        this.incrementDirectoryIdCache = new ArrayList<DirCacheEntry>();
        System.setProperty("derby.storage.pageSize", "32768");
        System.setProperty("derby.stream.error.method", "ch.fhnw.jbackpack.chooser.RdiffFileDatabase.disableDerbyLogFile");
        String driver = "org.apache.derby.jdbc.EmbeddedDriver";
        String connectionURL = "jdbc:derby:" + databasePath + ";create=true";
        try {
            Class.forName(driver).newInstance();
            LOGGER.log(Level.INFO, "connecting to database {0}", databasePath);
            this.connection = DriverManager.getConnection(connectionURL);
            DatabaseMetaData databaseMetaData = this.connection.getMetaData();
            ResultSet tables = databaseMetaData.getTables(null, null, MIRROR_TIMESTAMP_TABLE.toUpperCase(), null);
            if (tables.next()) {
                LOGGER.fine("jbackpack tables are already there");
            } else {
                LOGGER.info("creating tables for jbackpack");
                Statement statement = this.connection.createStatement();
                statement.executeUpdate("CREATE TABLE mirror_timestamp(timestamp BIGINT)");
                statement.executeUpdate("CREATE TABLE increment_timestamps(timestamp BIGINT)");
                statement.executeUpdate("CREATE TABLE mirror_directories(id BIGINT GENERATED ALWAYS AS IDENTITY, parent_id BIGINT, name VARCHAR(255))");
                statement.executeUpdate("CREATE TABLE mirror_files(id BIGINT, name VARCHAR(255), type VARCHAR(15), size BIGINT, mod_time BIGINT)");
                statement.executeUpdate("CREATE TABLE increment_directories(id BIGINT GENERATED ALWAYS AS IDENTITY, timestamp BIGINT, parent_id BIGINT, name VARCHAR(255))");
                statement.executeUpdate("CREATE TABLE increment_files(id BIGINT, name VARCHAR(255), type VARCHAR(15), size BIGINT, mod_time BIGINT)");
                statement.executeUpdate("CREATE INDEX MirrorDir_Index ON mirror_directories(parent_id,name)");
                statement.executeUpdate("CREATE INDEX MirrorFiles_Index ON mirror_files(id)");
                statement.executeUpdate("CREATE INDEX IncDir_Time_Index ON increment_directories(timestamp)");
                statement.executeUpdate("CREATE INDEX IncDir_TimeParentName_Index ON increment_directories(timestamp,parent_id,name)");
                statement.executeUpdate("CREATE INDEX IncFiles_ID_Index ON increment_files(id)");
            }
            tables.close();
            this.getIncrementsStatement = this.connection.prepareStatement("SELECT * FROM increment_timestamps");
            this.getMirrorDirIDStatement = this.connection.prepareStatement("SELECT id FROM mirror_directories WHERE parent_id=? AND name=?");
            this.getMirrorFilesStatement = this.connection.prepareStatement("SELECT name,type,size,mod_time FROM mirror_files WHERE id=?");
            this.getIncrementDirIDStatement = this.connection.prepareStatement("SELECT id FROM increment_directories WHERE timestamp=? AND parent_id=? AND name=?");
            this.getIncrementFilesStatement = this.connection.prepareStatement("SELECT name,type,size,mod_time FROM increment_files WHERE id=?");
            this.connectionSucceeded = true;
        }
        catch (SQLException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
            while ("XJ040".equals(ex.getSQLState())) {
                ex = ex.getNextException();
            }
            this.anotherInstanceRunning = "XSDB6".equals(ex.getSQLState());
        }
        catch (ClassNotFoundException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    public boolean isConnected() {
        return this.connectionSucceeded;
    }

    public boolean isAnotherInstanceRunning() {
        return this.anotherInstanceRunning;
    }

    public void sync() throws SQLException, IOException {
        String backupPath = this.backupDirectory.getPath();
        this.fileSystemTimestamps = this.getFileSystemTimestamps();
        if (this.fileSystemTimestamps.isEmpty()) {
            LOGGER.log(Level.WARNING, "no rdiff-backup mirror/increments found in \"{0}\"", backupPath);
            return;
        }
        Date fileSystemMirrorTimestamp = this.fileSystemTimestamps.get(0).getTimestamp();
        Date databaseMirrorTimestamp = this.getDatabaseMirrorTimestamp();
        boolean deleteMirror = databaseMirrorTimestamp != null && !fileSystemMirrorTimestamp.equals(databaseMirrorTimestamp);
        boolean insertMirror = databaseMirrorTimestamp == null || !fileSystemMirrorTimestamp.equals(databaseMirrorTimestamp);
        List<Date> databaseIncrementTimestamps = this.getDatabaseIncrementTimestamps();
        ArrayList<Date> timestampsToDelete = new ArrayList<Date>();
        for (Date databaseTimestamp : databaseIncrementTimestamps) {
            boolean delete = true;
            int size = this.fileSystemTimestamps.size();
            for (int i = 1; i < size; ++i) {
                Date fileSystemTimestamp = this.fileSystemTimestamps.get(i).getTimestamp();
                if (!databaseTimestamp.equals(fileSystemTimestamp)) continue;
                delete = false;
                break;
            }
            if (!delete) continue;
            timestampsToDelete.add(databaseTimestamp);
        }
        ArrayList<RdiffTimestamp> timestampsToAdd = new ArrayList<RdiffTimestamp>();
        int size = this.fileSystemTimestamps.size();
        for (int i = 1; i < size; ++i) {
            RdiffTimestamp rdiffTimestamp = this.fileSystemTimestamps.get(i);
            Date timestamp = rdiffTimestamp.getTimestamp();
            boolean add = true;
            for (Date databaseTimestamp : databaseIncrementTimestamps) {
                if (!databaseTimestamp.equals(timestamp)) continue;
                add = false;
                break;
            }
            if (!add) continue;
            timestampsToAdd.add(rdiffTimestamp);
        }
        boolean databaseChanged = false;
        this.syncState = SyncState.TRIMMING;
        this.incrementCounter = 0;
        this.maxIncrementCounter = timestampsToDelete.size() + (deleteMirror ? 1 : 0);
        if (deleteMirror) {
            this.currentTimestamp = databaseMirrorTimestamp;
            ++this.incrementCounter;
            LOGGER.info("deleting old mirror timestamp");
            Statement statement = this.connection.createStatement();
            statement.executeUpdate("DELETE FROM mirror_timestamp");
            statement.close();
            LOGGER.info("deleting old mirror directories");
            statement = this.connection.createStatement();
            statement.executeUpdate("DELETE FROM mirror_directories");
            statement.close();
            LOGGER.info("deleting old mirror files");
            statement = this.connection.createStatement();
            statement.executeUpdate("DELETE FROM mirror_files");
            statement.close();
            databaseChanged = true;
        }
        if (!timestampsToDelete.isEmpty()) {
            this.trimIncrements(timestampsToDelete);
            databaseChanged = true;
        }
        this.syncState = SyncState.SYNCING;
        this.incrementCounter = 0;
        this.maxIncrementCounter = timestampsToAdd.size() + (insertMirror ? 1 : 0);
        this.directoryCounter = 0L;
        this.fileCounter = 0L;
        if (insertMirror) {
            LOGGER.info("inserting new mirror timestamp");
            Statement statement = this.connection.createStatement();
            statement.executeUpdate("INSERT INTO mirror_timestamp VALUES(" + fileSystemMirrorTimestamp.getTime() / 1000L + ")");
            statement.close();
            LOGGER.info("adding file system root into mirror directories");
            statement = this.connection.createStatement();
            statement.executeUpdate("INSERT INTO mirror_directories VALUES(DEFAULT,0,'')");
            statement.close();
            LOGGER.info("inserting new mirror files");
            PreparedStatement insertMirrorDirStatement = this.connection.prepareStatement("INSERT INTO mirror_directories VALUES (DEFAULT,?,?)");
            PreparedStatement insertMirrorFileStatement = this.connection.prepareStatement("INSERT INTO mirror_files VALUES (?,?,?,?,?)");
            this.parseMetaDataFile(backupPath, this.fileSystemTimestamps.get(0), insertMirrorDirStatement, insertMirrorFileStatement, null, null);
            databaseChanged = true;
        }
        for (RdiffTimestamp timestampToAdd : timestampsToAdd) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "inserting increment timestamp of {0}", timestampToAdd.getFilestamp());
            }
            Statement statement = this.connection.createStatement();
            statement.executeUpdate("INSERT INTO increment_timestamps VALUES(" + timestampToAdd.getTimestamp().getTime() / 1000L + ")");
            statement.close();
            this.incrementDirectoryIdCache.clear();
            PreparedStatement insertIncrementDirStatement = this.connection.prepareStatement("INSERT INTO increment_directories VALUES (DEFAULT,?,?,?)");
            PreparedStatement insertIncrementFileStatement = this.connection.prepareStatement("INSERT INTO increment_files VALUES (?,?,?,?,?)");
            this.parseMetaDataFile(backupPath, timestampToAdd, null, null, insertIncrementDirStatement, insertIncrementFileStatement);
            databaseChanged = true;
        }
        if (databaseChanged) {
            long start = System.currentTimeMillis();
            LOGGER.log(Level.INFO, "compressing tables");
            this.syncState = SyncState.COMPRESSING;
            this.connection.commit();
            CallableStatement cstatement = this.connection.prepareCall("CALL SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', ?, 0)");
            cstatement.setString(1, MIRROR_TIMESTAMP_TABLE.toUpperCase());
            cstatement.execute();
            cstatement.setString(1, MIRROR_DIRECTORIES_TABLE.toUpperCase());
            cstatement.execute();
            cstatement.setString(1, MIRROR_FILES_TABLE.toUpperCase());
            cstatement.execute();
            cstatement.setString(1, INCREMENT_TIMESTAMPS_TABLE.toUpperCase());
            cstatement.execute();
            cstatement.setString(1, INCREMENT_DIRECTORIES_TABLE.toUpperCase());
            cstatement.execute();
            cstatement.setString(1, INCREMENT_FILES_TABLE.toUpperCase());
            cstatement.execute();
            if (LOGGER.isLoggable(Level.INFO)) {
                long time = System.currentTimeMillis() - start;
                LOGGER.log(Level.INFO, "compressing tables took {0} ms", time);
            }
        }
    }

    public SyncState getSyncState() {
        return this.syncState;
    }

    public List<Increment> getIncrements() {
        ArrayList<Date> timestamps = new ArrayList<Date>();
        try {
            Date databaseMirrorTimestamp = this.getDatabaseMirrorTimestamp();
            if (databaseMirrorTimestamp != null) {
                timestamps.add(databaseMirrorTimestamp);
            }
            timestamps.addAll(this.getDatabaseIncrementTimestamps());
        }
        catch (SQLException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        Collections.sort(timestamps, Collections.reverseOrder());
        Increment youngerIncrement = null;
        ArrayList<Increment> increments = new ArrayList<Increment>();
        for (Date timestamp : timestamps) {
            Increment increment;
            RdiffTimestamp rdiffTimestamp = null;
            for (RdiffTimestamp fileSystemTimestamp : this.fileSystemTimestamps) {
                if (!fileSystemTimestamp.getTimestamp().equals(timestamp)) continue;
                rdiffTimestamp = fileSystemTimestamp;
            }
            youngerIncrement = increment = new Increment(youngerIncrement, rdiffTimestamp, this, this.backupDirectory);
            increments.add(increment);
        }
        return increments;
    }

    public synchronized List<RdiffFile> listFiles(Increment increment, RdiffFile directory) {
        long start = System.currentTimeMillis();
        ArrayList<RdiffFile> files = new ArrayList<RdiffFile>();
        try {
            long directoryID;
            String path;
            if (directory.getParentFile() == null) {
                path = "";
                directoryID = 1L;
            } else {
                path = directory.getPath();
                directoryID = this.getMirrorDirID(path.split(QUOTED_SEPARATOR));
            }
            this.getMirrorFilesStatement.setLong(1, directoryID);
            ResultSet mirrorFiles = this.getMirrorFilesStatement.executeQuery();
            while (mirrorFiles.next()) {
                String name = mirrorFiles.getString(NAME_COLUMN);
                String type = mirrorFiles.getString(TYPE_COLUMN);
                long size = mirrorFiles.getLong(SIZE_COLUMN);
                long modtime = mirrorFiles.getLong(MODTIME_COLUMN) * 1000L;
                files.add(new RdiffFile(this, increment, directory, name, size, modtime, "dir".equals(type)));
            }
            mirrorFiles.close();
            if (LOGGER.isLoggable(Level.INFO)) {
                long time = System.currentTimeMillis() - start;
                LOGGER.log(Level.INFO, "getting mirror files of directory \"{0}\" took {1} ms", new Object[]{path, time});
            }
            if (!increment.isMirror()) {
                ArrayList<Increment> increments = new ArrayList<Increment>();
                for (Increment tmpIncrement = increment; tmpIncrement != null; tmpIncrement = tmpIncrement.getYoungerIncrement()) {
                    if (tmpIncrement.isMirror()) continue;
                    increments.add(tmpIncrement);
                }
                for (int i = increments.size() - 1; i >= 0; --i) {
                    this.replayIncrement((Increment)increments.get(i), directory, path, files);
                }
            }
        }
        catch (SQLException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        return files;
    }

    public int getMaxIncrementCounter() {
        return this.maxIncrementCounter;
    }

    public int getIncrementCounter() {
        return this.incrementCounter;
    }

    public Date getCurrentTimestamp() {
        return this.currentTimestamp;
    }

    public long getDirectoryCounter() {
        return this.directoryCounter;
    }

    public long getFileCounter() {
        return this.fileCounter;
    }

    public String getCurrentFile() {
        if (this.currentPath == null || this.currentName == null) {
            return "";
        }
        return this.currentPath + '/' + this.currentName;
    }

    public void close() {
        try {
            this.getIncrementsStatement.close();
            this.getMirrorDirIDStatement.close();
            this.getMirrorFilesStatement.close();
            this.getIncrementDirIDStatement.close();
            this.getIncrementFilesStatement.close();
            this.connection.close();
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == 50000 && "XJ015".equals(ex.getSQLState())) {
                LOGGER.info("Derby shut down normally");
            }
            LOGGER.log(Level.WARNING, "Derby did not shut down normally", ex);
        }
    }

    public static OutputStream disableDerbyLogFile() {
        return new OutputStream(){

            public void write(int b) throws IOException {
            }
        };
    }

    private long getMirrorDirID(String[] directories) throws SQLException {
        long directoryID = 1L;
        for (String directory : directories) {
            long tmpID = this.getMirrorDirID(directoryID, directory);
            if (tmpID == 0L) {
                directoryID = 0L;
                break;
            }
            directoryID = tmpID;
        }
        return directoryID;
    }

    private long getMirrorDirID(long parentID, String name) throws SQLException {
        long directoryID = 0L;
        this.getMirrorDirIDStatement.setLong(1, parentID);
        this.getMirrorDirIDStatement.setString(2, name);
        ResultSet resultSet = this.getMirrorDirIDStatement.executeQuery();
        if (resultSet.next()) {
            directoryID = resultSet.getLong(ID_COLUMN);
        }
        resultSet.close();
        return directoryID;
    }

    private long getIncrementDirID(Date timestamp, String[] directories) throws SQLException {
        long directoryID = this.getIncrementDirID(timestamp, 0L, "");
        for (String directory : directories) {
            long tmpID = this.getIncrementDirID(timestamp, directoryID, directory);
            if (tmpID == 0L) {
                directoryID = 0L;
                break;
            }
            directoryID = tmpID;
        }
        return directoryID;
    }

    private long getIncrementDirID(Date timestamp, long parentID, String path) throws SQLException {
        long directoryID = 0L;
        this.getIncrementDirIDStatement.setLong(1, timestamp.getTime() / 1000L);
        this.getIncrementDirIDStatement.setLong(2, parentID);
        this.getIncrementDirIDStatement.setString(3, path);
        ResultSet resultSet = this.getIncrementDirIDStatement.executeQuery();
        if (resultSet.next()) {
            directoryID = resultSet.getLong(ID_COLUMN);
        }
        resultSet.close();
        LOGGER.log(Level.FINE, "directoryID = {0}", directoryID);
        return directoryID;
    }

    private void replayIncrement(Increment increment, RdiffFile directory, String directoryPath, List<RdiffFile> files) throws SQLException {
        long directoryID;
        long start = System.currentTimeMillis();
        Date timestamp = increment.getTimestamp();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "processing increment {0} of directory \"{1}\"", new Object[]{timestamp, directoryPath});
        }
        if (directoryPath.isEmpty()) {
            directoryID = this.getIncrementDirID(timestamp, 0L, "");
        } else {
            String[] directories = directoryPath.split(QUOTED_SEPARATOR);
            directoryID = this.getIncrementDirID(timestamp, directories);
        }
        this.getIncrementFilesStatement.setLong(1, directoryID);
        ResultSet resultSet = this.getIncrementFilesStatement.executeQuery();
        block0: while (resultSet.next()) {
            String name = resultSet.getString(NAME_COLUMN);
            if (".".equals(name)) continue;
            String type = resultSet.getString(TYPE_COLUMN);
            if ("None".equals(type)) {
                for (int i = files.size() - 1; i >= 0; --i) {
                    RdiffFile file = files.get(i);
                    if (!file.getName().equals(name)) continue;
                    files.remove(i);
                    continue block0;
                }
                continue;
            }
            long size = resultSet.getLong(SIZE_COLUMN);
            long modtime = resultSet.getLong(MODTIME_COLUMN) * 1000L;
            boolean updated = false;
            int j = files.size();
            for (int i = 0; i < j; ++i) {
                RdiffFile file = files.get(i);
                if (!file.getName().equals(name)) continue;
                files.set(i, new RdiffFile(this, increment, directory, name, size, modtime, "dir".equals(type)));
                updated = true;
                break;
            }
            if (updated) continue;
            files.add(new RdiffFile(this, increment, directory, name, size, modtime, "dir".equals(type)));
        }
        resultSet.close();
        if (LOGGER.isLoggable(Level.INFO)) {
            long time = System.currentTimeMillis() - start;
            LOGGER.log(Level.INFO, "processing increment {0} took {1} ms", new Object[]{timestamp, time});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseMetaDataFile(String backupPath, RdiffTimestamp rdiffTimestamp, PreparedStatement insertMirrorDirStatement, PreparedStatement insertMirrorFileStatement, PreparedStatement insertIncrementDirStatement, PreparedStatement insertIncrementFileStatement) throws IOException, SQLException {
        long start = System.currentTimeMillis();
        ++this.incrementCounter;
        Date timestamp = rdiffTimestamp.getTimestamp();
        String filestamp = rdiffTimestamp.getFilestamp();
        this.currentTimestamp = timestamp;
        this.connection.setAutoCommit(false);
        BufferedReader reader = null;
        try {
            String line;
            File metaDataFile = Increment.getRdiffBackupFile(backupPath, "mirror_metadata." + filestamp);
            if (metaDataFile == null) {
                LOGGER.log(Level.WARNING, "could not find mirror_metadata file for {0}", filestamp);
                return;
            }
            reader = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(metaDataFile))));
            String path = null;
            String type = null;
            long size = 0L;
            long modTime = 0L;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("File ")) {
                    if (path != null) {
                        this.processParsedFile(timestamp, path, type, size, modTime, insertMirrorDirStatement, insertMirrorFileStatement, insertIncrementDirStatement, insertIncrementFileStatement);
                    }
                    path = line.substring(5);
                    type = null;
                    size = 0L;
                    modTime = 0L;
                    continue;
                }
                if (line.startsWith("  Type ")) {
                    type = line.substring(7);
                    continue;
                }
                if (line.startsWith("  Size ")) {
                    size = Long.parseLong(line.substring(7));
                    continue;
                }
                if (!line.startsWith("  ModTime ")) continue;
                modTime = Long.parseLong(line.substring(10));
            }
            this.processParsedFile(timestamp, path, type, size, modTime, insertMirrorDirStatement, insertMirrorFileStatement, insertIncrementDirStatement, insertIncrementFileStatement);
        }
        finally {
            this.connection.commit();
            this.connection.setAutoCommit(true);
            if (reader != null) {
                reader.close();
            }
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            long time = System.currentTimeMillis() - start;
            LOGGER.log(Level.INFO, "parsing timestamp {0} took {1} ms", new Object[]{filestamp, time});
        }
    }

    private void processParsedFile(Date timestamp, String path, String type, long size, long modTime, PreparedStatement insertMirrorDirStatement, PreparedStatement insertMirrorFileStatement, PreparedStatement insertIncrementDirStatement, PreparedStatement insertIncrementFileStatement) throws SQLException {
        ++this.fileCounter;
        int lastSlashIndex = path.lastIndexOf(47);
        if (lastSlashIndex == -1) {
            this.currentPath = "";
            this.currentName = path;
        } else {
            this.currentPath = path.substring(0, lastSlashIndex);
            this.currentName = path.substring(lastSlashIndex + 1);
        }
        if (insertMirrorDirStatement != null) {
            if ("".equals(this.currentPath) && ".".equals(this.currentName)) {
                return;
            }
            long directoryID = this.insertMirrorDir(insertMirrorDirStatement);
            this.insertFile(insertMirrorFileStatement, directoryID, type, size, modTime);
        } else {
            if ("".equals(this.currentPath) && ".".equals(this.currentName)) {
                this.insertIncrementDir(timestamp, insertIncrementDirStatement);
                return;
            }
            long directoryID = this.insertIncrementDir(timestamp, insertIncrementDirStatement);
            this.insertFile(insertIncrementFileStatement, directoryID, type, size, modTime);
        }
    }

    private void insertFile(PreparedStatement insertFileStatement, long directoryID, String type, long size, long modTime) throws SQLException {
        insertFileStatement.setLong(1, directoryID);
        insertFileStatement.setString(2, this.currentName);
        insertFileStatement.setString(3, type);
        insertFileStatement.setLong(4, size);
        insertFileStatement.setLong(5, modTime);
        int rowCount = insertFileStatement.executeUpdate();
        if (rowCount == 1) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "added file {0}/{1}", new Object[]{this.currentPath, this.currentName});
            }
        } else if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "could not insert file {0}/{1} to database", new Object[]{this.currentPath, this.currentName});
        }
    }

    private long insertMirrorDir(PreparedStatement insertMirrorDirStatement) throws SQLException {
        long directoryID = 1L;
        if (!this.currentPath.isEmpty()) {
            String[] directories = this.currentPath.split("/");
            int length = directories.length;
            for (int i = 0; i < length; ++i) {
                DirCacheEntry entry;
                String directory = directories[i];
                if (i < this.mirrorDirectoryIdCache.size()) {
                    entry = this.mirrorDirectoryIdCache.get(i);
                    if (directory.equals(entry.directory)) {
                        directoryID = entry.ID;
                        continue;
                    }
                    directoryID = this.getOrAddMirrorDir(directoryID, directory, insertMirrorDirStatement);
                    entry.directory = directory;
                    entry.ID = directoryID;
                    for (int j = this.mirrorDirectoryIdCache.size() - 1; j > i; --j) {
                        this.mirrorDirectoryIdCache.remove(j);
                    }
                    continue;
                }
                directoryID = this.getOrAddMirrorDir(directoryID, directory, insertMirrorDirStatement);
                entry = new DirCacheEntry();
                entry.directory = directory;
                entry.ID = directoryID;
                this.mirrorDirectoryIdCache.add(entry);
            }
        }
        return directoryID;
    }

    private long insertIncrementDir(Date timestamp, PreparedStatement insertIncrementDirStatement) throws SQLException {
        long directoryID = this.getOrAddIncrementDir(timestamp, 0L, "", insertIncrementDirStatement);
        if (!this.currentPath.isEmpty()) {
            String[] directories = this.currentPath.split("/");
            int length = directories.length;
            for (int i = 0; i < length; ++i) {
                DirCacheEntry entry;
                String directory = directories[i];
                if (i < this.incrementDirectoryIdCache.size()) {
                    entry = this.incrementDirectoryIdCache.get(i);
                    if (directory.equals(entry.directory)) {
                        directoryID = entry.ID;
                        continue;
                    }
                    directoryID = this.getOrAddIncrementDir(timestamp, directoryID, directory, insertIncrementDirStatement);
                    entry.directory = directory;
                    entry.ID = directoryID;
                    for (int j = this.incrementDirectoryIdCache.size() - 1; j > i; --j) {
                        this.incrementDirectoryIdCache.remove(j);
                    }
                    continue;
                }
                directoryID = this.getOrAddIncrementDir(timestamp, directoryID, directory, insertIncrementDirStatement);
                entry = new DirCacheEntry();
                entry.directory = directory;
                entry.ID = directoryID;
                this.incrementDirectoryIdCache.add(entry);
            }
        }
        return directoryID;
    }

    private long getOrAddMirrorDir(long parentID, String directory, PreparedStatement insertMirrorDirStatement) throws SQLException {
        long directoryID = this.getMirrorDirID(parentID, directory);
        if (directoryID == 0L) {
            insertMirrorDirStatement.setLong(1, parentID);
            insertMirrorDirStatement.setString(2, directory);
            int rowCount = insertMirrorDirStatement.executeUpdate();
            if (rowCount == 1) {
                ++this.directoryCounter;
                LOGGER.log(Level.FINE, "added mirror directory {0}", directory);
            } else {
                LOGGER.log(Level.WARNING, "could not insert mirror directory {0} to database", directory);
            }
            directoryID = this.getMirrorDirID(parentID, directory);
        }
        return directoryID;
    }

    private long getOrAddIncrementDir(Date timestamp, long parentID, String directory, PreparedStatement insertIncrementDirStatement) throws SQLException {
        long directoryID = this.getIncrementDirID(timestamp, parentID, directory);
        if (directoryID == 0L) {
            insertIncrementDirStatement.setLong(1, timestamp.getTime() / 1000L);
            insertIncrementDirStatement.setLong(2, parentID);
            insertIncrementDirStatement.setString(3, directory);
            int rowCount = insertIncrementDirStatement.executeUpdate();
            if (rowCount == 1) {
                ++this.directoryCounter;
                LOGGER.log(Level.FINE, "added increment directory {0}", directory);
            } else {
                LOGGER.log(Level.WARNING, "could not insert increment directory {0} to database", directory);
            }
            directoryID = this.getIncrementDirID(timestamp, parentID, directory);
        }
        return directoryID;
    }

    private void trimIncrements(List<Date> timestampsToDelete) throws SQLException {
        long trimStart = System.currentTimeMillis();
        PreparedStatement deleteTimestampStatement = this.connection.prepareStatement("DELETE FROM increment_timestamps WHERE timestamp=?");
        PreparedStatement deleteFilesStatement = this.connection.prepareStatement("DELETE FROM increment_files WHERE id IN (SELECT id FROM increment_directories WHERE timestamp=?)");
        PreparedStatement deleteDirectoriesStatement = this.connection.prepareStatement("DELETE FROM increment_directories WHERE timestamp=?");
        for (Date timestampToDelete : timestampsToDelete) {
            long time;
            LOGGER.log(Level.INFO, "deleting increment timestamp {0}", DATE_FORMAT.format(timestampToDelete));
            ++this.incrementCounter;
            long rdiffTimestamp = timestampToDelete.getTime() / 1000L;
            deleteTimestampStatement.setLong(1, rdiffTimestamp);
            int rowCount = deleteTimestampStatement.executeUpdate();
            if (rowCount != 1) {
                LOGGER.log(Level.WARNING, "could not remove timestamp {0} from database", DATE_FORMAT.format(timestampToDelete));
            }
            long start = System.currentTimeMillis();
            deleteFilesStatement.setLong(1, rdiffTimestamp);
            rowCount = deleteFilesStatement.executeUpdate();
            if (LOGGER.isLoggable(Level.INFO)) {
                time = System.currentTimeMillis() - start;
                LOGGER.log(Level.INFO, "removing {0} files took {1} ms", new Object[]{rowCount, time});
            }
            start = System.currentTimeMillis();
            deleteDirectoriesStatement.setLong(1, rdiffTimestamp);
            rowCount = deleteDirectoriesStatement.executeUpdate();
            if (!LOGGER.isLoggable(Level.INFO)) continue;
            time = System.currentTimeMillis() - start;
            LOGGER.log(Level.INFO, "removing {0} directories took {1} ms", new Object[]{rowCount, time});
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            long time = System.currentTimeMillis() - trimStart;
            LOGGER.log(Level.INFO, "trimming database took {0} ms", time);
        }
    }

    private List<RdiffTimestamp> getFileSystemTimestamps() {
        ArrayList<Long> timestamps = new ArrayList<Long>();
        for (String line : this.rdiffBackupListOutput) {
            String[] tokens = line.split(" ");
            if (tokens.length == 2) {
                String timestampString = tokens[0];
                try {
                    long timestamp = Long.parseLong(timestampString);
                    timestamps.add(timestamp);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.log(Level.WARNING, "could not parse timestamp" + timestampString, numberFormatException);
                }
                continue;
            }
            LOGGER.log(Level.WARNING, "could not parse line \"{0}\"", line);
        }
        Collections.sort(timestamps, Collections.reverseOrder());
        if (LOGGER.isLoggable(Level.INFO)) {
            StringBuilder stringBuilder = new StringBuilder("filesystem timestamps:\n");
            Iterator i$ = timestamps.iterator();
            while (i$.hasNext()) {
                long timestamp = (Long)i$.next();
                stringBuilder.append("\t");
                stringBuilder.append(String.valueOf(timestamp));
                stringBuilder.append("\n");
            }
            LOGGER.info(stringBuilder.toString());
        }
        ArrayList<RdiffTimestamp> rdiffTimestamps = new ArrayList<RdiffTimestamp>();
        File rdiffBackupDataDirectory = new File(this.backupDirectory, "rdiff-backup-data");
        File[] statisticsFiles = rdiffBackupDataDirectory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("session_statistics.");
            }
        });
        for (Long timestamp : timestamps) {
            for (File statisticsFile : statisticsFiles) {
                try {
                    List<String> lines = FileTools.readFile(statisticsFile);
                    for (String line : lines) {
                        if (!line.startsWith("StartTime")) continue;
                        String timeString = line.split(" ")[1].split("\\.")[0];
                        if (!timestamp.toString().equals(timeString)) continue;
                        String fileName = statisticsFile.getName();
                        String fileStamp = fileName.split("\\.")[1];
                        rdiffTimestamps.add(new RdiffTimestamp(new Date(timestamp * 1000L), fileStamp));
                    }
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            }
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            StringBuilder stringBuilder = new StringBuilder("rdiffTimestamps:\n");
            for (RdiffTimestamp timestamp : rdiffTimestamps) {
                stringBuilder.append("\t");
                stringBuilder.append(String.valueOf(timestamp.getTimestamp()));
                stringBuilder.append(" (");
                stringBuilder.append(timestamp.getFilestamp());
                stringBuilder.append(")\n");
            }
            LOGGER.info(stringBuilder.toString());
        }
        return rdiffTimestamps;
    }

    private Date getDatabaseMirrorTimestamp() throws SQLException {
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT timestamp FROM mirror_timestamp");
        if (resultSet.next()) {
            Date databaseMirrorTimeStamp = new Date(resultSet.getLong(TIMESTAMP_COLUMN) * 1000L);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "database mirror timestamp: {0}", DATE_FORMAT.format(databaseMirrorTimeStamp));
            }
            statement.close();
            return databaseMirrorTimeStamp;
        }
        statement.close();
        return null;
    }

    private List<Date> getDatabaseIncrementTimestamps() throws SQLException {
        ArrayList<Date> timestamps = new ArrayList<Date>();
        ResultSet resultSet = this.getIncrementsStatement.executeQuery();
        while (resultSet.next()) {
            timestamps.add(new Date(resultSet.getLong(TIMESTAMP_COLUMN) * 1000L));
        }
        resultSet.close();
        return timestamps;
    }

    private static class DirCacheEntry {
        public String directory;
        public long ID;

        private DirCacheEntry() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SyncState {
        CHECKING,
        TRIMMING,
        SYNCING,
        COMPRESSING;

    }
}

