/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack;

import ch.fhnw.jbackpack.LogLevel;
import ch.fhnw.jbackpack.MyListCellRenderer;
import ch.fhnw.util.CurrentOperatingSystem;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PreferencesDialog
extends JDialog {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
    private static final LogLevel[] LOG_LEVELS = LogLevel.values();
    private LogLevel logLevel;
    private boolean okButtonClicked;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JPanel cardPanel;
    private JScrollPane descriptionScrollPane;
    private JTextArea descriptionTextArea;
    private JSeparator jSeparator1;
    private JSlider levelSlider;
    private JLabel logFileLabel;
    private JTextField logFileTextField;
    private JPanel logPanel;
    private JPanel logfilePanel;
    private JList menuList;
    private JScrollPane menuListScrollPane;
    private JPanel miscPanel;
    private JButton okButton;
    private JCheckBox plainBackupWarningCheckBox;

    public PreferencesDialog(Frame parent, String currentLogFile, LogLevel logLevel, boolean showPlainWarning) {
        super(parent, true);
        this.initComponents();
        DefaultListModel<String> menuListModel = new DefaultListModel<String>();
        menuListModel.addElement(BUNDLE.getString("Logging_Level"));
        menuListModel.addElement(BUNDLE.getString("Miscellaneous"));
        this.menuList.setModel(menuListModel);
        ArrayList<Icon> icons = new ArrayList<Icon>();
        icons.add(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/32x32/toggle_log.png")));
        icons.add(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/32x32/misc.png")));
        this.menuList.setCellRenderer(new MyListCellRenderer(icons));
        this.menuList.setSelectedIndex(0);
        Dimension preferredSize = this.menuListScrollPane.getPreferredSize();
        this.menuListScrollPane.setPreferredSize(preferredSize);
        this.menuListScrollPane.setMinimumSize(preferredSize);
        if (currentLogFile == null || currentLogFile.length() == 0) {
            this.logFileTextField.setText(BUNDLE.getString("Unknown"));
        } else {
            this.logFileTextField.setText(currentLogFile);
        }
        this.logLevel = logLevel;
        Hashtable<Integer, JLabel> loggingLabelTable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i < 8; ++i) {
            String levelText = LogLevel.values()[i].toString();
            JLabel label = new JLabel(levelText);
            if (i == 0) {
                label.setForeground(Color.RED);
            }
            loggingLabelTable.put(i, label);
        }
        this.levelSlider.setLabelTable(loggingLabelTable);
        this.levelSlider.setValue(logLevel.ordinal());
        this.descriptionTextArea.setText(logLevel.getDescription());
        switch (CurrentOperatingSystem.OS) {
            case Mac_OS_X: 
            case Linux: {
                this.plainBackupWarningCheckBox.setSelected(showPlainWarning);
                break;
            }
            default: {
                Color disabledForeground = UIManager.getColor("Button.disabledForeground");
                this.plainBackupWarningCheckBox.setSelected(false);
                this.plainBackupWarningCheckBox.setEnabled(false);
                this.plainBackupWarningCheckBox.setForeground(disabledForeground);
                this.plainBackupWarningCheckBox.setToolTipText(BUNDLE.getString("Tooltip_ENCFS"));
            }
        }
        this.setSize(500, 300);
        this.setLocationRelativeTo(parent);
    }

    public boolean okPressed() {
        return this.okButtonClicked;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public boolean isShowPlainBackupWarningSelected() {
        return this.plainBackupWarningCheckBox.isSelected();
    }

    private void initComponents() {
        this.menuListScrollPane = new JScrollPane();
        this.menuList = new JList();
        this.cardPanel = new JPanel();
        this.logPanel = new JPanel();
        this.logfilePanel = new JPanel();
        this.logFileLabel = new JLabel();
        this.logFileTextField = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.levelSlider = new JSlider();
        this.descriptionScrollPane = new JScrollPane();
        this.descriptionTextArea = new JTextArea();
        this.miscPanel = new JPanel();
        this.plainBackupWarningCheckBox = new JCheckBox();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
        this.setTitle(bundle.getString("PreferencesDialog.title"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.menuList.setSelectionMode(0);
        this.menuList.setName("menuList");
        this.menuList.setVisibleRowCount(4);
        this.menuList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                PreferencesDialog.this.menuListValueChanged(evt);
            }
        });
        this.menuListScrollPane.setViewportView(this.menuList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.menuListScrollPane, gridBagConstraints);
        this.cardPanel.setBorder(BorderFactory.createEtchedBorder());
        this.cardPanel.setLayout(new CardLayout());
        this.logPanel.setLayout(new GridBagLayout());
        this.logfilePanel.setLayout(new GridBagLayout());
        this.logFileLabel.setText(bundle.getString("PreferencesDialog.logFileLabel.text"));
        this.logfilePanel.add((Component)this.logFileLabel, new GridBagConstraints());
        this.logFileTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.logfilePanel.add((Component)this.logFileTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.logPanel.add((Component)this.logfilePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.logPanel.add((Component)this.jSeparator1, gridBagConstraints);
        this.levelSlider.setMajorTickSpacing(1);
        this.levelSlider.setMaximum(7);
        this.levelSlider.setOrientation(1);
        this.levelSlider.setPaintLabels(true);
        this.levelSlider.setPaintTicks(true);
        this.levelSlider.setSnapToTicks(true);
        this.levelSlider.setValue(0);
        this.levelSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                PreferencesDialog.this.levelSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 5);
        this.logPanel.add((Component)this.levelSlider, gridBagConstraints);
        this.descriptionTextArea.setColumns(20);
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setWrapStyleWord(true);
        this.descriptionScrollPane.setViewportView(this.descriptionTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 10, 10);
        this.logPanel.add((Component)this.descriptionScrollPane, gridBagConstraints);
        this.cardPanel.add((Component)this.logPanel, "logPanel");
        this.miscPanel.setLayout(new GridBagLayout());
        this.plainBackupWarningCheckBox.setText(bundle.getString("PreferencesDialog.plainBackupWarningCheckBox.text"));
        this.plainBackupWarningCheckBox.setName("plainBackupWarningCheckBox");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.miscPanel.add((Component)this.plainBackupWarningCheckBox, gridBagConstraints);
        this.cardPanel.add((Component)this.miscPanel, "miscPanel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.cardPanel, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.okButton.setText(bundle.getString("PreferencesDialog.okButton.text"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.buttonPanel.add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setText(bundle.getString("PreferencesDialog.cancelButton.text"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.buttonPanel.add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(10, 5, 10, 5);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
    }

    private void levelSliderStateChanged(ChangeEvent evt) {
        this.logLevel = LOG_LEVELS[this.levelSlider.getValue()];
        this.descriptionTextArea.setText(this.logLevel.getDescription());
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
        this.setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.okButtonClicked = true;
        this.dispose();
        this.setVisible(false);
    }

    private void menuListValueChanged(ListSelectionEvent evt) {
        int index = this.menuList.getSelectedIndex();
        switch (index) {
            case 0: {
                this.showPanel("logPanel");
                break;
            }
            case 1: {
                this.showPanel("miscPanel");
                break;
            }
        }
    }

    private void showPanel(String panel) {
        CardLayout layout = (CardLayout)this.cardPanel.getLayout();
        layout.show(this.cardPanel, panel);
    }
}

