/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack;

import ch.fhnw.jbackpack.FilenameCheckDialog;
import ch.fhnw.util.ModalDialogHandler;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import javax.swing.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilenameCheckSwingWorker
extends SwingWorker<Integer, Void> {
    private final FilenameCheckDialog filenameCheckDialog;
    private final ModalDialogHandler dialogHandler;
    private final File directory;
    private int goodLength;
    private int badLength;

    public FilenameCheckSwingWorker(Frame parentFrame, File directory) {
        this.directory = directory;
        this.filenameCheckDialog = new FilenameCheckDialog(parentFrame);
        this.dialogHandler = new ModalDialogHandler(this.filenameCheckDialog);
        this.dialogHandler.show();
    }

    @Override
    protected Integer doInBackground() {
        Random random = new Random();
        this.goodLength = 0;
        this.badLength = 32768;
        int length = 0;
        while (this.badLength - this.goodLength > 1) {
            StringBuilder stringBuilder;
            String randomFileName;
            length = (this.badLength + this.goodLength) / 2;
            File testFile = null;
            do {
                stringBuilder = new StringBuilder(length);
                for (int i = 0; i < length; ++i) {
                    stringBuilder.append(random.nextInt(10));
                }
            } while ((testFile = new File(this.directory, randomFileName = stringBuilder.toString())).exists());
            try {
                if (testFile.createNewFile()) {
                    this.goodLength = length;
                    testFile.delete();
                }
            }
            catch (IOException ex) {
                this.badLength = length;
            }
            this.publish(new Void[0]);
        }
        return length;
    }

    @Override
    protected void process(List<Void> chunks) {
        this.filenameCheckDialog.setLengths(this.goodLength, this.badLength);
    }

    @Override
    protected void done() {
        this.dialogHandler.hide();
    }
}

