/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import org.apache.tomcat.util.collections.SimplePool;
import org.apache.tomcat.util.net.PoolTcpEndpoint;
import org.apache.tomcat.util.net.TcpConnection;
import org.apache.tomcat.util.threads.ThreadPoolRunnable;

class TcpWorkerThread
implements ThreadPoolRunnable {
    PoolTcpEndpoint endpoint;
    SimplePool connectionCache;
    static final boolean usePool = false;

    public TcpWorkerThread(PoolTcpEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Object[] getInitData() {
        Object[] obj = new Object[2];
        obj[1] = this.endpoint.getConnectionHandler().init();
        obj[0] = new TcpConnection();
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runIt(Object[] perThrData) {
        if (this.endpoint.isRunning()) {
            Socket s = null;
            try {
                s = this.endpoint.acceptSocket();
                Object var4_3 = null;
                if (this.endpoint.isRunning()) {
                    this.endpoint.tp.runIt(this);
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (this.endpoint.isRunning()) {
                    this.endpoint.tp.runIt(this);
                }
                throw throwable;
            }
            if (null != s) {
                try {
                    if (this.endpoint.getServerSocketFactory() != null) {
                        this.endpoint.getServerSocketFactory().handshake(s);
                    }
                }
                catch (Throwable t) {
                    PoolTcpEndpoint.log.debug((Object)"Handshake failed", t);
                    try {
                        s.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return;
                }
                TcpConnection con = null;
                try {
                    con = (TcpConnection)perThrData[0];
                    perThrData = (Object[])perThrData[1];
                    con.setEndpoint(this.endpoint);
                    con.setSocket(s);
                    this.endpoint.setSocketOptions(s);
                    this.endpoint.getConnectionHandler().processConnection(con, perThrData);
                }
                catch (SocketException se) {
                    PoolTcpEndpoint.log.error((Object)("Remote Host " + s.getInetAddress() + " SocketException: " + se.getMessage()));
                    try {
                        s.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                catch (Throwable t) {
                    PoolTcpEndpoint.log.error((Object)"Unexpected error", t);
                    try {
                        s.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                finally {
                    if (con != null) {
                        con.recycle();
                    }
                }
            }
        }
    }
}

