/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util.log;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.avalon.framework.ExceptionUtil;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.log.ExtensiblePatternFormatter;
import org.apache.log.ContextMap;
import org.apache.log.LogEvent;
import org.apache.log.Logger;

public class CocoonLogFormatter
extends ExtensiblePatternFormatter {
    public static final int DEFAULT_STACK_DEPTH = 8;
    protected static final int TYPE_CLASS = 9;
    protected static final int TYPE_URI = 10;
    protected static final int TYPE_THREAD = 11;
    protected static final int TYPE_HOST = 12;
    protected static final String TYPE_CLASS_STR = "class";
    protected static final String TYPE_CLASS_SHORT_STR = "short";
    protected static final String TYPE_URI_STR = "uri";
    protected static final String TYPE_THREAD_STR = "thread";
    protected static final String TYPE_HOST_STR = "host";
    protected final SimpleDateFormat dateFormatter = new SimpleDateFormat("(yyyy-MM-dd) HH:mm.ss:SSS");
    private Class logkitClass = LogKitLogger.class;
    private Class loggerClass = Logger.class;
    private CallStack callStack = new CallStack();
    private final int m_stackDepth;

    public CocoonLogFormatter() {
        this(8);
    }

    public CocoonLogFormatter(int stackDepth) {
        this.m_stackDepth = stackDepth;
    }

    protected int getTypeIdFor(String type) {
        if (type.equalsIgnoreCase(TYPE_CLASS_STR)) {
            return 9;
        }
        if (type.equalsIgnoreCase(TYPE_URI_STR)) {
            return 10;
        }
        if (type.equalsIgnoreCase(TYPE_THREAD_STR)) {
            return 11;
        }
        if (type.equalsIgnoreCase(TYPE_HOST_STR)) {
            return 12;
        }
        return super.getTypeIdFor(type);
    }

    protected String formatPatternRun(LogEvent event, ExtensiblePatternFormatter.PatternRun run) {
        switch (run.m_type) {
            case 9: {
                return this.getClass(run.m_format);
            }
            case 10: {
                return this.getURI(event.getContextMap());
            }
            case 11: {
                return this.getThread(event.getContextMap());
            }
            case 12: {
                return this.getHost(event.getContextMap());
            }
        }
        return super.formatPatternRun(event, run);
    }

    private String getClass(String format) {
        Class[] stack = this.callStack.get();
        for (int i = stack.length - 1; i >= 0; --i) {
            int pos;
            if (!this.logkitClass.isAssignableFrom(stack[i]) && !this.loggerClass.isAssignableFrom(stack[i])) continue;
            String className = stack[i + 1].getName();
            if (TYPE_CLASS_SHORT_STR.equalsIgnoreCase(format) && (pos = className.lastIndexOf(46)) >= 0) {
                className = className.substring(pos + 1);
            }
            return className;
        }
        return "Unknown-class";
    }

    private String getURI(ContextMap ctxMap) {
        Request request;
        Object context;
        String result = "Unknown-URI";
        if (ctxMap != null && (context = ctxMap.get("objectModel")) != null && context instanceof Map && (request = ObjectModelHelper.getRequest((Map)context)) != null) {
            result = request.getRequestURI();
        }
        return result;
    }

    private String getHost(ContextMap ctxMap) {
        Request request;
        Object context;
        String result = "Unknown-host";
        if (ctxMap != null && (context = ctxMap.get("objectModel")) != null && context instanceof Map && (request = ObjectModelHelper.getRequest((Map)context)) != null) {
            result = request.getHeader(TYPE_HOST_STR);
        }
        return result;
    }

    private String getThread(ContextMap ctxMap) {
        if (ctxMap != null && ctxMap.get("threadName") != null) {
            return (String)ctxMap.get("threadName");
        }
        return "Unknown-thread";
    }

    protected String getStackTrace(Throwable throwable, String format) {
        return throwable == null ? null : ExceptionUtil.printStackTrace((Throwable)throwable, (int)this.m_stackDepth);
    }

    protected String getTime(long time, String format) {
        return this.dateFormatter.format(new Date());
    }

    public static class CallStack
    extends SecurityManager {
        public Class[] get() {
            return this.getClassContext();
        }
    }
}

