/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.serialization;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.component.Composable;
import org.apache.cocoon.serialization.AbstractSerializer;
import org.apache.cocoon.serialization.Serializer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.NamespaceSupport;

public class ZipArchiveSerializer
extends AbstractSerializer
implements Composable,
Disposable {
    public static final String ZIP_NAMESPACE = "http://apache.org/cocoon/zip-archive/1.0";
    private static final int START_STATE = 0;
    private static final int IN_ZIP_STATE = 1;
    private static final int IN_CONTENT_STATE = 2;
    protected ComponentManager manager;
    protected ComponentSelector selector;
    protected ZipOutputStream zipOutput;
    protected int state = 0;
    protected SourceResolver resolver;
    protected byte[] buffer = new byte[1024];
    protected Serializer serializer;
    protected int contentDepth;
    private NamespaceSupport nsSupport = new NamespaceSupport();
    private SAXException exception = null;

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        this.resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
    }

    public String getMimeType() {
        return null;
    }

    public void startDocument() throws SAXException {
        this.state = 0;
        this.zipOutput = new ZipOutputStream(this.output);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.state == 2) {
            super.startPrefixMapping(prefix, uri);
        } else if (!uri.equals(ZIP_NAMESPACE)) {
            this.nsSupport.declarePrefix(prefix, uri);
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.exception != null) {
            throw this.exception;
        }
        switch (this.state) {
            case 0: {
                if (namespaceURI.equals(ZIP_NAMESPACE) && localName.equals("archive")) {
                    this.nsSupport.pushContext();
                    this.state = 1;
                    break;
                }
                this.exception = new SAXException("Expecting 'archive' root element (got '" + localName + "')");
                throw this.exception;
            }
            case 1: {
                if (namespaceURI.equals(ZIP_NAMESPACE) && localName.equals("entry")) {
                    this.nsSupport.pushContext();
                    this.addEntry(atts);
                    break;
                }
                this.exception = new SAXException("Expecting 'entry' element (got '" + localName + "')");
                throw this.exception;
            }
            case 2: {
                ++this.contentDepth;
                super.startElement(namespaceURI, localName, qName, atts);
            }
        }
    }

    public void characters(char[] buffer, int offset, int length) throws SAXException {
        if (this.state == 2 && this.contentDepth > 0) {
            super.characters(buffer, offset, length);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addEntry(Attributes atts) throws SAXException {
        String name = atts.getValue("name");
        if (name == null) {
            this.exception = new SAXException("No name given to the Zip entry");
            throw this.exception;
        }
        String src = atts.getValue("src");
        String serializerType = atts.getValue("serializer");
        if (src == null && serializerType == null) {
            this.exception = new SAXException("No source nor serializer given for the Zip entry '" + name + "'");
            throw this.exception;
        }
        if (src != null && serializerType != null) {
            this.exception = new SAXException("Cannot specify both 'src' and 'serializer' on a Zip entry '" + name + "'");
            throw this.exception;
        }
        Source source = null;
        try {
            ZipEntry entry = new ZipEntry(name);
            this.zipOutput.putNextEntry(entry);
            if (src != null) {
                int len;
                source = this.resolver.resolveURI(src);
                InputStream sourceInput = source.getInputStream();
                while ((len = sourceInput.read(this.buffer)) > 0) {
                    this.zipOutput.write(this.buffer, 0, len);
                }
                this.zipOutput.closeEntry();
            } else {
                if (this.selector == null) {
                    this.selector = (ComponentSelector)this.manager.lookup(Serializer.ROLE + "Selector");
                }
                this.serializer = (Serializer)this.selector.select((Object)serializerType);
                this.serializer.setOutputStream(new FilterOutputStream(this.zipOutput){

                    public void close() {
                    }
                });
                this.setConsumer(this.serializer);
                this.serializer.startDocument();
                Enumeration<String> prefixes = this.nsSupport.getPrefixes();
                while (prefixes.hasMoreElements()) {
                    String prefix = prefixes.nextElement();
                    super.startPrefixMapping(prefix, this.nsSupport.getURI(prefix));
                }
                this.state = 2;
                this.contentDepth = 0;
            }
        }
        catch (RuntimeException re) {
            try {
                throw re;
                catch (SAXException se) {
                    this.exception = se;
                    throw this.exception;
                }
                catch (Exception e) {
                    this.exception = new SAXException(e);
                    throw this.exception;
                }
            }
            catch (Throwable throwable) {
                this.resolver.release(source);
                throw throwable;
            }
        }
        this.resolver.release(source);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.state == 2) {
            super.endElement(namespaceURI, localName, qName);
            --this.contentDepth;
            if (this.contentDepth == 0) {
                Enumeration<String> prefixes = this.nsSupport.getPrefixes();
                while (prefixes.hasMoreElements()) {
                    String prefix = prefixes.nextElement();
                    super.endPrefixMapping(prefix);
                }
                super.endDocument();
                try {
                    this.zipOutput.closeEntry();
                }
                catch (IOException ioe) {
                    this.exception = new SAXException(ioe);
                    throw this.exception;
                }
                super.setConsumer(null);
                this.selector.release((Component)this.serializer);
                this.serializer = null;
                this.state = 1;
            }
        } else {
            this.nsSupport.popContext();
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.zipOutput.finish();
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void recycle() {
        this.exception = null;
        if (this.serializer != null) {
            this.selector.release((Component)this.serializer);
        }
        if (this.selector != null) {
            this.manager.release((Component)this.selector);
        }
        this.nsSupport.reset();
        super.recycle();
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Component)this.resolver);
            this.resolver = null;
            this.manager = null;
        }
    }
}

