/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import org.eclipse.jdt.internal.core.util.IDumpable;

public class Dumper {
    int fTabLevel = 0;
    PrintWriter fWriter;

    public Dumper() {
        this(System.out);
    }

    public Dumper(OutputStream out) {
        this(new PrintWriter(out));
    }

    public Dumper(PrintWriter writer) {
        this.fWriter = writer;
    }

    String classNameFor(Object val) {
        String name = val.getClass().getName();
        int i = name.lastIndexOf(46);
        if (i != -1) {
            name = name.substring(i + 1);
        }
        return name;
    }

    public void dump(int[] val, int maxPerLine) {
        boolean oneLine;
        int len = val.length;
        boolean bl = oneLine = len <= maxPerLine;
        if (!oneLine) {
            ++this.fTabLevel;
        }
        this.fWriter.print("[");
        int i = 0;
        while (i < len) {
            if (!oneLine && i % maxPerLine == 0) {
                this.fWriter.println();
                this.tabIfNeeded();
                this.fWriter.print(i);
                this.fWriter.print(": ");
            }
            this.fWriter.print(val[i]);
            if (i + 1 < len) {
                this.fWriter.print(", ");
            }
            ++i;
        }
        if (oneLine) {
            this.fWriter.print("]");
            this.fWriter.println();
        } else {
            this.fWriter.println();
            --this.fTabLevel;
            this.tabIfNeeded();
            this.fWriter.print("]");
            this.fWriter.println();
        }
    }

    public void dump(Object[] val) {
        int len = val.length;
        this.fWriter.print("[");
        if (len > 0) {
            this.fWriter.println();
            ++this.fTabLevel;
            int i = 0;
            while (i < len) {
                this.dump(val[i]);
                ++i;
            }
            --this.fTabLevel;
            this.tabIfNeeded();
        }
        this.fWriter.println("]");
    }

    public void dump(String[] val, int maxPerLine) {
        boolean oneLine;
        int len = val.length;
        boolean bl = oneLine = len <= maxPerLine;
        if (!oneLine) {
            ++this.fTabLevel;
        }
        this.fWriter.print("[");
        boolean newLine = !oneLine;
        int i = 0;
        while (i < len) {
            if (newLine) {
                this.fWriter.println();
                this.tabIfNeeded();
            }
            this.fWriter.print("\"" + val[i] + "\"");
            if (i + 1 < len) {
                this.fWriter.print(", ");
            }
            newLine = i != 0 && i % maxPerLine == 0;
            ++i;
        }
        this.fWriter.print("]");
        if (oneLine || newLine) {
            this.fWriter.println();
        }
        if (!oneLine) {
            --this.fTabLevel;
        }
    }

    public void dump(Object val) {
        this.tabIfNeeded();
        if (val instanceof IDumpable) {
            IDumpable dumpable = (IDumpable)val;
            this.fWriter.println(String.valueOf(this.classNameFor(val)) + " {");
            int originalLevel = this.fTabLevel++;
            try {
                dumpable.dump(this);
            }
            catch (Throwable throwable) {
                this.fWriter.println("*ERR*");
            }
            this.fTabLevel = originalLevel;
            this.tabIfNeeded();
            this.fWriter.println("}");
        } else {
            this.fWriter.println(val);
        }
    }

    public void dump(String name, int[] val) {
        this.dump(name, val, 10);
    }

    public void dump(String name, int[] val, int maxPerLine) {
        this.prefix(name);
        this.dump(val, maxPerLine);
    }

    public void dump(String name, Object[] val) {
        this.prefix(name);
        this.dump(val);
    }

    public void dump(String name, String[] val) {
        this.prefix(name);
        this.dump(val, 5);
    }

    public void dump(String name, int val) {
        this.prefix(name);
        this.fWriter.println(val);
    }

    public void dump(String name, Object val) {
        this.prefix(name);
        this.fWriter.println();
        ++this.fTabLevel;
        this.dump(val);
        --this.fTabLevel;
    }

    public void dump(String name, String val) {
        this.prefix(name);
        this.fWriter.println(val == null ? "null" : "\"" + val + "\"");
    }

    public void dump(String name, boolean val) {
        this.prefix(name);
        this.fWriter.println(val);
    }

    public void dumpMessage(String name, String msg) {
        this.prefix(name);
        this.fWriter.println(msg);
    }

    public void flush() {
        this.fWriter.flush();
    }

    public int getTabLevel() {
        return this.fTabLevel;
    }

    public PrintWriter getWriter() {
        return this.fWriter;
    }

    public void indent() {
        ++this.fTabLevel;
    }

    public void outdent() {
        if (--this.fTabLevel < 0) {
            this.fTabLevel = 0;
        }
    }

    void prefix(String name) {
        this.tabIfNeeded();
        this.fWriter.print(name);
        this.fWriter.print(": ");
    }

    public void print(Object obj) {
        this.fWriter.print(obj);
    }

    public void println() {
        this.fWriter.println();
    }

    public void println(Object obj) {
        this.fWriter.println(obj);
    }

    void tabIfNeeded() {
        int i = 0;
        while (i < this.fTabLevel) {
            this.fWriter.print("  ");
            ++i;
        }
    }
}

