/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.codeassist.CompletionEngine;
import org.eclipse.jdt.internal.codeassist.SelectionEngine;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.DeltaProcessor;
import org.eclipse.jdt.internal.core.JavaElementDelta;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelCache;
import org.eclipse.jdt.internal.core.JavaModelOperation;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.ModelUpdater;
import org.eclipse.jdt.internal.core.Util;
import org.eclipse.jdt.internal.core.builder.JavaBuilder;
import org.eclipse.jdt.internal.core.builder.State;
import org.eclipse.jdt.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.jdt.internal.core.search.AbstractSearchScope;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.processing.JobManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JavaModelManager
implements ISaveParticipant {
    final JavaModel javaModel = new JavaModel();
    public static HashMap Variables = new HashMap(5);
    public static HashMap PreviousSessionVariables = new HashMap(5);
    public static HashSet OptionNames = new HashSet(20);
    public static final String CP_VARIABLE_PREFERENCES_PREFIX = "org.eclipse.jdt.core.classpathVariable.";
    public static final String CP_CONTAINER_PREFERENCES_PREFIX = "org.eclipse.jdt.core.classpathContainer.";
    public static final String CP_ENTRY_IGNORE = "##<cp entry ignore>##";
    public static HashMap Containers = new HashMap(5);
    public static HashMap PreviousSessionContainers = new HashMap(5);
    public static final String CPVARIABLE_INITIALIZER_EXTPOINT_ID = "classpathVariableInitializer";
    public static final String CPCONTAINER_INITIALIZER_EXTPOINT_ID = "classpathContainerInitializer";
    public static final String FORMATTER_EXTPOINT_ID = "codeFormatter";
    public static final IPath VariableInitializationInProgress = new Path("Variable Initialization In Progress");
    public static final IClasspathContainer ContainerInitializationInProgress = new IClasspathContainer(){

        public IClasspathEntry[] getClasspathEntries() {
            return null;
        }

        public String getDescription() {
            return "Container Initialization In Progress";
        }

        public int getKind() {
            return 0;
        }

        public IPath getPath() {
            return null;
        }

        public String toString() {
            return this.getDescription();
        }
    };
    private static final String INDEX_MANAGER_DEBUG = "org.eclipse.jdt.core/debug/indexmanager";
    private static final String COMPILER_DEBUG = "org.eclipse.jdt.core/debug/compiler";
    private static final String JAVAMODEL_DEBUG = "org.eclipse.jdt.core/debug/javamodel";
    private static final String CP_RESOLVE_DEBUG = "org.eclipse.jdt.core/debug/cpresolution";
    private static final String ZIP_ACCESS_DEBUG = "org.eclipse.jdt.core/debug/zipaccess";
    private static final String DELTA_DEBUG = "org.eclipse.jdt.core/debug/javadelta";
    private static final String HIERARCHY_DEBUG = "org.eclipse.jdt.core/debug/hierarchy";
    private static final String POST_ACTION_DEBUG = "org.eclipse.jdt.core/debug/postaction";
    private static final String BUILDER_DEBUG = "org.eclipse.jdt.core/debug/builder";
    private static final String COMPLETION_DEBUG = "org.eclipse.jdt.core/debug/completion";
    private static final String SELECTION_DEBUG = "org.eclipse.jdt.core/debug/selection";
    private static final String SHARED_WC_DEBUG = "org.eclipse.jdt.core/debug/sharedworkingcopy";
    private static final String SEARCH_DEBUG = "org.eclipse.jdt.core/debug/search";
    public static final IWorkingCopy[] NoWorkingCopy = new IWorkingCopy[0];
    private static final JavaModelManager Manager = new JavaModelManager();
    protected JavaModelCache cache = new JavaModelCache();
    protected Map elementsOutOfSynchWithBuffers = new HashMap(11);
    private boolean isFiring = true;
    ArrayList javaModelDeltas = new ArrayList();
    HashMap reconcileDeltas = new HashMap();
    private IElementChangedListener[] elementChangedListeners = new IElementChangedListener[5];
    private int[] elementChangedListenerMasks = new int[5];
    private int elementChangedListenerCount = 0;
    public int currentChangeEventType = 2;
    public static final int DEFAULT_CHANGE_EVENT = 0;
    public final DeltaProcessor deltaProcessor = new DeltaProcessor(this);
    private final ModelUpdater modelUpdater = new ModelUpdater();
    public IJavaProject[] javaProjectsCache;
    protected Map perProjectInfo = new HashMap(5);
    public Map sharedWorkingCopies = new HashMap();
    protected WeakHashMap scopes = new WeakHashMap();
    public static boolean VERBOSE = false;
    public static boolean CP_RESOLVE_VERBOSE = false;
    public static boolean ZIP_ACCESS_VERBOSE = false;
    private HashMap zipFiles = new HashMap();

    public static boolean conflictsWithOutputLocation(IPath folderPath, JavaProject project) {
        try {
            IPath outputLocation = project.getOutputLocation();
            if (outputLocation == null) {
                return true;
            }
            if (outputLocation.isPrefixOf(folderPath)) {
                IClasspathEntry[] classpath = project.getResolvedClasspath(true);
                boolean isOutputUsed = false;
                int i = 0;
                int length = classpath.length;
                while (i < length) {
                    IClasspathEntry entry = classpath[i];
                    if (entry.getEntryKind() == 3) {
                        if (entry.getPath().equals((Object)outputLocation)) {
                            return false;
                        }
                        if (entry.getOutputLocation() == null) {
                            isOutputUsed = true;
                        }
                    }
                    ++i;
                }
                return isOutputUsed;
            }
            return false;
        }
        catch (JavaModelException javaModelException) {
            return true;
        }
    }

    public static IClasspathContainer containerGet(IJavaProject project, IPath containerPath) {
        Map projectContainers = (Map)Containers.get(project);
        if (projectContainers == null) {
            return null;
        }
        IClasspathContainer container = (IClasspathContainer)projectContainers.get(containerPath);
        return container;
    }

    public static void containerPut(IJavaProject project, IPath containerPath, IClasspathContainer container) {
        HashMap<IPath, IClasspathContainer> projectContainers = (HashMap<IPath, IClasspathContainer>)Containers.get(project);
        if (projectContainers == null) {
            projectContainers = new HashMap<IPath, IClasspathContainer>(1);
            Containers.put(project, projectContainers);
        }
        if (container == null) {
            projectContainers.remove(containerPath);
            Map previousContainers = (Map)PreviousSessionContainers.get(project);
            if (previousContainers != null) {
                previousContainers.remove(containerPath);
            }
        } else {
            projectContainers.put(containerPath, container);
        }
        if (container == ContainerInitializationInProgress) {
            return;
        }
        Preferences preferences = JavaCore.getPlugin().getPluginPreferences();
        String containerKey = CP_CONTAINER_PREFERENCES_PREFIX + project.getElementName() + "|" + containerPath;
        String containerString = CP_ENTRY_IGNORE;
        try {
            if (container != null) {
                containerString = ((JavaProject)project).encodeClasspath(container.getClasspathEntries(), null, false);
            }
        }
        catch (JavaModelException javaModelException) {}
        preferences.setDefault(containerKey, CP_ENTRY_IGNORE);
        preferences.setValue(containerKey, containerString);
        JavaCore.getPlugin().savePluginPreferences();
    }

    public static IJavaElement create(IResource resource, IJavaProject project) {
        if (resource == null) {
            return null;
        }
        int type = resource.getType();
        switch (type) {
            case 4: {
                return JavaCore.create((IProject)resource);
            }
            case 1: {
                return JavaModelManager.create((IFile)resource, project);
            }
            case 2: {
                return JavaModelManager.create((IFolder)resource, project);
            }
            case 8: {
                return JavaCore.create((IWorkspaceRoot)resource);
            }
        }
        return null;
    }

    public static IJavaElement create(IFile file, IJavaProject project) {
        if (file == null) {
            return null;
        }
        if (project == null) {
            project = JavaCore.create(file.getProject());
        }
        if (file.getFileExtension() != null) {
            String name = file.getName();
            if (Util.isValidCompilationUnitName(name)) {
                return JavaModelManager.createCompilationUnitFrom(file, project);
            }
            if (Util.isValidClassFileName(name)) {
                return JavaModelManager.createClassFileFrom(file, project);
            }
            if (Util.isArchiveFileName(name)) {
                return JavaModelManager.createJarPackageFragmentRootFrom(file, project);
            }
        }
        return null;
    }

    public static IJavaElement create(IFolder folder, IJavaProject project) {
        if (folder == null) {
            return null;
        }
        if (project == null) {
            project = JavaCore.create(folder.getProject());
        }
        IJavaElement element = JavaModelManager.determineIfOnClasspath((IResource)folder, project);
        if (JavaModelManager.conflictsWithOutputLocation(folder.getFullPath(), (JavaProject)project) || folder.getName().indexOf(46) >= 0 && !(element instanceof IPackageFragmentRoot)) {
            return null;
        }
        return element;
    }

    public static IClassFile createClassFileFrom(IFile file, IJavaProject project) {
        IPackageFragment pkg;
        if (file == null) {
            return null;
        }
        if (project == null) {
            project = JavaCore.create(file.getProject());
        }
        if ((pkg = (IPackageFragment)JavaModelManager.determineIfOnClasspath((IResource)file, project)) == null) {
            IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)file.getParent());
            pkg = root.getPackageFragment("");
        }
        return pkg.getClassFile(file.getName());
    }

    public static ICompilationUnit createCompilationUnitFrom(IFile file, IJavaProject project) {
        IPackageFragment pkg;
        if (file == null) {
            return null;
        }
        if (project == null) {
            project = JavaCore.create(file.getProject());
        }
        if ((pkg = (IPackageFragment)JavaModelManager.determineIfOnClasspath((IResource)file, project)) == null) {
            IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)file.getParent());
            pkg = root.getPackageFragment("");
            if (VERBOSE) {
                System.out.println("WARNING : creating unit element outside classpath (" + Thread.currentThread() + "): " + file.getFullPath());
            }
        }
        return pkg.getCompilationUnit(file.getName());
    }

    public static IPackageFragmentRoot createJarPackageFragmentRootFrom(IFile file, IJavaProject project) {
        if (file == null) {
            return null;
        }
        if (project == null) {
            project = JavaCore.create(file.getProject());
        }
        IPath resourcePath = file.getFullPath();
        try {
            IClasspathEntry[] entries = ((JavaProject)project).getResolvedClasspath(true);
            int i = 0;
            int length = entries.length;
            while (i < length) {
                IClasspathEntry entry = entries[i];
                IPath rootPath = entry.getPath();
                if (rootPath.equals((Object)resourcePath)) {
                    return project.getPackageFragmentRoot((IResource)file);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static IJavaElement determineIfOnClasspath(IResource resource, IJavaProject project) {
        IPath resourcePath = resource.getFullPath();
        try {
            IClasspathEntry[] entries = Util.isJavaFileName(resourcePath.lastSegment()) ? project.getRawClasspath() : ((JavaProject)project).getResolvedClasspath(true);
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() != 2) {
                    IPath rootPath = entry.getPath();
                    if (rootPath.equals((Object)resourcePath)) {
                        return project.getPackageFragmentRoot(resource);
                    }
                    if (rootPath.isPrefixOf(resourcePath) && !Util.isExcluded(resource, ((ClasspathEntry)entry).fullExclusionPatternChars())) {
                        IPackageFragmentRoot root = ((JavaProject)project).getFolderPackageFragmentRoot(rootPath);
                        if (root == null) {
                            return null;
                        }
                        IPath pkgPath = resourcePath.removeFirstSegments(rootPath.segmentCount());
                        if (resource.getType() == 1) {
                            pkgPath = pkgPath.removeLastSegments(1);
                            String pkgName = pkgPath.toString().replace('/', '.');
                            return root.getPackageFragment(pkgName);
                        }
                        String pkgName = Util.packageName(pkgPath);
                        if (pkgName == null || JavaConventions.validatePackageName(pkgName).getSeverity() == 4) {
                            return null;
                        }
                        return root.getPackageFragment(pkgName);
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        return null;
    }

    private JavaModelManager() {
    }

    public void addElementChangedListener(IElementChangedListener listener) {
        this.addElementChangedListener(listener, 5);
    }

    public void addElementChangedListener(IElementChangedListener listener, int eventMask) {
        int i = 0;
        while (i < this.elementChangedListenerCount) {
            if (this.elementChangedListeners[i].equals(listener)) {
                int cloneLength = this.elementChangedListenerMasks.length;
                this.elementChangedListenerMasks = new int[cloneLength];
                System.arraycopy(this.elementChangedListenerMasks, 0, this.elementChangedListenerMasks, 0, cloneLength);
                this.elementChangedListenerMasks[i] = eventMask;
                return;
            }
            ++i;
        }
        int length = this.elementChangedListeners.length;
        if (length == this.elementChangedListenerCount) {
            this.elementChangedListeners = new IElementChangedListener[length * 2];
            System.arraycopy(this.elementChangedListeners, 0, this.elementChangedListeners, 0, length);
            this.elementChangedListenerMasks = new int[length * 2];
            System.arraycopy(this.elementChangedListenerMasks, 0, this.elementChangedListenerMasks, 0, length);
        }
        this.elementChangedListeners[this.elementChangedListenerCount] = listener;
        this.elementChangedListenerMasks[this.elementChangedListenerCount] = eventMask;
        ++this.elementChangedListenerCount;
    }

    public void cacheZipFiles() {
        HashMap hashMap = this.zipFiles;
        synchronized (hashMap) {
            Thread currentThread = Thread.currentThread();
            if (this.zipFiles.get(currentThread) != null) {
                return;
            }
            this.zipFiles.put(currentThread, new HashMap());
        }
    }

    public void closeZipFile(ZipFile zipFile) {
        if (zipFile == null) {
            return;
        }
        HashMap hashMap = this.zipFiles;
        synchronized (hashMap) {
            if (this.zipFiles.get(Thread.currentThread()) != null) {
                return;
            }
            try {
                if (ZIP_ACCESS_VERBOSE) {
                    System.out.println("(" + Thread.currentThread() + ") [JavaModelManager.closeZipFile(ZipFile)] Closing ZipFile on " + zipFile.getName());
                }
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void configurePluginDebugOptions() {
        if (JavaCore.getPlugin().isDebugging()) {
            String option = Platform.getDebugOption((String)BUILDER_DEBUG);
            if (option != null) {
                JavaBuilder.DEBUG = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)COMPILER_DEBUG)) != null) {
                Compiler.DEBUG = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)COMPLETION_DEBUG)) != null) {
                CompletionEngine.DEBUG = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)CP_RESOLVE_DEBUG)) != null) {
                CP_RESOLVE_VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)DELTA_DEBUG)) != null) {
                DeltaProcessor.VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)HIERARCHY_DEBUG)) != null) {
                TypeHierarchy.DEBUG = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)INDEX_MANAGER_DEBUG)) != null) {
                JobManager.VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)JAVAMODEL_DEBUG)) != null) {
                VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)POST_ACTION_DEBUG)) != null) {
                JavaModelOperation.POST_ACTION_VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)SEARCH_DEBUG)) != null) {
                SearchEngine.VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)SELECTION_DEBUG)) != null) {
                SelectionEngine.DEBUG = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)SHARED_WC_DEBUG)) != null) {
                CompilationUnit.SHARED_WC_VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)ZIP_ACCESS_DEBUG)) != null) {
                ZIP_ACCESS_VERBOSE = option.equalsIgnoreCase("true");
            }
        }
    }

    public void doneSaving(ISaveContext context) {
    }

    public void fire(IJavaElementDelta customDelta, int eventType) {
        IJavaElementDelta deltaToNotify;
        if (!this.isFiring) {
            return;
        }
        if (DeltaProcessor.VERBOSE && (eventType == 0 || eventType == 2)) {
            System.out.println("-----------------------------------------------------------------------------------------------------------------------");
        }
        if ((deltaToNotify = customDelta == null ? this.mergeDeltas(this.javaModelDeltas) : customDelta) != null) {
            Iterator scopes = ((AbstractMap)this.scopes).keySet().iterator();
            while (scopes.hasNext()) {
                AbstractSearchScope scope = (AbstractSearchScope)scopes.next();
                scope.processDelta(deltaToNotify);
            }
        }
        IElementChangedListener[] listeners = this.elementChangedListeners;
        int[] listenerMask = this.elementChangedListenerMasks;
        int listenerCount = this.elementChangedListenerCount;
        switch (eventType) {
            case 0: {
                this.firePreAutoBuildDelta(deltaToNotify, listeners, listenerMask, listenerCount);
                this.firePostChangeDelta(deltaToNotify, listeners, listenerMask, listenerCount);
                this.fireReconcileDelta(listeners, listenerMask, listenerCount);
                break;
            }
            case 2: {
                this.firePreAutoBuildDelta(deltaToNotify, listeners, listenerMask, listenerCount);
                break;
            }
            case 1: {
                this.firePostChangeDelta(deltaToNotify, listeners, listenerMask, listenerCount);
                this.fireReconcileDelta(listeners, listenerMask, listenerCount);
            }
        }
    }

    private void firePreAutoBuildDelta(IJavaElementDelta deltaToNotify, IElementChangedListener[] listeners, int[] listenerMask, int listenerCount) {
        if (DeltaProcessor.VERBOSE) {
            System.out.println("FIRING PRE_AUTO_BUILD Delta [" + Thread.currentThread() + "]:");
            System.out.println(deltaToNotify == null ? "<NONE>" : deltaToNotify.toString());
        }
        if (deltaToNotify != null) {
            this.notifyListeners(deltaToNotify, 2, listeners, listenerMask, listenerCount);
        }
    }

    private void firePostChangeDelta(IJavaElementDelta deltaToNotify, IElementChangedListener[] listeners, int[] listenerMask, int listenerCount) {
        if (DeltaProcessor.VERBOSE) {
            System.out.println("FIRING POST_CHANGE Delta [" + Thread.currentThread() + "]:");
            System.out.println(deltaToNotify == null ? "<NONE>" : deltaToNotify.toString());
        }
        if (deltaToNotify != null) {
            this.flush();
            this.notifyListeners(deltaToNotify, 1, listeners, listenerMask, listenerCount);
        }
    }

    private void fireReconcileDelta(IElementChangedListener[] listeners, int[] listenerMask, int listenerCount) {
        IJavaElementDelta deltaToNotify = this.mergeDeltas(this.reconcileDeltas.values());
        if (DeltaProcessor.VERBOSE) {
            System.out.println("FIRING POST_RECONCILE Delta [" + Thread.currentThread() + "]:");
            System.out.println(deltaToNotify == null ? "<NONE>" : deltaToNotify.toString());
        }
        if (deltaToNotify != null) {
            this.reconcileDeltas = new HashMap();
            this.notifyListeners(deltaToNotify, 4, listeners, listenerMask, listenerCount);
        }
    }

    public void notifyListeners(IJavaElementDelta deltaToNotify, int eventType, IElementChangedListener[] listeners, int[] listenerMask, int listenerCount) {
        final ElementChangedEvent extraEvent = new ElementChangedEvent(deltaToNotify, eventType);
        int i = 0;
        while (i < listenerCount) {
            if ((listenerMask[i] & eventType) != 0) {
                final IElementChangedListener listener = listeners[i];
                long start = -1L;
                if (DeltaProcessor.VERBOSE) {
                    System.out.print("Listener #" + (i + 1) + "=" + listener.toString());
                    start = System.currentTimeMillis();
                }
                Platform.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        Util.log(exception, "Exception occurred in listener of Java element change notification");
                    }

                    public void run() throws Exception {
                        listener.elementChanged(extraEvent);
                    }
                });
                if (DeltaProcessor.VERBOSE) {
                    System.out.println(" -> " + (System.currentTimeMillis() - start) + "ms");
                }
            }
            ++i;
        }
    }

    protected void flush() {
        this.javaModelDeltas = new ArrayList();
    }

    public void flushZipFiles() {
        HashMap hashMap = this.zipFiles;
        synchronized (hashMap) {
            Thread currentThread = Thread.currentThread();
            HashMap map = (HashMap)this.zipFiles.remove(currentThread);
            if (map == null) {
                return;
            }
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                try {
                    ZipFile zipFile = (ZipFile)iterator.next();
                    if (ZIP_ACCESS_VERBOSE) {
                        System.out.println("(" + currentThread + ") [JavaModelManager.flushZipFiles()] Closing ZipFile on " + zipFile.getName());
                    }
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected Map getElementsOutOfSynchWithBuffers() {
        return this.elementsOutOfSynchWithBuffers;
    }

    public IJavaElement getHandleFromMemento(String memento) throws JavaModelException {
        if (memento == null) {
            return null;
        }
        JavaModel model = this.getJavaModel();
        if (memento.equals("")) {
            return model;
        }
        int modelEnd = memento.indexOf(61);
        if (modelEnd == -1) {
            return null;
        }
        boolean returnProject = false;
        int projectEnd = memento.indexOf(47, modelEnd);
        if (projectEnd == -1) {
            projectEnd = memento.length();
            returnProject = true;
        }
        String projectName = memento.substring(modelEnd + 1, projectEnd);
        JavaProject proj = (JavaProject)model.getJavaProject(projectName);
        if (returnProject) {
            return proj;
        }
        int rootEnd = memento.indexOf(60, projectEnd + 1);
        if (rootEnd == -1) {
            return model.getHandleFromMementoForRoot(memento, proj, projectEnd, memento.length());
        }
        IPackageFragmentRoot root = model.getHandleFromMementoForRoot(memento, proj, projectEnd, rootEnd);
        if (root == null) {
            return null;
        }
        int end = memento.indexOf(123, rootEnd);
        if (end == -1) {
            end = memento.indexOf(40, rootEnd);
            if (end == -1) {
                if (rootEnd + 1 == memento.length()) {
                    return root.getPackageFragment("");
                }
                return root.getPackageFragment(memento.substring(rootEnd + 1));
            }
            return model.getHandleFromMementoForBinaryMembers(memento, root, rootEnd, end);
        }
        return model.getHandleFromMementoForSourceMembers(memento, root, rootEnd, end);
    }

    public IndexManager getIndexManager() {
        return this.deltaProcessor.indexManager;
    }

    public Object getInfo(IJavaElement element) {
        return this.cache.getInfo(element);
    }

    public final JavaModel getJavaModel() {
        return this.javaModel;
    }

    public static final JavaModelManager getJavaModelManager() {
        return Manager;
    }

    public Object getLastBuiltState(IProject project, IProgressMonitor monitor) {
        if (!JavaProject.hasJavaNature(project)) {
            return null;
        }
        PerProjectInfo info = this.getPerProjectInfo(project, true);
        if (!info.triedRead) {
            info.triedRead = true;
            try {
                if (monitor != null) {
                    monitor.subTask(Util.bind("build.readStateProgress", project.getName()));
                }
                info.savedState = this.readState(project);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return info.savedState;
    }

    public PerProjectInfo getPerProjectInfo(IProject project, boolean create) {
        Map map = this.perProjectInfo;
        synchronized (map) {
            PerProjectInfo info = (PerProjectInfo)this.perProjectInfo.get(project);
            if (info == null && create) {
                info = new PerProjectInfo(project);
                this.perProjectInfo.put(project, info);
            }
            return info;
        }
    }

    public PerProjectInfo getPerProjectInfoCheckExistence(IProject project) throws JavaModelException {
        PerProjectInfo info = this.getPerProjectInfo(project, false);
        if (info == null) {
            if (!JavaProject.hasJavaNature(project)) {
                throw ((JavaProject)JavaCore.create(project)).newNotPresentException();
            }
            info = this.getPerProjectInfo(project, true);
        }
        return info;
    }

    public static String[] getRegisteredVariableNames() {
        Plugin jdtCorePlugin = JavaCore.getPlugin();
        if (jdtCorePlugin == null) {
            return null;
        }
        ArrayList<String> variableList = new ArrayList<String>(5);
        IExtensionPoint extension = jdtCorePlugin.getDescriptor().getExtensionPoint(CPVARIABLE_INITIALIZER_EXTPOINT_ID);
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String varAttribute = configElements[j].getAttribute("variable");
                    if (varAttribute != null) {
                        variableList.add(varAttribute);
                    }
                    ++j;
                }
                ++i;
            }
        }
        String[] variableNames = new String[variableList.size()];
        variableList.toArray(variableNames);
        return variableNames;
    }

    public static String[] getRegisteredContainerIDs() {
        Plugin jdtCorePlugin = JavaCore.getPlugin();
        if (jdtCorePlugin == null) {
            return null;
        }
        ArrayList<String> containerIDList = new ArrayList<String>(5);
        IExtensionPoint extension = jdtCorePlugin.getDescriptor().getExtensionPoint(CPCONTAINER_INITIALIZER_EXTPOINT_ID);
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String idAttribute = configElements[j].getAttribute("id");
                    if (idAttribute != null) {
                        containerIDList.add(idAttribute);
                    }
                    ++j;
                }
                ++i;
            }
        }
        String[] containerIDs = new String[containerIDList.size()];
        containerIDList.toArray(containerIDs);
        return containerIDs;
    }

    private File getSerializationFile(IProject project) {
        if (!project.exists()) {
            return null;
        }
        IPluginDescriptor descr = JavaCore.getJavaCore().getDescriptor();
        IPath workingLocation = project.getPluginWorkingLocation(descr);
        return workingLocation.append("state.dat").toFile();
    }

    public ZipFile getZipFile(IPath path) throws CoreException {
        HashMap hashMap = this.zipFiles;
        synchronized (hashMap) {
            IPath location;
            ZipFile zipFile;
            Thread currentThread = Thread.currentThread();
            HashMap map = null;
            map = (HashMap)this.zipFiles.get(currentThread);
            if (map != null && (zipFile = (ZipFile)map.get(path)) != null) {
                return zipFile;
            }
            String fileSystemPath = null;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IResource file = root.findMember(path);
            if (path.isAbsolute() && file != null) {
                if (file == null) {
                    fileSystemPath = path.toOSString();
                } else {
                    if (file.getType() != 1 || (location = file.getLocation()) == null) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.core", -1, Util.bind("file.notFound", path.toString()), null));
                    }
                    fileSystemPath = location.toOSString();
                }
            } else if (!path.isAbsolute()) {
                file = root.getFile(path);
                if (file == null || file.getType() != 1) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.core", -1, Util.bind("file.notFound", path.toString()), null));
                }
                location = file.getLocation();
                if (location == null) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.core", -1, Util.bind("file.notFound", path.toString()), null));
                }
                fileSystemPath = location.toOSString();
            } else {
                fileSystemPath = path.toOSString();
            }
            try {
                if (ZIP_ACCESS_VERBOSE) {
                    System.out.println("(" + currentThread + ") [JavaModelManager.getZipFile(IPath)] Creating ZipFile on " + fileSystemPath);
                }
                zipFile = new ZipFile(fileSystemPath);
                if (map != null) {
                    map.put(path, zipFile);
                }
                return zipFile;
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.core", -1, Util.bind("status.IOException"), (Throwable)e));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadVariablesAndContainers() throws CoreException {
        String varName;
        String xmlString;
        QualifiedName qName;
        block22: {
            qName = new QualifiedName("org.eclipse.jdt.core", "variables");
            xmlString = ResourcesPlugin.getWorkspace().getRoot().getPersistentProperty(qName);
            try {
                try {
                    Element cpElement;
                    if (xmlString == null) break block22;
                    StringReader reader = new StringReader(xmlString);
                    try {
                        try {
                            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                            cpElement = parser.parse(new InputSource(reader)).getDocumentElement();
                        }
                        catch (SAXException sAXException) {
                            Object var6_7 = null;
                            reader.close();
                            Object var11_13 = null;
                            if (xmlString == null) return;
                            ResourcesPlugin.getWorkspace().getRoot().setPersistentProperty(qName, null);
                            return;
                        }
                        catch (ParserConfigurationException parserConfigurationException) {
                            Object var6_8 = null;
                            reader.close();
                            Object var11_14 = null;
                            if (xmlString == null) return;
                            ResourcesPlugin.getWorkspace().getRoot().setPersistentProperty(qName, null);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        reader.close();
                        throw throwable;
                    }
                    Object var6_10 = null;
                    reader.close();
                    if (cpElement == null) {
                        Object var11_15 = null;
                        if (xmlString == null) return;
                        ResourcesPlugin.getWorkspace().getRoot().setPersistentProperty(qName, null);
                        return;
                    }
                    if (!cpElement.getNodeName().equalsIgnoreCase("variables")) {
                        Object var11_16 = null;
                        if (xmlString == null) return;
                        ResourcesPlugin.getWorkspace().getRoot().setPersistentProperty(qName, null);
                        return;
                    }
                    NodeList list = cpElement.getChildNodes();
                    int length = list.getLength();
                    int i = 0;
                    while (i < length) {
                        Element element;
                        Node node = list.item(i);
                        short type = node.getNodeType();
                        if (type == 1 && (element = (Element)node).getNodeName().equalsIgnoreCase("variable")) {
                            JavaModelManager.variablePut(element.getAttribute("name"), (IPath)new Path(element.getAttribute("path")));
                        }
                        ++i;
                    }
                }
                catch (IOException iOException) {
                }
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                if (xmlString != null) {
                    ResourcesPlugin.getWorkspace().getRoot().setPersistentProperty(qName, null);
                }
                throw throwable;
            }
        }
        Object var11_18 = null;
        if (xmlString != null) {
            ResourcesPlugin.getWorkspace().getRoot().setPersistentProperty(qName, null);
        }
        Preferences preferences = JavaCore.getPlugin().getPluginPreferences();
        String[] propertyNames = preferences.propertyNames();
        int variablePrefixLength = CP_VARIABLE_PREFERENCES_PREFIX.length();
        int i = 0;
        while (i < propertyNames.length) {
            String propertyName = propertyNames[i];
            if (propertyName.startsWith(CP_VARIABLE_PREFERENCES_PREFIX)) {
                varName = propertyName.substring(variablePrefixLength);
                Path varPath = new Path(preferences.getString(propertyName).trim());
                Variables.put(varName, varPath);
                PreviousSessionVariables.put(varName, varPath);
            }
            if (propertyName.startsWith(CP_CONTAINER_PREFERENCES_PREFIX)) {
                JavaModelManager.recreatePersistedContainer(propertyName, preferences.getString(propertyName), true);
            }
            ++i;
        }
        String[] registeredVariables = JavaModelManager.getRegisteredVariableNames();
        int i2 = 0;
        while (i2 < registeredVariables.length) {
            varName = registeredVariables[i2];
            Variables.put(varName, null);
            ++i2;
        }
        String[] registeredContainerIDs = JavaModelManager.getRegisteredContainerIDs();
        int i3 = 0;
        while (i3 < registeredContainerIDs.length) {
            String containerID = registeredContainerIDs[i3];
            Iterator projectIterator = Containers.keySet().iterator();
            while (projectIterator.hasNext()) {
                IJavaProject project = (IJavaProject)projectIterator.next();
                Map projectContainers = (Map)Containers.get(project);
                if (projectContainers == null) continue;
                Iterator containerIterator = projectContainers.keySet().iterator();
                while (containerIterator.hasNext()) {
                    IPath containerPath = (IPath)containerIterator.next();
                    if (!containerPath.segment(0).equals(containerID)) continue;
                    projectContainers.put(containerPath, null);
                }
            }
            ++i3;
        }
    }

    public IJavaElementDelta mergeDeltas(Collection deltas) {
        if (deltas.size() == 0) {
            return null;
        }
        if (deltas.size() == 1) {
            return (IJavaElementDelta)deltas.iterator().next();
        }
        if (DeltaProcessor.VERBOSE) {
            System.out.println("MERGING " + deltas.size() + " DELTAS [" + Thread.currentThread() + "]");
        }
        Iterator iterator = deltas.iterator();
        JavaModel javaModel = this.getJavaModel();
        JavaElementDelta rootDelta = new JavaElementDelta(javaModel);
        boolean insertedTree = false;
        while (iterator.hasNext()) {
            IJavaElement element;
            JavaElementDelta delta = (JavaElementDelta)iterator.next();
            if (DeltaProcessor.VERBOSE) {
                System.out.println(delta.toString());
            }
            if (((Object)javaModel).equals(element = delta.getElement())) {
                IJavaElementDelta[] children = delta.getAffectedChildren();
                int j = 0;
                while (j < children.length) {
                    JavaElementDelta projectDelta = (JavaElementDelta)children[j];
                    rootDelta.insertDeltaTree(projectDelta.getElement(), projectDelta);
                    insertedTree = true;
                    ++j;
                }
                IResourceDelta[] resourceDeltas = delta.getResourceDeltas();
                if (resourceDeltas == null) continue;
                int i = 0;
                int length = resourceDeltas.length;
                while (i < length) {
                    rootDelta.addResourceDelta(resourceDeltas[i]);
                    insertedTree = true;
                    ++i;
                }
                continue;
            }
            rootDelta.insertDeltaTree(element, delta);
            insertedTree = true;
        }
        if (insertedTree) {
            return rootDelta;
        }
        return null;
    }

    protected Object peekAtInfo(IJavaElement element) {
        return this.cache.peekAtInfo(element);
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    protected void putInfo(IJavaElement element, Object info) {
        this.cache.putInfo(element, info);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object readState(IProject project) throws CoreException {
        File file = this.getSerializationFile(project);
        if (file == null) return null;
        if (!file.exists()) return null;
        try {
            DataInputStream in;
            block9: {
                State state;
                block8: {
                    in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                    try {
                        String pluginID = in.readUTF();
                        if (!pluginID.equals("org.eclipse.jdt.core")) {
                            throw new IOException(Util.bind("build.wrongFileFormat"));
                        }
                        String kind = in.readUTF();
                        if (!kind.equals("STATE")) {
                            throw new IOException(Util.bind("build.wrongFileFormat"));
                        }
                        if (in.readBoolean()) {
                            state = JavaBuilder.readState(project, in);
                            Object var6_8 = null;
                            break block8;
                        }
                        if (JavaBuilder.DEBUG) {
                            System.out.println("Saved state thinks last build failed for " + project.getName());
                        }
                        break block9;
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        in.close();
                        throw throwable;
                    }
                }
                in.close();
                return state;
            }
            Object var6_10 = null;
            in.close();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.core", 2, "Error reading last build state for project " + project.getName(), (Throwable)e));
        }
    }

    public static void recreatePersistedContainer(String propertyName, String containerString, boolean addToContainerValues) {
        int containerPrefixLength = CP_CONTAINER_PREFERENCES_PREFIX.length();
        int index = propertyName.indexOf(124, containerPrefixLength);
        if (containerString != null) {
            containerString = containerString.trim();
        }
        if (index > 0) {
            String projectName = propertyName.substring(containerPrefixLength, index).trim();
            JavaProject project = (JavaProject)JavaModelManager.getJavaModelManager().getJavaModel().getJavaProject(projectName);
            Path containerPath = new Path(propertyName.substring(index + 1).trim());
            if (containerString == null || containerString.equals(CP_ENTRY_IGNORE)) {
                JavaModelManager.containerPut(project, (IPath)containerPath, null);
            } else {
                final IClasspathEntry[] containerEntries = project.decodeClasspath(containerString, false, false);
                if (containerEntries != null && containerEntries != JavaProject.INVALID_CLASSPATH) {
                    HashMap<Path, 3> projectContainers;
                    IClasspathContainer container = new IClasspathContainer((IPath)containerPath, projectName){
                        private final /* synthetic */ IPath val$containerPath;
                        private final /* synthetic */ String val$projectName;
                        {
                            this.val$containerPath = iPath;
                            this.val$projectName = string;
                        }

                        public IClasspathEntry[] getClasspathEntries() {
                            return containerEntries;
                        }

                        public String getDescription() {
                            return "Persisted container [" + this.val$containerPath + " for project [" + this.val$projectName + "]";
                        }

                        public int getKind() {
                            return 0;
                        }

                        public IPath getPath() {
                            return this.val$containerPath;
                        }

                        public String toString() {
                            return this.getDescription();
                        }
                    };
                    if (addToContainerValues) {
                        JavaModelManager.containerPut(project, (IPath)containerPath, container);
                    }
                    if ((projectContainers = (HashMap<Path, 3>)PreviousSessionContainers.get(project)) == null) {
                        projectContainers = new HashMap<Path, 3>(1);
                        PreviousSessionContainers.put(project, projectContainers);
                    }
                    projectContainers.put(containerPath, container);
                }
            }
        }
    }

    protected void registerJavaModelDelta(IJavaElementDelta delta) {
        this.javaModelDeltas.add(delta);
    }

    public void rememberScope(AbstractSearchScope scope) {
        this.scopes.put(scope, null);
    }

    public void removeElementChangedListener(IElementChangedListener listener) {
        int i = 0;
        while (i < this.elementChangedListenerCount) {
            if (this.elementChangedListeners[i].equals(listener)) {
                int length = this.elementChangedListeners.length;
                IElementChangedListener[] newListeners = new IElementChangedListener[length];
                System.arraycopy(this.elementChangedListeners, 0, newListeners, 0, i);
                int[] newMasks = new int[length];
                System.arraycopy(this.elementChangedListenerMasks, 0, newMasks, 0, i);
                int trailingLength = this.elementChangedListenerCount - i - 1;
                if (trailingLength > 0) {
                    System.arraycopy(this.elementChangedListeners, i + 1, newListeners, i, trailingLength);
                    System.arraycopy(this.elementChangedListenerMasks, i + 1, newMasks, i, trailingLength);
                }
                this.elementChangedListeners = newListeners;
                this.elementChangedListenerMasks = newMasks;
                --this.elementChangedListenerCount;
                return;
            }
            ++i;
        }
    }

    protected void removeInfo(IJavaElement element) {
        this.cache.removeInfo(element);
    }

    public void removePerProjectInfo(JavaProject javaProject) {
        Map map = this.perProjectInfo;
        synchronized (map) {
            IProject project = javaProject.getProject();
            PerProjectInfo info = (PerProjectInfo)this.perProjectInfo.get(project);
            if (info != null) {
                this.perProjectInfo.remove(project);
            }
        }
    }

    public void rollback(ISaveContext context) {
    }

    private void saveState(PerProjectInfo info, ISaveContext context) throws CoreException {
        if (context.getKind() == 2) {
            return;
        }
        if (info.triedRead) {
            this.saveBuiltState(info);
        }
    }

    private void saveBuiltState(PerProjectInfo info) throws CoreException {
        File file;
        if (JavaBuilder.DEBUG) {
            System.out.println(Util.bind("build.saveStateProgress", info.project.getName()));
        }
        if ((file = this.getSerializationFile(info.project)) == null) {
            return;
        }
        long t = System.currentTimeMillis();
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            try {
                out.writeUTF("org.eclipse.jdt.core");
                out.writeUTF("STATE");
                if (info.savedState == null) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    JavaBuilder.writeState(info.savedState, out);
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                out.close();
                throw throwable;
            }
            Object var6_9 = null;
            out.close();
        }
        catch (RuntimeException e) {
            try {
                file.delete();
            }
            catch (SecurityException securityException) {}
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.core", 2, Util.bind("build.cannotSaveState", info.project.getName()), (Throwable)e));
        }
        catch (IOException e) {
            try {
                file.delete();
            }
            catch (SecurityException securityException) {}
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.core", 2, Util.bind("build.cannotSaveState", info.project.getName()), (Throwable)e));
        }
        if (JavaBuilder.DEBUG) {
            t = System.currentTimeMillis() - t;
            System.out.println(Util.bind("build.saveStateComplete", String.valueOf(t)));
        }
    }

    public void saving(ISaveContext context) throws CoreException {
        IProject savedProject = context.getProject();
        if (savedProject != null) {
            if (!JavaProject.hasJavaNature(savedProject)) {
                return;
            }
            PerProjectInfo info = this.getPerProjectInfo(savedProject, true);
            this.saveState(info, context);
            return;
        }
        ArrayList<IStatus> vStats = null;
        Iterator iter = this.perProjectInfo.values().iterator();
        while (iter.hasNext()) {
            try {
                PerProjectInfo info = (PerProjectInfo)iter.next();
                this.saveState(info, context);
            }
            catch (CoreException e) {
                if (vStats == null) {
                    vStats = new ArrayList<IStatus>();
                }
                vStats.add(e.getStatus());
            }
        }
        if (vStats != null) {
            IStatus[] stats = new IStatus[vStats.size()];
            vStats.toArray(stats);
            throw new CoreException((IStatus)new MultiStatus("org.eclipse.jdt.core", 4, stats, Util.bind("build.cannotSaveStates"), null));
        }
    }

    protected void setBuildOrder(String[] javaBuildOrder) throws JavaModelException {
        String[] newOrder;
        if (!"compute".equals(JavaCore.getOption("org.eclipse.jdt.core.computeJavaBuildOrder"))) {
            return;
        }
        if (javaBuildOrder == null || javaBuildOrder.length <= 1) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription description = workspace.getDescription();
        String[] wksBuildOrder = description.getBuildOrder();
        if (wksBuildOrder == null) {
            newOrder = javaBuildOrder;
        } else {
            int javaCount = javaBuildOrder.length;
            HashMap<String, String> newSet = new HashMap<String, String>(javaCount);
            int i = 0;
            while (i < javaCount) {
                newSet.put(javaBuildOrder[i], javaBuildOrder[i]);
                ++i;
            }
            int removed = 0;
            int oldCount = wksBuildOrder.length;
            int i2 = 0;
            while (i2 < oldCount) {
                if (newSet.containsKey(wksBuildOrder[i2])) {
                    wksBuildOrder[i2] = null;
                    ++removed;
                }
                ++i2;
            }
            newOrder = new String[oldCount - removed + javaCount];
            System.arraycopy(javaBuildOrder, 0, newOrder, 0, javaCount);
            int index = javaCount;
            int i3 = 0;
            while (i3 < oldCount) {
                if (wksBuildOrder[i3] != null) {
                    newOrder[index++] = wksBuildOrder[i3];
                }
                ++i3;
            }
        }
        description.setBuildOrder(newOrder);
        try {
            workspace.setDescription(description);
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    public void setLastBuiltState(IProject project, Object state) {
        if (!JavaProject.hasJavaNature(project)) {
            return;
        }
        PerProjectInfo info = this.getPerProjectInfo(project, true);
        info.triedRead = true;
        info.savedState = state;
        if (state == null) {
            try {
                File file = this.getSerializationFile(project);
                if (file != null && file.exists()) {
                    file.delete();
                }
            }
            catch (SecurityException securityException) {}
        }
    }

    public void shutdown() {
        if (this.deltaProcessor.indexManager != null) {
            this.deltaProcessor.indexManager.shutdown();
        }
        try {
            JavaModel model = this.getJavaModel();
            if (model != null) {
                model.close();
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    public void startDeltas() {
        this.isFiring = true;
    }

    public void stopDeltas() {
        this.isFiring = false;
    }

    public void updateJavaModel(IJavaElementDelta customDelta) {
        if (customDelta == null) {
            int i = 0;
            int length = this.javaModelDeltas.size();
            while (i < length) {
                IJavaElementDelta delta = (IJavaElementDelta)this.javaModelDeltas.get(i);
                this.modelUpdater.processJavaDelta(delta);
                ++i;
            }
        } else {
            this.modelUpdater.processJavaDelta(customDelta);
        }
    }

    public static IPath variableGet(String variableName) {
        return (IPath)Variables.get(variableName);
    }

    public static String[] variableNames() {
        int length = Variables.size();
        String[] result = new String[length];
        Iterator vars = Variables.keySet().iterator();
        int index = 0;
        while (vars.hasNext()) {
            result[index++] = (String)vars.next();
        }
        return result;
    }

    public static void variablePut(String variableName, IPath variablePath) {
        if (variablePath == null) {
            Variables.remove(variableName);
            PreviousSessionVariables.remove(variableName);
        } else {
            Variables.put(variableName, variablePath);
        }
        if (variablePath == VariableInitializationInProgress) {
            return;
        }
        Preferences preferences = JavaCore.getPlugin().getPluginPreferences();
        String variableKey = CP_VARIABLE_PREFERENCES_PREFIX + variableName;
        String variableString = variablePath == null ? CP_ENTRY_IGNORE : variablePath.toString();
        preferences.setDefault(variableKey, CP_ENTRY_IGNORE);
        preferences.setValue(variableKey, variableString);
        JavaCore.getPlugin().savePluginPreferences();
    }

    public static class PerProjectInfo {
        public IProject project;
        public Object savedState = null;
        public boolean triedRead = false;
        public IClasspathEntry[] classpath;
        public IClasspathEntry[] lastResolvedClasspath;
        public Map resolvedPathToRawEntries;
        public IPath outputLocation;
        public Preferences preferences;

        public PerProjectInfo(IProject project) {
            this.project = project;
        }
    }

    public static class PluginPreferencesListener
    implements Preferences.IPropertyChangeListener {
        public void propertyChange(Preferences.PropertyChangeEvent event) {
            String propertyName = event.getProperty();
            if (propertyName.startsWith(JavaModelManager.CP_VARIABLE_PREFERENCES_PREFIX)) {
                String varName = propertyName.substring(JavaModelManager.CP_VARIABLE_PREFERENCES_PREFIX.length());
                String newValue = (String)event.getNewValue();
                if (newValue != null && !(newValue = newValue.trim()).equals(JavaModelManager.CP_ENTRY_IGNORE)) {
                    Variables.put(varName, new Path(newValue));
                } else {
                    Variables.remove(varName);
                }
            }
            if (propertyName.startsWith(JavaModelManager.CP_CONTAINER_PREFERENCES_PREFIX)) {
                JavaModelManager.recreatePersistedContainer(propertyName, (String)event.getNewValue(), false);
            }
        }
    }
}

