<?xml version="1.0" encoding="ISO-8859-15"?>
<!-- 
 *   Copyright (C) 2002, 2003, 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:template name="copybox">
 <!-- index is a counter for the form variables, so this sheet can be
      used several times within the same form -->
 <xsl:param name="index"/>

   <!-- Stuff to move or copy messages to another folder -->
   <td class="field_light_bg" align="center" width="55%" colspan="3">
      <!-- parameter "iscopy" (flag to indicate copy, or else move) -->
      <select class="simpletext">
         <xsl:attribute name="name">
	    <xsl:value-of select="concat('iscopy',$index)"/>
	 </xsl:attribute>
         <option value="false"><xsl:value-of select="normalize-space(copyoptions/optiontext2)" /></option>
	 <option value="true"><xsl:value-of select="normalize-space(copyoptions/optiontext1)" /></option>
      </select>
      <span class="simpletext">
         &#160;<xsl:value-of select="normalize-space(copyoptions/actiontext2)"/>&#160;
      </span>

      <!-- parameter "destination" (i.e. destination folder number) -->
      <select class="simpletext">
         <xsl:attribute name="name">
	    <xsl:value-of select="concat('destination',$index)"/>
	 </xsl:attribute>
         <xsl:for-each select="copyoptions/destination">
            <option>
		<xsl:attribute name="value">
		   <xsl:value-of select="normalize-space(folderNr)" />
		</xsl:attribute>
		<xsl:value-of select="normalize-space(folderName)" />
	    </option>
	 </xsl:for-each>
      </select>
      <input class="simpletext" type="submit">
         <xsl:attribute name="name">
	    <xsl:value-of select="concat('copymovemsgs',$index)"/>
	 </xsl:attribute>
	 <xsl:attribute name="value">
	    <xsl:value-of select="normalize-space(copyoptions/buttontext)" />
	 </xsl:attribute>
      </input>
   </td>

</xsl:template>

</xsl:stylesheet>
