<?xml version="1.0" encoding="ISO-8859-15"?>
<!-- 
 *   Copyright (C) 2002, 2003, 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:template match="page/contact">
   <content>

   <!-- define the action link for this form -->
   <xsl:variable name="action_link_prefix">
       <xsl:value-of select="'contact.xsl?act=contact'" />
   </xsl:variable>

   <!-- what if we want to go back to address list -->
   <xsl:variable name="address_link">
       <xsl:value-of select="'addresses.xsl?act=addresses'" />
   </xsl:variable>


<!-- TO DO: how can we implement this now ? 
<body class="body_bg" onload="document.contactform.email.focus();">
     -->	  

   <!-- Header information -->
   <table cellpadding="2" cellspacing="1" border="0" width="100%">
      <tr>
	 <td class="simpletext" colspan="2">
            <img align="middle" border="0" hspace="5" src="images/gnome/contact_48.png" />    
	    <xsl:value-of select="normalize-space(title)"/>
	 </td>
      </tr>

      <xsl:if test="error">
       <tr class="bold_red">
         <td rowspan="2" align="center" width="10%">
            <img align="middle" border="0" src="images/gnome/dialog-error.png" />
	 </td>
         <td align="left">
            <xsl:value-of select="normalize-space(error/header)"/>
	 </td>
       </tr>
       <tr class="bold_red">
         <td align="left">
            <xsl:value-of select="normalize-space(error/content)"/>
	 </td>
       </tr>
      </xsl:if>

      <!-- state row -->
       <tr class="simpletext">
          <td></td>
          <td class="bold">
             <xsl:if test="added">
                <xsl:value-of select="normalize-space(added/header)"/>&#160;
                <xsl:value-of select="normalize-space(added/name)"/><br/>
             </xsl:if>
             <xsl:if test="updated">
                <xsl:value-of select="normalize-space(updated/header)"/>&#160;
                <xsl:value-of select="normalize-space(updated/name)"/><br/>
             </xsl:if>
             <xsl:if test="isNew">
                <xsl:value-of select="normalize-space(isNew/header)"/><br/>
             </xsl:if>
             <xsl:if test="isEdit">
                <xsl:value-of select="normalize-space(isEdit/header)"/>&#160; <br/>
		<xsl:comment>
		   Editing contact <xsl:value-of select="normalize-space(isEdit/contactNr)"/>
		</xsl:comment>
             </xsl:if>
	  </td>
       </tr>

   </table>
   <!-- end of header table -->


   <xsl:variable name="action_link">
      <xsl:choose>
	 <!-- first case: submitting a new entry -->
	 <xsl:when test="isNew">
	    <xsl:value-of select="concat($action_link_prefix,'&amp;add=true&amp;redirect=',$address_link)"/>
         </xsl:when>
	 <xsl:when test="isEdit">
	    <xsl:value-of select="concat($action_link_prefix,'&amp;update=true&amp;redirect=',$address_link)"/>
	 </xsl:when>

	 <!-- default case -->
	 <xsl:otherwise>
	    <xsl:value-of select="$action_link_prefix"/>
	 </xsl:otherwise>
      </xsl:choose>
   </xsl:variable>


   <form method="post" name="contactform">
       <xsl:attribute name="action">
         <xsl:value-of select="$action_link"/>
       </xsl:attribute>

       <xsl:if test="isEdit">
          <input type="hidden" name="contactNr">
	     <xsl:attribute name="value"><xsl:value-of select="normalize-space(isEdit/contactNr)"/></xsl:attribute>
	  </input>
       </xsl:if>
       
       <table cellpadding="4" cellspacing="2" border="0" width="100%">
	<tbody>

	  <!-- "e-Mail" row -->
	  <tr class="field_light_bg">
	     <td width="13%" class="link_text" height="22">
		<xsl:value-of select="normalize-space(email/text)" /></td>
	     <td width="87%" class="simpletext" height="22">
		<input class="simpletext" size="40" name="email" type="text">
		   <xsl:attribute name="value"><xsl:value-of select="normalize-space(email/content)" /></xsl:attribute>
		</input>
	     </td>
	  </tr>

	  <!-- "Name" row -->
	  <tr class="field_middle_bg">
	     <td width="13%" class="link_text" height="22">
		<xsl:value-of select="normalize-space(name/text)" /></td>
	     <td width="87%" class="simpletext" height="22">
		<input class="simpletext" size="40" name="name" type="text">
			<xsl:attribute name="value"><xsl:value-of select="normalize-space(name/content)" /></xsl:attribute>
		</input>
	     </td>
	  </tr>

	  <!-- "Nickname" row -->
	  <tr class="field_light_bg">
	     <td width="13%" class="link_text" height="22">
		<xsl:value-of select="normalize-space(nickname/text)" /></td>
	     <td width="87%" class="simpletext" height="22">
		<input class="simpletext" size="40" name="nickname" type="text">
			<xsl:attribute name="value"><xsl:value-of select="normalize-space(nickname/content)" /></xsl:attribute>
		</input>
	     </td>
	  </tr>

	</tbody>
       </table>

       <!-- submit button -->
	<p class="simpletext" align="center">
	   <input name="store" class="simpletext" type="submit">
		<xsl:attribute name="value">
			<xsl:value-of select="normalize-space(actiontext)" />
		</xsl:attribute>
	   </input>
	</p>

   </form>

   </content>
</xsl:template>
	
   <!-- stuff to pass on the rest of the content 
        (i.e., any parts that this stylesheet is not concerned with) -->
   <xsl:template match="@*|node()">
      <xsl:copy>
         <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template match="text()">
      <xsl:value-of select="."/>
   </xsl:template>

</xsl:stylesheet>
