/*
 * Decompiled with CFR 0.152.
 */
package net.jatec.ironmailer.model;

import java.util.Enumeration;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import net.jatec.ironmailer.model.MailPart;
import net.jatec.ironmailer.model.MessageHeader;
import net.jatec.ironmailer.model.ModelException;
import org.apache.log4j.Logger;

public class MailMessage {
    private final Logger log = Logger.getLogger((Class)(class$net$jatec$ironmailer$model$MailMessage == null ? (class$net$jatec$ironmailer$model$MailMessage = MailMessage.class$((String)"net.jatec.ironmailer.model.MailMessage")) : class$net$jatec$ironmailer$model$MailMessage));
    private MessageHeader header;
    private InternetAddress[] fromAddresses;
    private InternetAddress[] toAddresses;
    private InternetAddress[] ccAddresses;
    private InternetAddress[] replyToAddresses;
    private String body;
    private MailPart[] attachments;
    private int attachmentOffset;
    private Multipart myMultipart;
    static /* synthetic */ Class class$net$jatec$ironmailer$model$MailMessage;

    public MailMessage(MessageHeader messageHeader) throws MessagingException {
        try {
            Object object;
            Address[] addressArray;
            Address[] addressArray2;
            Address[] addressArray3;
            if (messageHeader == null) {
                throw new IllegalArgumentException("parameter header is empty");
            }
            MimeMessage mimeMessage = messageHeader.getMessage();
            if (mimeMessage == null) {
                throw new Exception("illegal header parameter: contains empty message");
            }
            this.header = messageHeader;
            this.log.debug((Object)"MailMessage() reading addresses from message ...");
            Address[] addressArray4 = mimeMessage.getFrom();
            if (addressArray4 != null && addressArray4.length > 0) {
                this.fromAddresses = new InternetAddress[addressArray4.length];
                for (int i = 0; i < addressArray4.length; ++i) {
                    this.fromAddresses[i] = (InternetAddress)addressArray4[i];
                }
            } else {
                this.fromAddresses = new InternetAddress[0];
            }
            if ((addressArray3 = mimeMessage.getRecipients(Message.RecipientType.TO)) != null && addressArray3.length > 0) {
                this.toAddresses = new InternetAddress[addressArray3.length];
                for (int i = 0; i < addressArray3.length; ++i) {
                    this.toAddresses[i] = (InternetAddress)addressArray3[i];
                }
            } else {
                this.toAddresses = new InternetAddress[0];
            }
            if ((addressArray2 = messageHeader.getMessage().getRecipients(Message.RecipientType.CC)) != null && addressArray2.length > 0) {
                this.ccAddresses = new InternetAddress[addressArray2.length];
                for (int i = 0; i < addressArray2.length; ++i) {
                    this.ccAddresses[i] = (InternetAddress)addressArray2[i];
                }
            } else {
                this.ccAddresses = new InternetAddress[0];
            }
            if ((addressArray = mimeMessage.getReplyTo()) != null && addressArray.length > 0) {
                this.replyToAddresses = new InternetAddress[addressArray.length];
                for (int i = 0; i < addressArray.length; ++i) {
                    this.replyToAddresses[i] = (InternetAddress)addressArray[i];
                }
            } else {
                this.replyToAddresses = new InternetAddress[0];
            }
            String string = mimeMessage.getContentType();
            this.log.debug((Object)("MailMessage() preparing to read body; content type of message is: " + string));
            if (messageHeader.isTextOnly()) {
                this.log.debug((Object)"MailMessage() got a message containing text only");
            }
            if ((object = mimeMessage.getContent()) instanceof String) {
                this.log.debug((Object)"MailMessage() handling content of type String");
                this.body = (String)object;
                this.attachments = new MailPart[0];
            } else if (object instanceof Multipart) {
                this.log.debug((Object)"MailMessage() handling content of type Multipart");
                Multipart multipart = (Multipart)object;
                int n = multipart.getCount();
                if (n < 1) {
                    this.body = "";
                    this.attachments = new MailPart[0];
                } else {
                    this.log.debug((Object)"MailMessage() determining body parts");
                    MailPart mailPart = new MailPart((Part)multipart.getBodyPart(0));
                    this.attachmentOffset = 0;
                    if (mailPart.isAnonymousText()) {
                        this.log.debug((Object)"MailMessage() handling case where first body part is plain text");
                        this.body = mailPart.getText();
                        this.attachments = new MailPart[n - 1];
                        this.attachmentOffset = 1;
                    } else {
                        this.log.debug((Object)"MailMessage() handling case where first body part is NOT plain text, handling all parts as attachments");
                        this.body = "";
                        this.attachments = new MailPart[n];
                        this.attachments[0] = mailPart;
                    }
                    for (int i = 1; i < n; ++i) {
                        MailPart mailPart2;
                        this.log.debug((Object)("MailMessage() now handling attachment nb " + i));
                        this.attachments[i - this.attachmentOffset] = mailPart2 = new MailPart((Part)multipart.getBodyPart(i));
                    }
                }
                this.myMultipart = multipart;
            } else {
                this.log.warn((Object)("MailMessage() got strange message, content type: " + mimeMessage.getContentType() + ", attempting to transform to standard mail"));
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                Enumeration enumeration = mimeMessage.getAllHeaders();
                while (enumeration.hasMoreElements()) {
                    Header header = (Header)enumeration.nextElement();
                    mimeBodyPart.setHeader(header.getName(), header.getValue());
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("MailMessage() workaround: setting header " + header.getName() + " to value " + header.getValue()));
                }
                mimeBodyPart.setDisposition("attachment");
                this.log.debug((Object)"MailMessage() set all header fields of constructed body part");
                mimeBodyPart.setContent(object, string);
                this.log.debug((Object)"MailMessage() done setting content of constructed body part");
                mimeBodyPart.setHeader("Content-Type", string);
                this.log.debug((Object)("MailMessage() constructed body part now claims it is of type " + mimeBodyPart.getContentType()));
                this.myMultipart = new MimeMultipart();
                this.myMultipart.addBodyPart((BodyPart)mimeBodyPart);
                this.attachments = new MailPart[1];
                this.attachments[0] = new MailPart((Part)mimeMessage);
                this.log.debug((Object)"MailMessage(), done constructing work-around multipart");
            }
        }
        catch (Exception exception) {
            this.log.error((Object)"error initializing MailMessage", (Throwable)exception);
            throw new MessagingException("error initializing MailMessage: " + exception.toString(), exception);
        }
        this.log.debug((Object)"MailMessage() successful");
    }

    public MessageHeader getMessageHeader() {
        return this.header;
    }

    public InternetAddress[] getFromAddresses() {
        return this.fromAddresses;
    }

    public InternetAddress[] getToAddresses() {
        return this.toAddresses;
    }

    public InternetAddress[] getCcAddresses() {
        return this.ccAddresses;
    }

    public InternetAddress[] getReplyToAddresses() {
        return this.replyToAddresses;
    }

    public boolean hasReplyToAddresses() {
        return this.replyToAddresses != null && this.replyToAddresses.length > 0;
    }

    public boolean hasBody() {
        return this.body != null;
    }

    public String getBody() {
        return this.body;
    }

    public MailPart getMailAttachment(int n) throws ModelException {
        MailPart mailPart = this.attachments[n];
        if (this.myMultipart != null) {
            MailPart mailPart2;
            BodyPart bodyPart;
            try {
                bodyPart = this.myMultipart.getBodyPart(n + this.attachmentOffset);
            }
            catch (MessagingException messagingException) {
                throw new ModelException("internal error, cannot access body part", (Throwable)messagingException);
            }
            this.attachments[n] = mailPart2 = new MailPart((Part)bodyPart);
        } else {
            this.log.warn((Object)"getMailAttachment() returning, but cannot refresh body part due to empty multipart structure");
        }
        return mailPart;
    }

    public MailPart[] getMailAttachments() {
        return this.attachments;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

