/*
 * Decompiled with CFR 0.152.
 */
package net.jatec.ironmailer.controller;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.jatec.ironmailer.controller.MailWorkerBean;
import net.jatec.ironmailer.framework.HttpSessionManager;
import net.jatec.ironmailer.model.MailPart;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.AbstractReader;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class AttachmentReader
extends AbstractReader {
    private final Logger log = Logger.getLogger((Class)(class$net$jatec$ironmailer$controller$AttachmentReader == null ? (class$net$jatec$ironmailer$controller$AttachmentReader = AttachmentReader.class$((String)"net.jatec.ironmailer.controller.AttachmentReader")) : class$net$jatec$ironmailer$controller$AttachmentReader));
    private MailWorkerBean wb;
    private MailPart ma;
    static /* synthetic */ Class class$net$jatec$ironmailer$controller$AttachmentReader;

    public void setup(SourceResolver sourceResolver, Map map, String string, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(sourceResolver, map, string, parameters);
        this.log.debug((Object)"setup() called");
        HttpServletRequest httpServletRequest = (HttpServletRequest)map.get("httprequest");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("setup() req.getContextPath()=" + httpServletRequest.getContextPath()));
            this.log.debug((Object)("setup() req.getPathInfo()=" + httpServletRequest.getPathInfo()));
            this.log.debug((Object)("setup() req.getPathTranslated()=" + httpServletRequest.getPathTranslated()));
            this.log.debug((Object)("setup() req.getQueryString()=" + httpServletRequest.getQueryString()));
            this.log.debug((Object)("setup() req.getRequestURI()=" + httpServletRequest.getRequestURI()));
            this.log.debug((Object)("setup() req.getServletPath()=" + httpServletRequest.getServletPath()));
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        try {
            if (!HttpSessionManager.getInstance().isInValidSession(httpServletRequest)) {
                throw new Exception("setup error: not living in session");
            }
            HttpSession httpSession = httpServletRequest.getSession(false);
            this.wb = (MailWorkerBean)httpSession.getAttribute("workerBean");
            if (this.wb == null) {
                throw new Exception("setup error: in a valid session but no worker bean found");
            }
            string2 = httpServletRequest.getParameter("folderNr");
            if (string2 == null) {
                throw new Exception("missing parameter folderNr");
            }
            string2 = string2.trim();
            string3 = httpServletRequest.getParameter("messageNr");
            if (string3 == null) {
                throw new Exception("missing parameter messageNr");
            }
            string3 = string3.trim();
            string4 = httpServletRequest.getParameter("attachmentNr");
            if (string4 == null) {
                throw new Exception("missing parameter attachmentNr");
            }
            string4 = string4.trim();
            string5 = httpServletRequest.getParameter("partNr");
            if (string5 == null) {
                this.ma = this.wb.getMailAttachment(Integer.parseInt(string2), Integer.parseInt(string3), Integer.parseInt(string4));
            } else {
                string5 = string5.trim();
                this.ma = this.wb.getMailAttachmentPart(Integer.parseInt(string2), Integer.parseInt(string3), Integer.parseInt(string4), Integer.parseInt(string5));
            }
        }
        catch (Throwable throwable) {
            this.log.error((Object)"setup() got some unexpected error, probably due to a setup error", throwable);
            throw new ProcessingException("setup() got some unexpected error, probably due to a setup error: " + throwable.toString());
        }
        this.log.debug((Object)("setup() read parameters folderNr=" + string2 + ", messageNr=" + string3 + ", attachmentNr=" + string4));
    }

    public String getMimeType() {
        this.log.debug((Object)"getMimeType() called");
        String string = this.ma != null ? this.ma.getContentType() : null;
        this.log.debug((Object)("getMimeType() returning value " + string));
        return string;
    }

    public long getLastModified() {
        return 0L;
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.log.debug((Object)"generate() called");
        try {
            if (this.ma == null) {
                throw new Exception("internal error: ma (pointer to mail attachment) is null");
            }
            if (this.ma.isText()) {
                this.log.debug((Object)"generate(): writing string into output stream");
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.out));
                bufferedWriter.write(this.ma.getText());
                ((Writer)bufferedWriter).flush();
            } else {
                this.log.debug((Object)"generate(): reading attachment as stream and writing into output");
                InputStream inputStream = this.ma.getInputStream();
                if (inputStream == null) {
                    throw new Exception("internal error: input stream from mail attachment is null");
                }
                byte[] byArray = new byte[8192];
                int n = -1;
                while ((n = inputStream.read(byArray)) > -1) {
                    this.out.write(byArray, 0, n);
                }
                inputStream.close();
                inputStream = null;
                this.out.flush();
            }
        }
        catch (IOException iOException) {
            this.log.debug((Object)"generate() received an IOException, assuming client severed connection on purpose");
        }
        catch (Exception exception) {
            this.log.error((Object)"generate() unexpected error", (Throwable)exception);
            throw new ProcessingException("generate() got some unexpected error: " + exception.toString());
        }
        this.log.debug((Object)"generate successful.");
    }

    public static void logParameters(Logger logger, Parameters parameters) {
        if (parameters == null) {
            logger.debug((Object)"null parameters");
        } else {
            String[] stringArray = parameters.getNames();
            logger.debug((Object)("parameters has " + stringArray.length + " items"));
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    logger.debug((Object)("parameter " + string + "=" + parameters.getParameter(string)));
                }
            }
            catch (ParameterException parameterException) {
                logger.error((Object)"unable to read parameters", (Throwable)parameterException);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

