/**CHeaderFile*************************************************************
  PackageName [pa]
  Synopsis    [Package 'pa' is a framework for implementation of
               process algebrae similar to Milner's CCS and Hoare's CSP.]

  FileName    [paDecls.h]
  Revision    [$Revision: 76 $]
  Date        [$Date: 2013-04-26 14:26:09 +0200 (pet, 26 apr 2013) $]
  Authors     [Robert Meolic (meolic@uni-mb.si)]
  Description [Generated by genStubs.tcl, see http://wiki.tcl.tk/3358]
  SeeAlso     [pa.h, pa.decls, paStubInit.c, paStubLib.c]

  Copyright   [This file is part of EST (Efficient Symbolic Tools).
               Copyright (C) 2003, 2013
               UM-FERI, Smetanova ulica 17, SI-2000 Maribor, Slovenia

               EST is free software; you can redistribute it and/or modify
               it under the terms of the GNU General Public License as
               published by the Free Software Foundation; either version 2
               of the License, or (at your option) any later version.

               EST is distributed in the hope that it will be useful,
               but WITHOUT ANY WARRANTY; without even the implied warranty of
               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
               GNU General Public License for more details.

               You should have received a copy of the GNU General Public
               License along with this program; if not, write to the Free
               Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
               Boston, MA 02110-1301 USA.]
  ************************************************************************/

/* !BEGIN!: Do not edit below this line. */

/*
 * Exported function declarations: implemented in pa.h
 */

typedef struct PaStubs {
    int magic;
    const struct PaStubHooks *hooks;

    int *pa_status; /* 0 */
    int *pa_variables; /* 1 */
    int *pa_sorts; /* 2 */
    int *pa_processes; /* 3 */
    int *pa_compositions; /* 4 */
    Pa_Variable * *pa_variableTable; /* 5 */
    Pa_Sort * *pa_sortTable; /* 6 */
    Pa_Process * *pa_processTable; /* 7 */
    Pa_Composition * *pa_compositionTable; /* 8 */
    void (*pa_InitPkg) (); /* 9 */
    void (*pa_ExitPkg) (); /* 10 */
    void (*pa_AboutPkg) (); /* 11 */
    void (*pa_InitVariable) (int i); /* 12 */
    int (*pa_AddNewSort) (Est_String name); /* 13 */
    int (*pa_FindSort) (Est_String name); /* 14 */
    int (*pa_FOASortAction) (Pa_Sort *sort, Est_String name); /* 15 */
    int (*pa_FindSortAction) (Pa_Sort *sort, Est_String name); /* 16 */
    int (*pa_AddNewProcess) (Est_String name); /* 17 */
    int (*pa_FindProcess) (Est_String name); /* 18 */
    void (*pa_RenameProcess) (Est_String old, Est_String new); /* 19 */
    int (*pa_CopyProcess) (Est_String name, Est_String copy, Est_String copysort, Est_String old, Est_String new); /* 20 */
    Est_Boolean (*pa_IsGate) (Est_String name); /* 21 */
    int (*pa_FOAStateProcess) (Pa_Process *proc, Est_String name); /* 22 */
    int (*pa_FOAGateProcess) (Pa_Process *proc, Est_String name); /* 23 */
    int (*pa_FOAComposedStateProcess) (Pa_Process *proc, Bdd_Edge F, Est_String prefix); /* 24 */
    int (*pa_FindStateProcess) (Pa_Process *proc, Est_String name); /* 25 */
    int (*pa_AddStateProcess) (Pa_Process *proc, Est_String name); /* 26 */
    int (*pa_FOANextStateProcess) (Pa_Process *proc, Est_String prefix); /* 27 */
    int (*pa_NumberStateProcess) (Pa_Process *proc); /* 28 */
    int (*pa_FOATransition) (Pa_Process *proc, int state1, int action, int type, int state2); /* 29 */
    int (*pa_AddNewComposition) (Est_String name, int type, int numP, int numA); /* 30 */
    void (*pa_DeleteStateProcess) (Pa_Process *proc, int num); /* 31 */
    void (*pa_DeleteSort) (int num); /* 32 */
    void (*pa_RemoveDeletedSorts) (); /* 33 */
    void (*pa_DeleteProcess) (int num); /* 34 */
    void (*pa_RemoveDeletedProcesses) (); /* 35 */
    void (*pa_RemoveComposition) (int num); /* 36 */
    int (*pa_FindComposition) (Est_String name); /* 37 */
    int (*pa_FindProcessComp) (Pa_Composition *c, Est_String name); /* 38 */
    Bdd_Edge (*pa_AddStab) (Bdd_Edge d, Est_String name); /* 39 */
    void (*paSaveSortActions) (Pa_Sort *s); /* 40 */
    void (*paSaveProcStates) (Pa_Process *p); /* 41 */
    void (*pa_EncodeSort) (Est_String name); /* 42 */
    void (*pa_EncodeProcess) (Est_String name); /* 43 */
    void (*pa_EncodeMultiProcesses) (Est_String plist); /* 44 */
    int (*pa_ExpandGates) (Pa_Process *p); /* 45 */
    int (*pa_Process2Composition) (Est_String name); /* 46 */
    int (*pa_Composition2Process) (Est_String name, Est_Boolean full); /* 47 */
    int (*pa_DecodeSortActions) (Pa_Sort *s, Bdd_Edge F, Est_Boolean write); /* 48 */
    Est_String (*pa_DecodeSortActions1) (Pa_Sort *s, Bdd_Edge F, Est_Boolean write); /* 49 */
    void (*pa_DecodeProcess) (Est_String name, Est_Boolean write); /* 50 */
    int (*pa_DecodeProcessStates) (Pa_Process *p, Bdd_Edge F, Est_Boolean write); /* 51 */
    int (*pa_DecodeProcessTR) (Pa_Process *p, Bdd_Edge F, Est_Boolean write); /* 52 */
    void (*pa_DecodeComposition) (Est_String name, Est_Boolean write); /* 53 */
    int (*pa_DecodeCompStates) (Pa_Composition *c, Bdd_Edge F, Est_Boolean write); /* 54 */
    int (*pa_DecodeCompTR) (Pa_Composition *c, Bdd_Edge F, Est_Boolean write); /* 55 */
    int (*pa_DecodeProcProcPair) (Pa_Process *p1, Pa_Process *p2, Bdd_Edge F, Est_Boolean write); /* 56 */
    int (*pa_DecodeCompProcPair) (Pa_Composition *c, Pa_Process *p, Bdd_Edge F, Est_Boolean write); /* 57 */
    int (*pa_DecodeCompCompPair) (Pa_Composition *c1, Pa_Composition *c2, Bdd_Edge F, Est_Boolean write); /* 58 */
    Bdd_Edge (*pa_ExtractProcTransition) (Pa_Process *p, Bdd_Edge f); /* 59 */
    Bdd_Edge (*pa_ExtractCompTransition) (Pa_Composition *c, Bdd_Edge f); /* 60 */
    Bdd_Edge (*pa_ExtractProcState) (Pa_Process *p, Bdd_Edge f); /* 61 */
    int (*pa_EnumerateProcState) (Pa_Process *p, Bdd_Edge f); /* 62 */
    Bdd_Edge (*pa_ExtractCompState) (Pa_Composition *c, Bdd_Edge f); /* 63 */
    Bdd_Edge (*pa_ExtractSortAction) (Pa_Sort *s, Bdd_Edge f); /* 64 */
    int (*pa_EnumerateSortAction) (Pa_Sort *s, Bdd_Edge f); /* 65 */
    void (*pa_WriteKnownSorts) (); /* 66 */
    void (*pa_WriteSort) (Est_String name); /* 67 */
    void (*pa_WriteKnownProcesses) (); /* 68 */
    void (*pa_WriteProcess) (Est_String name, char type); /* 69 */
    void (*pa_WriteKnownCompositions) (); /* 70 */
    void (*pa_WriteProcessCCS) (Est_String name, char type); /* 71 */
    int (*pa_ParseSortProcess) (Est_String ime); /* 72 */
    void (*pa_WriteProcessFSP) (Est_String name, char type); /* 73 */
} PaStubs;

#ifdef __cplusplus
extern "C" {
#endif
extern const PaStubs *paStubsPtr;
#ifdef __cplusplus
}
#endif

#if defined(USE_PA_STUBS)

/*
 * Inline function declarations:
 */

#define pa_status \
	(*paStubsPtr->pa_status) /* 0 */
#define pa_variables \
	(*paStubsPtr->pa_variables) /* 1 */
#define pa_sorts \
	(*paStubsPtr->pa_sorts) /* 2 */
#define pa_processes \
	(*paStubsPtr->pa_processes) /* 3 */
#define pa_compositions \
	(*paStubsPtr->pa_compositions) /* 4 */
#define pa_variableTable \
	(*paStubsPtr->pa_variableTable) /* 5 */
#define pa_sortTable \
	(*paStubsPtr->pa_sortTable) /* 6 */
#define pa_processTable \
	(*paStubsPtr->pa_processTable) /* 7 */
#define pa_compositionTable \
	(*paStubsPtr->pa_compositionTable) /* 8 */
#define Pa_InitPkg \
	(paStubsPtr->pa_InitPkg) /* 9 */
#define Pa_ExitPkg \
	(paStubsPtr->pa_ExitPkg) /* 10 */
#define Pa_AboutPkg \
	(paStubsPtr->pa_AboutPkg) /* 11 */
#define Pa_InitVariable \
	(paStubsPtr->pa_InitVariable) /* 12 */
#define Pa_AddNewSort \
	(paStubsPtr->pa_AddNewSort) /* 13 */
#define Pa_FindSort \
	(paStubsPtr->pa_FindSort) /* 14 */
#define Pa_FOASortAction \
	(paStubsPtr->pa_FOASortAction) /* 15 */
#define Pa_FindSortAction \
	(paStubsPtr->pa_FindSortAction) /* 16 */
#define Pa_AddNewProcess \
	(paStubsPtr->pa_AddNewProcess) /* 17 */
#define Pa_FindProcess \
	(paStubsPtr->pa_FindProcess) /* 18 */
#define Pa_RenameProcess \
	(paStubsPtr->pa_RenameProcess) /* 19 */
#define Pa_CopyProcess \
	(paStubsPtr->pa_CopyProcess) /* 20 */
#define Pa_IsGate \
	(paStubsPtr->pa_IsGate) /* 21 */
#define Pa_FOAStateProcess \
	(paStubsPtr->pa_FOAStateProcess) /* 22 */
#define Pa_FOAGateProcess \
	(paStubsPtr->pa_FOAGateProcess) /* 23 */
#define Pa_FOAComposedStateProcess \
	(paStubsPtr->pa_FOAComposedStateProcess) /* 24 */
#define Pa_FindStateProcess \
	(paStubsPtr->pa_FindStateProcess) /* 25 */
#define Pa_AddStateProcess \
	(paStubsPtr->pa_AddStateProcess) /* 26 */
#define Pa_FOANextStateProcess \
	(paStubsPtr->pa_FOANextStateProcess) /* 27 */
#define Pa_NumberStateProcess \
	(paStubsPtr->pa_NumberStateProcess) /* 28 */
#define Pa_FOATransition \
	(paStubsPtr->pa_FOATransition) /* 29 */
#define Pa_AddNewComposition \
	(paStubsPtr->pa_AddNewComposition) /* 30 */
#define Pa_DeleteStateProcess \
	(paStubsPtr->pa_DeleteStateProcess) /* 31 */
#define Pa_DeleteSort \
	(paStubsPtr->pa_DeleteSort) /* 32 */
#define Pa_RemoveDeletedSorts \
	(paStubsPtr->pa_RemoveDeletedSorts) /* 33 */
#define Pa_DeleteProcess \
	(paStubsPtr->pa_DeleteProcess) /* 34 */
#define Pa_RemoveDeletedProcesses \
	(paStubsPtr->pa_RemoveDeletedProcesses) /* 35 */
#define Pa_RemoveComposition \
	(paStubsPtr->pa_RemoveComposition) /* 36 */
#define Pa_FindComposition \
	(paStubsPtr->pa_FindComposition) /* 37 */
#define Pa_FindProcessComp \
	(paStubsPtr->pa_FindProcessComp) /* 38 */
#define Pa_AddStab \
	(paStubsPtr->pa_AddStab) /* 39 */
#define PaSaveSortActions \
	(paStubsPtr->paSaveSortActions) /* 40 */
#define PaSaveProcStates \
	(paStubsPtr->paSaveProcStates) /* 41 */
#define Pa_EncodeSort \
	(paStubsPtr->pa_EncodeSort) /* 42 */
#define Pa_EncodeProcess \
	(paStubsPtr->pa_EncodeProcess) /* 43 */
#define Pa_EncodeMultiProcesses \
	(paStubsPtr->pa_EncodeMultiProcesses) /* 44 */
#define Pa_ExpandGates \
	(paStubsPtr->pa_ExpandGates) /* 45 */
#define Pa_Process2Composition \
	(paStubsPtr->pa_Process2Composition) /* 46 */
#define Pa_Composition2Process \
	(paStubsPtr->pa_Composition2Process) /* 47 */
#define Pa_DecodeSortActions \
	(paStubsPtr->pa_DecodeSortActions) /* 48 */
#define Pa_DecodeSortActions1 \
	(paStubsPtr->pa_DecodeSortActions1) /* 49 */
#define Pa_DecodeProcess \
	(paStubsPtr->pa_DecodeProcess) /* 50 */
#define Pa_DecodeProcessStates \
	(paStubsPtr->pa_DecodeProcessStates) /* 51 */
#define Pa_DecodeProcessTR \
	(paStubsPtr->pa_DecodeProcessTR) /* 52 */
#define Pa_DecodeComposition \
	(paStubsPtr->pa_DecodeComposition) /* 53 */
#define Pa_DecodeCompStates \
	(paStubsPtr->pa_DecodeCompStates) /* 54 */
#define Pa_DecodeCompTR \
	(paStubsPtr->pa_DecodeCompTR) /* 55 */
#define Pa_DecodeProcProcPair \
	(paStubsPtr->pa_DecodeProcProcPair) /* 56 */
#define Pa_DecodeCompProcPair \
	(paStubsPtr->pa_DecodeCompProcPair) /* 57 */
#define Pa_DecodeCompCompPair \
	(paStubsPtr->pa_DecodeCompCompPair) /* 58 */
#define Pa_ExtractProcTransition \
	(paStubsPtr->pa_ExtractProcTransition) /* 59 */
#define Pa_ExtractCompTransition \
	(paStubsPtr->pa_ExtractCompTransition) /* 60 */
#define Pa_ExtractProcState \
	(paStubsPtr->pa_ExtractProcState) /* 61 */
#define Pa_EnumerateProcState \
	(paStubsPtr->pa_EnumerateProcState) /* 62 */
#define Pa_ExtractCompState \
	(paStubsPtr->pa_ExtractCompState) /* 63 */
#define Pa_ExtractSortAction \
	(paStubsPtr->pa_ExtractSortAction) /* 64 */
#define Pa_EnumerateSortAction \
	(paStubsPtr->pa_EnumerateSortAction) /* 65 */
#define Pa_WriteKnownSorts \
	(paStubsPtr->pa_WriteKnownSorts) /* 66 */
#define Pa_WriteSort \
	(paStubsPtr->pa_WriteSort) /* 67 */
#define Pa_WriteKnownProcesses \
	(paStubsPtr->pa_WriteKnownProcesses) /* 68 */
#define Pa_WriteProcess \
	(paStubsPtr->pa_WriteProcess) /* 69 */
#define Pa_WriteKnownCompositions \
	(paStubsPtr->pa_WriteKnownCompositions) /* 70 */
#define Pa_WriteProcessCCS \
	(paStubsPtr->pa_WriteProcessCCS) /* 71 */
#define Pa_ParseSortProcess \
	(paStubsPtr->pa_ParseSortProcess) /* 72 */
#define Pa_WriteProcessFSP \
	(paStubsPtr->pa_WriteProcessFSP) /* 73 */

#endif /* defined(USE_PA_STUBS) */

/* !END!: Do not edit above this line. */
