#!/bin/sh
# the next line executes the program\
exec wish "$0" "$@"

# Here, version 1.0 should be given due to the problems with
# "package ifneeded" used in pkgIndex.tcl in the packages that use this.
package provide est2ed 1.0

# MAYBE YOU MUST USE ONE OF THE FOLLOWING LINES
# exec /usr/local/bin/wish "$0" "$@"
# exec /home/meolic/ActiveTcl/bin/wish "$0" "$@"

#  Authors     [Robert Meolic (meolic@uni-mb.si)]
#  Revision    [$Revision: 61 $]
#  Date        [$Date: 2012-07-05 14:18:15 +0200 (čet, 05 jul 2012) $]
#
#  Copyright   [This file is part of EST (Efficient Symbolic Tools).
#               Copyright (C) 2003, 2012
#               UM-FERI, Smetanova ulica 17, SI-2000 Maribor, Slovenia
#
#               EST is free software; you can redistribute it and/or modify
#               it under the terms of the GNU General Public License as
#               published by the Free Software Foundation; either version 2
#               of the License, or (at your option) any later version.
#
#               EST is distributed in the hope that it will be useful,
#               but WITHOUT ANY WARRANTY; without even the implied warranty of
#               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#               GNU General Public License for more details.
#
#               You should have received a copy of the GNU General Public
#               License along with this program; if not, write to the Free
#               Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#               Boston, MA 02110-1301 USA.]

global TITLE
global ICONNAME
global PROMPT
global BINDIR

# Use this if you start the program using wish
lappend auto_path .
lappend auto_path /usr/lib/est2ed

# --------------
# identification
# --------------

set TITLE "EST - Efficient Symbolic Tools, 2nd Edition"
set ICONNAME "EST"
set PROMPT "EST> "

set LOCALDIR [pwd]
cd [file dirname [info script]]
set BINDIR [pwd]

# ####################################################################
# Start My Interface Tcl/Tk GUI
# ####################################################################

wm geometry . =1020x540+0+0
package require myinterface

# ####################################################################
# Say hello
# ####################################################################

outline "Efficient Symbolic Tools, 2nd Edition, Copyright (C) 2003-2012 UM-FERI"
outline "This is free software, and comes with ABSOLUTELY NO WARRANTY."
outline "You are welcome to redistribute EST; type \"license\" for details."
outline ""
outline "Running on $tcl_platform(machine) ($tcl_platform(os), $tcl_platform(osVersion)) with tcl $tcl_patchLevel and tk $tk_patchLevel."
outline ""

# ####################################################################
# GUI package
# ####################################################################

package require est2ed-gui
gui_initPkg

# ####################################################################
# BDD package
# ####################################################################

package require est2ed-bdd
bdd_initPkg

# ####################################################################
# Process algebra package
# ####################################################################

package require est2ed-pa
pa_initPkg

# ####################################################################
# Versis package
# ####################################################################

package require est2ed-versis
versis_initPkg

# ####################################################################
# Model checking package
# ####################################################################

package require est2ed-mc
mc_initPkg

# ####################################################################
# Strucval package
# ####################################################################

package require est2ed-strucval
strucval_initPkg

# ####################################################################
# CCS package
# ####################################################################

package require est2ed-ccs
ccs_initPkg

# ####################################################################
# Change to the default folder
# ####################################################################

if {[file isdirectory "/usr/share/est2ed"]} {
  cd "/usr/share/est2ed"
} else {
  if {[file isdirectory "$BINDIR/../data"]} {
    cd "$BINDIR/../data"
  } else {
    cd "$LOCALDIR"
  }
}

# ####################################################################
# OK. Let's go!
# ####################################################################

outline "Ready."
outline ""

# ####################################################################
# License = GNU GPL (version 2)
# ####################################################################

proc license {  } {

    outline "Efficient Symbolic Tools, 2nd Edition, Copyright (C) 2003-2012 UM-FERI"

	outline ""
	outline \
	"EST is free software; you can redistribute it and/or modify"
	outline \
        "it  under  the  terms of  the GNU General Public License as"
	outline \
        "published by the Free Software Foundation; either version 2"
	outline \
        "of the License, or (at your option) any later version."

	outline ""
	outline \
	"EST is distributed in the hope that it will be useful,  but"
	outline \
	"WITHOUT  ANY  WARRANTY;  without even the implied  warranty"
	outline \
	"of MERCHANTABILITY or FITNESS  FOR  A  PARTICULAR  PURPOSE."
	outline \
	"See the GNU General Public License for more details."

	outline ""
	outline \
	"You  should  have received a copy of the GNU General Public"
	outline \
	"License along with this program;  if not, write to the Free"
	outline \
	"Software Foundation, Inc., 51 Franklin Street,  Fifth Floor"
	outline \
	"Boston, MA 02110-1301 USA."

	outline ""
}

# ####################################################################
# DEBUGGING ONLY
# ####################################################################

proc myexit { } {
  ccs_exitPkg
  strucval_exitPkg
  mc_exitPkg
  versis_exitPkg
  pa_exitPkg
  bdd_exitPkg
  gui_exitPkg
}
