<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

if ($rechte["admin"] == false) fehler("Sie besitzen nicht gengend Zugriffsrechte, um diese Seite zu betreten!");

if (!isset($_GET["type"]))
{
    ?>
    <h3>Blogs verwalten</h3>
    <table class="maintable">
    <form method="POST" action="index.php?action=admincp&amp;show=mod&amp;mod=blogs&amp;type=neu">
    <tr class="rowberschrift">
        <td colspan="2">Blog erstellen</td>
    </tr>
    <tr class="row2"> 
        <td>Titel:</td><td><input class="inputtext" name="titel" type="text" size="40" /></td>
    </tr>
    <tr class="row2">
        <td>Beschreibung:</td><td><input class="inputtext" name="beschreibung" type="text" size="40" /></td>
    </tr>
    <tr class="row2">
        <td>&nbsp;</td><td><input name="erstellen" type="submit" value="erstellen" /></td>
    </tr>
    </form>
    <form method="POST" action="index.php?action=admincp&amp;show=mod&amp;mod=blogs&amp;type=bearbeiten">
    <tr class="rowberschrift">
        <td colspan="2">Blog bearbeiten/lschen</td>
    </tr>
    <tr class="row2">
        <td>Blog:</td>
        <td>
            <select class="inputtext" name="id" size="1">
            <?php
            $result = sql_select("*", "blogs_blogs", "ORDER BY id ASC");
            while ($ergebnis = sql_fetch_assoc($result))
            {
                echo "<option value=\"".$ergebnis["id"]."\" />".$ergebnis["id"]." - ".$ergebnis["titel"]."</option>";
            }
            ?>
            </select>
            <input name="blog_bearbeiten" type="submit" value="bearbeiten" /> <input name="blog_loeschen" type="submit" value="lschen" />
        </td>
    </tr>
    </form>
    </table>
    <?php
}
if(isset($_GET["type"]))
{
    //********************************** neu *****************************************************
    if($_GET["type"] == "neu")
    {
        // neues blog in db einfgen
        if(trim($_POST["titel"]) == "") fehler("Jedes Blog muss einen Titel haben!");
        // erst blog erzeugen, dann bearbeiten-seite aufrufen
        // als besitzer erstmal den aktuellen admin-user nehmen
        
        $werte = array(
            "titel"         => htmlspecialchars($_POST["titel"]),
            "beschreibung"  => htmlspecialchars($_POST["beschreibung"]),
            "besitzer_id"   => $user["id"],
            "besitzer_name" => $user["username"],
            "privat"        => 0
            );
        sql_insert("blogs_blogs", $werte);
        
        // id des neuen eintrags?
        $result = sql_select("id", "blogs_blogs", "ORDER BY id DESC");
        $ergebnis = sql_fetch_assoc($result);
        
        ?>
        <h3>Blog erstellen</h3>
        Das Blog wurde erfolgreich erstellt!<br />
        Klicken Sie jetzt auf "bearbeiten" um die Einstellungen fr das Blog zu bearbeiten.<br />
        <form method="POST" action="index.php?action=admincp&amp;show=mod&amp;mod=blogs&amp;type=bearbeiten">
        <input name="id" type="hidden" value="<?php echo $ergebnis["id"] ?>" />
        <input name="blog_bearbeiten" type="submit" value="bearbeiten" />
        </form>
        <?php
    }
    if($_GET["type"] == "bearbeiten")
    {
        //********************************** bearbeiten *******************************************
        if(isset($_POST["blog_bearbeiten"]))
        {
            if(!isset($_POST["bearbeiten_knopf"]))
            {
                //bearbeiten-formular
                //bisherige einstellungen abfragen:
                $blog = sql_fetch_assoc(sql_select("*", "blogs_blogs", "WHERE id=".$_POST["id"]));
                
                $blogrechteresult = sql_select("*", "blogs_rechte", "WHERE blog_id=".$blog["id"]);
                $lesen[] = 0; $schreiben[] = 0; $moderieren[] = 0;
                while($blogrechte = sql_fetch_assoc($blogrechteresult))
                {
                    if($blogrechte["lesen"]      == 1) $lesen[]      = $blogrechte["gruppe_id"];
                    if($blogrechte["schreiben"]  == 1) $schreiben[]  = $blogrechte["gruppe_id"];
                    if($blogrechte["moderieren"] == 1) $moderieren[] = $blogrechte["gruppe_id"];
                }
                ?>
                <h3>Blog bearbeiten</h3>
                <form method="POST" action="index.php?action=admincp&amp;show=mod&amp;mod=blogs&amp;type=bearbeiten">
                <input name="id" type="hidden" value="<?php echo $_POST["id"] ?>" />
                <input name="blog_bearbeiten" type="hidden" value="1" />
                <table class="maintable">
                <tr class="rowberschrift">
                    <td colspan="2">Allgemeines:</td>
                </tr>
                <tr class="row2">
                    <td>Titel:</td><td><input class="inputtext" name="titel" type="text" value="<?php echo $blog["titel"] ?>" size="40" /></td>
                </tr>
                <tr class="row2">
                    <td>Beschreibung:</td><td><input class="inputtext" name="beschreibung" type="text" value="<?php echo $blog["beschreibung"] ?>" size="40" /></td>
                </tr>
                <tr class="row2">
                    <td>Besitzer:</td><td><input class="inputtext" name="besitzer" type="text" value="<?php echo $blog["besitzer_name"] ?>" size="40" /></td>
                </tr>
                <tr class="row2">
                    <td>Privat:</td><td><input class="inputtext" name="privat" type="radio" value="1" <?php if($blog["privat"] == 1) echo "checked " ?>/>Ja <input class="inputtext" name="privat" type="radio" value="0" <?php if($blog["privat"] == 0) echo "checked " ?>/>Nein</td>
                </tr>
                <tr class="rowberschrift">
                    <td colspan="2">Rechte:</td>
                </tr>
                <tr class="row2">
                    <td>Lesen:</td><td><select multiple class="inputtext" name="lesen[]" size="5">
                    <?php
                    // welche gruppen gibt es?
                    $gruppenresult = sql_select("id, titel", "gruppen ORDER BY id ASC");
                    while($gruppen = sql_fetch_assoc($gruppenresult))
                    {
                        echo "<option value=\"".$gruppen["id"]."\"";
                        if(in_array($gruppen["id"],$lesen))
                        {
                            echo "selected";
                        }
                        echo ">".$gruppen["titel"]."</option>";
                    }
                    ?>
                    </select></td>
                </tr>
                <tr class="row2">
                    <td>Schreiben:</td><td><select multiple class="inputtext" name="schreiben[]" size="5">
                    <?php
                    // welche gruppen gibt es?
                    $gruppenresult = sql_select("id, titel", "gruppen ORDER BY id ASC");
                    while($gruppen = sql_fetch_assoc($gruppenresult))
                    {
                        echo "<option value=\"".$gruppen["id"]."\"";
                        if(in_array($gruppen["id"],$schreiben))
                        {
                            echo "selected";
                        }
                        echo ">".$gruppen["titel"]."</option>";
                    }
                    ?>
                    </select></td>
                </tr>
                <tr class="row2">
                    <td>Moderieren:</td><td><select multiple class="inputtext" name="moderieren[]" size="5">
                    <?php
                    // welche gruppen gibt es?
                    $gruppenresult = sql_select("id, titel", "gruppen ORDER BY id ASC");
                    while($gruppen = sql_fetch_assoc($gruppenresult))
                    {
                        echo "<option value=\"".$gruppen["id"]."\"";
                        if(in_array($gruppen["id"],$moderieren))
                        {
                            echo "selected";
                        }
                        echo ">".$gruppen["titel"]."</option>";
                    }
                    ?>
                    </select></td>
                </tr>
                <tr class="row2">
                    <td>&nbsp</td><td><input name="bearbeiten_knopf" type="submit" value="bearbeiten" /></td>
                </tr>
                </table>
                </form>
                <?php
            }
            else
            {
                // datenbank-eintrag aktualisieren
                if(trim($_POST["titel"])        == "") fehler("Jedes Blog muss einen Titel haben!");
                if(trim($_POST["beschreibung"]) == "") fehler("Jedes Blog muss eine Beschreibung haben!");
                if(trim($_POST["besitzer"])     == "") fehler("Jedes Blog muss einen Besitzer haben!");
                
                // wenn eine gruppe, die in $_POST["lesen"] ist, noch nicht in der tabelle ist -> hinzufgen
                function checkgroups($value, $key)
                {
                    if(sql_num_rows(sql_select("gruppe_id", "blogs_rechte", "WHERE blog_id=".$_POST["id"]." AND gruppe_id=".$value)) == 0)
                    {
                        $werte = array("gruppe_id" => $value, "blog_id" => $_POST["id"]);
                        sql_insert("blogs_rechte", $werte);
                    }
                }
                @array_walk($_POST["lesen"],      'checkgroups');
                @array_walk($_POST["schreiben"],  'checkgroups');
                @array_walk($_POST["moderieren"], 'checkgroups');
                
                // jede gruppe durchgehen
                $alterechteresult = sql_select("*", "blogs_rechte", "WHERE blog_id=".$_POST["id"]);
                function checkrechte($recht, $alterechte)
                {
                    global $alterechte;
                    // wenn diese gruppe ein recht hat -> aktualisieren
                    if(in_array($alterechte["gruppe_id"],$_POST[$recht]))
                    {
                        $werte = array($recht => 1);
                        sql_update("blogs_rechte", $werte, "WHERE gruppe_id=".$alterechte["gruppe_id"]." AND blog_id=".$_POST["id"]);
                    }
                    else
                    {
                        $werte = array($recht => 0);
                        sql_update("blogs_rechte", $werte, "WHERE gruppe_id=".$alterechte["gruppe_id"]." AND blog_id=".$_POST["id"]);
                    }
                }
                while($alterechte = sql_fetch_assoc($alterechteresult))
                {
                    @checkrechte("lesen",      $alterechte);
                    @checkrechte("schreiben",  $alterechte);
                    @checkrechte("moderieren", $alterechte);
                }
                
                // id zum besitzernamen finden
                $besitzerresult = sql_select("*", "users", "WHERE username='".$_POST["besitzer"]."'", NULL, NULL);
                if(sql_num_rows($besitzerresult) == 0) fehler("Der Benutzername ist nicht vorhanden!");
                $besitzer = sql_fetch_assoc($besitzerresult);
                
                $werte = array(
                    "titel"         => htmlspecialchars($_POST["titel"]),
                    "beschreibung"  => htmlspecialchars($_POST["beschreibung"]),
                    "besitzer_id"   => $besitzer["id"],
                    "besitzer_name" => $besitzer["username"],
                    "privat"        => $_POST["privat"]
                    );
                sql_update("blogs_blogs", $werte, "WHERE id=".$_POST["id"]);
                
                redir("index.php?action=admincp&show=mod&mod=blogs", "Die Einstellungen wurden bearbeitet!");
            }
        }
        //*********************************** lschen *********************************************
        elseif(isset($_POST["blog_loeschen"]))
        {
            // sicherheitsabfrage, dann lschen
            if(!isset($_POST["bestaetigen_knopf"]))
            {
                // formular mit besttigungsknopf anzeigen
                $result = sql_select("*", "blogs_blogs", "WHERE id=".$_POST["id"]);
                $ergebnis = sql_fetch_assoc($result);
                ?>
                <h3>Blog lschen</h3>
                <form method="POST" action="index.php?action=admincp&amp;show=mod&amp;mod=blogs&amp;type=bearbeiten">
                <input name="id" type="hidden" value="<?php echo $_POST["id"] ?>" />
                <input name="blog_loeschen" type="hidden" value="1" />
                Sind Sie sicher, dass Sie das Blog "<?php echo $ergebnis["titel"] ?>" lschen wollen?<br />
                Die enthaltenen Posts:<br />
                <input class="inputtext" name="move" type="radio" value="1" />Verschieben in dieses Blog:
                <select class="inputtext" name="moveid" size="1">
                <?php
                $result = sql_select("*", "blogs_blogs", "ORDER BY id ASC");
                while ($ergebnis = sql_fetch_assoc($result))
                {
                    echo "<option value=\"".$ergebnis["id"]."\" />".$ergebnis["id"]." - ".$ergebnis["titel"];
                }
                ?>
                </select><br />
                <input class="inputtext" name="move" type="radio" value="0" checked />Lschen<br />
                <input name="bestaetigen_knopf" type="submit" value="lschen" />
                </form>
                <?php
            }
            else
            {
                // blog aus der datenbank lschen
                // alle zugehrigen blog-rechte lschen
                sql_delete("blogs_rechte", "WHERE blog_id=".$_POST["id"]);
                
                if($_POST["move"] == 1)
                {
                    // alle enthaltenen posts verschieben
                    $werte = array("blog" => $_POST["moveid"]);
                    sql_update("blogs_posts", $werte, "WHERE blog=".$_POST["id"]);
                }
                else
                {
                    // alle posts des blogs lschen
                    sql_delete("blogs_posts", "WHERE blog=".$_POST["id"]);
                }
                // blog lschen
                sql_delete("blogs_blogs", "WHERE id=".$_POST["id"]);
                
                redir("index.php?action=admincp&show=mod&mod=blogs", "Das Blog wurde gelscht!");
            }
        }
    }
}
?>