<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

if(!isset($_GET["suchen_knopf"]))
{
  // formular ausgeben
  ?>
  <h3>Suche</h3>
  <form method="GET" action="index.php">
  <input name="action" type="hidden" value="suche" />
  <table class="maintable">
  <tr class="rowberschrift">
    <td colspan="2"><b>Suchbegriffe:</b></td>
  </tr>
  <tr class="row2">
    <td colspan="2" align="center"><input class="inputtext" name="suchtext" type="text" size="45" /></td>
  </tr>
  <tr class="row2">
    <td colspan="2" align="center">AND, OR, (AND) NOT und OR NOT sind erlaubt!</td>
  </tr>
  <tr class="rowberschrift">
    <td colspan="2"><b>Optionen:</b></td>
  </tr>
  <tr class="row2">
    <td>Such-Typ:</td><td><input name="typ" type="radio" value="normal" checked /> Normal <input name="typ" type="radio" value="volltext" /> Volltext <i>(fehlt noch!!!)</i></td>
  </tr>
  <tr class="row2">
    <td>Suchen in:</td><td><input name="titel_suchen" type="checkbox" value="1" checked /> In Titeln <input name="nachricht_suchen" type="checkbox" value="1" checked /> In Nachrichten-Texten</td>
  </tr>
  <tr class="row2">
    <td>Boards durchsuchen:</td>
    <td><select class="inputtext" name="boards[]" size="5" multiple><?php
    foreach($boards as $board)
    {
      echo "<option value=\"".$board["id"]."\" selected>".$board["titel"]."</option>";
    }
    ?></select></td>
  </tr>
  <tr class="row2">
    <td>Zeitraum:</td><td><select class="inputtext" name="zeitraum" size="1">
    <option value="alle" selected>Alle</option>
    <option value="1d">1 Tag</option>
    <option value="1w">1 Woche</option>
    <option value="2w">2 Wochen</option>
    <option value="1m">1 Monat</option>
    <option value="3m">3 Monate</option>
    <option value="6m">6 Monate</option>
    <option value="1y">1 Jahr</option>
    </select></td>
  </tr>
  <tr class="row2">
    <td>&nbsp</td><td><input name="suchen_knopf" type="submit" value="suchen" /></td>
  </tr>
  </table>
  </form>
  <?php
}
else
{
  if(!isset($suchthread))
  {
    ?>
    <table class="maintable">
    <tr class="row2">
      <td class="liste">Es wurden keine entsprechenden Beitrge gefunden!</td>
    </tr>
    </table>
    <?php
  }
  else
  {
    $strseite = "<b>Seite: ";
    if($startausgeblendet == true) $strseite .= ".. ";
    foreach($seitenlink as $n => $link)
    {
      if($n != "letzte")
      {
        if($link == "")
        {
          // aktuelle seite
          $strseite .= $n." ";
        }
        else
        {
          $strseite .= "<a href=\"".$link."\">".$n."</a> ";
        }
      }
      else
      {
        $strseite .= "<a href=\"".$link."\">[letzte Seite]</a>";
      }
    }
    $strseite .= "</b>";
    echo $strseite;
    ?>
    </b><br /><br />

    <table class="maintable" width="100%">
    <tr class="rowberschrift">
      <td><b>ID</b></td>
      <td><b>Status</b></td>
      <td><b>Titel</b></td>
      <td><b>gefundene Posts</b></td>
      <td><b>Board</b></td>
      <td><b>erstellt</b></td>
      <td><b>Posts</b></td>
      <td><b>Hits</b></td>
      <td><b>Letzter Post</b></td>
    </tr>

    <?php
    // jede zeile aus dem array holen und in die table einfgen
    $zeile = 2;

    foreach($threads as $thread)
    {
      ?>
      <tr class="row<?php echo $zeile ?>">
        <td class="liste"><?php echo $thread["id"] ?></td>
        <td class="liste"><?php echo $thread["status"] ?></td>
        <td class="liste"><?php if($thread["umfrage"] == true) echo "Umfrage: " ?><a href="<?php echo $thread["titellink"] ?>"><?php echo $thread["titel"] ?></a></td>
        <td class="liste"><?php echo $thread["gefundene_posts"] ?></td>
        <td class="liste"><a href="<?php echo $thread["boardlink"] ?>"><?php echo $thread["boardtitel"] ?></a></td>
        <td class="liste"><?php echo $thread["erstellt"]." von ";
        if($thread["autorlink"] != "") echo "<a href=\"".$thread["autorlink"]."\">";
        echo $thread["autorname"];
        if($thread["autorlink"] != "") echo "</a>";
        ?></td>
        <td class="liste"><?php echo $thread["posts"] ?></td>
        <td class="liste"><?php echo $thread["hits"] ?></td>
        <td class="liste"><?php
        if($thread["posts"] != 0)
        {
          ?><a href="<?php echo $thread["lastpostlink"] ?>"><?php echo $thread["lastpostdatum"] ?></a> von <?php
          if($thread["lastpostautorlink"] != "") { ?><a href="<?php echo $thread["lastpostautorlink"] ?>"><?php }
          echo $thread["lastpostautor"];
          if($thread["lastpostautorlink"] != "") { ?></a><?php }
          ?></td><?php
        }
        else
        {
          ?> - </td>
          <?php
        }
        ?>
      </tr>
      <?php

      $zeile++;
      if ($zeile>2) $zeile=1;
    }
    ?>
    </table>
    <br />
    <?php echo $strseite;
  }
}
?>