
// Experiencing with C++ operator new/delete overload
// see eg:http://www.scs.stanford.edu/~dm/home/papers/c++-new.html
//
// Use an alternate allocator
// http://eli.thegreenplace.net/2008/10/17/memmgr-a-fixed-pool-memory-allocator

#include <iostream>
#include "memmgr.h"
#include <memory>

/////////////////////////////////////////////////
// Overload global operators
/////////////////////////////////////////////////
void* operator new(size_t s) throw (std::bad_alloc){
	std::cout << "Global operator new("<<s<<")"<<std::endl;
	return memmgr_alloc(s);
}

void operator delete(void * addr) throw (){
	std::cout << "Global operator delete("<<addr<<")"<<std::endl;
	memmgr_free(addr);
}
/////////////////////////////////////////////////
// Overload global operators (array case)
/////////////////////////////////////////////////
void* operator new[] (size_t s) throw (std::bad_alloc){
	std::cout << "Global operator new[] ("<<s<<")"<<std::endl;
	return memmgr_alloc(s);
}

void operator delete[] (void * addr) throw (){
	std::cout << "Global operator delete[]("<<addr<<")"<<std::endl;
	memmgr_free(addr);
}
