game.data = { "font" : "18px Arial", "height" : 480, "pauseScreen" : { "scenes" : [ { "actions" : [ { "type" : "Wait", "waitType" : "Forever" } ], "backgroundColor" : [ 242, 242, 242, 255 ], "name" : "main", "objects" : [ { "resource" : "MenuButton", "text" : "Resume", "x" : 243, "y" : 136 }, { "name" : "MenuButton1", "onMouseMove" : [ { "changeObjectBackgroundColor" : true, "changeObjectColor" : false, "color" : [ 255, 255, 255, 255 ], "object" : "MenuButton1", "type" : "ChangeColor" } ], "onMouseRelease" : [ { "target" : "saveGame", "targetType" : 0, "type" : "GoToScene" } ], "resource" : "MenuButton", "text" : "Save Game", "x" : 244, "y" : 184 }, { "name" : "MenuButton2", "onMouseMove" : [ { "changeObjectBackgroundColor" : true, "changeObjectColor" : false, "color" : [ 255, 255, 255, 255 ], "object" : "MenuButton2", "type" : "ChangeColor" } ], "onMouseRelease" : [ { "target" : "loadGame", "targetType" : 0, "type" : "GoToScene" } ], "resource" : "MenuButton", "text" : "Load Game", "x" : 243, "y" : 234 }, { "name" : "MenuButton4", "onMouseMove" : [ { "changeObjectBackgroundColor" : true, "changeObjectColor" : false, "color" : [ 255, 255, 255, 255 ], "object" : "MenuButton4", "type" : "ChangeColor" } ], "resource" : "MenuButton", "text" : "Quit", "x" : 242, "y" : 285 } ], "type" : "Scene" }, { "actions" : [ { "comment" : "create save slots", "script" : "var width = game.width;\nvar height = game.height;\nvar scene = game.getCurrentScene();\nvar hw = width / 2;\n\nvar data = { \"resource\" : \"emptySlotTextbox\" }; //use already created and styled resource for all textbox slots\nvar line = 0;\nvar yoffset = 60;\nvar xoffset = 1;\nvar x = xoffset;\nvar border = 2; //border width\nvar savedGames = game.getSavedGames();\n\nfor( var i =0; i < 10; i++) {\n\tvar textbox = new belle.objects.TextBox(data);\n\ttextbox.setWidth(hw-border-xoffset);\n\ttextbox.setX(x);\n\ttextbox.setY(yoffset + (textbox.height+5)*line);\n\ttextbox.setText((i+1) + \". Empty Slot\");\n\ttextbox.name = \"textbox_\" + i;\n\tif (i >= 0 && i < savedGames.length && savedGames[i] !== null) {\n\t\tvar entry = savedGames[i];\n\t\ttextbox.setText((i +1) + \". \" + entry.name+\"\\n\"+entry.date);\n\t}\n\ttextbox.addEventListener(\"mouserelease\", function() {\n\t\tvar id = parseInt(this.name.split(\"_\")[1]);\n\t\tvar data = game.save(id);\n\t\tthis.setText( (id+1) + \". \" + data.name+\" \\n\"+data.date);\n\t});\n\t\n\tx += textbox.width + border + xoffset;\n\tscene.addObject(textbox);\t\n\n\tif ( (i+1) % 2 == 0) { //2 slots per line\n\t\tline++;\n\t\tx = xoffset;\n\t}\n}", "type" : "RunScript" }, { "type" : "Wait", "waitType" : "Forever" } ], "backgroundColor" : [ 242, 242, 242, 255 ], "name" : "saveGame", "objects" : [ { "font" : "24px Ubuntu", "height" : 30, "resource" : "titleBox", "text" : "Save Game", "textAlignment" : "Left|Top", "width" : 127, "x" : 246, "y" : 11 } ], "type" : "Scene" }, { "actions" : [ { "comment" : "create load slots", "script" : "var width = game.width;\nvar height = game.height;\nvar hw = width / 2;\n\nvar data = { \"resource\" : \"emptySlotTextbox\" }; //use already created and styled resource for all textbox slots\nvar line = 0;\nvar xoffset = 1;\nvar x = xoffset;\nvar yoffset = 60;\nvar border = 2; //border width\nvar savedGames = game.getSavedGames();\n\nfor( var i =0; i < 10; i++) {\n\tvar textbox = new belle.objects.TextBox(data);\n\ttextbox.setWidth(hw-border-1);\n\ttextbox.setX(x);\n\ttextbox.setY(yoffset+(textbox.height+5)*line);\n\ttextbox.setText((i+1) + \". Empty Slot\");\n\ttextbox.name = \"textbox_\" + i;\n\n\tif (i >= 0 && i < savedGames.length && savedGames[i] !== null) {\n\t\tvar entry = savedGames[i];\n\t\ttextbox.setText( (i +1)  + \". \" + entry.name+\" \\n\"+entry.date);\n\t\ttextbox.addEventListener(\"mouserelease\", function() {\n\t\t\tvar id = parseInt(this.name.split(\"_\")[1]);\n\t\t\tvar data = game.load(id);\t\n\t\t}); \n\t}\n\t\n\tx += textbox.width + border + xoffset;\n\tgame.getCurrentScene().addObject(textbox);\t\n\n\tif ( (i+1) % 2 == 0) { //2 slots per line\n\t\tline++;\n\t\tx = xoffset;\n\t}\n}", "type" : "RunScript" }, { "type" : "Wait", "waitType" : "Forever" } ], "backgroundColor" : [ 242, 242, 242, 255 ], "name" : "loadGame", "objects" : [ { "font" : "24px Ubuntu", "resource" : "titleBox", "text" : "Load Game", "x" : 253, "y" : 11 } ], "type" : "Scene" } ] }, "resources" : { "MenuButton" : { "backgroundColor" : [ 220, 220, 220, 255 ], "cornerRadius" : 5, "height" : 30, "name" : "MenuButton", "onMouseMove" : [ { "changeObjectBackgroundColor" : true, "changeObjectColor" : false, "color" : [ 255, 255, 255, 255 ], "object" : "MenuButton", "type" : "ChangeColor" } ], "opacity" : 255, "padding" : { "bottom" : 0, "left" : 0, "right" : 0, "top" : 0 }, "text" : "Button", "textAlignment" : "HCenter|VCenter", "textColor" : [ 0, 0, 0, 255 ], "type" : "Button", "visible" : true, "width" : 137, "x" : 436, "y" : 260 }, "emptySlotTextbox" : { "backgroundColor" : [ 220, 220, 220, 255 ], "borderColor" : [ 0, 0, 0, 255 ], "borderWidth" : 1, "cornerRadius" : 9, "height" : 41, "name" : "emptySlotTextbox", "opacity" : 255, "padding" : { "bottom" : 0, "left" : 0, "right" : 0, "top" : 0 }, "text" : "Empty Slot", "textAlignment" : "Left|VCenter", "textColor" : [ 0, 0, 0, 255 ], "type" : "TextBox", "visible" : true, "width" : 163, "x" : 423, "y" : 277 }, "titleBox" : { "backgroundColor" : [ 255, 255, 255, 0 ], "height" : 28, "name" : "titleBox", "opacity" : 255, "padding" : { "bottom" : 0, "left" : 0, "right" : 0, "top" : 0 }, "text" : "Text goes here...", "textAlignment" : "HCenter|Top", "textColor" : [ 0, 0, 0, 255 ], "type" : "TextBox", "visible" : true, "width" : 137, "x" : 389, "y" : 250 } }, "scenes" : [ { "actions" : [ { "type" : "Wait", "waitType" : "Forever" } ], "backgroundColor" : [ 242, 242, 242, 255 ], "name" : "main_menu", "objects" : [ { "onMouseRelease" : [ { "target" : "Next", "targetType" : 1, "type" : "GoToScene" } ], "resource" : "MenuButton", "text" : "Start Game", "x" : 243, "y" : 183 }, { "name" : "MenuButton1", "onMouseMove" : [ { "changeObjectBackgroundColor" : true, "changeObjectColor" : false, "color" : [ 255, 255, 255, 255 ], "object" : "MenuButton1", "type" : "ChangeColor" } ], "onMouseRelease" : [ { "comment" : "Go to Load Game Screen", "script" : "game.pause();\ngame.setCurrentScene(\"loadGame\");", "type" : "RunScript" } ], "resource" : "MenuButton", "text" : "Load Game", "x" : 245, "y" : 237 } ], "type" : "Scene" } ], "textSpeed" : 50, "title" : "default", "width" : 640 }