<?php

// -----------------------------------------------------------------------
// This file is part of Beacon
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
?>


<?php
if (isset($item)) {
?>
<div class="box">
	<div class="box_top">
		<?php echo $this->date->formatDate($item['item_create_datetime']);?><br />
	</div>
	
	<div class="box_mid">
		<div class="content">
			<p class="txt_item_title">
				<?php echo $item['item_title'];?><br />
			</p>
			
			<p>
				<?php echo $item['item_body_display'];?><br />
			</p>
			
			<div class="metadata">
				<p>
					<b><?php echo $lang['txt_author'];?></b> -&#62;
					
					<?php echo $author['user_name'];?>: 
					<?php 
					if (!empty($author['show_email'])){
						echo formatEmail($author['user_email']);
					}
					else {
						echo $lang['txt_email_withheld'];
					}
					?>, 
						
						
					<?php
					if (isset($item['item_edit_datetime'])) {
					?>
					<?php echo $lang['txt_last_edited'];?>:&nbsp;<?php echo $this->date->formatDate($item['item_edit_datetime'],1);?>
					<?php
					}
					elseif (isset($item['item_create_datetime'])) {
					?>
					<?php echo $lang['txt_created'];?>:&nbsp;<?php echo $this->date->formatDate($item['item_create_datetime']);?>
					<?php }?>
					&nbsp;
					<?php
					if ($this->user_acs->checkPermission($resource_ids['wiki'], $privilege_ids['allow_edit'])) {
					?>
					&nbsp;
					<a href="admin.php?item_id=<?php echo $item['item_id'];?>"><?php echo $lang['href_edit_this'];?></a>
					<?php }?>, 
					<a href="list.php?wiki_id=<?php echo $item['wiki_id'];?>"><?php echo $lang['href_history'];?></a>
					
					<br />
					<?php
					$out_tags = "";
					if (isset($tags)) {
						echo $lang['txt_tag'] . " ";
						foreach ($tags as $key => $i):
							$out_tags .= "<a href='list.php?tag=" . $i['tag_body']. "'>" . $i['tag_body'] . "</a>";
							
							if (count($tags) > $key+1) {
								$out_tags .= ", ";
							}
						endforeach;
					}
					
					echo $out_tags;
					?>
					<br />
				</p>
			</div>
		</div>
	</div>
</div>
	
<div class="box_bottom">
	<span class="box_bottom_right"></span>
	<span class="box_bottom_left"></span>
</div>

<div class="box">
	<div class="box_top">
		<?php echo $lang['hdr_comments'];?><br />
	</div>
	
	<div class="box_mid">
		<div class="content">
			<?php
			if (isset($comments)) {
			foreach($comments as $key => $i):
			?>
				<div class="comment">
					<span class="comment_author">
						<b><?php echo $lang['txt_comment'];?></b> -&#62; 
						<?php echo $this->date->formatDate($i['comment_create_datetime'], 1);?><br />
						<b><?php echo $lang['txt_from'];?></b> -&#62;
						<?php echo $i['user_name'];?>, 
						<?php 
						if (!empty($i['show_email'])){
							echo $i['user_email'];
						}
						else {
							echo $lang['txt_email_withheld'];
						}
						?><br />
					</span>
					<br />
					<?php echo $i['comment_body'];?><br />
					
				</div>
			<?php
			endforeach;
			}
			else {
			?>
				<div class="comment">
					<p>
						<?php echo $lang['err_no_comments'];?><br />
					</p>
				</div>
			<?php }?>
			<div>
				<p align="right">
						<?php
						if (isset($_REQUEST['ico'])) {
						?>
						<a href="index.php?item_id=<?php echo $item['item_id'];?>"><?php echo $lang['href_all_comments'];?></a>&nbsp;<br />
						<?php
						}
						else {
						?>
						<a href="index.php?item_id=<?php echo $item['item_id'];?>&amp;ico=1"><?php echo $lang['href_item_comments_only'];?></a>&nbsp;<br />
						<?php }?>
						<br />
				</p>
				</div>
			<div class="comment_form">
			<?php
			if ($this->user_acs->checkPermission($resource_ids['wiki'], $privilege_ids['allow_comment']) && isset($_SESSION['s_user_id']) && isset($item) && $item['allow_comment'] == 1) {
			?>
				<form action="index.php" method="post" name="comment">
				<input type="hidden" name="item_id" value="<?php echo $item['item_id'];?>" />
				
				<?php
				if (isset($display) && $display == "preview_comment") {
				?>
					<p>
						<input type="hidden" name="comment_body" value="<?php echo $comment['comment_body'];?>" />
						<?php echo $comment['display_comment_body'];?><br />
					</p>
					<p align="right">
						<input type="submit" name="edit_comment_again" value="<?php echo $lang['form_submit_edit_again'];?>" />&nbsp;&nbsp;
						<input type="submit" name="insert_comment" value="<?php echo $lang['form_submit_save'];?>" /><br />
					</p>
					<?php
					}
					else {
					?>
						<span class="gui" align="right">
							<script language="JavaScript" type="text/javascript">
								var displayType = 'comment';
							</script>
							<script language="JavaScript" type="text/javascript" src="js/gui_wiki.js"></script>
						</span>
						<h4><?php echo $lang['hdr_add_comment'];?></h4>
						
						<p>
							<textarea id="id_comment" name="comment_body" rows="4" cols="70"><?php if(isset($comment['comment_body'])) { echo $comment['comment_body'];}?></textarea><br />
							<script language="JavaScript" type="text/javascript">
								var txtarea = document.comment.comment_body;
							</script>
						</p>
						
						<p align="right">
							<?php if (isset($allow_spellcheck)) {?>
							<input type="button" value="<?php echo $lang['form_submit_spelling'];?>" class="button_light" onClick="openSpellChecker();" />&nbsp;
							<?php }?>
							<input type="submit" name="preview_comment" value="<?php echo $lang['form_submit_preview'];?>" />&nbsp;
							
							<input type="submit" name="insert_comment" value="<?php echo $lang['form_submit_add'];?>" /><br />
						</p>
					<?php }?>
				</form>
				<?php 
				}
				elseif (!isset($_SESSION['s_user_id']) && isset($item) && $item['allow_comment'] == 1) { 
				?>
					<p>
						<?php echo $lang['txt_comment_leave_help'];?><br />
					</p>
				<?php }?>
			</div>
		</div>
	</div>
</div>
	
<div class="box_bottom">
	<span class="box_bottom_right"></span>
	<span class="box_bottom_left"></span>
</div>

<?php
if ($this->user_acs->checkPermission($resource_ids['wiki'], $privilege_ids['allow_tag']) && isset($item) && (!isset($display) || $display != "preview_comment")) {
?>
<div class="box">
	<div class="box_top">
		<?php echo $lang['hdr_tags'];?><br />
	</div>
	
	<div class="box_mid">
		<div class="content">
				<form action="index.php" method="post" name="tag">
				<input type="hidden" name="item_id" value="<?php echo $item['item_id'];?>" />
				
				<?php
				$out_tags = "";
				if (isset($tags)) {
					foreach ($tags as $key => $i):
						$out_tags .= $i['tag_body'];
						if (count($tags) > $key+1) {
							$out_tags .= ", ";
						}
					endforeach;
				}
				?>
				<p>
					<b><?php echo $lang['txt_tag_edit'];?></b><br/>
				</p>
				
				<p>
					<?php echo $lang['txt_tag_help'];?><br />
				</p>
				
				<p>
					<input name="tags" size="68" value="<?php echo $out_tags;?>" /><br />
				</p>
				
				<p align="right">
					<input type="submit" name="update_tag" value="<?php echo $lang['sub_update_tag'];?>" class="button" /><br />
				</p>
		</div>
	</div>
</div>
	
<div class="box_bottom">
	<span class="box_bottom_right"></span>
	<span class="box_bottom_left"></span>
</div>
<?php }?>
<?php }?>
