<?php

// -----------------------------------------------------------------------
// This file is part of Beacon
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
?>

<form action="account.php" method="post" id="frm">

<div class="box">
	<div class="box_top">
		<?php echo $lang['hdr_account'];?><br />
	</div>
		
	<div class="box_mid">
		<div class="content">
			<p>
				<?php echo $lang['txt_account_intro'];?><br />
			</p>
			
			<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="30" alt="" /><br />
			
			<table border="0" cellspacing="0" cellpadding="0" width="100%">
				<tr>
					<td valign="top" width="50%">
						<fieldset>
						<legend><b>&nbsp;<?php echo $lang['fld_account'];?>&nbsp;</b></legend>
						
							<p>
								<label for="id_name"><?php echo $lang['txt_name'];?></label>
								<input id="id_name" type="text" name="user_name" size="20" value="<?php if(isset($user['user_name'])) { echo $user['user_name'];}?>" /><br />
							</p>
						
							<?php
							if(count($lang['language']) == 1) {
							?>
								<input type="hidden" name="language_id" value="<?php echo $_SESSION['language_id'];?>" />
							<?php
							}
							else {
							?>
							<p>
							<?php echo $lang['txt_language_intro'];?><br />
							</p>
							
							<p>
								<label for="id_language"><?php echo $lang['form_label_language'];?></label>
								<select id="id_language" name="language_id">
								<?php
								foreach($lang['language'] as $key => $i):
								$selected = "";
								
								if (isset($user['language_id']) && $user['language_id'] == $key) {
									$selected = " selected=\"selected\"";
								}
								?>
								<option value="<?php echo $key;?>"><?php echo $i;?></option>
								<?php endforeach; ?>
								</select>
							</p>
							<?php }?>
							
							<p>
							<label for="id_password"><?php echo $lang['txt_new_password'];?></label>
							<input id="id_password" type="password" name="password1" size="12" value="" /><br />
							</p>
							
							<p>
								<label for="id_password"><?php echo $lang['txt_conf_password'];?></label>
								<input id="id_password" type="password" name="password2" size="12" value="" /><br />
							</p>
						</fieldset>
					</td>
					<td width="20">
						<img src="<?php echo $templatePath;?>img/pixel.png" width="20" height="1" alt="" border="0" /><br />
					</td>
					<td valign="top" width="50%">
						<fieldset>
						<legend><b>&nbsp;<?php echo $lang['fld_preferences'];?>&nbsp;</b></legend>
						
							<p>
								<label for="id_allow_correspondence" style="width:100%"><?php echo $lang['txt_allow_correspondence'];?></label><br />
							</p>
							
							<p align="right">
								<input id="id_allow_correspondence" type="checkbox" name="allow_correspondence" value="1" <?php if(!empty($user['allow_correspondence'])) { echo "checked=\"checked\"";}?> /><br />
							</p>
							
							<p>
								<label for="id_show_email" style="width:100%"><?php echo $lang['txt_show_email'];?></label><br />
							</p>
							
							<p align="right">
								<input id="id_show_email" type="checkbox" name="show_email" value="1" <?php if(!empty($user['show_email'])) { echo "checked=\"checked\"";}?> /><br />
							</p>
						</fieldset>
						
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" border="0" /><br />
						
						<fieldset>
						<legend><b>&nbsp;<?php echo $lang['fld_save'];?>&nbsp;</b></legend>
							<p align="right">
								<input type="submit" name="update_account" value="<?php echo $lang['sub_update'];?>" /><br />
							</p>
						</fieldset>
					</td>
				</tr>
			</table>
		</div>
	</div>
</div>
	
<div class="box_bottom">
	<span class="box_bottom_right"></span>
	<span class="box_bottom_left"></span>
</div>
</form>
