<?php

// -----------------------------------------------------------------------
// This file is part of Beacon
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "structure";
include "inc/header.inc.php";

if (!isset($_SESSION['s_user_id'])) {
	if (isset($_REQUEST['item_id'])) {
		$url = "account.php?item_id=" . $_REQUEST['item_id'];
	}
	else {
		$url = "account.php";
	}
	return header("Location: " . $url);
	exit;
}

if (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['newsletter'], $c_acs['arr_acs']['privilege']['allow_access'])) {
	header("Location: index.php?" . SID);
	exit;
}

require_once($c_node['dir']['class_path'] . 'Newsletter.class.php');
$nl = new Newsletter($db, null);


// SETUP NEWSLETTER -----------------------------------------------------
if (isset($frmdata['options'])) {
	if ($frmdata['options'] == "list") {
		$output_newsletters = $nl->selNewsletters();
	}
	elseif ($frmdata['options'] == "item_edit") {
		//edit this item
		header("Location: nlt_edit.php?message_id=" . $frmdata['message_id'] . "&".SID);
		exit;
	}
	elseif ($frmdata['options'] == "item_add") {
		//add an item
		header("Location: nlt_edit.php?item_add=1&".SID);
		exit;
	}
}
elseif (!empty($_REQUEST['message_id'])) {
	$output_newsletter = $nl->selNewsletter($_REQUEST['message_id']);
	//wikify body
	$wiki_image_base = "get_file.php?file=";
	
	$wiki->setRenderConf('xhtml', 'image', 'base', $wiki_image_base);
	$output_newsletter['message_body'] = $wiki->transform($output_newsletter['message_body'], 'Xhtml');
	
}
else {
	$output_newsletters = $nl->selNewsletters();
}

//move to template
if (!empty($output_newsletter)) {
	$body->set('newsletter', $output_newsletter);
}

if (!empty($output_newsletters)) {
	$body->set('newsletters', $output_newsletters);
}

include "inc/footer.inc.php";

?>
