<?php
// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


/*
* writeLogFile
* writes output to a text file
* tom calthrop
* 14th June 2005
*/
function writeLogFile($content, $path=null) {
	
	$content = "\n" . date("Y-m-d H:i:s") . "\t " . $content;
	
	if (!isset($path)) {
		$path = "";
	}
	
	$path = $path . "log/";
	
	$filename = "am_" . date('Y_m_d') . ".txt";
	
	//open or make the file
	if(!$handle = fopen($path . $filename, 'a')) {
		$handle = fopen($path . $filename, 'x');
	}
	// Write to file.
	@fwrite($handle, $content);
	//close file
	@fclose($handle);
}


/*
* Read file from hard disk and return
* tom calthrop
* 22nd April 2004
*/
function readTxtFile($source) {

	$handle = fopen($source, "rb");
	$output = "";
	do {
	   $data = fread($handle, 8192);
	   if (strlen($data) == 0) {
	       break;
	   }
	   $output .= $data;
	} while (true);

	fclose($handle);

	$output = addslashes($output);

	return $output;
}



// htmlspecialchars_decode ---------------------------------------------------------------
// Build in to PHP5, but included here for <5. Used to strip html from RSS descriptions
// tom calthrop - 07 May 2006
//
if (!function_exists('htmlspecialchars_decode')) {
   function htmlspecialchars_decode($str, $quote_style = ENT_COMPAT) {
	   return strtr($str, array_flip(get_html_translation_table(HTML_SPECIALCHARS, $quote_style)));
   }
}

/*
* compare
* general function for usort (used in SocialNetwork.class.php
* 8th January 2005
*/
function compare($a, $b) {

	if($a["degree"]==$b["degree"])
		return 0;
	elseif($a["degree"]<$b["degree"])
		return -1;
	else
		return 1;
}




/*
* searchTextFormat
* takes a search string, highlights it in the supplied txt
* and strips unwanted data
*
* tom calthrop
* 10th April 2004
*/
function searchTextFormat($search, $txt) {

	//remove all html
	$pattern = array ("'<script[^>]*?>.*?</script>'si",  // Strip out javascript
		"'<[\/\!]*?[^<>]*?>'si",          // Strip out HTML tags
       	"'([\r\n])[\s]+'",                // Strip out white space
       	"'&(quot|#34);'i"                // Replace HTML entities
	);

	$replace = array ("",
       	"",
       	"\\1",
		"\""
	);

	$txt = preg_replace($pattern, $replace, $txt);

	//show 20 chars before first highlighted word
	$search_start_pos = (strlen($txt) - strlen(stristr($txt,$search))-20);

	if ($search_start_pos > 20) {
		$txt = substr($txt,$search_start_pos);
		$txt = "..." . $txt;
	}

	//reduce string length to 150 char
	if (strlen($txt) > 150) {
		$txt = substr($txt,0, 160);
		$txt = $txt . "...";
	}

	//make the search word red
	$txt = preg_replace("/($search)/i","<span class='txt_search_highlight'>\\0</span>",$txt);

	return $txt;
}


// parseCustomElements
// returns CSS element names, types and any associated comments
// used in editing (classes dropdown) and in stylesheet editor
function parseCustomElements ($css) {

	$css = trim($css);

	// split the stylesheet into an array of lines
	$elements = preg_split("/[\n]+/", $css);

	if (!empty($elements)) {

		$parsed_elements = array();
		
		// get the element and look for a matching comment
		foreach ($elements as $key => $i):
			// get the element name
			$pattern = "/.am_custom_(.*?)\ {/";

			if (preg_match($pattern, $i, $element_name)) {
				
				$tmp_element['type'] = "custom";
				$tmp_element['name'] = "am_custom_" . $element_name[1];
				$tmp_element['title'] = $element_name[1];

				$parsed_elements[$tmp_element['name']] = $tmp_element;
			}
		endforeach;

		// we look for a comment to match the name
		if (!empty($parsed_elements)) {
			foreach ($parsed_elements as $key => $i):
				
				$pattern = "/\/\* " . $i['name'] . "(.*?)\*\//";
				//   /* body the body tag*/
				if (preg_match($pattern, $css, $element_comment)) {
					$parsed_elements[$i['name']]['description'] = $element_comment[1];
				}
			endforeach;
		}

		return $parsed_elements;
	}
}

?>