<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------


$core = "user";
include "inc/header.inc.php";

//ACS check
if (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['administration'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['s_homepage'] . "?" . SID);
	exit;
}


//append language setup
require_once($languageArrayPath . 'arr_language_name.lang.php');
require_once($languageArrayPath . 'arr_user.lang.php');
require_once($languageTextPath . 'message.lang.php');


//setup useradmin (extends user)
require_once($c_node['dir']['class_path'] . 'User.class.php');
require_once($c_node['dir']['class_path'] . 'UserAdmin.class.php');
$user = new UserAdmin($db, $date);
$user->language_dir = $c_node['node']['template_default_name'];


//form actions
if (isset($_POST['preview'])) {
	$lang['txt_invite'] = $data['subject'];
	$lang['txt_invite_message_txt'] = $data['message'];
	
	$display = "preview";
}
elseif (isset($_POST['edit_again'])) {
	$lang['txt_invite'] = $data['subject'];
	$lang['txt_invite_message_txt'] = $data['message'];
	
}
elseif (isset($_POST['register'])) {
	// Checks the email and the password
	

	if (isset($_POST['language_ids'])) {
	    $data['language_ids'] = $_POST['language_ids'];
	}
	
	$user->checkRegister($data);

	if (empty($GLOBALS['am_error_log'])) {

		//setup email
		require_once($c_node['dir']['class_path'] . '/Mail/class.phpmailer.php');
		$mail = new PHPMailer();
		$mail->Host = 		$c_node['mail']['host'];
		$mail->Mailer = 	$c_node['mail']['mailer'];
		
		if (isset($c_node['mail']['smtp']['username'])) {
			$mail->SMTPAuth = true;
			$mail->Username = $c_node['mail']['smtp']['username'];
			$mail->Password = $c_node['mail']['smtp']['password'];
		}
				
		$mail->From = 		$c_node['mail']['no_reply_address'];
		$mail->FromName = 	$c_node['mail']['from_name'];
		$mail->WordWrap = 	$c_node['mail']['wordwrap'];
		$mail->Subject = 	$data['subject'];
		$mail->AddReplyTo($c_node['mail']['no_reply_address'], $lang['subject_noreply']);
		$mail->language = 	"en";
		$user->mail = $mail;


		if (isset($data['invitee_id'])) {
			$user->invitee_id = $data['invitee_id'];
		}
		$user->txt_message = $data['message'];
		$user->user_image_allocation = $c_node['file']['default_max_user_space'];
		$user->template_id = $c_node['node']['template_default_id'];
		$data['user_dob'] = $_REQUEST['year']."-".$_REQUEST['month']."-".$_REQUEST['day'];
		$user->txt_default_profile_name = $lang['txt_default_profile_name'];
		$user->txt_default_profile_hometown = $lang['txt_default_profile_hometown'];
		$user->status_id = $c_node['user']['status']['pending'];
		$user->template_id = $c_node['node']['template_default_id'];
		$user->page_default = $c_node['node']['page_default'];
		$user->aroundme_dir = "";
		$user->role_default = $c_acs['arr_acs']['user_join_role_default'];
		$user->registerUser($data);

		//check if we need to add invitee into social network
		if (isset($data) && !empty($data['invitee_id'])) {
			require_once($c_node['dir']['aroundme'] . $c_node['dir']['class_path'] . 'User/SocialNetwork.class.php');
			$sn = new SocialNetwork($user->user_id, $db, $c_node['node']['node_id']);
			$relation = $sn->insertRelation($data['invitee_id'], $c_node['relation_type']['approved']);
		}

		$display = "registration_complete";
	}

}


//if someone has invited someone here
if ((isset($_REQUEST['invitee']) && $_REQUEST['invitee'] > 0) || isset($data['invitee_id'])) {
	if (isset($_REQUEST['invitee'])) {
	    $invitee = $_REQUEST['invitee'];
	}
	else {
	    $invitee = $data['invitee_id'];
	}

	if ($invitee > 0) {
		$_SESSION['s_user_id'] = "x";
	    $output_invite = $user->getUser($invitee);
		
		require_once($c_node['dir']['aroundme'] . $c_node['dir']['class_path'] . 'File.class.php');
		$file = new File($db, $c_node['file'], $c_node['dir']);
		$file->module = "user";
		$file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
		
		if (isset($output_invite['profile_image_id'])) {
			$file->file_id = $output_invite['profile_image_id'];
			$output_invite['image'] = $file->getFileRecord();
		}
		else {
			$output_invite['image']['file_title'] = "";
			$output_invite['image']['file'] = $file->noimage;
		}
	}
}
	
	
//TEMPLATE
if (isset($c_node['node']['language_available'])) {
    $body->set('language_available', $c_node['node']['language_available']);
}

if (isset($c_node['node']['language_default'])) {
    $body->set('language_default', $c_node['node']['language_default']);
}

if (!empty($output_invite)) {
    $body->set('invite', $output_invite);
}

if (isset($display)) {
    $body->set('display', $display);
}

if (isset($data)) {
    $body->set('data', $data);
	$user_dob = $_REQUEST['year']."-".$_REQUEST['month']."-".$_REQUEST['day'];
	$body->set('datedropdown', $date->dateDropdown($user_dob));
	$body->set('display_dob', $user_dob);
	$body->set('year', $_REQUEST['year']);
	$body->set('month', $_REQUEST['month']);
	$body->set('day', $_REQUEST['day']);
}
else {
	$data = array("language_id" => $me['language_id']);

	if (isset($_REQUEST['email'])) {
	    $data['user_email'] = $_REQUEST['email'];
	}

	$body->set('data', $data);

	$body->set('datedropdown', $date->dateDropdown());
}

include "inc/footer.inc.php";
?>
