<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------
include "inc/header_activity.inc.php";
require_once($c_node['dir']['class_path'] . 'Calendar.class.php');
require_once($c_node['dir']['class_path'] . 'Activity.class.php');


//append language setup
require_once($languageArrayPath . 'arr_task_user_status.lang.php');
require_once($languageArrayPath . 'arr_activities.lang.php');


//setup cms
require_once($c_node['dir']['class_path'] . 'Cms.class.php');
$cms = new Cms($db, $c_acs['arr_section']['group']);
$cms->level_id = $c_node['cms']['cms_level']['node'];


//setup file
$file->path = "group";
$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][3]['name'];



//activity setup
$activity = new Activity($db, $c_acs['arr_section']['group'], $date, $file);
$activity->task_user_status_ids = $c_node['activity']['task_user_status'];


if (isset($_POST['search'])) {
	$search = trim($_POST['search_text']);
	$activity->activity_type_id = $_POST['search_activity_type_id'];
	$output_activity_search_results = $activity->getActivities($search);
	$output_task_search_results = $activity->getTasks($search);
	$display = "search";
}
else {
	//get activity ids ---------------------------------------------------
	$cms->cms_item_type_id = $c_node['cms']['item_type']['group_activity'];
	if (isset($data['activity_status'])) {
		foreach($data['activity_status'] as $key => $i):
			if ($i <= 0) {
			    $arr_activity_delete[] = $key;
			}
			else {
				$cms->item_id = $key;
				
				if (isset($data['activity_sticky'][$key])) {
				    $cms->updateCmsItem($i, 1);
				}
				else {
					$cms->updateCmsItem($i);
				}
			}
		endforeach;
		
		if (isset($arr_activity_delete)) {
		    $cms->deleteCmsItem($arr_activity_delete);
		}
	}
	$output_cms_activities = $cms->getCmsItems();
	foreach($output_cms_activities as $key => $i):
		$cms_activity_ids[] = $i['item_id'];
	endforeach;
	//get task ids ---------------------------------------------------
	$cms->cms_item_type_id = $c_node['cms']['item_type']['group_task'];
	if (isset($data['task_status'])) {
		foreach($data['task_status'] as $key => $i):
			if ($i <= 0) {
			    $arr_task_delete[] = $key;
			}
			else {
				$cms->item_id = $key;
				
				if (isset($data['task_sticky'][$key])) {
				    $cms->updateCmsItem($i, 1);
				}
				else {
					$cms->updateCmsItem($i);
				}
			}
		endforeach;
		
		if (isset($arr_task_delete)) {
		    $cms->deleteCmsItem($arr_task_delete);
		}
	}
	$output_cms_tasks = $cms->getCmsItems();
	if (!empty($output_cms_tasks)) {
		foreach($output_cms_tasks as $key => $i):
			$cms_task_ids[] = $i['item_id'];
		endforeach;
	}
	
	//get activities
	if (!empty($cms_activity_ids)) {
		$activity->activity_ids = $cms_activity_ids;
		$output_activities = $activity->getActivities();
	}
	
	//get tasks
	if (!empty($cms_task_ids)) {
		$activity->task_ids = $cms_task_ids;
		$output_tasks = $activity->getTasks();
	}
	
	
	//setup calendar
	if(!isset($_REQUEST["time"])) {
		$time = mktime();
	}
	else {
		$time = $_REQUEST["time"];
	}
	
	$now = getdate($time);
	
	$cal = new Calendar($db, $now, $me['user_id']);
	
	//get date
	$cal->setCalendarBase();
	
	
	// get global activities
	if (isset($lang['arr_activities'])) {
		foreach($lang['arr_activities'] as $index => $activity_tmp):
			$activities[] = $cal->modifyActivityDate($activity_tmp);
		endforeach;
	}
	
	
	//setup group
	require_once($c_node['dir']['class_path'] . 'Group.class.php');
	$group = new Group($db, $date, null);
	$group->user_id = $user_id;
	$group->registration_types = $c_node['group']['registration_type'];
	// get all group events
	$output_groups = $group->getMyGroups();
	
	if (!empty($output_groups)) {
		foreach($output_groups as $index1 => $temp):
			$activity->section_item_id = $temp['group_id'];
			$activities_v = $activity->getActivities();
			foreach($activities_v as $index => $activity_tmp):
				if(isset($activity_tmp)) {
					$activities[] = $cal->modifyActivityDate($activity_tmp);
				}
			endforeach;
		endforeach;
	}
	
	
	// get all user events
	$activity->section_id = $c_acs['arr_section']['group'];
	$activities_v = $activity->getActivities();
	if (!empty($activities_v)) {
		foreach($activities_v as $index => $activity_tmp):
			if(isset($activity_tmp)) {
				$activities[] = $cal->modifyActivityDate($activity_tmp);
			}
		endforeach;
	}
	
	
	// Populate all activities
	foreach($activities as $index => $activity_tmp)
		$cal->populateActivity($activity_tmp);
	
	$cal->setBlankDays();             // Set blank days in the beginning of the calendar
	$calendar = $cal->getCalendar();  // Get the calendar array
	
	
	// get today's day number to highlight today in calendar,
	// a string is only returned if the calendar view is current month
	$todaynumber = $cal->getToDay(mktime());
	
	// Get last and next months timestamp
	$links["last"] = $date->getMonthTime($time, -1);
	$links["next"] = $date->getMonthTime($time, 1);
	
	// Get the calendar view month name
	$thismonth = $date->getMonthString($time);
}



//move to template
if (!empty($output_activity_search_results)) {
	$body->set('activity_search_results', $output_activity_search_results);
}

if (!empty($output_task_search_results)) {
	$body->set('task_search_results', $output_task_search_results);
}

if (!empty($output_activities)) {
   $body->set('activities', $output_activities);
}

if (!empty($output_tasks)) {
	$body->set('tasks', $output_tasks);
}

if (isset($display)) {
	$body->set('display', $display);
}

if (!empty($search)) {
	$body->set('search', $search);
}

if (!empty($search_activity_type_id)) {
	$body->set('search_activity_type_id', $search_activity_type_id);
}

if (!empty($time)) {
	$body->set('time', $time);
}

if (!empty($calendar)) {
	$body->set('calendar', $calendar);
}

if (isset($todaynumber)) {
	$body->set('todaynumber', $todaynumber);
}

if (!empty($thismonth)) {
	$body->set('thismonth', $thismonth);
}

if (!empty($links)) {
	$body->set('links', $links);
}

$template_pageLink = $lang['txt_activities'];
include "inc/footer.inc.php";

?>
