<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "library";

include_once ("config/lbr.config.php");
include_once ("inc/lbr_initiate.inc.php");


if (isset($_POST['update_ownership'])) {
	$query = "
		SELECT * 
		FROM " . $db->prefix . "_library_set 
		WHERE 
		set_id=" . $_POST['set_id']
	;
	
	$result = $db->Execute($query);
	
	if (isset($result->fields)) {
		$rec = array();
		$rec['user_id'] = $_POST['user_id'];
		
		$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $db->Execute($query);
	}
	
	header("Location: index.php?amn=lbr_page&page_id=" . $_POST['default_page_id'] . "&" . strip_tags(SID));
	exit;
}
elseif (isset($_POST['set_default_page_id'])) {
	// we update the default page in the set table
	$set_rec = array();
	$set_rec['default_page_id'] = $_POST['default_page_id'];
	
	$query = "
		SELECT * 
		FROM " . $db->prefix . "_library_set 
		WHERE 
		set_id=" . $_POST['set_id']
	;

	$set_result = $db->Execute($query);

	if (isset($set_result->fields)) {
		$query = $db->GetUpdateSQL($set_result, $set_rec, false, get_magic_quotes_gpc());
		$result = $db->Execute($query);
	}
	
	header("Location: index.php?amn=lbr_page&page_id=" . $_POST['default_page_id'] . "&" . strip_tags(SID));
	exit;
}
elseif (isset($_POST['save_set'])) {
	$_POST['set_title'] = trim(strip_tags($_POST['set_title']));
	$_POST['set_synopsis'] = trim(strip_tags($_POST['set_synopsis']));
	
	
	if (empty($_POST['set_title'])) {
		$GLOBALS['am_error_log'][] = array('title_empty');
	}
	
	if (empty($_POST['set_synopsis'])) {
		$GLOBALS['am_error_log'][] = array('synopsis_empty');
	}
	
	if (empty($GLOBALS['am_error_log'])) {
	
		if (empty($_POST['language_id'])) {
			$_POST['language_id'] = $core_config['language']['default_id'];
		}
		
		
		$set_rec = array();
		$set_rec['set_title'] = $_POST['set_title'];
		$set_rec['set_synopsis'] = $_POST['set_synopsis'];
		$set_rec['language_id'] = $_POST['language_id'];
		$set_rec['set_type'] = $_POST['set_type'];
		
		if (isset($_POST['permission']['set'])) {
			$permission_count = "0";
			
			foreach ($_POST['permission']['set'] as $key => $i):
				$permission_count = $permission_count+$i;
			endforeach;
			
			$set_rec['set_permission'] = $permission_count;
		}
		
		if (empty($_POST['file_id'])) {
			$_POST['file_id'] = "null";
		}
		
		$set_rec['file_id'] = $_POST['file_id'];
		$set_rec['level_id'] = $_POST['level_id'];
		
		if (!empty($_POST['set_id'])) { // we update
			
			$set_rec['status_id'] = $_POST['status_id'];
			
			$query = "
				SELECT * 
				FROM " . $db->prefix . "_library_set 
				WHERE 
				set_id=" . $_POST['set_id']
			;
			
			$set_result = $db->Execute($query);
	
			if (isset($set_result->fields)) {
				$query = $db->GetUpdateSQL($set_result, $set_rec, false, get_magic_quotes_gpc());
				$result = $db->Execute($query);
			}
				
			$set_id = $_POST['set_id'];
			
			
		}
		else { // we insert
			
			$set_rec['set_create_datetime'] = time();
			$set_rec['user_id'] = $_SESSION['user_id'];
			$set_rec['level_id'] = $_POST['level_id'];
			$set_rec['status_id'] = $library_config['status']['live'];
			$set_rec['default_user_permission'] = $library_config['default_participation_permission'];
			
			$table = $db->prefix . "_library_set";
		
			$query = $db->GetInsertSQL($table, $set_rec, get_magic_quotes_gpc());
			$result = $db->Execute($query);
			
			if (isset($result)) {
				$set_id = $db->Insert_ID();
			}
			
			if (isset($set_id)) {
				// after we insert we create page
				$rec = array();
				$rec['page_title'] = $lang['create_page_title'];
				$rec['page_synopsis'] = $lang['create_page_synopsis'];
				$rec['set_id'] = $set_id;
				$rec['page_name'] = $lang['create_page_name'];
				
				$table = $db->prefix . "_library_page";
		
				$query = $db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
				$result = $db->Execute($query);
				
				if (isset($result)) {
					$page_id = $db->Insert_ID();
				}
			}
			
			// after we insert the page we add default_page_id to the set
			if (isset($page_id)) {
				
				$set_rec = array();
				$set_rec['default_page_id'] = $page_id;
				
				$query = "
					SELECT * 
					FROM " . $db->prefix . "_library_set 
					WHERE 
					set_id=" . $set_id
				;
		
				$set_result = $db->Execute($query);
		
				if (isset($set_result->fields)) {
					$query = $db->GetUpdateSQL($set_result, $set_rec, false, get_magic_quotes_gpc());
					$result = $db->Execute($query);
				}
			}
			
			// after we insert the page we create a default revision
			if (isset($page_id)) {
				
				$rev_rec = array();
				$rev_rec['revision_body'] = readTxtFile($language_path . "texts/default_page.txt.php");
				$rev_rec['user_id'] = $_SESSION['user_id'];
				$rev_rec['revision_create_datetime'] = time();
				$rev_rec['page_id'] = $page_id;
				
				$table = $db->prefix . "_library_revision";
		
				$query = $db->GetInsertSQL($table, $rev_rec, get_magic_quotes_gpc());
				$result = $db->Execute($query);
				
				if (isset($result)) {
					$revision_id = $db->Insert_ID();
				}
				
			}
			
			// when we have the revision we update the page with the current revision
			if (isset($revision_id)) {
				//current_revision_id 
				$page_rec = array();
				$page_rec['current_revision_id'] = $revision_id;
				
				$query = "
					SELECT * 
					FROM " . $db->prefix . "_library_page 
					WHERE 
					page_id=" . $page_id
				;
		
				$page_result = $db->Execute($query);
		
				if (isset($page_result->fields)) {
					$query = $db->GetUpdateSQL($page_result, $page_rec, false, get_magic_quotes_gpc());
					$result = $db->Execute($query);
				}
			}
			
			// I add myself to the participation table
			$editor_permissions = 0;
			
			if (!empty($library_config['resource']['user'])) {
				foreach ($library_config['resource']['user'] as $key => $i):
					$editor_permissions = $editor_permissions + $i;
				endforeach;
			}		
			
			$user->identity_type = $core_config['user']['identity']['type']['registered'];
			$output_identity = $user->selUserIdentity($_SESSION['user_id']);	
			
			$rec = array();
			$rec['module_id'] = $core_config['module_id']['library'];
			$rec['item_id'] = $set_id;
			$rec['user_id'] = $_SESSION['user_id'];
			$rec['status_id'] = $core_config['participation']['status']['active'];
			$rec['identity_id'] = $_POST['identity_id'];
			$rec['participation_permission'] = $editor_permissions;
			$rec['participation_create_datetime'] = time();
			$rec['role_id'] = $library_config['role']['editor'];
			
			$table = $db->prefix . "_participation";
		
			$query = $db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
			$result = $db->Execute($query);
			
			// we set the allocation
			$rec = array();
			$rec['module_id'] = $core_config['module_id']['library'];
			$rec['item_id'] = $set_id;
			$rec['file_allocation'] = $library_config['default_file_allocation'];
			
			$table = $db->prefix . "_file_allocation";
			
			$query = $db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
			$result = $db->Execute($query);
		}
		
		// we add membership types to the am_module_membership_type_access table
		if ($_POST['set_type'] == $library_config['type']['membership_type']) {
			
			$query = "
				DELETE FROM " . $db->prefix . "_mem_type_access 
				WHERE 
				module_id=" . $core_config['module_id']['library'] . " AND 
				item_id=" . $set_id
			;
			
			if (!empty($_POST['membership_types'])) {
				foreach ($_POST['membership_types'] as $key => $i) :
					$rec = array();
					$rec['module_id'] = $core_config['module_id']['library'];
					$rec['item_id'] = $set_id;
					$rec['membership_type_id'] = $i;
						
					$table = $db->prefix . "_mem_type_access";
						
					$query = $db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
					$result = $db->Execute($query);
				endforeach;
			}
		}
	
		header("Location: index.php?amn=lbr_page&set_id=" . $set_id . "&" . strip_tags(SID));
		exit;
	}
	
	$output_set = $_POST;
	unset($output_set['set_id']);
	$body->set('set', $output_set);
}


if (!empty($_REQUEST['set_id'])) {
	$output_set = $library->selSet($_REQUEST['set_id']);
	
	if (!empty($output_set)) {
		// are we the owner of this set?
		if ($_SESSION['user_id'] == $output_set['user_id']) {
			// obtain any roles
			$query = "
				SELECT * 
				FROM " . $db->prefix . "_mem_type_access 
				WHERE 
				module_id=" . $core_config['module_id']['library'] . " AND 
				item_id=" . $output_set['set_id']
			;
			
			$result = $db->Execute($query);
		
			if (isset($result->fields)) {
				$membership_type_ids = array();

				while (!$result->EOF) {
					array_push($membership_type_ids, $result->fields);
					$result->MoveNext();
				}
				
				$output_set['membership_type_ids'] = $membership_type_ids;
			}
			
			
			$body->set('set', $output_set);
		
			// get revisions
			$output_pages = $library->selPages($output_set['set_id'], 1);
			$body->set('pages', $output_pages);
		}
		else {
			header("Location: index.php?amn=lbr_page&page_id=" . $set['default_page_id'] . "&" . strip_tags(SID));
			exit;
		}
	}
}

	
// get available images
if (isset($output_set['set_id'])) {
	require_once ("components/core/class/File.class.php");
	$file = new File($db, $core_config['file']);
	$file->module_id = $core_config['module_id']['library'];
	$file->item_id = $output_set['set_id'];
	$file->core_config_module = $core_config['module'];
	$file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
	$file->thumbs = $core_config['file']['image']['thumb'];
	
	$images = $file->selFiles("images", "t2");
	$body->set("images", $images);
}
else {
	$output_identities = $user->selUserIdentities($_SESSION['user_id']);
	$body->set('identities', $output_identities);
}

// get coordinators
$output_editors = $participation->selParticipants(null, $library_config['role']['editor']);
	
if (!empty($output_editors)) {
	foreach ($output_editors as $key => $i):
		$user->identity_ids[] = $i['identity_id'];
	endforeach;
	
	$user->identity_ids = array_unique($user->identity_ids);
	
	if (!empty($user->identity_ids)) {
		$output_editors = $user->selUserIdentities();
		$body->set('editors', $output_editors);
	}
}


// select tags
if (!empty($output_set['set_id'])) {
	require_once('components/core/class/Tag.class.php');
	$tag = new Tag($db, $core_config['module_id']['library'], $library_config['tag']['lbr']['library']);
	$tag->item_id = $output_set['set_id'];
	$tag->level_id = $core_config['tag']['level']['item'];
	
	if (isset($_POST['insert_tag'])) {
		if (empty($_POST['tag_id'])) { // we insert
			$tag->insertTag($_POST['tag_body']);
		}
		elseif (!empty($_POST['tag_id']) && empty($_POST['tag_body'])) { // we delete
			$tag->deleteTag($_POST['tag_id']);
		}
		else { // we update tag
			$tag->updateTag($_POST['tag_id'], $_POST['tag_body']);
		}
	}
	elseif (isset($_POST['delete_tag'])) {
		$tag->deleteTag($_POST['tag_id']);
	}
	elseif (isset($_REQUEST['edit_tag'])) {
		$output_tag = $tag->selTag($_REQUEST['edit_tag']);
	
		if (!empty($output_tag)) {
		$body->set('tag', $output_tag);
		}
	}
	
	$output_tags = $tag->selTags();				
	
	if (!empty($output_tags)) {
		$body->set('tags', $output_tags);
	}
}

$body->set("library_config", $library_config);
$body->set("module_prefix", $core_config['module'][$core_config['module_id']['library']]['prefix']);

?>
