<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


if (!isset($_SESSION['user_id']) || $_SESSION['user_id'] < 1) {
	header("Location: index.php?amn=grp_list&" . strip_tags(SID));
	exit;
}


include_once ("config/grp.config.php");
include_once ("inc/grp_initiate.inc.php");

if (empty($output_group)) {
	header("Location: index.php?amn=grp_list&" . strip_tags(SID));
	exit;
}


if (isset($_POST['insert_group_bookmark'])) {
	// insert record into group recommend table
	$rec = array();
	$rec['user_id'] = $_SESSION['user_id'];
	$rec['group_id'] = $output_group['group_id'];
	$rec['module_id'] = $_POST['b_module_id'];
	$rec['item_id'] = $_POST['b_item_id'];
	$rec['recommend_create_datetime'] = time();
		
	if (!empty($_POST['b_inner_item_id'])) {
		$rec['inner_item_id'] = $_POST['b_inner_item_id'];
	}
	
	if (!empty($_POST['subject_id'])) {
		$rec['subject_id'] = $_POST['subject_id'];
	}
	
	if (!empty($_POST['recommend_note'])) {
		$rec['recommend_note'] = strip_tags($_POST['recommend_note']);
	}
	
	$table = $db->prefix . "_group_recommend";
		
	$query = $db->getInsertSQL($table, $rec, get_magic_quotes_gpc());
	$result = $db->Execute($query);
	
	unset($_REQUEST['b_module_id'], $_REQUEST['b_item_id']);
}
elseif (isset($_POST['remove_group_bookmark'])) {
	if (!empty($_POST['recommendations'])) {
		// we receive a value 'module_id-item_id-inner_item_id-subject_id
		foreach ($_POST['recommendations'] as $key => $i):
			
			$arr = explode("-", $i);
			
			$query = "
				DELETE FROM " . $db->prefix . "_group_recommend 
				WHERE 
				user_id=" . $_SESSION['user_id'] . " AND 
				group_id=" . $output_group['group_id'] . " AND 
				module_id=" . $arr[0] . " AND 
				item_id=" . $arr[1] . " AND "
			;
			
			if (!empty($arr[2])) {
				$query .= "inner_item_id=" . $arr[2] . " AND ";
			}
			else {
				$query .= "inner_item_id is null AND ";
			}
			
			if (!empty($arr[3])) {
				$query .= "subject_id=" . $arr[3] . " AND ";
			}
			else {
				$query .= "subject_id is null AND ";
			}
			
			$query .= "1=1";
			
			$result = $db->Execute($query);
		endforeach;
	}
}


// GET FUNCTIONS -------------------------------------------------------------------------
// we include all module files which have a function to obtain a single item
// module_id 1 will include a function called -selItemModule1
if (!empty($core_config['module'])) {
	foreach($core_config['module'] as $key => $i):
		$suffix = $core_config['module'][$key]['prefix'];
		
	    if(is_file("components/" . $suffix . "/inc/" . $suffix . "_item_select.function.php")) {
	    	include_once("components/" . $suffix . "/inc/" . $suffix . "_item_select.function.php");
	    }
	endforeach;
}


// SETUP BOOKMARKS ------------------------------------------------------
require_once('components/core/class/Bookmark.class.php');
$bookmark = new Bookmark($db);
$bookmark->bookmark_type = $core_config['bookmark']['type']['watch'];


if (!empty($_REQUEST['b_module_id']) && !empty($_REQUEST['b_item_id'])) {
	// we want to add a bookmark
	$bookmark->user_id = $_SESSION['user_id'];
	$bookmark->module_id = $_REQUEST['b_module_id'];
	$bookmark->item_id = $_REQUEST['b_item_id'];
	
	if (!empty($_REQUEST['b_inner_item_id'])) {
		$bookmark->inner_item_id = $_REQUEST['b_inner_item_id'];
	}
	
	$output_bookmark = $bookmark->selBookmark(1);
	
	if (!empty($output_bookmark)) {
		if (isset($core_config['module'])) {
			$suffix = $core_config['module'][$output_bookmark['module_id']]['prefix'];
			$function_name = "selItemModule_" . $suffix;
				
			if (function_exists($function_name)) {
			
				$output_bookmark['item'] = $function_name($output_bookmark['item_id'], $output_bookmark['inner_item_id']);
			}
		}
		
		$body->set('bookmark', $output_bookmark);
		
		// get recent subjects
		$group->limit = 20;
		$output_subjects = $group->selSubjects();
		
		if (!empty($output_subjects)) {
			$body->set('subjects', $output_subjects);
		}
	}
}



// GET RECOMMENDATIONS TO THE GROUP -----------------------------------------------------
$output_recommendations = $group->selRecommendations();

if (!empty($output_recommendations)) {
	if (isset($core_config['module'])) {
		foreach($output_recommendations as $key => $i) {
			$suffix = $core_config['module'][$i['module_id']]['prefix'];
			$function_name = "selItemModule_" . $suffix;
			
			if (function_exists($function_name)) {
				$output_recommendations[$key]['item'] = $function_name($i['item_id'], $i['inner_item_id']);
			}
			
		}
	}

	$body->set('recommendations', $output_recommendations);

}



// GET BOOKMARKS ---------------------------------------------------------------------
unset ($bookmark->module_id, $bookmark->item_id, $bookmark->inner_item_id);

$bookmark->user_id = $_SESSION['user_id'];

$output_bookmarks = $bookmark->selBookmarks(1);

if (!empty($output_bookmarks)) {
	foreach ($output_bookmarks as $key => $i):
		// we remove bookmarks from this group
		if ($i['item_id'] == $output_group['group_id']) {
			unset ($output_bookmarks[$key]);
		}
		else {
			// we get the item
			$suffix = $core_config['module'][$i['module_id']]['prefix'];
			$function_name = "selItemModule_" . $suffix;
			
			if (function_exists($function_name)) {
				$output_bookmarks[$key]['item'] = $function_name($i['item_id'], $i['inner_item_id']);
			}
		}
	endforeach;
	
	$body->set('bookmarks', $output_bookmarks);
}




?>
