<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "group";

include_once ("config/grp.config.php");
include_once ("inc/grp_initiate.inc.php");



if (isset($_POST['update_subject'])) {
	// we update the subject
	$query = "
		SELECT subject_sticky, subject_locked, topic_id 
		FROM " . $db->prefix . "_group_subject 
		WHERE 
		group_id=" . $output_group['group_id'] . " AND 
		subject_id=" . $_POST['subject_id']
	;
		
	$result = $db->SelectLimit($query, 1);
			
	if (isset($result->fields)) {
		$rec = array();
			
		if (!empty($_POST['subject_sticky'])) {
			$rec['subject_sticky'] = 1;
		}
		else {
			$rec['subject_sticky'] = "null";
		}
		
		if (!empty($_POST['subject_locked'])) {
			$rec['subject_locked'] = 1;
		}
		else {
			$rec['subject_locked'] = "null";
		}
		
		$rec['topic_id'] = $_POST['move_to_topic_id'];
		$rec['subject_edit_datetime'] = time();
		
			
		$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $db->Execute($query);
	}
}
elseif (!empty($_REQUEST['insert_poll_answer'])) {
	
	$current_answer = pollUserCurrentVote($_POST['poll_id'], $_SESSION['user_id']);
	
	if (isset($current_answer) && $current_answer != $_POST['option_id']) {
		
		updateAnswer($_POST['option_id'], $_POST['poll_id'], $_SESSION['user_id']);
	}
}


if (isset($_REQUEST['subject_id'])) {
	$output_subject = $group->selSubject($_REQUEST['subject_id']);
}

if (!empty($output_subject)) {
	// get author
	$author_participation = $participation->selParticipation($output_subject['user_id']);
	$output_identity = $user->selUserIdentity(null, $author_participation['identity_id']);
	
	$body->set('identity', $output_identity);
	
	if (!empty($output_subject['file_id'])) {
		require_once ("components/core/class/File.class.php");
		$file = new File($db, $core_config['file']);
		$file->module_id = $core_config['module_id']['group'];
		$file->core_config_module = $core_config['module'];
		$file->no_image = $core_config['file']['image']['thumb'][1]['no_image'];
		
		$output_subject['image'] = $file->selFile($output_subject['file_id'], "t1");
	}
	
	$group->limit = 10;
	$output_subjects = $group->selSubjects($output_subject['topic_id']);
	
	if (!empty($output_subjects)) {
		$body->set('subjects', $output_subjects);
	}
	
	// get the topic
	$output_topic = $group->selTopic($output_subject['topic_id']);
	$body->set('topic', $output_topic);
	
	if (isset($output_participation['participation_permission']) && $output_participation['participation_permission'] & $group_config['resource']['user']['manage_subjects']) {
		// get the topic
		$output_topics = $group->selTopics();
		$body->set('topics', $output_topics);
	}
	
	
	// SETUP COMMENTS --------------------------------------------------------
	require_once('components/core/class/Comment.class.php');
	$comment = new Comment($db, $core_config['module_id']['group'], $output_group['group_id']);
	
	if (isset($_POST['insert_comment'])) {
		$comment->user_id = $_SESSION['user_id'];
		$comment->item_id = $output_group['group_id'];
		$comment->item_user_id = $output_subject['user_id'];
		$comment->inner_item_id = $output_subject['subject_id'];
		$comment->insertComment($_POST);
		
		// insert statistics ------------------------------
		require_once('components/core/class/Statistic.class.php');
		$statistic = new Statistic($db, $group_config['statistic']);
		$statistic->module_id = $core_config['module_id']['group'];
		$statistic->user_id = $_SESSION['user_id'];
		
		// insert library statistic - subject comments
		$statistic->statistic_type_id = $group_config['statistic']['total_comments'];
		$statistic->item_id = $output_subject['subject_id'];
		$statistic->setStatistic($comment->countComments());
		
		unset($statistic->module_id, $comment->item_id, $comment->inner_item_id);
		
		// insert user statistic - total comments
		$statistic->item_id = $_SESSION['user_id'];
		$statistic->statistic_type_id = $core_config['statistic']['user']['total_comments'];
		$statistic->setStatistic($comment->countComments());
		
	}
	elseif (isset($_POST['preview_comment'])) {
		$output_comment = $_POST;
		$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
		$output_comment['comment_body'] = htmlspecialchars($output_comment['comment_body']);
		
		$output_comment['display_comment_body'] = $output_comment['comment_body'];
		
		$body->set('comment', $output_comment);
		$body->set('display', 'preview_comment');

	}
	elseif (isset($_POST['edit_comment_again'])) {
		$output_comment = $_POST;
		$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
	
		$body->set('comment', $output_comment);
	}
	
	unset ($comment->user_id);
	
	$comment->item_id = $output_group['group_id'];
	
	$output_comments = $comment->selComments($output_subject['subject_id']);
	
	
	
	
	// GET AND SET POLLS -----------------------------------------------------------------
	if (!empty($output_subject['poll_id'])) {
		$output_poll = $group->selPoll($output_subject['poll_id']);
		
		
		// ADD USER VOTES TO COMMENTS
		if (isset($_SESSION['user_id'])) {
			$output_poll['current_answer'] = pollUserCurrentVote($output_poll['poll_id'], $_SESSION['user_id']);
			
			$output_poll_history = pollUserVoteHistory($output_poll['poll_id'], $_SESSION['user_id']);
			
			if (!empty($output_poll_history)) {
				$body->set('poll_history', $output_poll_history);
			}
		}
		
		if (isset($output_comments)) {
			foreach($output_comments as $key => $i):
				$output_comments[$key]['vote'] = pollUserVoteHistory($output_poll['poll_id'], $i['user_id']);
			endforeach;
		}
		
		if (!empty($output_poll)) {
			$body->set('poll', $output_poll);
		}
	}
	
	$body->set('comments', $output_comments);
	
	
	
	if (!empty($_SESSION['md5'])) {	
		// FAVOURITES -----------------------------------------
		require_once('components/core/class/Bookmark.class.php');
		$bookmark = new Bookmark($db, $core_config['module_id']['group']);
		$bookmark->item_id = $output_group['group_id'];
		$bookmark->user_id = $_SESSION['user_id'];
		$bookmark->inner_item_id = $output_subject['subject_id'];	
		$bookmark->bookmark_type = $core_config['bookmark']['type']['watch'];

		
		
		// 0=unset, 1=set
		if (isset($_POST['mark_0_x'])) {
			$bookmark->deleteBookmark();
		}
		elseif (isset($_POST['mark_1_x'])) {
			$bookmark->insertBookmark();
		}
		elseif (isset($_POST['mark_2_x'])) {
			$bookmark->insertBookmark(1);
		}
		elseif (isset($_POST['recommend_0_x'])) {
			$bookmark->bookmark_type = $core_config['bookmark']['type']['recommend'];
			$bookmark->deleteBookmark();
		}
		elseif (isset($_POST['recommend_1_x'])) {
			$bookmark->bookmark_type = $core_config['bookmark']['type']['recommend'];
			$bookmark->insertBookmark();
		}
		
		
		// GET BOOKMARK --------------------------------------------------
		if (isset($bookmark)) {
			$bookmark->item_id = $output_group['group_id'];
			$bookmark->bookmark_type = $core_config['bookmark']['type']['watch'];
			if ($bookmark->selBookmark()) {
				$bookmark->updateBookmark();
				$output_subject['bookmark']['watch'] = 1;
			}
			
			$bookmark->bookmark_type = $core_config['bookmark']['type']['recommend'];
			if ($bookmark->selBookmark()) {
				$bookmark->updateBookmark();
				$output_subject['bookmark']['recommend'] = 1;
			}
		}
		
		
		// GET RATINGS -----------------------------------------------------
		require_once('components/core/class/Rate.class.php');
		$rate = new Rate($db, $core_config['module_id']['group']);
		$rate->item_id = $output_group['group_id'];
		$rate->inner_item_id = $output_subject['subject_id'];
		$rate->user_id = $_SESSION['user_id'];	
		$rate->rate_type = $core_config['rate']['type']['relevent'];

		
		// 0=unset, 1=set
		if (isset($_POST['relevent_0_x'])) {
			$rate->deleteRating();
			$rate->insertRating(0);
		}
		elseif (isset($_POST['relevent_1_x'])) {
			$rate->deleteRating();
			$rate->insertRating(1);
		}
		elseif (isset($_POST['accurate_0_x'])) {
			$rate->rate_type = $core_config['rate']['type']['accurate'];
			$rate->deleteRating();
			$rate->insertRating(0);
		}
		elseif (isset($_POST['accurate_1_x'])) {
			$rate->rate_type = $core_config['rate']['type']['accurate'];
			$rate->deleteRating();
			$rate->insertRating(1);
			
		}
		
		// select my ratings on this page
		$rate->rate_type = $core_config['rate']['type']['relevent'];
		$output_rating_relevent = $rate->selRating();
		
		if (isset($output_rating_relevent)) {
			if (isset($output_rating_relevent[0]['rate_value'])) {
				$output_subject['rate']['relevent']['value'] = $output_rating_relevent[0]['rate_value'];
			}
		}
		
		$rate->rate_type = $core_config['rate']['type']['accurate'];
		$output_rating_accurate = $rate->selRating();
		
		if (isset($output_rating_accurate)) {
			if (isset($output_rating_accurate[0]['rate_value'])) {
				$output_subject['rate']['accurate']['value'] = $output_rating_accurate[0]['rate_value'];
			}
		}
		
		unset($rate->user_id);
		
		// statistics
		if (isset($output_rating_relevent)) {
			$rate->rate_type = $core_config['rate']['type']['relevent'];
			$output_subject['rate']['relevent']['total'] = $rate->countRating();
			$output_subject['rate']['relevent']['positive'] = $rate->countRating(1);
			
			if (!empty($output_subject['rate']['relevent']['total'])) {
				$percentage = round((100 / $output_subject['rate']['relevent']['total']) * $output_subject['rate']['relevent']['positive']);
			}
			else {
				$percentage = "0";
			}
			
			$lang['txt_relevent_summary'] = str_replace("SYS_KEYWORD_PERCENTAGE", $percentage, $lang['txt_relevent_summary']);
		}
		
		if (isset($output_rating_accurate)) {
			$rate->rate_type = $core_config['rate']['type']['accurate'];
			$output_subject['rate']['accurate']['total'] = $rate->countRating();
			$output_subject['rate']['accurate']['positive'] = $rate->countRating(1);
			
			if (!empty($output_subject['rate']['accurate']['total'])) {
				$percentage = round((100 / $output_subject['rate']['accurate']['total']) * $output_subject['rate']['accurate']['positive']);
			}
			else {
				$percentage = "0";
			}
			
			$lang['txt_accurate_summary'] = str_replace("SYS_KEYWORD_PERCENTAGE", $percentage, $lang['txt_accurate_summary']);
		}
		
		
		
		// select tags
		require_once('components/core/class/Tag.class.php');
		$tag = new Tag($db, $core_config['module_id']['group'], $group_config['tag']['grp']['subject']);
		$tag->item_id = $output_group['group_id'];
		$tag->inner_item_id = $output_subject['subject_id'];
		$tag->user_id = $_SESSION['user_id'];	
		
		if (isset($_POST['insert_tag']) && !empty($_POST['tag_body'])) {
			if (empty($_POST['tag_id'])) { // we insert
				$tag->insertTag($_POST['tag_body']);
			}
			elseif (!empty($_POST['tag_id']) && empty($_POST['tag_body'])) { // we delete
				$tag->deleteTag($_POST['tag_id']);
			}
			else { // we update tag
				$tag->updateTag($_POST['tag_id'], $_POST['tag_body']);
			}
		}
		elseif (isset($_POST['delete_tag']) && !empty($_POST['tag_id'])) {
			$tag->deleteTag($_POST['tag_id']);
		}
		elseif (isset($_REQUEST['edit_tag'])) {
			$output_tag = $tag->selTag($_REQUEST['edit_tag']);
		
			if (!empty($output_tag)) {
			$body->set('tag', $output_tag);
			}
		}
		
		$output_tags = $tag->selTags();				
		
		if (!empty($output_tags)) {
			$body->set('tags', $output_tags);
		}
	
	
		// GET AND SET RELATIONSHIP -----------------------------------------------
		if (isset($output_participation) && $output_subject['user_id'] != $_SESSION['user_id']) {
			require_once ("components/core/class/Tie.class.php");
			$tie = new Tie($db, $core_config);
			$tie->module_id = $core_config['module_id']['group'];
			$tie->item_id = $output_group['group_id'];
			
			$output_relationship = $tie->selRelation($output_participation['identity_id'], $output_identity['identity_id']);
			
			if (empty($output_relationship) && !empty($_REQUEST['respect'])) {
				
				$tie->user_id = $_SESSION['user_id'];
				
				$data['identity_id'] = $output_participation['identity_id'];
				$data['identity_id_relation'] = $output_identity['identity_id'];
				
				$tie->insertRelation($data);
				
				$output_relationship = $tie->selRelation($output_participation['identity_id'], $output_identity['identity_id']);
			}		
			
			
			if (!empty($output_relationship)) {
				if ($tie->isMutual($output_identity['identity_id'], $output_participation['identity_id'])) {
					$output_relationship['mutual'] = 1;
				}
				
				$body->set('relationship', $output_relationship);
			}
			
			
			// GET THEIR MATRIX ---------------------------------------
			$output_common_ties = $tie->selCommonTies($output_identity['identity_id'], $output_participation['identity_id']);
			$output_common_ties['identity_id'] = $output_participation['identity_id'];
			$output_common_ties['identity_id_relation'] = $output_identity['identity_id'];

			$body->set('common_ties', $output_common_ties);
			
			// GET THEIR TESTIMONIAL COUNT ---------------------------
			require_once ("components/core/class/Testimonial.class.php");
			$testimonial = new Testimonial($db);
			$testimonial->identity_id = $output_identity['identity_id'];
			$testimonial->testifier_identity_id = $output_participation['identity_id'];

			// count testimonials
			$output_identity['testimonial_count'] = $testimonial->countTestimonials();
		}
	}
	
	$body->set('subject', $output_subject);
	
	// GET RECOMMENDATIONS TO THIS SUBJECT -----------------------------------------------------
	$group->limit = 6;
	$output_recommendations = $group->selRecommendations($output_subject['subject_id']);
	
	if (!empty($output_recommendations)) {
		// we include all module files which have a function to obtain a single item
		// module_id 1 will include a function called -selItemModule1
		if (!empty($core_config['module'])) {
			foreach($core_config['module'] as $key => $i):
				$suffix = $core_config['module'][$key]['prefix'];
				
			    if(is_file("components/" . $suffix . "/inc/" . $suffix . "_item_select.function.php")) {
			    	include_once("components/" . $suffix . "/inc/" . $suffix . "_item_select.function.php");
			    }
			endforeach;
		}
		
		if (isset($core_config['module'])) {
			foreach($output_recommendations as $key => $i) {
				$suffix = $core_config['module'][$i['module_id']]['prefix'];
				$function_name = "selItemModule_" . $suffix;
				
				if (function_exists($function_name)) {
					$output_recommendations[$key]['item'] = $function_name($i['item_id'], $i['inner_item_id']);
				}
				
			}
		}
	
		$body->set('recommendations', $output_recommendations);
	
	}
}
else {
	header("Location: index.php?amn=grp_item&group_id=" . $output_group['group_id'] . "&" . strip_tags(SID));
	exit;
}


// move group to templates
$tpl->set('group', $output_group);
$body->set('group', $output_group);


// pollUserCurrentVote --------------------------------------------------------------------
// returns the current vote for a user
// tom calthrop - 24th Feb 2004
//
function pollUserCurrentVote($poll_id, $user_id) {
	
	global $db;
	
	$query = "
		SELECT answer_id, poll_id, current_answer, answer_create_datetime,
		option_id
		FROM " . $db->prefix . "_group_poll_answer
		WHERE
		user_id=" . $user_id . " AND
		poll_id=" . $poll_id . " AND
		current_answer=1 
		order by answer_create_datetime"
	;
	
	$result = $db->Execute($query);

	if (isset($result->fields)) {
		return $result->fields;
	}
}//EO pollUserCurrentVote



// updateAnswer --------------------------------------------------------------------
// update defaults and insert new answer
// tom calthrop - 28th December 2004
//
function updateAnswer($option_id, $poll_id, $user_id) {
	
	global $db;
	
	$query = "
		SELECT * FROM " . $db->prefix . "_group_poll_answer
		WHERE 
		poll_id=" . $poll_id . " AND
		user_id=" . $user_id
	;
	
	$result = $db->Execute($query);
	
	$rec = array();
	$rec['current_answer'] = "null";
	
	$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
	$result = $db->Execute($query);
	
	$rec = array();
	$rec['user_id'] = $user_id;
	$rec['poll_id'] = $poll_id;
	$rec['option_id'] = $option_id;
	$rec['current_answer'] = 1;
	$rec['answer_create_datetime'] = time();
	
	$table = $db->prefix . "_group_poll_answer";
		
	$query = $db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
	$result = $db->Execute($query);
	
}//EO updateAnswer




// pollUserVoteHistory --------------------------------------------------------------------
// returns the history of the votes given by a user to a poll (used in forum subjects)
// tom calthrop - 24th Feb 2004
//
function pollUserVoteHistory ($poll_id, $user_id) {

	global $db;
	
	$query = "
		SELECT pa.answer_create_datetime, o.option_body
		FROM " . $db->prefix . "_group_poll_answer pa, " . $db->prefix . "_group_poll_option o
		where
		pa.option_id = o.option_id and
		pa.user_id=" . $user_id . " and
		pa.poll_id=" . $poll_id . "
		order by pa.answer_create_datetime"
	;
	
	$result = $db->Execute($query);

	if (isset($result->fields)) {

		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;

			array_push($temp, $temp1);
			$result->MoveNext();
		}
		$result->Close();

		return $temp;
	}
} // EO pollUserVoteHistory

?>
