/* Xymon Client V1.2 for VSE/ESA and z/VSE
    Copyright (C) 2003-2010 Richard Smrcina
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU General Public License for more details.
 
    http://www.gnu.org/licenses/old-licenses/gpl-2.0.html            */
/*  This program will do the process check.
    It tests for certain jobs to be running on VSE and will report
      the results back to Xymon.  If a required job is not
      running, the page becomes red.  If an optional job count
      threshhold is reached a yellow page is generated.
 
    Rich Smrcina: Original V1.0 release 04/28/2005
    Rich Smrcina: Changed process check to use a librarian member to
                  store jobnames to watch.  This would allow a site to
                  check a larger number of jobs.           11/30/2005
   V1.2 - Added cfgmode parameter to designate the configuration mode
          Changed client architecture to use Hobbit server based
          configuration for most VSE tests (getvis is the exception).
          Server mode writes the test results to librarian members which
          are sent to Hobbit via the client data channel.
          Server based configuration will require the Hobbit back-end
          code which should be available with Hobbit 4.3. 02/01/2007
    Rich Smrcina: Changed project name to Xymon 02/10/2009
                                                                      */
parse arg lib cfgmode .
if cfgmode='CLIENT' then do
  call init_local_vars
  call do_procs_client
  end
else
  call do_procs_server
return
 
do_procs_server:
call outtrap power.
ADDRESS POWER 'D RDR,CDISP=*,FULL=YES'  /* POWER command      */
i=0
do j=2 to power.0
  parse var power.j p1 p2 p3 p4 p5 p6 rest
  if p1='1R46I' then do
    i=i+1
    jobname.i=p2
    jobnum.i=p3
    jobclass.i=p6
    parse var rest 'PART='pid.i .
    parse var rest 'FROM=('fuser.i')' .
    end
  if left(p1,2)='D=' then
    parse var p1 'D='jobdate.i .
  end
jobname.0=i
queue '[jobs]'
do k=1 to jobname.0
  queue left(jobname.k,8) left(jobnum.k,5) jobclass.k right(pid.k,2) ,
        right(fuser.k,4) jobdate.k
  end
queue ''
'execio * diskw 'lib'.hobvsepr.data (finis'
'execio * diskr 'lib'.hobvsenp.z (stem nparts. finis'
queue '[nparts]'
queue strip(nparts.1) jobname.0
queue ''
'execio * diskw 'lib'.hobvsenp.data (finis'
return
 
do_procs_client:
color='green'
call outtrap power.
ADDRESS POWER 'D RDR,CDISP=*'           /* POWER command      */
numjobs=power.0-1
if job_count=0 then
  nop
else do
  if numjobs > job_count then
    color='yellow'
  end
job_tbl=''
curjobs=''
do j=2 to power.0
  parse var power.j . rjobname .
  curjobs=curjobs||' '||strip(rjobname)
  end
if hobjobs.0=0 then
  job_tbl=job_tbl||'There are no jobs to check.'||cr
not_running=0
do i=1 to hobjobs.0
  ljobname=strip(hobjobs.i)
  if wordpos(ljobname,curjobs) = 0 then do
    color='red'
    job_tbl=job_tbl||'&red 'ljobname 'is down'||cr
    not_running=not_running+1
    end
  end
select
  when not_running=0 then
    msg='All monitored jobs are running'
  when not_running=1 then
    msg=not_running' monitored job is not running'
  otherwise
    msg=not_running' monitored jobs are not running'
  end
if job_tbl<>'' then
  job_tbl=cr||job_tbl
call init_open_socket         /* Initialize and Open the socket  */
status='status' fqdn'.procs' color date() time() msg ,
       cr'There are 'numjobs' jobs running.'||cr||job_tbl
call send_to_bb
call close_term_socket
return
 
send_to_bb:
status=toascii(status)
ret=Socket('Send',sid,status)
parse var ret rc .
if rc<>0 then
  say 'Send:' ret
return
 
toascii:
parse arg buffer
buffer=translate(buffer,asc,ebc)
return buffer
 
init_open_socket:
ret=socket('Initialize','hobbvse')
parse var ret rc .
if rc<>0 then
  say 'Initialize:' ret
ret=socket('Socket','AF_INET','Sock_Stream',0)
parse var ret rc .
if rc<>0 then
  say 'Socket:' ret
parse var ret rc sid .
call init_values
name='AF_INET' bbport bbdisplay
ret=socket('Connect',sid,name)
parse var ret rc .
if rc<>0 then
  say 'Connect:' ret
return
 
close_term_socket:
ret=Socket('Close',sid)
parse var ret rc .
if rc<>0 then
  say 'Close:' ret
ret=Socket('Terminate')
parse var ret rc .
if rc<>0 then
  say 'Terminate:' ret
return
 
init_local_vars:
init='0'             /*  Init flag  */
cr='0a'x             /*  Carriage return   */
/*  Retrieve options member from lib                             */
'execio * diskr 'lib'.hobvars.z (stem hobvars. finis'
/*  Init local variables first  */
bbdisplay=''
bbport=''
domainname=''
hostname=''
j=1
/*  Go through options table to fill values to run the client    */
do i=1 to hobvars.0
  if left(hobvars.i,1)='#' then iterate   /* Ignore comment */
  parse var hobvars.i kw value .
  value=strip(value,'B')
  select
    when kw='bbdisplay' then
      bbdisplay=value
    when kw='bbport' then
      bbport=value
    when kw='domainname' then
      domainname=value
    when kw='hostname' then
      hostname=value
    when kw='PROCS' then do
      if datatype(value)='NUM' then
        job_count=word(value,1)  /*  Check if first word is numeric */
      else do                    /*  if it is, use it in job count  */
        hobjobs.j=value          /*  If not, add to jobs stem       */
        j=j+1
        end
      end
    otherwise
      nop
    end
  end
hobjobs.0=j-1   /*  Count of jobs to check  */
return
 
init_values:
ebc=' !"#$%&'||'7D'X||'()*+,-./012' ,
    '3456789:;<=>?@ABCDE' ,
    'FGHIJKLMNOPQRSTUVWX' ,
    'YZ
\Y_`abcdefghijk' ,
    'lmnopqrstuvwxyz{|}~'
asc='202122232425262728292A2B2C2D2E2F303132'x ,
    '333435363738393A3B3C3D3E3F404142434445'x ,
    '464748494A4B4C4D4E4F505152535455565758'x ,
    '595A5B5C5D5E5F606162636465666768696A6B'x ,
    '6C6D6E6F707172737475767778797A7B7C7D7E'x
if hostname='' then do
  ret=socket('Gethostname')
  parse var ret rc hostname .
  if rc<>0 then
    say 'Gethostname:' ret
  hostname=lower(hostname)
  end
if domainname='' then
  fqdn=hostname
else
  fqdn=hostname||'.'||domainname
/*  Change periods to commas  */
fqdn=translate(fqdn,',','.')
return
 
/*  Convert parameter to lower case.  */
lower:
arg string
lc_chars='abcdefghijklmnopqrstuvwxyz'
uc_chars='ABCDEFGHIJKLMNOPQRSTUVWXYZ'
string=translate(string,lc_chars,uc_chars)
return string
