/* Xymon Client V1.2 for VSE/ESA and z/VSE
    Copyright (C) 2003-2010 Richard Smrcina
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU General Public License for more details.
 
    http://www.gnu.org/licenses/old-licenses/gpl-2.0.html            */
/*  This program will call an assembler subroutine to get the NETSTAT
    info for the TCP/IP Tools stack for z/VSE or VSE/ESA.
 
   Rich Smrcina: Original V1.2 release 12/12/2007
   Rich Smrcina: Changed project name to Xymon 02/10/2009
                                                                      */
parse arg lib cfgmode .
if cfgmode='CLIENT' then
  call init_local_vars
call do_netstat
if cfgmode='SERVER' then
  call write_client_data
else
  call send_client_data
return
 
do_netstat:
/*  Call assembler routine to call IOCTL to issue NETSTATS command  */
nsout.1='Active Internet connections (servers and established)'
nsout.2='Proto Recv-Q Send-Q Local Address        ' ,
        'Foreign Address       State'
n=3
rc=rxbstcmd('NETSTATS')
if rc=0 then do
  do i=3 to rxbstcmd.0
    parse var rxbstcmd.i . tcb rq sq lport remip rport state .
    if datatype(tcb)<>'NUM' then
      leave
    locaddr='0.0.0.0:'lport
    if state='ESTABLISH' then
      state='ESTABLISHED'
    if state='LISTEN' then
      remaddr='0.0.0.0:*'
    else
      remaddr=remip':'rport
    nsout.n='tcp   'right(rq,6) right(sq,6) left(locaddr,21) ,
            left(remaddr,21) state
    n=n+1
    end
  end
nsout.0=n-1
return
 
write_client_data:
queue '[ports]'
do i=1 to nsout.0
  queue nsout.i
  end
'execio * diskw' lib'.hobvsepo.data (finis'
return
 
send_client_data:
return
 
send_to_bb:
status=toascii(status)
ret=Socket('Send',sid,status)
parse var ret rc .
if rc<>0 then
  say 'Send:' ret
return
 
toascii:
parse arg buffer
buffer=translate(buffer,asc,ebc)
return buffer
 
init_open_socket:
call init_local_vars
ret=socket('Initialize','hobvse')
parse var ret rc .
if rc<>0 then
  say 'Initialize:' ret
ret=socket('Socket','AF_INET','Sock_Stream',0)
parse var ret rc .
if rc<>0 then
  say 'Socket:' ret
parse var ret rc sid .
call init_values
name='AF_INET' bbport bbdisplay
ret=socket('Connect',sid,name)
parse var ret rc .
if rc<>0 then
  say 'Connect:' ret
return
 
close_term_socket:
ret=Socket('Close',sid)
parse var ret rc .
if rc<>0 then
  say 'Close:' ret
ret=Socket('Terminate')
parse var ret rc .
if rc<>0 then
  say 'Terminate:' ret
return
 
init_local_vars:
cr='0a'x             /*  Carriage return   */
/*  Init local variables first  */
bbdisplay=''
bbport=''
domainname=''
hostname=''
/*  Go through options table to fill values to run the client    */
/*  Retrieve options member from PRD2.CONFIG                     */
'execio * diskr 'lib'.hobvars.z (stem hobvars. finis'
do i=1 to hobvars.0
  if left(hobvars.i,1)='#' then iterate   /* Ignore comment */
  parse var hobvars.i kw value
  value=strip(value,'B')
  select
    when kw='bbdisplay' then
      bbdisplay=value
    when kw='bbport' then
      bbport=value
    when kw='domainname' then
      domainname=value
    when kw='hostname' then
      hostname=value
    when kw='PAGE' then
      parse var value yellow red
    otherwise
      nop
    end
  end
return
 
init_values:
ebc=' !"#$%&'||'7D'X||'()*+,-./012' ,
    '3456789:;<=>?@ABCDE' ,
    'FGHIJKLMNOPQRSTUVWX' ,
    'YZ
\Y_`abcdefghijk' ,
    'lmnopqrstuvwxyz{|}~'
asc='202122232425262728292A2B2C2D2E2F303132'x ,
    '333435363738393A3B3C3D3E3F404142434445'x ,
    '464748494A4B4C4D4E4F505152535455565758'x ,
    '595A5B5C5D5E5F606162636465666768696A6B'x ,
    '6C6D6E6F707172737475767778797A7B7C7D7E'x
if hostname='' then do
  ret=socket('Gethostname')
  parse var ret rc hostname .
  if rc<>0 then
    say 'Gethostname:' ret
  hostname=lower(hostname)
  end
if domainname='' then
  fqdn=hostname
else
  fqdn=hostname||'.'||domainname
/*  Change periods to commas  */
fqdn=translate(fqdn,',','.')
return
 
/*  Convert parameter to lower case.  */
lower:
arg string
lc_chars='abcdefghijklmnopqrstuvwxyz'
uc_chars='ABCDEFGHIJKLMNOPQRSTUVWXYZ'
string=translate(string,lc_chars,uc_chars)
return string
