/* Xymon Client V1.2 for VSE/ESA and z/VSE
    Copyright (C) 2003-2010 Richard Smrcina
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU General Public License for more details.
 
    http://www.gnu.org/licenses/old-licenses/gpl-2.0.html            */
/* This EXEC will drive the programs to perform the various tests
   every 5 minutes.
   The library/sublibrary used to hold parameters and as a temporary
   data repository is passed as the first argument.  The second
   argument is the configuration mode which determines where the
   thressholds are set for the various tests.
   It reads the test names to perform from the library member
   hobtest.z
 
    Rich Smrcina 04/28/2005
 
   V1.1 - Modified to accept a lib.sublib as an argument to look for
          and put all other members.  The default is PRD2.CONFIG.
          Modified to call an assembler function to load other REXX
          assembler functions to cut down on program load time during
          each cycle.  Added code to get the VSE release level from
          SPLEVEL.PROC for display on the CPU page.      05/28/2006
 
   V1.2 - Added cfgmode parameter to designate the configuration mode
          Changed driver to use SIR to retrieve IPL time, VSE release
          level and current timezone.  The only console interaction of
          this nature is at client startup time.
          Changed client architecture to use Hobbit server based
          configuration for most VSE tests (getvis is the exception).
          Server mode writes the test results to librarian members which
          are sent to Hobbit via the client data channel.
          Server based configuration will require the Hobbit back-end
          code which should be available with Hobbit 4.3. 02/01/2007
          Changed project name to Xymon 02/09/2009
                                                                      */
arg lib cfgmode
if lib='' | lib='.' then
  lib='prd2.config'
if cfgmode='' then
  cfgmode='server'
version='V1.2'        /*  Version identifier  */
datfmt=1         /* Set system date format here, 1=US, 2=European  */
rc=sysvar('syspid')
SIGNAL ON HALT
msgdata=opermsg('ON')
call ASSGN 'STDOUT','SYSLOG'
say 'Xymon VSE Client' version 'Startup'
say "Use 'MSG" syspid",DATA=SHUTDOWN' to terminate."
call ASSGN 'STDOUT','SYSLST'
 
/* Set CPU and Paging data collection members to zero   */
push '0 0 0 0'
'execio 1 diskw 'lib'.hobvsecp.z (finis'
push '0 0 0'
'execio 1 diskw 'lib'.hobvsepg.z (finis'
 
/*  Retrieve options member from PRD2.CONFIG                     */
'execio * diskr 'lib'.hobvars.z (stem hobvars. finis'
 
/*  Get NPARTS value */
rc=hobvssys()
/*  The only the last two bytes of the result are used which is the
    current value of the NPARTS value of the IPL SYS stmt.  */
nparts=x2d(right(c2x(rc),2))
push nparts
'execio 1 diskw 'lib'.hobvsenp.z (finis'
 
/*  Init local variables first  */
hostname=''
/*  Go through options table to fill values to run the client    */
do i=1 to hobvars.0
  if left(hobvars.i,1)='#' then iterate   /* Ignore comment */
  parse var hobvars.i kw value
  value=strip(value,'B')
  select
    when kw='hostname' then
      hostname=value
    otherwise
      nop
    end
  end
 
/*  Open a console to issue the SIR command for
    additional static information.                               */
address console 'ACTIVATE NAME XYMON PROFILE REXNORC'
address console 'SIR'
rc=getmsg(sirresp.,'RESP',,,15)
address console 'DEACTIVATE XYMON'
 
/*  Call REXX function to load other REXX functions              */
rtn=hobvslod()
rtn=x2d(c2x(rtn))
if rtn <> 0 then
  say 'Return code 'rtn' loading other REXX functions.'
 
/*  Set up client member data  */
queue '[osversion]'
/*  Get OS and LEVEL info from SIR output first, since it appears on
    the info page, then queue up release info from the SIR output.
    After the SYSTEM info is collected, we're done with SIR.          */
do i=1 to sirresp.0
  parse var sirresp.i . . kw rest   /* skip 'AR 0015' */
  if kw='SYSTEM' then do
    parse var rest with os rel .
    queue os rel
    leave
    end
  end
done=0
i=0
do until done=1
  i=i+1
  parse var sirresp.i . . first rest   /* skip 'AR 0015' */
  queue first rest
  if first='SYSTEM' then
    done=1
  if first='PROC-MODE' then
    parse var sirresp.i . . . . . . ipltime timezone ipldate .
  end
i=i+1
parse var sirresp.i . . first rest   /* skip 'AR 0015' */
queue '           ' first rest
i=i+1
parse var sirresp.i . . first rest   /* skip 'AR 0015' */
queue '           ' first rest
queue ''
'execio * diskw 'lib'.hobvseos.data (finis'
dropbuf
 
/*  Process IPL Time                                             */
if datfmt=1 then   /* US date format  */
  idate=right(ipldate,4)||left(ipldate,2)||substr(ipldate,4,2)
else               /* European date format  */
  idate=right(ipldate,4)||substr(ipldate,4,2)||left(ipldate,2)
numdays=date('B',idate,'S')
numsecs=(left(ipltime,2)*3600)+(substr(ipltime,4,2)*60)+right(ipltime,2)
ipldate=substr(idate,5,2)||'/'||right(idate,2)||'/'||left(idate,4)
push ipldate ipltime numdays numsecs timezone
'execio 1 diskw 'lib'.hobvsitm.z (finis'
 
/*  Retrieve options member from lib                             */
'execio * diskr 'lib'.hobvars.z (stem hobvars. finis'
do forever
/*  Retrieve tests member from sublib passed                   */
  'execio * diskr 'lib'.hobtest.z (stem hobtest. finis'
  do i=1 to hobtest.0
    parse var hobtest.i test execname .
    if left(test,1)='#' then
      iterate
    exec execname lib cfgmode
    end
/*  Even when cfgmode=client there is data that can be sent
    via the client data stream                                 */
  exec hobvsecd lib cfgmode
/*  Sleep for 15 seconds 20 times                              */
/*    20*15 seconds = 300 seconds which is 5 minutes           */
/*  Since the OC exit only gets triggered after the sleep      */
/*  cycle, this is necessary to be able to shut the client     */
/*  down without having to wait up to 5 minutes.               */
  do 20
    rc=sleep(15)
    msgdata=opermsg('MSGDATA')
    if wordpos(msgdata,'SHUTDOWN QUIT EXIT TERM STOP') > 0 then
      signal halt
    end
  end
exit
 
HALT:
call ASSGN 'STDOUT','SYSLOG'
say 'Xymon VSE Client' version 'ending.'
call ASSGN 'STDOUT','SYSLST'
exit
