/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.lang;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import org.x4o.xml.element.Element;
import org.x4o.xml.element.ElementAttributeValueParser;
import org.x4o.xml.element.ElementObjectPropertyValue;
import org.x4o.xml.io.sax.X4ODebugWriter;
import org.x4o.xml.lang.X4OLanguage;
import org.x4o.xml.lang.X4OLanguageContextLocal;
import org.x4o.xml.lang.X4OLanguageProperty;
import org.x4o.xml.lang.phase.X4OPhase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractX4OLanguageContext
implements X4OLanguageContextLocal {
    private Logger logger = null;
    private X4OLanguage language = null;
    private ExpressionFactory expressionFactory = null;
    private ELContext eLContext = null;
    private ElementAttributeValueParser elementAttributeValueParser = null;
    private ElementObjectPropertyValue elementObjectPropertyValue = null;
    private X4OPhase currentX4OPhase = null;
    private Map<Element, X4OPhase> dirtyElements = null;
    private Element rootElement = null;
    private X4ODebugWriter debugWriter;
    private Map<String, Object> languageProperties;

    public AbstractX4OLanguageContext(X4OLanguage language) {
        if (language == null) {
            throw new NullPointerException("language may not be null");
        }
        this.logger = Logger.getLogger(AbstractX4OLanguageContext.class.getName());
        this.logger.finest("Creating new ParsingContext");
        this.language = language;
        this.dirtyElements = new HashMap<Element, X4OPhase>(40);
        this.languageProperties = new HashMap<String, Object>(20);
        this.languageProperties.put(X4OLanguageProperty.LANGUAGE_NAME.toUri(), language.getLanguageName());
        this.languageProperties.put(X4OLanguageProperty.LANGUAGE_VERSION.toUri(), language.getLanguageVersion());
    }

    @Override
    public X4OLanguage getLanguage() {
        return this.language;
    }

    @Override
    public ELContext getExpressionLanguageContext() {
        return this.eLContext;
    }

    @Override
    public void setExpressionLanguageContext(ELContext context) {
        if (this.eLContext != null) {
            throw new IllegalStateException("Can only set elContext once.");
        }
        this.eLContext = context;
    }

    @Override
    public ExpressionFactory getExpressionLanguageFactory() {
        return this.expressionFactory;
    }

    @Override
    public void setExpressionLanguageFactory(ExpressionFactory expressionFactory) {
        if (this.expressionFactory != null) {
            throw new IllegalStateException("Can only set expressionFactory once.");
        }
        this.expressionFactory = expressionFactory;
    }

    @Override
    public ElementAttributeValueParser getElementAttributeValueParser() {
        return this.elementAttributeValueParser;
    }

    @Override
    public void setElementAttributeValueParser(ElementAttributeValueParser elementAttributeValueParser) {
        if (this.elementAttributeValueParser != null) {
            throw new IllegalStateException("Can only set elementAttributeValueParser once.");
        }
        this.elementAttributeValueParser = elementAttributeValueParser;
    }

    @Override
    public ElementObjectPropertyValue getElementObjectPropertyValue() {
        return this.elementObjectPropertyValue;
    }

    @Override
    public void setElementObjectPropertyValue(ElementObjectPropertyValue elementObjectPropertyValue) {
        if (this.elementObjectPropertyValue != null) {
            throw new IllegalStateException("Can only set elementObjectPropertyValue once.");
        }
        this.elementObjectPropertyValue = elementObjectPropertyValue;
    }

    @Override
    public X4OPhase getCurrentPhase() {
        return this.currentX4OPhase;
    }

    @Override
    public void setCurrentPhase(X4OPhase currentX4OPhase) {
        this.currentX4OPhase = currentX4OPhase;
    }

    @Override
    public void addDirtyElement(Element element, X4OPhase phase) {
        if (this.dirtyElements.containsKey(element)) {
            throw new IllegalArgumentException("Can't add an element twice.");
        }
        this.dirtyElements.put(element, phase);
    }

    @Override
    public Map<Element, X4OPhase> getDirtyElements() {
        return this.dirtyElements;
    }

    @Override
    public Element getRootElement() {
        return this.rootElement;
    }

    @Override
    public void setRootElement(Element element) {
        if (element == null) {
            throw new NullPointerException("May not set rootElement to null");
        }
        this.rootElement = element;
    }

    @Override
    public Object getLanguageProperty(String key) {
        return this.languageProperties.get(key);
    }

    @Override
    public void setLanguageProperty(String key, Object value) {
        this.languageProperties.put(key, value);
    }

    @Override
    public Object getLanguageProperty(X4OLanguageProperty property) {
        return this.getLanguageProperty(property.toUri());
    }

    @Override
    public void setLanguageProperty(X4OLanguageProperty property, Object value) {
        if (!property.isValueValid(value)) {
            throw new IllegalArgumentException("Now allowed to set value: " + value + " in property: " + property.name());
        }
        this.setLanguageProperty(property.toUri(), value);
    }

    @Override
    public boolean getLanguagePropertyBoolean(X4OLanguageProperty property) {
        Object value = this.getLanguageProperty(property);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return (Boolean)property.getDefaultValue();
    }

    @Override
    public int getLanguagePropertyInteger(X4OLanguageProperty property) {
        Object value = this.getLanguageProperty(property);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return (Integer)property.getDefaultValue();
    }

    @Override
    public String getLanguagePropertyString(X4OLanguageProperty property) {
        Object value = this.getLanguageProperty(property);
        if (value instanceof String) {
            return (String)value;
        }
        return (String)property.getDefaultValue();
    }

    @Override
    public X4ODebugWriter getX4ODebugWriter() {
        return this.debugWriter;
    }

    @Override
    public boolean hasX4ODebugWriter() {
        return this.debugWriter != null;
    }

    @Override
    public void setX4ODebugWriter(X4ODebugWriter debugWriter) {
        this.debugWriter = debugWriter;
    }
}

