/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.io.sax.ext;

import java.io.Writer;
import java.util.Calendar;
import org.x4o.xml.io.sax.ext.ContentWriterXmlTag;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentWriterHtml
extends ContentWriterXmlTag<Tag> {
    private static final String DOCTYPE_NAME = "HTML PUBLIC";

    public ContentWriterHtml(Writer out, String encoding, String charNewLine, String charTab) {
        super(out, encoding, charNewLine, charTab);
    }

    public void printDocType(DocType doc) throws SAXException {
        this.startDTD(doc.getName(), doc.getPublicId(), doc.getSystemId());
    }

    public void printHtmlStart(String language) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        if (language != null) {
            atts.addAttribute("", "lang", "", "", language);
        }
        this.printTagStart(Tag.html, atts);
    }

    public void printHtmlEnd() throws SAXException {
        this.printTagEnd(Tag.html);
    }

    public void printHeadMetaDate() throws SAXException {
        Calendar cal = Calendar.getInstance();
        this.printHeadMeta("date", cal.get(1) + "-" + (cal.get(2) + 1) + "-" + cal.get(5));
    }

    public void printHeadTitle(String title) throws SAXException {
        this.printTagCharacters(Tag.title, title);
    }

    public void printHeadMetaContentType() throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "http-equiv", "", "", "Content-Type");
        atts.addAttribute("", "content", "", "", "text/html");
        atts.addAttribute("", "charset", "", "", this.encoding);
        this.startElementEnd("", "meta", "", atts);
    }

    public void printHeadMeta(String name, String content) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "name", "", "", name);
        atts.addAttribute("", "content", "", "", content);
        this.startElementEnd("", "meta", "", atts);
    }

    public void printHeadLinkCss(String cssUrl) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "rel", "", "", "stylesheet");
        atts.addAttribute("", "type", "", "", "text/css");
        atts.addAttribute("", "title", "", "", "Style");
        atts.addAttribute("", "href", "", "", cssUrl);
        this.startElementEnd("", "link", "", atts);
    }

    public void printScriptInline(String script) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "type", "", "", "text/javascript");
        this.printTagStart(Tag.script, atts);
        this.comment(script);
        this.printTagEnd(Tag.script);
    }

    public void printScriptNoDiv() throws SAXException {
        this.printScriptNoDiv(null);
    }

    public void printScriptNoDiv(String text) throws SAXException {
        if (text == null) {
            text = "JavaScript is disabled on your browser.";
        }
        this.printTagStart(Tag.noscript);
        this.printTagStart(Tag.div);
        this.characters(text);
        this.printTagEnd(Tag.div);
        this.printTagEnd(Tag.noscript);
    }

    public void printHrefNamed(String name) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "name", "", "", name);
        this.printTagStart(Tag.a, atts);
        this.comment(" ");
        this.printTagEnd(Tag.a);
    }

    public void printHrefTarget(String href, String title, String target) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "href", "", "", href);
        atts.addAttribute("", "target", "", "", target);
        this.printTagStart(Tag.a, atts);
        this.characters(title);
        this.printTagEnd(Tag.a);
    }

    public void printHref(String href, String title) throws SAXException {
        this.printHref(href, title, title);
    }

    public void printHref(String href, String title, String text) throws SAXException {
        this.printHref(href, title, text, null);
    }

    public void printHref(String href, String title, String text, String spanClass) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "href", "", "", href);
        if (title != null) {
            atts.addAttribute("", "title", "", "", title);
        }
        this.printTagStart(Tag.a, atts);
        if (spanClass != null) {
            atts = new AttributesImpl();
            if (spanClass.length() > 0) {
                atts.addAttribute("", "class", "", "", spanClass);
            }
            this.printTagStart(Tag.span, atts);
        }
        this.characters(text);
        if (spanClass != null) {
            this.printTagEnd(Tag.span);
        }
        this.printTagEnd(Tag.a);
    }

    public void printTagCharacters(Tag tag, String text, String tagClass) throws SAXException {
        this.printTagCharacters(tag, text, tagClass, null);
    }

    public void printTagCharacters(Tag tag, String text, String tagClass, String tagId) throws SAXException {
        this.printTagStart(tag, tagClass, tagId, null);
        if (text == null) {
            text = " ";
        }
        this.characters(text);
        this.printTagEnd(tag);
    }

    public void printTagStart(Tag tag, String tagClass) throws SAXException {
        this.printTagStart(tag, tagClass, null, null);
    }

    public void printTagStart(Tag tag, Enum<?> tagClassEnum) throws SAXException {
        this.printTagStart(tag, tagClassEnum, null);
    }

    public void printTagStart(Tag tag, Enum<?> tagClassEnum, String tagId) throws SAXException {
        this.printTagStart(tag, tagClassEnum, tagId, null);
    }

    public void printTagStart(Tag tag, Enum<?> tagClassEnum, String tagId, String typeId) throws SAXException {
        this.printTagStart(tag, tagClassEnum.name(), tagId, typeId);
    }

    public void printTagStart(Tag tag, String tagClass, String tagId, String typeId) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        if (tagId != null && tagId.length() > 0) {
            atts.addAttribute("", "id", "", "", tagId);
        }
        if (tagClass != null && tagClass.length() > 0) {
            atts.addAttribute("", "class", "", "", tagClass);
        }
        if (typeId != null && typeId.length() > 0) {
            atts.addAttribute("", "type", "", "", typeId);
        }
        this.printTagStart(tag, atts);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DocType {
        HTML_5("html", "", ""),
        HTML_4_FRAMESET("HTML PUBLIC", "\"-//W3C//DTD HTML 4.01 Frameset//EN\"", "http://www.w3.org/TR/html4/frameset.dtd"),
        HTML_4_TRANSITIONAL("HTML PUBLIC", "\"-//W3C//DTD HTML 4.01 Transitional//EN\"", "http://www.w3.org/TR/html4/loose.dtd"),
        HTML_4_STRICT("HTML PUBLIC", "\"-//W3C//DTD HTML 4.01//EN\"", "http://www.w3.org/TR/html4/strict.dtd"),
        XHTML_1_FRAMESET("HTML PUBLIC", "\"-//W3C//DTD XHTML 1.0 Frameset//EN\"", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd"),
        XHTML_1_TRANSITIONAL("HTML PUBLIC", "\"-//W3C//DTD XHTML 1.0 Transitional//EN\"", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"),
        XHTML_1_STRICT("HTML PUBLIC", "\"-//W3C//DTD XHTML 1.0 Strict//EN\"", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"),
        XHTML_11("HTML PUBLIC", "\"-//W3C//DTD XHTML 1.1//EN\"", "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd");

        private final String name;
        private final String publicId;
        private final String systemId;

        private DocType(String name, String publicId, String systemId) {
            this.name = name;
            this.publicId = publicId;
            this.systemId = systemId;
        }

        public String getName() {
            return this.name;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public String getSystemId() {
            return this.systemId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Tag {
        frameset,
        frame,
        noframes,
        tt,
        font,
        dir,
        center,
        strike,
        big,
        basefont,
        acronym,
        applet,
        iframe,
        html,
        head,
        title,
        meta,
        link,
        base,
        body,
        script,
        style,
        h1,
        h2,
        h3,
        h4,
        h5,
        h6,
        a,
        div,
        span,
        p,
        pre,
        img,
        hr,
        br,
        b,
        em,
        strong,
        small,
        noscript,
        ul,
        li,
        dl,
        dt,
        dd,
        ol,
        table,
        thead,
        tfoot,
        tbody,
        caption,
        th,
        tr,
        td,
        abbr,
        address,
        area,
        bdo,
        blockquote,
        cite,
        code,
        col,
        colgroup,
        del,
        dfn,
        i,
        ins,
        kbd,
        legend,
        map,
        menu,
        object,
        param,
        optgroup,
        q,
        s,
        samp,
        sub,
        u,
        var,
        form,
        fieldset,
        input,
        option,
        label,
        button,
        select,
        textarea,
        canvas,
        audio,
        video,
        source,
        embed,
        track,
        datalist,
        keygen,
        output,
        article,
        aside,
        bdi,
        command,
        details,
        dialog,
        summary,
        figure,
        figcaption,
        footer,
        header,
        hgroup,
        mark,
        meter,
        nav,
        progress,
        ruby,
        rt,
        rp,
        section,
        time,
        wbr;

    }
}

