/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.io.sax;

import org.x4o.xml.element.ElementException;
import org.x4o.xml.lang.X4OLanguageContext;
import org.x4o.xml.lang.X4OLanguageProperty;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class X4OErrorHandler
implements ErrorHandler {
    private X4OLanguageContext languageContext = null;
    private ErrorHandler errorHandler = null;

    public X4OErrorHandler(X4OLanguageContext languageContext) {
        if (languageContext == null) {
            throw new NullPointerException("Can't debug and proxy errors with null languageContext.");
        }
        this.languageContext = languageContext;
        this.errorHandler = (ErrorHandler)languageContext.getLanguageProperty(X4OLanguageProperty.READER_ERROR_HANDLER);
    }

    private void printError(boolean isError, SAXParseException exception) throws SAXException {
        if (!this.languageContext.hasX4ODebugWriter()) {
            return;
        }
        String message = this.printErrorString(isError, exception);
        try {
            this.languageContext.getX4ODebugWriter().debugPhaseMessage(message, X4OErrorHandler.class);
        }
        catch (ElementException e) {
            throw new SAXException(e);
        }
    }

    private String printErrorString(boolean isError, SAXParseException exception) {
        StringBuffer buf = new StringBuffer(50);
        buf.append(exception.getSystemId());
        buf.append(":");
        buf.append(exception.getLineNumber());
        buf.append(":");
        buf.append(exception.getColumnNumber());
        buf.append(" ");
        buf.append(isError ? "Error: " : "Warning: ");
        buf.append(exception.getMessage());
        return buf.toString();
    }

    public void warning(SAXParseException exception) throws SAXException {
        this.printError(false, exception);
        if (this.errorHandler == null) {
            throw new SAXException(this.printErrorString(false, exception));
        }
        this.errorHandler.warning(exception);
    }

    public void error(SAXParseException exception) throws SAXException {
        this.printError(true, exception);
        if (this.errorHandler == null) {
            throw new SAXException(this.printErrorString(true, exception));
        }
        this.errorHandler.error(exception);
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        this.printError(true, exception);
        if (this.errorHandler == null) {
            throw new SAXException(this.printErrorString(true, exception));
        }
        this.errorHandler.fatalError(exception);
    }
}

