/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.io.sax;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.x4o.xml.conv.ObjectConverter;
import org.x4o.xml.element.Element;
import org.x4o.xml.element.ElementAttributeHandler;
import org.x4o.xml.element.ElementBindingHandler;
import org.x4o.xml.element.ElementClass;
import org.x4o.xml.element.ElementClassAttribute;
import org.x4o.xml.element.ElementClassBase;
import org.x4o.xml.element.ElementConfigurator;
import org.x4o.xml.element.ElementConfiguratorGlobal;
import org.x4o.xml.element.ElementException;
import org.x4o.xml.element.ElementInterface;
import org.x4o.xml.element.ElementNamespaceContext;
import org.x4o.xml.element.ElementNamespaceInstanceProvider;
import org.x4o.xml.io.sax.ext.ContentWriter;
import org.x4o.xml.lang.X4OLanguageConfiguration;
import org.x4o.xml.lang.X4OLanguageContext;
import org.x4o.xml.lang.X4OLanguageModule;
import org.x4o.xml.lang.X4OLanguageProperty;
import org.x4o.xml.lang.phase.X4OPhase;
import org.x4o.xml.lang.phase.X4OPhaseException;
import org.x4o.xml.lang.phase.X4OPhaseListener;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X4ODebugWriter {
    public static final String DEBUG_URI = "http://language.x4o.org/xml/ns/debug-output";
    protected ContentWriter contentWriter = null;

    public X4ODebugWriter(ContentWriter debugWriter) {
        this.contentWriter = debugWriter;
    }

    public ContentWriter getContentWriter() {
        return this.contentWriter;
    }

    public X4OPhaseListener createDebugX4OPhaseListener() {
        return new DebugX4OPhaseListener();
    }

    public void debugLanguageProperties(X4OLanguageContext ec) throws ElementException {
        try {
            AttributesImpl atts = new AttributesImpl();
            this.contentWriter.startElement(DEBUG_URI, "X4OLanguageProperties", "", atts);
            for (X4OLanguageProperty p : X4OLanguageProperty.values()) {
                Object value = ec.getLanguageProperty(p);
                if (value == null) continue;
                AttributesImpl atts2 = new AttributesImpl();
                atts2.addAttribute("", "uri", "", "", p.toUri());
                atts2.addAttribute("", "value", "", "", value.toString());
                this.contentWriter.startElement(DEBUG_URI, "X4OLanguageProperty", "", atts2);
                this.contentWriter.endElement(DEBUG_URI, "X4OLanguageProperty", "");
            }
            this.contentWriter.endElement(DEBUG_URI, "X4OLanguageProperties", "");
        }
        catch (SAXException e) {
            throw new ElementException(e);
        }
    }

    public void debugLanguageDefaultClasses(X4OLanguageContext ec) throws ElementException {
        try {
            AttributesImpl atts = new AttributesImpl();
            this.contentWriter.startElement(DEBUG_URI, "X4OLanguageDefaultClasses", "", atts);
            X4OLanguageConfiguration conf = ec.getLanguage().getLanguageConfiguration();
            this.debugLanguageDefaultClass("getDefaultElementNamespaceContext", conf.getDefaultElementNamespaceContext());
            this.debugLanguageDefaultClass("getDefaultElementInterface", conf.getDefaultElementInterface());
            this.debugLanguageDefaultClass("getDefaultElement", conf.getDefaultElement());
            this.debugLanguageDefaultClass("getDefaultElementClass", conf.getDefaultElementClass());
            this.debugLanguageDefaultClass("getDefaultElementClassAttribute", conf.getDefaultElementClassAttribute());
            this.debugLanguageDefaultClass("getDefaultElementLanguageModule", conf.getDefaultElementLanguageModule());
            this.debugLanguageDefaultClass("getDefaultElementBodyComment", conf.getDefaultElementBodyComment());
            this.debugLanguageDefaultClass("getDefaultElementBodyCharacters", conf.getDefaultElementBodyCharacters());
            this.debugLanguageDefaultClass("getDefaultElementBodyWhitespace", conf.getDefaultElementBodyWhitespace());
            this.debugLanguageDefaultClass("getDefaultElementNamespaceInstanceProvider", conf.getDefaultElementNamespaceInstanceProvider());
            this.debugLanguageDefaultClass("getDefaultElementAttributeValueParser", conf.getDefaultElementAttributeValueParser());
            this.debugLanguageDefaultClass("getDefaultElementObjectPropertyValue", conf.getDefaultElementObjectPropertyValue());
            this.debugLanguageDefaultClass("getDefaultElementAttributeHandlerComparator", conf.getDefaultElementAttributeHandlerComparator());
            this.contentWriter.endElement(DEBUG_URI, "X4OLanguageDefaultClasses", "");
        }
        catch (SAXException e) {
            throw new ElementException(e);
        }
    }

    private void debugLanguageDefaultClass(String name, Class<?> clazz) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "name", "", "", name);
        atts.addAttribute("", "className", "", "", clazz.getName());
        this.contentWriter.startElement(DEBUG_URI, "X4OLanguageDefaultClass", "", atts);
        this.contentWriter.endElement(DEBUG_URI, "X4OLanguageDefaultClass", "");
    }

    public void debugPhaseOrder(List<X4OPhase> phases) throws X4OPhaseException {
        X4OPhase phase = null;
        try {
            AttributesImpl atts = new AttributesImpl();
            this.contentWriter.startElement(DEBUG_URI, "phaseOrder", "", atts);
            Iterator<X4OPhase> i$ = phases.iterator();
            while (i$.hasNext()) {
                X4OPhase phase2;
                phase = phase2 = i$.next();
                this.debugPhase(phase2);
            }
            this.contentWriter.endElement(DEBUG_URI, "phaseOrder", "");
        }
        catch (SAXException e) {
            if (phase == null) {
                if (phases.isEmpty()) {
                    throw new X4OPhaseException(null, e);
                }
                phase = phases.get(0);
            }
            throw new X4OPhaseException(phase, e);
        }
    }

    private void debugPhase(X4OPhase phase) throws X4OPhaseException {
        try {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "id", "", "", phase.getId());
            atts.addAttribute("", "runOnce", "", "", phase.isRunOnce() + "");
            atts.addAttribute("", "listenersSize", "", "", phase.getPhaseListeners().size() + "");
            this.contentWriter.startElement(DEBUG_URI, "phase", "", atts);
            for (X4OPhaseListener l : phase.getPhaseListeners()) {
                atts = new AttributesImpl();
                atts.addAttribute("", "className", "", "", l.getClass().getName());
                this.contentWriter.startElement(DEBUG_URI, "X4OPhaseListener", "", atts);
                this.contentWriter.endElement(DEBUG_URI, "X4OPhaseListener", "");
            }
            this.contentWriter.endElement(DEBUG_URI, "phase", "");
        }
        catch (SAXException e) {
            throw new X4OPhaseException(phase, e);
        }
    }

    public void debugElementLanguageModules(X4OLanguageContext elementLanguage) throws ElementException {
        try {
            AttributesImpl attsEmpty = new AttributesImpl();
            this.contentWriter.startElement(DEBUG_URI, "ElementLanguageModules", "", attsEmpty);
            for (X4OLanguageModule module : elementLanguage.getLanguage().getLanguageModules()) {
                AttributesImpl atts = new AttributesImpl();
                atts.addAttribute("", "className", "", "", module.getClass().getName());
                atts.addAttribute("", "id", "", "", module.getId());
                atts.addAttribute("", "providerName", "", "", module.getProviderName());
                atts.addAttribute("", "providerHost", "", "", module.getProviderHost());
                if (module.getLanguageModuleLoader() == null) {
                    atts.addAttribute("", "elementLanguageModuleLoaderClassName", "", "", "null");
                } else {
                    atts.addAttribute("", "elementLanguageModuleLoaderClassName", "", "", module.getLanguageModuleLoader().getClass().getName());
                }
                this.contentWriter.startElement(DEBUG_URI, "ElementLanguageModule", "", atts);
                this.debugElementConfiguratorGlobal(module.getElementConfiguratorGlobals());
                this.debugElementBindingHandler(module.getElementBindingHandlers());
                for (ElementAttributeHandler p : module.getElementAttributeHandlers()) {
                    atts = new AttributesImpl();
                    atts.addAttribute("", "attributeName", "", "", p.getAttributeName());
                    atts.addAttribute("", "description", "", "", p.getDescription());
                    atts.addAttribute("", "className", "", "", p.getClass().getName());
                    this.contentWriter.startElement(DEBUG_URI, "elementAttributeHandler", "", atts);
                    for (String para : p.getNextAttributes()) {
                        atts = new AttributesImpl();
                        atts.addAttribute("", "attributeName", "", "", para);
                        this.contentWriter.startElement(DEBUG_URI, "nextAttribute", "", atts);
                        this.contentWriter.endElement(DEBUG_URI, "nextAttribute", "");
                    }
                    this.contentWriter.endElement(DEBUG_URI, "elementAttributeHandler", "");
                }
                for (ElementInterface elementInterface : module.getElementInterfaces()) {
                    atts = new AttributesImpl();
                    atts.addAttribute("", "className", "", "", elementInterface.getClass().getName());
                    atts.addAttribute("", "description", "", "", elementInterface.getDescription());
                    atts.addAttribute("", "interfaceClass", "", "", elementInterface.getInterfaceClass().getName());
                    this.contentWriter.startElement(DEBUG_URI, "elementInterface", "", atts);
                    this.debugElementBindingHandler(elementInterface.getElementBindingHandlers());
                    this.debugElementClassBase(elementInterface);
                    this.contentWriter.endElement(DEBUG_URI, "elementInterface", "");
                }
                for (ElementNamespaceContext enc : module.getElementNamespaceContexts()) {
                    atts = new AttributesImpl();
                    atts.addAttribute("", "uri", "", "", enc.getUri());
                    atts.addAttribute("", "description", "", "", enc.getDescription());
                    atts.addAttribute("", "schemaUri", "", "", enc.getSchemaUri());
                    atts.addAttribute("", "schemaResource", "", "", enc.getSchemaResource());
                    atts.addAttribute("", "className", "", "", enc.getClass().getName());
                    this.contentWriter.startElement(DEBUG_URI, ElementNamespaceContext.class.getSimpleName(), "", atts);
                    for (ElementClass ec : enc.getElementClasses()) {
                        this.debugElementClass(ec);
                    }
                    ElementNamespaceInstanceProvider eip = enc.getElementNamespaceInstanceProvider();
                    atts = new AttributesImpl();
                    atts.addAttribute("", "className", "", "", eip.getClass().getName());
                    this.contentWriter.startElement(DEBUG_URI, ElementNamespaceInstanceProvider.class.getSimpleName(), "", atts);
                    this.contentWriter.endElement(DEBUG_URI, ElementNamespaceInstanceProvider.class.getSimpleName(), "");
                    this.contentWriter.endElement(DEBUG_URI, ElementNamespaceContext.class.getSimpleName(), "");
                }
                this.contentWriter.endElement(DEBUG_URI, "ElementLanguageModule", "");
            }
            this.contentWriter.endElement(DEBUG_URI, "ElementLanguageModules", "");
        }
        catch (SAXException e) {
            throw new ElementException(e);
        }
    }

    public void debugElement(Element element) throws ElementException {
        try {
            boolean rootElement;
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "objectClass", "", "", "" + element.getElementClass().getObjectClass());
            boolean bl = rootElement = element.getParent() == null;
            if (rootElement) {
                atts.addAttribute("", "isRootElement", "", "", "true");
            }
            if (element.getElementObject() == null) {
                atts.addAttribute("", "elementObjectClassName", "", "", "null");
            } else {
                atts.addAttribute("", "elementObjectClassName", "", "", element.getElementObject().getClass().getName());
                AttributesImpl atts2 = new AttributesImpl();
                try {
                    for (Method m : element.getElementObject().getClass().getMethods()) {
                        Object value;
                        if (!m.getName().startsWith("get") || m.getParameterTypes().length > 0 || (value = m.invoke(element.getElementObject(), new Object[0])) == null) continue;
                        if (value instanceof String) {
                            atts2.addAttribute("", m.getName(), "", "", value.toString());
                        }
                        if (value instanceof Number) {
                            atts2.addAttribute("", m.getName(), "", "", value.toString());
                        }
                        if (value instanceof Collection) {
                            atts2.addAttribute("", m.getName() + ".size", "", "", "" + ((Collection)value).size());
                        }
                        if (!(value instanceof Map)) continue;
                        atts2.addAttribute("", m.getName() + ".size", "", "", "" + ((Map)value).size());
                    }
                }
                catch (Exception e) {
                    atts.addAttribute("", "exceptionWhileGetingBeanValues", "", "", e.getMessage());
                }
                this.contentWriter.startElement(DEBUG_URI, "elementObject", "", atts2);
                this.contentWriter.endElement(DEBUG_URI, "elementObject", "");
            }
            StringBuffer elementPath = this.getElementPath(element, new StringBuffer());
            atts.addAttribute("", "elementPath", "", "", elementPath.toString());
            this.contentWriter.startElement(DEBUG_URI, "element", "", atts);
            this.contentWriter.endElement(DEBUG_URI, "element", "");
        }
        catch (SAXException e) {
            throw new ElementException(e);
        }
    }

    private StringBuffer getElementPath(Element element, StringBuffer buff) {
        if (element.getParent() == null) {
            buff.append('/');
            buff.append(element.getElementClass().getId());
            return buff;
        }
        buff = this.getElementPath(element.getParent(), buff);
        buff.append('/');
        buff.append(element.getElementClass().getId());
        return buff;
    }

    public void debugPhaseMessage(String message, Class<?> clazz) throws ElementException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "class", "", "", clazz.getName() + "");
        try {
            this.contentWriter.startElement(DEBUG_URI, "message", "", atts);
            char[] msg = message.toCharArray();
            this.contentWriter.characters(msg, 0, msg.length);
            this.contentWriter.endElement(DEBUG_URI, "message", "");
        }
        catch (SAXException e) {
            throw new ElementException(e);
        }
    }

    public void debugElementConfigurator(ElementConfigurator ec, Element element) throws ElementException {
        try {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "configAction", "", "", ec.isConfigAction() + "");
            atts.addAttribute("", "description", "", "", ec.getDescription());
            atts.addAttribute("", "className", "", "", ec.getClass().getName());
            this.contentWriter.startElement(DEBUG_URI, "runElementConfigurator", "", atts);
            this.debugElement(element);
            this.contentWriter.endElement(DEBUG_URI, "runElementConfigurator", "");
        }
        catch (SAXException e) {
            throw new ElementException(e);
        }
    }

    public void debugElementBindingHandler(ElementBindingHandler ebh, Element element) throws ElementException {
        try {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "description", "", "", ebh.getDescription());
            atts.addAttribute("", "className", "", "", ebh.getClass().getName() + "");
            atts.addAttribute("", "parentClass", "", "", element.getParent().getElementObject().getClass() + "");
            atts.addAttribute("", "childClass", "", "", element.getElementObject().getClass() + "");
            this.contentWriter.startElement(DEBUG_URI, "doBind", "", atts);
            this.debugElement(element);
            this.contentWriter.endElement(DEBUG_URI, "doBind", "");
        }
        catch (SAXException e) {
            throw new ElementException(e);
        }
    }

    public void debugLanguageContext(X4OLanguageContext elementLanguage) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "language", "", "", elementLanguage.getLanguage().getLanguageName());
        atts.addAttribute("", "languageVersion", "", "", elementLanguage.getLanguage().getLanguageVersion());
        atts.addAttribute("", "className", "", "", elementLanguage.getClass().getName() + "");
        atts.addAttribute("", "currentX4OPhase", "", "", elementLanguage.getCurrentPhase().getId());
        this.contentWriter.startElement(DEBUG_URI, "printElementLanguage", "", atts);
        this.contentWriter.endElement(DEBUG_URI, "printElementLanguage", "");
    }

    private void debugElementClass(ElementClass elementClass) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "id", "", "", elementClass.getId());
        atts.addAttribute("", "autoAttributes", "", "", "" + elementClass.getAutoAttributes());
        atts.addAttribute("", "description", "", "", elementClass.getDescription());
        atts.addAttribute("", "objectClassName", "", "", "" + elementClass.getObjectClass());
        atts.addAttribute("", "className", "", "", elementClass.getClass().getName());
        this.contentWriter.startElement(DEBUG_URI, "elementClass", "", atts);
        for (String phase : elementClass.getSkipPhases()) {
            atts = new AttributesImpl();
            atts.addAttribute("", "phase", "", "", "" + phase);
            this.contentWriter.startElement(DEBUG_URI, "elementSkipPhase", "", atts);
            this.contentWriter.endElement(DEBUG_URI, "elementSkipPhase", "");
        }
        this.debugElementConfigurator(elementClass.getElementConfigurators());
        this.debugElementClassBase(elementClass);
        this.contentWriter.endElement(DEBUG_URI, "elementClass", "");
    }

    private void debugElementClassBase(ElementClassBase elementClassBase) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "description", "", "", elementClassBase.getDescription());
        atts.addAttribute("", "className", "", "", elementClassBase.getClass().getName());
        this.contentWriter.startElement(DEBUG_URI, "elementClassBase", "", atts);
        this.debugElementConfigurator(elementClassBase.getElementConfigurators());
        this.debugElementClassAttributes(elementClassBase.getElementClassAttributes());
        this.contentWriter.endElement(DEBUG_URI, "elementClassBase", "");
    }

    private void debugElementConfigurator(List<ElementConfigurator> elementConfigurators) throws SAXException {
        for (ElementConfigurator elementConfigurator : elementConfigurators) {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "description", "", "", elementConfigurator.getDescription());
            atts.addAttribute("", "className", "", "", elementConfigurator.getClass().getName());
            this.contentWriter.startElement(DEBUG_URI, "elementConfigurator", "", atts);
            this.contentWriter.endElement(DEBUG_URI, "elementConfigurator", "");
        }
    }

    private void debugElementConfiguratorGlobal(List<ElementConfiguratorGlobal> elementConfigurators) throws SAXException {
        for (ElementConfiguratorGlobal elementConfigurator : elementConfigurators) {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "description", "", "", elementConfigurator.getDescription());
            atts.addAttribute("", "className", "", "", elementConfigurator.getClass().getName());
            this.contentWriter.startElement(DEBUG_URI, "elementConfiguratorGlobal", "", atts);
            this.contentWriter.endElement(DEBUG_URI, "elementConfiguratorGlobal", "");
        }
    }

    private void debugElementClassAttributes(Collection<ElementClassAttribute> elementClassAttributes) throws SAXException {
        for (ElementClassAttribute elementClassAttribute : elementClassAttributes) {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "id", "", "", elementClassAttribute.getId());
            atts.addAttribute("", "description", "", "", elementClassAttribute.getDescription());
            atts.addAttribute("", "className", "", "", elementClassAttribute.getClass().getName());
            atts.addAttribute("", "defaultValue", "", "", "" + elementClassAttribute.getDefaultValue());
            atts.addAttribute("", "runBeanValue", "", "", "" + elementClassAttribute.getRunBeanValue());
            atts.addAttribute("", "runConverters", "", "", "" + elementClassAttribute.getRunConverters());
            atts.addAttribute("", "runResolveEL", "", "", "" + elementClassAttribute.getRunResolveEL());
            this.contentWriter.startElement(DEBUG_URI, "elementClassAttribute", "", atts);
            if (elementClassAttribute.getObjectConverter() != null) {
                this.debugObjectConverter(elementClassAttribute.getObjectConverter());
            }
            for (String alias : elementClassAttribute.getAttributeAliases()) {
                atts = new AttributesImpl();
                atts.addAttribute("", "name", "", "", "" + alias);
                this.contentWriter.startElement(DEBUG_URI, "attributeAlias", "", atts);
                this.contentWriter.endElement(DEBUG_URI, "attributeAlias", "");
            }
            this.contentWriter.endElement(DEBUG_URI, "elementClassAttribute", "");
        }
    }

    private void debugObjectConverter(ObjectConverter objectConverter) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "objectClassTo", "", "", objectConverter.getObjectClassTo().getName());
        atts.addAttribute("", "objectClassBack", "", "", objectConverter.getObjectClassBack().getName());
        atts.addAttribute("", "className", "", "", objectConverter.getClass().getName());
        this.contentWriter.startElement(DEBUG_URI, "objectConverter", "", atts);
        this.contentWriter.endElement(DEBUG_URI, "objectConverter", "");
    }

    private void debugElementBindingHandler(List<ElementBindingHandler> elementBindingHandlers) throws SAXException {
        for (ElementBindingHandler bind : elementBindingHandlers) {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "className", "", "", bind.getClass().getName());
            atts.addAttribute("", "description", "", "", bind.getDescription());
            atts.addAttribute("", "bindParentClass", "", "", bind.getBindParentClass().toString());
            this.contentWriter.startElement(DEBUG_URI, "elementBindingHandler", "", atts);
            for (Class<?> clazz : bind.getBindChildClasses()) {
                AttributesImpl atts2 = new AttributesImpl();
                atts2.addAttribute("", "className", "", "", clazz.getName());
                this.contentWriter.startElement(DEBUG_URI, "elementBindingHandlerChildClass", "", atts2);
                this.contentWriter.endElement(DEBUG_URI, "elementBindingHandlerChildClass", "");
            }
            this.contentWriter.endElement(DEBUG_URI, "elementBindingHandler", "");
        }
    }

    class DebugX4OPhaseListener
    implements X4OPhaseListener {
        long startTime = 0L;

        DebugX4OPhaseListener() {
        }

        public void preRunPhase(X4OPhase phase, X4OLanguageContext elementLanguage) throws X4OPhaseException {
            this.startTime = System.currentTimeMillis();
            try {
                AttributesImpl atts = new AttributesImpl();
                if (elementLanguage != null) {
                    atts.addAttribute("", "language", "", "", elementLanguage.getLanguage().getLanguageName());
                }
                X4ODebugWriter.this.contentWriter.startElement(X4ODebugWriter.DEBUG_URI, "executePhase", "", atts);
            }
            catch (SAXException e) {
                throw new X4OPhaseException(phase, e);
            }
            X4ODebugWriter.this.debugPhase(phase);
        }

        public void endRunPhase(X4OPhase phase, X4OLanguageContext elementLanguage) throws X4OPhaseException {
            long stopTime = System.currentTimeMillis();
            try {
                AttributesImpl atts = new AttributesImpl();
                atts.addAttribute("", "id", "", "", phase.getId());
                atts.addAttribute("", "speed", "", "", stopTime - this.startTime + " ms");
                X4ODebugWriter.this.contentWriter.startElement(X4ODebugWriter.DEBUG_URI, "executePhaseDone", "", atts);
                X4ODebugWriter.this.contentWriter.endElement(X4ODebugWriter.DEBUG_URI, "executePhaseDone", "");
                X4ODebugWriter.this.contentWriter.endElement(X4ODebugWriter.DEBUG_URI, "executePhase", "");
            }
            catch (SAXException e) {
                throw new X4OPhaseException(phase, e);
            }
        }
    }
}

