/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.conv;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.x4o.xml.conv.ObjectConverter;
import org.x4o.xml.conv.ObjectConverterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractObjectConverter
implements ObjectConverter {
    protected List<ObjectConverter> converters = new ArrayList<ObjectConverter>(5);

    public abstract Object convertAfterTo(Object var1, Locale var2) throws ObjectConverterException;

    public abstract Object convertAfterBack(Object var1, Locale var2) throws ObjectConverterException;

    @Override
    public abstract ObjectConverter clone() throws CloneNotSupportedException;

    protected List<ObjectConverter> cloneConverters() throws CloneNotSupportedException {
        ArrayList<ObjectConverter> result = new ArrayList<ObjectConverter>(this.converters.size());
        for (ObjectConverter converter : this.converters) {
            result.add(converter.clone());
        }
        return result;
    }

    @Override
    public Object convertTo(Object obj, Locale locale) throws ObjectConverterException {
        if (this.converters.isEmpty()) {
            return this.convertAfterTo(obj, locale);
        }
        Object result = null;
        for (ObjectConverter conv : this.converters) {
            result = conv.convertTo(obj, locale);
        }
        result = this.convertAfterTo(obj, locale);
        return result;
    }

    @Override
    public Object convertBack(Object obj, Locale locale) throws ObjectConverterException {
        if (this.converters.isEmpty()) {
            return this.convertAfterBack(obj, locale);
        }
        Object result = null;
        for (ObjectConverter conv : this.converters) {
            result = conv.convertBack(obj, locale);
        }
        result = this.convertAfterBack(obj, locale);
        return result;
    }

    @Override
    public List<ObjectConverter> getObjectConverters() {
        return this.converters;
    }

    @Override
    public void addObjectConverter(ObjectConverter converter) {
        this.converters.add(converter);
    }

    @Override
    public void removeObjectConverter(ObjectConverter converter) {
        this.converters.remove(converter);
    }
}

